/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.tools.console;

import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.log.LogLevel;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.ArgumentParser;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.SnmpConfigurator;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableListener;
import org.snmp4j.util.TableUtils;

public class LogControl {
    public static final OID[] SNMP4J_LOGGER_OIDS = new OID[]{new OID("1.3.6.1.4.1.4976.10.1.1.1.1.2.2.1.3"), new OID("1.3.6.1.4.1.4976.10.1.1.1.1.2.2.1.4"), new OID("1.3.6.1.4.1.4976.10.1.1.1.1.2.2.1.6")};
    private static final String OPTIONS = "+a[s{=MD5}<(MD5|SHA)>] +A[s] +b[i{=0}] -c[s{=public}] -bc[i{=0}] +u[s{securityName}] -t[l{timeout=5000}] -r[i{retries=0}] +l[o<\\n\\n[:\\n\\n]*>] +e[o<\\n\\n[:\\n\\n]*>] +E[o<\\n\\n[:\\n\\n]*>] +n[s] +Y[s] +y[s<(DES|3DES|AES|AES128|AES192|AES256)>] -v[s{version=3}<(1|2c|3)>] ";
    private static final String COMMAND_PARAMETER = "#command[s<(set|list)>] +following[s] ..";
    private static final String[][] COMMANDS = new String[][]{{"list", "+a[s{=MD5}<(MD5|SHA)>] +A[s] +b[i{=0}] -c[s{=public}] -bc[i{=0}] +u[s{securityName}] -t[l{timeout=5000}] -r[i{retries=0}] +l[o<\\n\\n[:\\n\\n]*>] +e[o<\\n\\n[:\\n\\n]*>] +E[o<\\n\\n[:\\n\\n]*>] +n[s] +Y[s] +y[s<(DES|3DES|AES|AES128|AES192|AES256)>] -v[s{version=3}<(1|2c|3)>] ", "#command[s<list>] #address[s<(udp|tcp):.*[/[0-9]+]?>] +filter[s]"}, {"set", "+a[s{=MD5}<(MD5|SHA)>] +A[s] +b[i{=0}] -c[s{=public}] -bc[i{=0}] +u[s{securityName}] -t[l{timeout=5000}] -r[i{retries=0}] +l[o<\\n\\n[:\\n\\n]*>] +e[o<\\n\\n[:\\n\\n]*>] +E[o<\\n\\n[:\\n\\n]*>] +n[s] +Y[s] +y[s<(DES|3DES|AES|AES128|AES192|AES256)>] -v[s{version=3}<(1|2c|3)>] ", "#command[s<set>] #address[s<(udp|tcp):.*[/[0-9]+]?>] #logger[s] #level[s<(NONE|OFF|ALL|TRACE|DEBUG|INFO|WARN|ERROR|FATAL)>]"}, {"help", "", "#command[s<help>] +subject[s<list|set>]"}};
    private Map parameters;

    public LogControl(Map map) {
        this.parameters = map;
    }

    public void run() {
        String string = (String)ArgumentParser.getValue(this.parameters, "command", 0);
        if ("help".equals(string)) {
            String string2 = (String)ArgumentParser.getValue(this.parameters, "subject", 0);
            if (string2 == null) {
                LogControl.printUsage();
            } else if ("list".equalsIgnoreCase(string2)) {
                LogControl.printUsageHeader();
                LogControl.printListUsage();
                LogControl.printOptions();
            } else if ("set".equalsIgnoreCase(string2)) {
                LogControl.printUsageHeader();
                LogControl.printListUsage();
                LogControl.printOptions();
            }
        } else {
            DefaultUdpTransportMapping defaultUdpTransportMapping = null;
            try {
                defaultUdpTransportMapping = new DefaultUdpTransportMapping(new UdpAddress("0.0.0.0/0"));
                MessageDispatcherImpl messageDispatcherImpl = new MessageDispatcherImpl();
                Snmp snmp = new Snmp(messageDispatcherImpl, defaultUdpTransportMapping);
                SecurityProtocols.getInstance().addDefaultProtocols();
                OctetString octetString = new OctetString(MPv3.createLocalEngineID(new OctetString("LogControl" + System.currentTimeMillis())));
                messageDispatcherImpl.addMessageProcessingModel(new MPv1());
                messageDispatcherImpl.addMessageProcessingModel(new MPv2c());
                USM uSM = new USM(SecurityProtocols.getInstance(), octetString, 0);
                messageDispatcherImpl.addMessageProcessingModel(new MPv3(uSM));
                SnmpConfigurator snmpConfigurator = new SnmpConfigurator();
                snmpConfigurator.configure(snmp, this.parameters);
                snmp.listen();
                Target target = snmpConfigurator.getTarget(this.parameters);
                PDUFactory pDUFactory = snmpConfigurator.getPDUFactory(this.parameters);
                if ("list".equals(string)) {
                    this.listLoggers(snmp, target, pDUFactory);
                } else if ("set".equals(string)) {
                    this.setLevel(snmp, target, pDUFactory);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void setLevel(Snmp snmp, Target target, PDUFactory pDUFactory) throws IOException {
        PDU pDU = pDUFactory.createPDU(target);
        OID oID = new OID(SNMP4J_LOGGER_OIDS[0]);
        String string = (String)ArgumentParser.getValue(this.parameters, "logger", 0);
        if (string != null) {
            OID oID2 = new OctetString(string).toSubIndex(true);
            String string2 = (String)ArgumentParser.getValue(this.parameters, "level", 0);
            oID.append(oID2);
            int n = LogLevel.toLevel(string2).getLevel();
            pDU.add(new VariableBinding(oID, new Integer32(n)));
            ResponseEvent responseEvent = snmp.set(pDU, target);
            if (responseEvent.getResponse() != null) {
                switch (responseEvent.getResponse().getErrorStatus()) {
                    case 0: {
                        this.verifyLoggerModification(snmp, target, pDU, oID, string, oID2, string2, responseEvent);
                        break;
                    }
                    case 11: 
                    case 18: {
                        pDU.clear();
                        OID oID3 = new OID(SNMP4J_LOGGER_OIDS[2]);
                        oID3.append(oID2);
                        pDU.add(new VariableBinding(oID, new Integer32(n)));
                        pDU.add(new VariableBinding(oID3, new Integer32(4)));
                        responseEvent = snmp.set(pDU, target);
                        if (responseEvent.getResponse() != null && responseEvent.getResponse().getErrorStatus() == 0) {
                            System.out.println("Logger created successfully.");
                        }
                        this.verifyLoggerModification(snmp, target, pDU, oID, string, oID2, string2, responseEvent);
                    }
                }
            } else {
                System.out.println("SET request timed out.");
            }
        }
    }

    private void verifyLoggerModification(Snmp snmp, Target target, PDU pDU, OID oID, String string, OID oID2, String string2, ResponseEvent responseEvent) throws IOException {
        pDU.clear();
        OID oID3 = new OID(SNMP4J_LOGGER_OIDS[1]);
        oID3.append(oID2);
        pDU.add(new VariableBinding(oID));
        pDU.add(new VariableBinding(oID3));
        responseEvent = snmp.get(pDU, target);
        PDU pDU2 = responseEvent.getResponse();
        if (pDU2 != null && pDU2.getErrorStatus() == 0 && !pDU2.get(0).isException() && !pDU2.get(1).isException()) {
            PDU pDU3 = responseEvent.getResponse();
            LogLevel logLevel = new LogLevel(pDU3.get(0).getVariable().toInt());
            LogLevel logLevel2 = new LogLevel(pDU3.get(1).getVariable().toInt());
            System.out.println("Set logger '" + string + "' level to " + string2 + ". Now levels are " + logLevel + " (configured) and " + logLevel2 + " (effective).");
        } else {
            System.out.println("SET request successfully sent, but verfication failed:");
            if (pDU2 == null) {
                System.out.println("GET request timed out.");
            } else if (pDU2.getErrorStatus() != 0) {
                System.out.println(PDU.toErrorStatusText(pDU2.getErrorStatus()));
            } else {
                System.out.println(pDU2.toString());
            }
        }
    }

    private synchronized void listLoggers(Snmp snmp, Target target, PDUFactory pDUFactory) {
        Object object;
        TableUtils tableUtils = new TableUtils(snmp, pDUFactory);
        OID oID = null;
        OID oID2 = null;
        String string = (String)ArgumentParser.getValue(this.parameters, "filter", 0);
        if (string != null) {
            object = new OctetString(string);
            oID = ((OctetString)object).toSubIndex(true);
            oID2 = oID.nextPeer();
        }
        object = new LoggerListListener();
        tableUtils.getTable(target, SNMP4J_LOGGER_OIDS, (TableListener)object, this, oID, oID2);
        while (!((LoggerListListener)object).isFinished()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = ArgumentParser.selectCommand(stringArray, OPTIONS, COMMANDS);
            if (stringArray2 == null) {
                LogControl.printUsage();
                System.exit(2);
            }
            ArgumentParser argumentParser = new ArgumentParser(stringArray2[1], stringArray2[2]);
            Map map = argumentParser.parse(stringArray);
            LogControl logControl = new LogControl(map);
            logControl.run();
        }
        catch (ParseException parseException) {
            System.out.println(parseException.getMessage());
            System.exit(1);
        }
    }

    private static void printUsage() {
        LogControl.printUsageHeader();
        LogControl.printHelpUsage();
        LogControl.printListUsage();
        LogControl.printSetUsage();
        LogControl.printOptions();
    }

    private static void printUsageHeader() {
        System.out.println("LogControl <OPTIONS> <COMMAND> <PARAMETERS>");
        System.out.println("where <COMMAND> is one of: ");
    }

    private static void printOptions() {
        System.out.println("valid <OPTIONS> are:");
        System.out.println("  -a  authProtocol      Sets the authentication protocol used to");
        System.out.println("                        authenticate SNMPv3 messages. Valid values are");
        System.out.println("                        MD5 and SHA.");
        System.out.println("  -A  authPassphrase    Sets the authentication pass phrase for authenticated");
        System.out.println("                        SNMPv3 messages.");
        System.out.println("  -bc bootCounter       The boot counter to be used (default is 0)");
        System.out.println("  -c  community         The SNMPv1/v2c community to use (default is 'public')");
        System.out.println("  -e  engineID          Sets the authoritative engine ID of the command");
        System.out.println("                        responder used for SNMPv3 request messages. If not");
        System.out.println("                        supplied, the engine ID will be discovered.");
        System.out.println("  -E  contextEngineID   Sets the context engine ID used for the SNMPv3 scoped");
        System.out.println("                        PDU. The authoritative engine ID will be used for the");
        System.out.println("                        context engine ID, if the latter is not specified.");
        System.out.println("  -l  localEngineID     Sets the local engine ID. This option can be");
        System.out.println("                        used to avoid engine ID clashes through duplicate IDs");
        System.out.println("                        leading to usmStatsNotInTimeWindows reports.");
        System.out.println("  -n  contextName       Sets the target context name for SNMPv3 messages. ");
        System.out.println("                        Default is the empty string.");
        System.out.println("  -u  securityName      The SNMPv3 security name");
        System.out.println("  -t  timeout           SNMP timeout in milli-seconds (default is 5000)");
        System.out.println("  -r  retries           SNMP retries (default is 0) ");
        System.out.println("  -v  1|2c|3            The SNMP version (one of 1, 2c, or 3)");
        System.out.println("  -y  privacyProtocol   Sets the privacy protocol to be used to encrypt");
        System.out.println("                        SNMPv3 messages. Valid values are DES, AES (AES128),");
        System.out.println("                        AES192, AES256, and 3DES(DESEDE).");
        System.out.println("  -Y  privacyPassphrase Sets the privacy pass phrase for encrypted");
        System.out.println("                        SNMPv3 messages.");
    }

    private static void printSetUsage() {
        System.out.println(" set <ADDRESS> <LOGGER> <LEVEL>  Set a LOGGER to a new LEVEL at agent");
        System.out.println("                                 ADDRESS (e.g. 'udp:localhost/161').");
        System.out.println("                                 LOGGER is a fully qualified logger name and");
        System.out.println("                                 LEVEL is one of NONE, OFF, ALL, TRACE, DEBUG,");
        System.out.println("                                 INFO, WARN, ERROR, or FATAL.");
    }

    private static void printListUsage() {
        System.out.println(" list <ADDRESS> [FILTER]         List logger configuration for the agent at");
        System.out.println("                                 ADDRESS (e.g. 'udp:localhost/161') with");
        System.out.println("                                 for all logger names that contain start with");
        System.out.println("                                 the optional parameter string FILTER.");
    }

    private static void printHelpUsage() {
        System.out.println(" help [COMMAND]                  Print usage help for the specified command.");
    }

    class LoggerListListener
    implements TableListener {
        private boolean finished;

        LoggerListListener() {
        }

        public boolean next(TableEvent tableEvent) {
            this.printLogger(tableEvent);
            return tableEvent.getStatus() == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished(TableEvent tableEvent) {
            this.printLogger(tableEvent);
            this.finished = true;
            Object object = tableEvent.getUserObject();
            synchronized (object) {
                tableEvent.getUserObject().notify();
            }
        }

        private void printLogger(TableEvent tableEvent) {
            if (tableEvent.getStatus() == 0 && tableEvent.getIndex() != null) {
                int n = tableEvent.getColumns()[2].getVariable().toInt();
                if (n == 1) {
                    OctetString octetString = new OctetString();
                    octetString.fromSubIndex(tableEvent.getIndex(), true);
                    LogLevel logLevel = new LogLevel(tableEvent.getColumns()[0].getVariable().toInt());
                    LogLevel logLevel2 = new LogLevel(tableEvent.getColumns()[1].getVariable().toInt());
                    System.out.println(octetString.toString() + "=" + logLevel + "(" + logLevel2 + ")");
                }
            } else if (tableEvent.getStatus() != 0) {
                System.err.println("Logger list command failed with: " + tableEvent.getErrorMessage());
            }
        }

        public boolean isFinished() {
            return this.finished;
        }
    }
}

