/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BERSerializable;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.util.VariableTextFormat;

public class VariableBinding
implements Serializable,
BERSerializable,
Cloneable {
    private static final long serialVersionUID = 1032709950031514113L;
    private OID oid;
    private Variable variable;

    public VariableBinding() {
        this.oid = new OID();
        this.variable = Null.instance;
    }

    public VariableBinding(OID oID) {
        this.setOid(oID);
        this.variable = Null.instance;
    }

    public VariableBinding(OID oID, Variable variable) {
        this.setOid(oID);
        this.setVariable(variable);
    }

    public OID getOid() {
        return this.oid;
    }

    public void setOid(OID oID) {
        if (oID == null) {
            throw new IllegalArgumentException("OID of a VariableBinding must not be null");
        }
        this.oid = (OID)oID.clone();
    }

    public void setVariable(Variable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Variable of a VariableBinding must not be null");
        }
        this.variable = (Variable)variable.clone();
    }

    public Variable getVariable() {
        return this.variable;
    }

    public final int getSyntax() {
        return this.variable.getSyntax();
    }

    public boolean isException() {
        return this.variable.isException();
    }

    public final int getBERPayloadLength() {
        return this.oid.getBERLength() + this.variable.getBERLength();
    }

    public final int getBERLength() {
        int n = this.getBERPayloadLength();
        n += BER.getBERLengthOfLength(n) + 1;
        return n;
    }

    public final void decodeBER(BERInputStream bERInputStream) throws IOException {
        BER.MutableByte mutableByte = new BER.MutableByte();
        int n = BER.decodeHeader(bERInputStream, mutableByte);
        long l = bERInputStream.getPosition();
        if (mutableByte.getValue() != 48) {
            throw new IOException("Invalid sequence encoding: " + mutableByte.getValue());
        }
        this.oid.decodeBER(bERInputStream);
        this.variable = AbstractVariable.createFromBER(bERInputStream);
        if (BER.isCheckSequenceLength()) {
            BER.checkSequenceLength(n, (int)(bERInputStream.getPosition() - l), this);
        }
    }

    public final void encodeBER(OutputStream outputStream) throws IOException {
        int n = this.getBERPayloadLength();
        BER.encodeHeader(outputStream, 48, n);
        this.oid.encodeBER(outputStream);
        this.variable.encodeBER(outputStream);
    }

    public String toString() {
        VariableTextFormat variableTextFormat = SNMP4JSettings.getVariableTextFormat();
        return variableTextFormat.format(this.oid, this.variable, true);
    }

    public String toValueString() {
        VariableTextFormat variableTextFormat = SNMP4JSettings.getVariableTextFormat();
        return variableTextFormat.format(this.oid, this.variable, false);
    }

    public Object clone() {
        return new VariableBinding(this.oid, this.variable);
    }

    public int hashCode() {
        return this.oid.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof VariableBinding) {
            VariableBinding variableBinding = (VariableBinding)object;
            return this.oid.equals(variableBinding.getOid()) && ((Object)this.variable).equals(variableBinding.getVariable());
        }
        return false;
    }
}

