/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;

public abstract class TransportIpAddress
extends IpAddress {
    private static final LogAdapter logger = LogFactory.getLogger(TransportIpAddress.class);
    static final long serialVersionUID = 695596530250216972L;
    protected int port = 0;

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Illegal port specified: " + n);
        }
        this.port = n;
    }

    public boolean isValid() {
        return super.isValid() && this.port >= 0 && this.port <= 65535;
    }

    public int compareTo(Object object) {
        int n = super.compareTo(object);
        if (n == 0) {
            return this.port - ((TransportIpAddress)object).getPort();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof TransportIpAddress) {
            return super.equals(object) && ((TransportIpAddress)object).getPort() == this.port;
        }
        return false;
    }

    public boolean parseAddress(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            if (super.parseAddress(string2)) {
                this.port = Integer.parseInt(string3);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Address parse(String string) {
        try {
            UdpAddress udpAddress = new UdpAddress();
            if (udpAddress.parseAddress(string)) {
                return udpAddress;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return super.toString() + "/" + this.port;
    }

    public int hashCode() {
        return super.hashCode() ^ 2 + this.port;
    }

    public void setTransportAddress(OctetString octetString) throws UnknownHostException {
        OctetString octetString2 = octetString.substring(0, octetString.length() - 2);
        byte[] byArray = octetString2.getValue();
        if (byArray.length == 8 || byArray.length == 20) {
            byte[] byArray2 = new byte[byArray.length - 4];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            int n = byArray2.length;
            int n2 = (byArray[n] << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
            try {
                Class[] classArray = new Class[]{String.class, [B.class, Integer.TYPE};
                Method method = Inet6Address.class.getMethod("getByAddress", classArray);
                Object[] objectArray = new Object[]{null, byArray2, new Integer(n2)};
                Object object = method.invoke((Object)Inet6Address.class, objectArray);
                this.setInetAddress((InetAddress)object);
            }
            catch (Exception exception) {
                logger.warn("Java < 1.5 does not support scoped IPv6 addresses, ignoring scope ID for " + octetString);
                this.setInetAddress(InetAddress.getByAddress(byArray2));
            }
        } else {
            this.setInetAddress(InetAddress.getByAddress(byArray));
        }
        this.port = (octetString.get(octetString.length() - 2) & 0xFF) << 8;
        this.port += octetString.get(octetString.length() - 1) & 0xFF;
    }

    public byte[] getValue() {
        Object object;
        byte[] byArray = this.getInetAddress().getAddress();
        int n = 0;
        int n2 = 0;
        if (this.getInetAddress() instanceof Inet6Address) {
            try {
                object = (Inet6Address)this.getInetAddress();
                Method method = Inet6Address.class.getMethod("getScopeId", null);
                Object object2 = method.invoke(object, null);
                n2 = ((Number)object2).intValue();
                n = 4;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = new byte[byArray.length + 2 + n];
        System.arraycopy(byArray, 0, object, 0, byArray.length);
        int n3 = byArray.length;
        if (n > 0) {
            object[n3++] = (byte)((n2 & 0xFF000000) >> 24);
            object[n3++] = (byte)((n2 & 0xFF0000) >> 16);
            object[n3++] = (byte)((n2 & 0xFF00) >> 8);
            object[n3++] = (byte)(n2 & 0xFF);
        }
        object[n3++] = (byte)(this.port >> 8 & 0xFF);
        object[n3++] = (byte)(this.port & 0xFF);
        return object;
    }

    public void decodeBER(BERInputStream bERInputStream) throws IOException {
        OctetString octetString = new OctetString();
        octetString.decodeBER(bERInputStream);
        try {
            this.setTransportAddress(octetString);
        }
        catch (Exception exception) {
            String string = "Wrong encoding of TransportAddress";
            logger.error(string);
            throw new IOException(string + ": " + exception.getMessage());
        }
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        OctetString octetString = new OctetString(this.getValue());
        octetString.encodeBER(outputStream);
    }

    public int getBERLength() {
        return this.getValue().length;
    }

    public int getBERPayloadLength() {
        return this.getBERLength();
    }

    public int getSyntax() {
        return 4;
    }
}

