/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogLevel;
import org.snmp4j.util.EnumerationIterator;

public class Log4jLogAdapter
implements LogAdapter,
Comparable {
    private final Logger logger;
    private static final String FQCN = Log4jLogAdapter.class.getName();

    public Log4jLogAdapter(Logger logger) {
        this.logger = logger;
    }

    public void debug(Object object) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, object, null);
    }

    public void error(Object object) {
        this.logger.log(FQCN, (Priority)Level.ERROR, object, null);
    }

    public void error(Object object, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.ERROR, object, throwable);
    }

    public void info(Object object) {
        this.logger.log(FQCN, (Priority)Level.INFO, object, null);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    public void warn(Object object) {
        this.logger.log(FQCN, (Priority)Level.WARN, object, null);
    }

    public void fatal(Object object) {
        this.logger.log(FQCN, (Priority)Level.FATAL, object, null);
    }

    public void fatal(Object object, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.FATAL, object, throwable);
    }

    public void setLogLevel(LogLevel logLevel) {
        Level level;
        switch (logLevel.getLevel()) {
            case 1: {
                level = Level.OFF;
                break;
            }
            case 2: {
                level = Level.ALL;
                break;
            }
            case 3: {
                level = Level.DEBUG;
                break;
            }
            case 4: {
                level = Level.DEBUG;
                break;
            }
            case 5: {
                level = Level.INFO;
                break;
            }
            case 6: {
                level = Level.WARN;
                break;
            }
            case 7: {
                level = Level.ERROR;
                break;
            }
            case 8: {
                level = Level.FATAL;
                break;
            }
            default: {
                level = null;
            }
        }
        this.logger.setLevel(level);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getName() {
        return this.logger.getName();
    }

    public LogLevel getLogLevel() {
        Level level = this.logger.getLevel();
        return this.toLogLevel(level);
    }

    private LogLevel toLogLevel(Level level) {
        if (level == null) {
            return LogLevel.NONE;
        }
        switch (level.toInt()) {
            case 0x7FFFFFFF: {
                return LogLevel.OFF;
            }
            case -2147483648: {
                return LogLevel.ALL;
            }
            case 10000: {
                return LogLevel.DEBUG;
            }
            case 20000: {
                return LogLevel.INFO;
            }
            case 30000: {
                return LogLevel.WARN;
            }
            case 40000: {
                return LogLevel.ERROR;
            }
            case 50000: {
                return LogLevel.FATAL;
            }
        }
        return LogLevel.DEBUG;
    }

    public int compareTo(Object object) {
        return this.getName().compareTo(((Log4jLogAdapter)object).getName());
    }

    public LogLevel getEffectiveLogLevel() {
        Level level = this.logger.getEffectiveLevel();
        return this.toLogLevel(level);
    }

    public Iterator getLogHandler() {
        return new EnumerationIterator(this.logger.getAllAppenders());
    }
}

