/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import org.opends.server.types.OperatingSystem;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.CertificateManager;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public class SetupUtils {
    public static final String IS_WEBSTART = "org.opends.quicksetup.iswebstart";
    public static final String OPENDS_JAVA_HOME = "OPENDS_JAVA_HOME";
    public static final String OPENDS_JAVA_ARGS = "OPENDS_JAVA_ARGS";
    public static final String LAZY_JAR_URLS = "org.opends.quicksetup.lazyjarurls";
    public static final String ZIP_FILE_NAME = "org.opends.quicksetup.zipfilename";
    public static final String LIBRARIES_PATH_RELATIVE = "lib";
    public static final String HOST_NAME_FILE = "config" + File.separatorChar + "hostname";
    public static final String NAME = "Name";
    public static final String BUILD_ID = "Build ID";
    public static final String MAJOR_VERSION = "Major Version";
    public static final String MINOR_VERSION = "Minor Version";
    public static final String POINT_VERSION = "Point Version";
    public static final String REVISION_NUMBER = "Revision Number";
    public static final String URL_REPOSITORY = "URL Repository";
    public static final String VERSION_QUALIFIER = "Version Qualifier";
    public static final String INCOMPATIBILITY_EVENTS = "Upgrade Event IDs";
    public static final String FIX_IDS = "Fix IDs";
    public static final String DEBUG_BUILD = "Debug Build";
    public static final String BUILD_OS = "Build OS";
    public static final String BUILD_USER = "Build User";
    public static final String BUILD_JAVA_VERSION = "Build Java Version";
    public static final String BUILD_JAVA_VENDOR = "Build Java Vendor";
    public static final String BUILD_JVM_VERSION = "Build JVM Version";
    public static final String BUILD_JVM_VENDOR = "Build JVM Vendor";
    public static final String BUILD_NUMBER = "Build Number";
    private static String lastReadHostName;

    public static File createTemplateFile(String baseDN, int numEntries) throws IOException {
        HashSet<String> baseDNs = new HashSet<String>(1);
        baseDNs.add(baseDN);
        return SetupUtils.createTemplateFile(baseDNs, numEntries);
    }

    public static File createTemplateFile(Set<String> baseDNs, int numEntries) throws IOException {
        File templateFile = File.createTempFile("opends-install", ".template");
        templateFile.deleteOnExit();
        LinkedList<String> lines = new LinkedList<String>();
        int i = 0;
        for (String baseDN : baseDNs) {
            lines.add("define suffix" + ++i + "=" + baseDN);
        }
        if (numEntries > 0) {
            lines.add("define numusers=" + numEntries);
        }
        for (i = 1; i <= baseDNs.size(); ++i) {
            lines.add("");
            lines.add("branch: [suffix" + i + "]");
            lines.add("");
            lines.add("branch: ou=People,[suffix" + i + "]");
            if (numEntries <= 0) continue;
            lines.add("subordinateTemplate: person:[numusers]");
            lines.add("");
        }
        if (!baseDNs.isEmpty() && numEntries > 0) {
            lines.add("template: person");
            lines.add("rdnAttr: uid");
            lines.add("objectClass: top");
            lines.add("objectClass: person");
            lines.add("objectClass: organizationalPerson");
            lines.add("objectClass: inetOrgPerson");
            lines.add("givenName: <first>");
            lines.add("sn: <last>");
            lines.add("cn: {givenName} {sn}");
            lines.add("initials: {givenName:1}<random:chars:ABCDEFGHIJKLMNOPQRSTUVWXYZ:1>{sn:1}");
            lines.add("employeeNumber: <sequential:0>");
            lines.add("uid: user.{employeeNumber}");
            lines.add("mail: {uid}@maildomain.net");
            lines.add("userPassword: password");
            lines.add("telephoneNumber: <random:telephone>");
            lines.add("homePhone: <random:telephone>");
            lines.add("pager: <random:telephone>");
            lines.add("mobile: <random:telephone>");
            lines.add("street: <random:numeric:5> <file:streets> Street");
            lines.add("l: <file:cities>");
            lines.add("st: <file:states>");
            lines.add("postalCode: <random:numeric:5>");
            lines.add("postalAddress: {cn}${street}${l}, {st}  {postalCode}");
            lines.add("description: This is the description for {cn}.");
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(templateFile));
        for (String line : lines) {
            writer.write(line);
            writer.newLine();
        }
        writer.flush();
        writer.close();
        return templateFile;
    }

    public static boolean isMacOS() {
        return OperatingSystem.MACOS == SetupUtils.getOperatingSystem();
    }

    public static boolean isUnix() {
        return OperatingSystem.isUNIXBased(SetupUtils.getOperatingSystem());
    }

    public static boolean isWindows() {
        return OperatingSystem.WINDOWS == SetupUtils.getOperatingSystem();
    }

    public static boolean isVista() {
        String os = System.getProperty("os.name");
        boolean isVista = os != null ? SetupUtils.isWindows() && os.toLowerCase().indexOf("vista") != -1 : false;
        return isVista;
    }

    public static boolean isWindows2008() {
        String os = System.getProperty("os.name");
        boolean isWindows2008 = os != null ? SetupUtils.isWindows() && os.toLowerCase().indexOf("server 2008") != -1 : false;
        return isWindows2008;
    }

    public static boolean isWindows7() {
        String os = System.getProperty("os.name");
        boolean isWindows7 = os != null ? os.toLowerCase().indexOf("windows 7") != -1 : false;
        return isWindows7;
    }

    public static boolean hasUAC() {
        return SetupUtils.isVista() || SetupUtils.isWindows2008() || SetupUtils.isWindows7();
    }

    public static String getOSString() {
        return SetupUtils.getOperatingSystem().toString();
    }

    public static OperatingSystem getOperatingSystem() {
        return OperatingSystem.forName(System.getProperty("os.name"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canUseAsPort(String hostname, int port) {
        boolean canUseAsPort = false;
        ServerSocket serverSocket = null;
        try {
            InetSocketAddress socketAddress = hostname != null ? new InetSocketAddress(hostname, port) : new InetSocketAddress(port);
            serverSocket = new ServerSocket();
            if (!SetupUtils.isWindows()) {
                serverSocket.setReuseAddress(true);
            }
            serverSocket.bind(socketAddress);
            canUseAsPort = true;
            serverSocket.close();
            Socket s = null;
            s = new Socket();
            s.connect(socketAddress, 1000);
            canUseAsPort = false;
            if (s == null) return canUseAsPort;
            try {
                s.close();
                return canUseAsPort;
            }
            catch (Throwable t) {}
            return canUseAsPort;
            catch (Throwable t) {
                if (s == null) return canUseAsPort;
                try {
                    s.close();
                    return canUseAsPort;
                }
                catch (Throwable t2) {}
                return canUseAsPort;
                catch (Throwable throwable) {
                    if (s == null) throw throwable;
                    try {
                        s.close();
                        throw throwable;
                    }
                    catch (Throwable t3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        catch (IOException ex) {
            canUseAsPort = false;
            return canUseAsPort;
        }
        finally {
            try {
                if (serverSocket != null) {
                    serverSocket.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    public static boolean canUseAsPort(int port) {
        return SetupUtils.canUseAsPort(null, port);
    }

    public static boolean isPriviledgedPort(int port) {
        return port <= 1024 && !SetupUtils.isWindows();
    }

    public static int getDefaultJMXPort() {
        return 1689;
    }

    public static boolean isWebStart() {
        return "true".equals(System.getProperty(IS_WEBSTART));
    }

    public static String getScriptPath(String script) {
        String s = script;
        if (!(!SetupUtils.isWindows() || s == null || s.startsWith("\"") && s.endsWith("\""))) {
            s = "\"" + script + "\"";
        }
        return s;
    }

    public static char[] createSelfSignedCertificatePwd() {
        int pwdLength = 50;
        char[] pwd = new char[pwdLength];
        Random random = new Random();
        for (int pos = 0; pos < pwdLength; ++pos) {
            char nextChar;
            int type = SetupUtils.getRandomInt(random, 3);
            pwd[pos] = nextChar = SetupUtils.getRandomChar(random, type);
        }
        return pwd;
    }

    public static void exportCertificate(CertificateManager certManager, String path) throws CertificateEncodingException, IOException, KeyStoreException {
        String[] aliases = certManager.getCertificateAliases();
        Certificate certificate = certManager.getCertificate(aliases[0]);
        byte[] certificateBytes = certificate.getEncoded();
        FileOutputStream outputStream = new FileOutputStream(path, false);
        outputStream.write(certificateBytes);
        outputStream.close();
    }

    public static void exportCertificate(CertificateManager certManager, String alias, String path) throws CertificateEncodingException, IOException, KeyStoreException {
        Certificate certificate = certManager.getCertificate(alias);
        byte[] certificateBytes = certificate.getEncoded();
        FileOutputStream outputStream = new FileOutputStream(path, false);
        outputStream.write(certificateBytes);
        outputStream.close();
    }

    private static char getRandomChar(Random random, int type) {
        char generatedChar;
        int next = random.nextInt();
        switch (type) {
            case 0: {
                int d = next % 10;
                if (d < 0) {
                    d *= -1;
                }
                generatedChar = (char)(d + 48);
                break;
            }
            case 1: {
                int d = next % 26;
                if (d < 0) {
                    d *= -1;
                }
                generatedChar = (char)(d + 97);
                break;
            }
            default: {
                int d = next % 26;
                if (d < 0) {
                    d *= -1;
                }
                generatedChar = (char)(d + 65);
            }
        }
        return generatedChar;
    }

    private static int getRandomInt(Random random, int modulo) {
        return random.nextInt() & modulo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHostNameForCertificate(String installationRoot) throws UnknownHostException {
        String hostName = null;
        File f = new File(installationRoot + File.separator + HOST_NAME_FILE);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(f));
            String s = br.readLine();
            s = s.trim();
            if (s.length() > 0) {
                lastReadHostName = hostName = s;
            }
        }
        catch (IOException ioe) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {}
        }
        if (hostName == null) {
            hostName = lastReadHostName;
        }
        if (hostName == null) {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        return hostName;
    }
}

