/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opends.messages.Message;

public class OperationOutput {
    private int returnCode = -1;
    private Exception exception = null;
    private List<Message> outputMessages = new ArrayList<Message>();
    private List<Message> errorMessages = new ArrayList<Message>();
    private List<Message> debugMessages = new ArrayList<Message>();
    private List<Message> accessMessages = new ArrayList<Message>();

    public List<Message> getErrorMessages(String regex) {
        ArrayList<Message> errorMessagesSubset = new ArrayList<Message>();
        for (Message msg : this.errorMessages) {
            if (!msg.toString().matches(regex)) continue;
            errorMessagesSubset.add(msg);
        }
        return Collections.unmodifiableList(errorMessagesSubset);
    }

    public List<Message> getErrorMessages() {
        return Collections.unmodifiableList(this.errorMessages);
    }

    public List<Message> getOutputMessages() {
        return Collections.unmodifiableList(this.outputMessages);
    }

    public List<Message> getDebugMessages() {
        return Collections.unmodifiableList(this.debugMessages);
    }

    public List<Message> getAccessMessages() {
        return Collections.unmodifiableList(this.accessMessages);
    }

    public Exception getException() {
        return this.exception;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    void setException(Exception exception) {
        this.exception = exception;
    }

    void addErrorMessage(Message errorMessage) {
        this.errorMessages.add(errorMessage);
    }

    void addOutputMessage(Message outputMessage) {
        this.outputMessages.add(outputMessage);
    }

    void addAccessMessage(Message accessMessage) {
        this.accessMessages.add(accessMessage);
    }

    void addDebugMessage(Message debugMessage) {
        this.debugMessages.add(debugMessage);
    }

    void setAccessMessages(List<Message> accessMessages) {
        this.accessMessages = accessMessages;
    }

    void setDebugMessages(List<Message> debugMessages) {
        this.debugMessages = debugMessages;
    }

    void setReturnCode(int i) {
        this.returnCode = i;
    }
}

