/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.util.OperationOutput;
import org.opends.quicksetup.util.OutputReader;
import org.opends.quicksetup.util.ServerController;
import org.opends.quicksetup.util.Utils;

public class ExternalTools {
    private static final Logger LOG = Logger.getLogger(ServerController.class.getName());
    private Installation installation;

    public ExternalTools(Installation installation) {
        this.installation = installation;
    }

    public OperationOutput backup(File backupDir) throws IOException, InterruptedException {
        String toolName = "backup";
        ArrayList<String> args = new ArrayList<String>();
        args.add(Utils.getScriptPath(Utils.getPath(this.installation.getCommandFile(toolName))));
        args.add("-a");
        args.add("-d");
        args.add(Utils.getPath(backupDir));
        return this.startProcess(toolName, args);
    }

    public OperationOutput ldifDiff(File source, File target, String ... otherArgs) throws IOException, InterruptedException {
        String toolName = "ldif-diff";
        ArrayList<String> args = new ArrayList<String>();
        args.add(Utils.getPath(this.installation.getCommandFile(toolName)));
        args.add("-s");
        args.add(Utils.getScriptPath(Utils.getPath(source)));
        args.add("-t");
        args.add(Utils.getPath(target));
        if (otherArgs != null) {
            for (String otherArg : otherArgs) {
                args.add(otherArg);
            }
        }
        return this.startProcess(toolName, args);
    }

    private OperationOutput startProcess(final String toolName, List<String> args) throws IOException, InterruptedException {
        final OperationOutput oo = new OperationOutput();
        LOG.log(Level.INFO, "Invoking " + Utils.listToString(args, " "));
        ProcessBuilder pb = new ProcessBuilder(args);
        Map<String, String> env = pb.environment();
        env.put("OPENDS_JAVA_HOME", System.getProperty("java.home"));
        Process p = pb.start();
        BufferedReader out = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        new OutputReader(out){

            @Override
            public void processLine(String line) {
                oo.addErrorMessage(Message.raw(line, new Object[0]));
                LOG.log(Level.INFO, toolName + ": " + line);
            }
        };
        BufferedReader err = new BufferedReader(new InputStreamReader(p.getInputStream()));
        new OutputReader(err){

            @Override
            public void processLine(String line) {
                oo.addOutputMessage(Message.raw(line, new Object[0]));
                LOG.log(Level.INFO, toolName + ": " + line);
            }
        };
        oo.setReturnCode(p.waitFor());
        return oo;
    }
}

