/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.event.BrowseActionListener;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.LabelFieldDescriptor;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.ui.Utilities;
import org.opends.quicksetup.upgrader.Upgrader;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.DynamicConstants;

public class WelcomePanel
extends QuickSetupStepPanel {
    private static final long serialVersionUID = 8695606871542491768L;
    private JLabel lblServerLocation;
    private JTextComponent tcServerLocation;
    private JTextComponent tcCurrentServerBuildNumber;

    public WelcomePanel(Upgrader application) {
        super(application);
    }

    @Override
    public void beginDisplay(UserData data) {
        super.beginDisplay(data);
        this.tcServerLocation.setText(data.getServerLocation());
    }

    @Override
    public Object getFieldValue(FieldName fieldName) {
        String v = null;
        if (FieldName.SERVER_TO_UPGRADE_LOCATION.equals((Object)fieldName)) {
            v = this.tcServerLocation.getText();
        }
        return v;
    }

    @Override
    public void displayFieldInvalid(FieldName fieldName, boolean invalid) {
        UIFactory.TextStyle style = invalid ? UIFactory.TextStyle.PRIMARY_FIELD_INVALID : UIFactory.TextStyle.PRIMARY_FIELD_VALID;
        if (FieldName.SERVER_TO_UPGRADE_LOCATION.equals((Object)fieldName)) {
            UIFactory.setTextStyle(this.lblServerLocation, style);
        }
    }

    @Override
    protected Message getTitle() {
        return QuickSetupMessages.INFO_UPGRADE_WELCOME_PANEL_TITLE.get();
    }

    @Override
    protected Message getInstructions() {
        return Utils.getCustomizedObject("INFO_UPGRADE_WELCOME_PANEL_WEBSTART_INSTRUCTIONS", QuickSetupMessages.INFO_UPGRADE_WELCOME_PANEL_WEBSTART_INSTRUCTIONS.get(DynamicConstants.COMPACT_VERSION_STRING, DynamicConstants.BUILD_ID), Message.class);
    }

    @Override
    protected Component createInputPanel() {
        LabelFieldDescriptor serverLocationDescriptor = new LabelFieldDescriptor(QuickSetupMessages.INFO_UPGRADE_LOCATION_LABEL.get(), QuickSetupMessages.INFO_UPGRADE_LOCATION_TOOLTIP.get(), LabelFieldDescriptor.FieldType.TEXTFIELD, LabelFieldDescriptor.LabelType.PRIMARY, 20);
        LabelFieldDescriptor serverLocationDescriptorRO = new LabelFieldDescriptor(QuickSetupMessages.INFO_UPGRADE_LOCATION_LABEL.get(), QuickSetupMessages.INFO_UPGRADE_LOCATION_TOOLTIP.get(), LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 20);
        LabelFieldDescriptor serverBuildDescriptorRO = new LabelFieldDescriptor(QuickSetupMessages.INFO_UPGRADE_BUILD_ID_LABEL.get(), QuickSetupMessages.INFO_UPGRADE_BUILD_ID_TOOLTIP.get(), LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 20);
        JPanel pnlBuildInfo = UIFactory.makeJPanel();
        pnlBuildInfo.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        UserData userData = this.getApplication().getUserData();
        if (Utils.isWebStart()) {
            this.lblServerLocation = UIFactory.makeJLabel(serverLocationDescriptor);
            this.tcServerLocation = UIFactory.makeJTextComponent(serverLocationDescriptor, userData.getServerLocation());
            JButton butBrowse = UIFactory.makeJButton(QuickSetupMessages.INFO_BROWSE_BUTTON_LABEL.get(), QuickSetupMessages.INFO_BROWSE_BUTTON_TOOLTIP.get());
            BrowseActionListener l = new BrowseActionListener(this.tcServerLocation, BrowseActionListener.BrowseType.LOCATION_DIRECTORY, this.getMainWindow());
            butBrowse.addActionListener(l);
            JPanel pnlBrowser = Utilities.createBrowseButtonPanel(this.lblServerLocation, this.tcServerLocation, butBrowse);
            pnlBrowser.setOpaque(false);
            gbc.insets.top = 15;
            gbc.insets.left = 10;
            gbc.anchor = 23;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            pnlBuildInfo.add((Component)pnlBrowser, gbc);
            gbc.gridy = 1;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            gbc.anchor = 21;
            JPanel fill = UIFactory.makeJPanel();
            pnlBuildInfo.add((Component)fill, gbc);
        } else {
            this.tcServerLocation = UIFactory.makeJTextComponent(serverLocationDescriptorRO, null);
            String buildId = null;
            Installation installation = this.getApplication().getInstallation();
            try {
                buildId = installation.getBuildInformation().getBuildId();
            }
            catch (Exception e) {
                buildId = QuickSetupMessages.INFO_UPGRADE_BUILD_ID_UNKNOWN.get().toString();
            }
            this.tcCurrentServerBuildNumber = UIFactory.makeJTextComponent(serverBuildDescriptorRO, buildId);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 23;
            gbc.insets.top = 15;
            gbc.insets.left = 10;
            pnlBuildInfo.add((Component)UIFactory.makeJLabel(serverLocationDescriptorRO), gbc);
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.insets.left = 10;
            gbc.fill = 2;
            gbc.anchor = 19;
            pnlBuildInfo.add((Component)this.tcServerLocation, gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 21;
            gbc.insets.left = 10;
            gbc.insets.top = 10;
            pnlBuildInfo.add((Component)UIFactory.makeJLabel(serverBuildDescriptorRO), gbc);
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.insets.left = 10;
            gbc.fill = 2;
            pnlBuildInfo.add((Component)this.tcCurrentServerBuildNumber, gbc);
            gbc.gridy = 2;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            gbc.anchor = 21;
            JPanel fill = UIFactory.makeJPanel();
            pnlBuildInfo.add((Component)fill, gbc);
        }
        JPanel c = pnlBuildInfo;
        return c;
    }
}

