/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.Launcher;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.UserDataException;
import org.opends.quicksetup.upgrader.Stage;
import org.opends.quicksetup.upgrader.UpgradeFileFilter;
import org.opends.quicksetup.upgrader.UpgradeSvr4Launcher;
import org.opends.quicksetup.upgrader.Upgrader;
import org.opends.quicksetup.upgrader.UpgraderCliHelper;
import org.opends.quicksetup.util.FileManager;

public class UpgraderSvr4
extends Upgrader {
    private static final Logger LOG = Logger.getLogger(UpgraderSvr4.class.getName());

    @Override
    public UserData createUserData(Launcher launcher) throws UserDataException {
        return new UpgraderCliHelper((UpgradeSvr4Launcher)launcher).createUserData(launcher.getArguments());
    }

    @Override
    protected File getStageDirectory() throws ApplicationException, IOException {
        return this.getInstallation().getTmplInstanceDirectory();
    }

    @Override
    protected Installation getStagedInstallation() throws IOException, ApplicationException {
        return this.getInstallation();
    }

    @Override
    protected void cleanup() throws ApplicationException {
    }

    @Override
    protected void backupFilesystem() throws ApplicationException {
        try {
            FileManager fm = new FileManager();
            File filesBackupDirectory = this.getFilesInstanceBackupDirectory();
            File root = this.getInstallation().getInstanceDirectory();
            UpgradeFileFilter filter = new UpgradeFileFilter(root, false);
            for (String fileName : root.list()) {
                File f = new File(root, fileName);
                fm.move(f, filesBackupDirectory, filter);
            }
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new ApplicationException(ReturnCode.FILE_SYSTEM_ACCESS_ERROR, QuickSetupMessages.INFO_ERROR_BACKUP_FILESYSTEM.get(), e);
        }
    }

    @Override
    protected void upgradeComponents() throws ApplicationException {
        try {
            Stage stage = this.getStage();
            Installation installation = this.getInstallation();
            File root = installation.getInstanceDirectory();
            stage.move(root, new UpgradeFileFilter(this.getStageDirectory(), false));
            LOG.log(Level.INFO, "upgraded bits to " + installation.getBuildInformation(false));
        }
        catch (IOException e) {
            throw ApplicationException.createFileSystemException(QuickSetupMessages.INFO_ERROR_UPGRADING_COMPONENTS.get(), e);
        }
    }
}

