/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ProgressStep;

enum UpgradeProgressStep implements ProgressStep
{
    NOT_STARTED(QuickSetupMessages.INFO_SUMMARY_UPGRADE_NOT_STARTED.get(), null, null, 0, false),
    DOWNLOADING(QuickSetupMessages.INFO_SUMMARY_UPGRADE_DOWNLOADING.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_DOWNLOADING.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_DOWNLOADING.get(), 0, true),
    EXTRACTING(QuickSetupMessages.INFO_SUMMARY_UPGRADE_EXTRACTING.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_EXTRACTING.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_EXTRACTING_VERBOSE.get(), 15, true),
    INITIALIZING(QuickSetupMessages.INFO_SUMMARY_UPGRADE_INITIALIZING.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_INITIALIZING.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_INITIALIZING.get(), 20, true),
    CALCULATING_SCHEMA_CUSTOMIZATIONS(QuickSetupMessages.INFO_SUMMARY_UPGRADE_CALCULATING_SCHEMA_CUSTOMIZATION.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_CALCULATING_SCHEMA_CUSTOMIZATION.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_CALCULATING_SCHEMA_CUSTOMIZATION.get(), 25, true),
    CALCULATING_CONFIGURATION_CUSTOMIZATIONS(QuickSetupMessages.INFO_SUMMARY_UPGRADE_CALCULATING_CONFIG_CUSTOMIZATION.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_CALCULATING_CONFIG_CUSTOMIZATION.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_CALCULATING_CONFIG_CUSTOMIZATION.get(), 30, true),
    BACKING_UP_DATABASES(QuickSetupMessages.INFO_SUMMARY_UPGRADE_BACKING_UP_DB.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_BACKING_UP_DB.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_BACKING_UP_DB.get(), 35, true),
    BACKING_UP_FILESYSTEM(QuickSetupMessages.INFO_SUMMARY_UPGRADE_BACKING_UP_FILES.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_BACKING_UP_FILES.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_BACKING_UP_FILES.get(), 40, true),
    UPGRADING_COMPONENTS(QuickSetupMessages.INFO_SUMMARY_UPGRADE_UPGRADING_COMPONENTS.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_UPGRADING_COMPONENTS.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_UPGRADING_COMPONENTS.get(), 45, true),
    PREPARING_CUSTOMIZATIONS(QuickSetupMessages.INFO_SUMMARY_UPGRADE_PREPARING_CUSTOMIZATIONS.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_PREPARING_CUSTOMIZATIONS.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_PREPARING_CUSTOMIZATIONS.get(), 50, true),
    APPLYING_SCHEMA_CUSTOMIZATIONS(QuickSetupMessages.INFO_SUMMARY_UPGRADE_APPLYING_SCHEMA_CUSTOMIZATION.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_APPLYING_SCHEMA_CUSTOMIZATION.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_APPLYING_SCHEMA_CUSTOMIZATION.get(), 55, true),
    APPLYING_CONFIGURATION_CUSTOMIZATIONS(QuickSetupMessages.INFO_SUMMARY_UPGRADE_APPLYING_CONFIG_CUSTOMIZATION.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_APPLYING_CONFIG_CUSTOMIZATION.get(), QuickSetupMessages.INFO_SUMMARY_UPGRADE_APPLYING_CONFIG_CUSTOMIZATION.get(), 60, true),
    APPLYING_ADS_CUSTOMIZATIONS(QuickSetupMessages.INFO_SUMMARY_UPGRADE_APPLYING_ADS_CUSTOMIZATION.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_APPLYING_ADS_CUSTOMIZATION.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_APPLYING_ADS_CUSTOMIZATION.get(), 65, true),
    VERIFYING(QuickSetupMessages.INFO_SUMMARY_UPGRADE_VERIFYING.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_VERIFYING.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_VERIFYING.get(), 70, true),
    STARTING_SERVER(QuickSetupMessages.INFO_SUMMARY_STARTING.get(), null, null, 75, false),
    STOPPING_SERVER(QuickSetupMessages.INFO_SUMMARY_STOPPING.get(), null, null, 75, false),
    RECORDING_HISTORY(QuickSetupMessages.INFO_SUMMARY_UPGRADE_HISTORY.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_HISTORY.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_HISTORY.get(), 90, true),
    CLEANUP(QuickSetupMessages.INFO_SUMMARY_UPGRADE_CLEANUP.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_CLEANUP.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_CLEANUP.get(), 90, true),
    ABORT(QuickSetupMessages.INFO_SUMMARY_UPGRADE_ABORT.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_ABORT.get(), QuickSetupMessages.INFO_PROGRESS_UPGRADE_ABORT.get(), 90, true),
    FINISHED_WITH_ERRORS(QuickSetupMessages.INFO_SUMMARY_UPGRADE_FINISHED_WITH_ERRORS.get(), null, null, 100, false),
    FINISHED_WITH_WARNINGS(QuickSetupMessages.INFO_SUMMARY_UPGRADE_FINISHED_WITH_WARNINGS.get(), null, null, 100, false),
    FINISHED_CANCELED(QuickSetupMessages.INFO_SUMMARY_UPGRADE_FINISHED_CANCELED.get(), null, null, 100, false),
    FINISHED(QuickSetupMessages.INFO_SUMMARY_UPGRADE_FINISHED_SUCCESSFULLY.get("", ""), null, null, 100, false);

    private Message summaryMsg;
    private Message logMsg;
    private Message logMsgVerbose;
    private int progress;
    private boolean logWithPoints;

    private UpgradeProgressStep(Message summaryMsg, Message logMsg, Message logMsgVerbose, int progress, boolean logWithPoints) {
        this.summaryMsg = summaryMsg;
        this.logMsg = logMsg;
        this.logMsgVerbose = logMsgVerbose;
        this.progress = progress;
        this.logWithPoints = logWithPoints;
    }

    public Message getSummaryMessage() {
        return this.summaryMsg;
    }

    public Message getLogMsg(boolean isVerbose) {
        Message msg = isVerbose ? this.logMsgVerbose : this.logMsg;
        return msg;
    }

    public boolean logRequiresPoints(boolean isVerbose) {
        boolean returnValue = this.logWithPoints ? (isVerbose ? this.logMsgVerbose == this.logMsg : true) : false;
        return returnValue;
    }

    public int getProgress() {
        return this.progress;
    }

    @Override
    public boolean isLast() {
        return this == FINISHED || this == FINISHED_WITH_ERRORS || this == FINISHED_WITH_WARNINGS || this == FINISHED_CANCELED;
    }

    @Override
    public boolean isError() {
        return this == FINISHED_WITH_ERRORS;
    }
}

