/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.util.FileManager;
import org.opends.quicksetup.util.Utils;

public class Stage {
    private static final Logger LOG = Logger.getLogger(Stage.class.getName());
    private File root;
    private FileManager fm;
    private List<Message> messages = new LinkedList<Message>();

    public Stage(File root) {
        this.root = root;
        this.fm = new FileManager();
    }

    public void move(File destination, FileFilter fileFilter) throws ApplicationException {
        for (String fileName : this.root.list()) {
            File dest = new File(destination, fileName);
            File srctmp = new File(this.root, fileName);
            File src = this.getSourceForCopy(srctmp, fileName, dest);
            this.fm.copyRecursively(src, destination, fileFilter, true);
        }
    }

    public void move(File destination, FileFilter fileFilter, boolean forInstallDir) throws ApplicationException {
        File actualRoot = this.root;
        actualRoot = forInstallDir ? new File(this.root, "install") : new File(this.root, "instance");
        for (String fileName : actualRoot.list()) {
            File dest = new File(destination, fileName);
            File srctmp = new File(actualRoot, fileName);
            File src = this.getSourceForCopy(srctmp, fileName, dest);
            this.fm.copyRecursively(src, destination, fileFilter, true);
        }
    }

    public List<Message> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    private File getSourceForCopy(File src, String fileName, File dest) {
        if ("upgrade.bat".equals(fileName) && Utils.isWindows()) {
            try {
                if (this.fm.filesDiffer(src, dest)) {
                    File renamedUpgradeBatFile = new File(this.root, "upgrade.bat.NEW");
                    if (src.renameTo(renamedUpgradeBatFile)) {
                        src = renamedUpgradeBatFile;
                        this.messages.add(QuickSetupMessages.INFO_NEW_UPGRADE_SCRIPT_AVAILABLE.get("upgrade.bat", "upgrade.bat.NEW"));
                    } else {
                        LOG.log(Level.INFO, "Failed to rename new version of 'upgrade.bat' to 'upgrade.bat.NEW'");
                    }
                }
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "Exception comparing files " + e.getMessage());
            }
        }
        return src;
    }
}

