/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ProgressStep;

enum ReversionProgressStep implements ProgressStep
{
    NOT_STARTED(QuickSetupMessages.INFO_SUMMARY_REVERT_NOT_STARTED.get(), null, null, 0, false),
    INITIALIZING(QuickSetupMessages.INFO_SUMMARY_REVERT_INITIALIZING.get(), QuickSetupMessages.INFO_PROGRESS_REVERT_INITIALIZING.get(), QuickSetupMessages.INFO_PROGRESS_REVERT_INITIALIZING.get(), 20, true),
    STOPPING_SERVER(QuickSetupMessages.INFO_SUMMARY_STOPPING.get(), null, null, 40, false),
    REVERTING_FILESYSTEM(QuickSetupMessages.INFO_SUMMARY_REVERT_REVERTING_COMPONENTS.get(), QuickSetupMessages.INFO_PROGRESS_REVERT_REVERTING_COMPONENTS.get(), QuickSetupMessages.INFO_PROGRESS_REVERT_REVERTING_COMPONENTS.get(), 60, true),
    VERIFYING(QuickSetupMessages.INFO_SUMMARY_REVERT_VERIFYING.get(), QuickSetupMessages.INFO_PROGRESS_REVERT_VERIFYING.get(), QuickSetupMessages.INFO_PROGRESS_REVERT_VERIFYING.get(), 70, true),
    STARTING_SERVER(QuickSetupMessages.INFO_SUMMARY_STARTING.get(), null, null, 80, false),
    RECORDING_HISTORY(QuickSetupMessages.INFO_SUMMARY_REVERT_HISTORY.get(), QuickSetupMessages.INFO_PROGRESS_REVERT_HISTORY.get(), QuickSetupMessages.INFO_PROGRESS_REVERT_HISTORY.get(), 90, true),
    CLEANUP(QuickSetupMessages.INFO_SUMMARY_REVERT_CLEANUP.get(), QuickSetupMessages.INFO_PROGRESS_REVERT_CLEANUP.get(), QuickSetupMessages.INFO_PROGRESS_REVERT_CLEANUP.get(), 95, true),
    ABORT(QuickSetupMessages.INFO_SUMMARY_REVERT_ABORT.get(), QuickSetupMessages.INFO_PROGRESS_REVERT_ABORT.get(), QuickSetupMessages.INFO_PROGRESS_REVERT_ABORT.get(), 99, true),
    FINISHED_WITH_ERRORS(QuickSetupMessages.INFO_SUMMARY_REVERT_FINISHED_WITH_ERRORS_CLI.get(), null, null, 100, false),
    FINISHED_WITH_WARNINGS(QuickSetupMessages.INFO_SUMMARY_REVERT_FINISHED_WITH_WARNINGS_CLI.get(), null, null, 100, false),
    FINISHED_CANCELED(QuickSetupMessages.INFO_SUMMARY_REVERT_FINISHED_CANCELED_CLI.get(), null, null, 100, false),
    FINISHED(QuickSetupMessages.INFO_SUMMARY_REVERT_FINISHED_SUCCESSFULLY_CLI.get("", ""), null, null, 100, false);

    private Message summaryMsg;
    private Message logMsg;
    private Message logMsgVerbose;
    private int progress;
    private boolean logWithPoints;

    private ReversionProgressStep(Message summaryMsg, Message logMsg, Message logMsgVerbose, int progress, boolean logWithPoints) {
        this.summaryMsg = summaryMsg;
        this.logMsg = logMsg;
        this.logMsgVerbose = logMsgVerbose;
        this.progress = progress;
        this.logWithPoints = logWithPoints;
    }

    public Message getSummaryMessage() {
        return this.summaryMsg;
    }

    public Message getLogMsg(boolean isVerbose) {
        Message msg = isVerbose ? this.logMsgVerbose : this.logMsg;
        return msg;
    }

    public boolean logRequiresPoints(boolean isVerbose) {
        boolean returnValue = this.logWithPoints ? (isVerbose ? this.logMsgVerbose == this.logMsg : true) : false;
        return returnValue;
    }

    public int getProgress() {
        return this.progress;
    }

    @Override
    public boolean isLast() {
        return this == FINISHED || this == FINISHED_WITH_ERRORS || this == FINISHED_WITH_WARNINGS || this == FINISHED_CANCELED;
    }

    @Override
    public boolean isError() {
        return this == FINISHED_WITH_ERRORS;
    }
}

