/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.BuildInformation;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.UserInteraction;
import org.opends.quicksetup.upgrader.VersionIssueNotifier;
import org.opends.server.util.VersionCompatibilityIssue;

public class ReversionIssueNotifier
extends VersionIssueNotifier {
    private static final Logger LOG = Logger.getLogger(ReversionIssueNotifier.class.getName());

    public ReversionIssueNotifier(UserInteraction ui, BuildInformation current, BuildInformation neu) {
        super(ui, current, neu);
    }

    @Override
    public void notifyUser() throws ApplicationException {
        Message cont = QuickSetupMessages.INFO_ORACLE_ACTION_PROMPT_CONTINUE.get();
        Message cancel = QuickSetupMessages.INFO_ORACLE_ACTION_PROMPT_CANCEL.get();
        if (this.hasIssues()) {
            List<VersionIssueNotifier.Directive> issues = this.getIssues();
            if (!this.isSupported()) {
                MessageBuilder reason = new MessageBuilder();
                if (issues != null) {
                    for (VersionIssueNotifier.Directive directive : issues) {
                        LOG.log(Level.INFO, "Unsupported reversion details: " + directive.getMessage());
                        reason.append(directive.getMessage());
                        reason.append(EOL);
                    }
                }
                throw new ApplicationException(ReturnCode.APPLICATION_ERROR, QuickSetupMessages.INFO_REVERSION_ORACLE_UNSUPPORTED.get(this.currentBuildInfo.toString(), this.newBuildInfo.toString(), reason.toMessage()), null);
            }
            if (this.ui != null) {
                for (VersionIssueNotifier.Directive directive : issues) {
                    Message defaultAction;
                    UserInteraction.MessageType msgType;
                    Message details;
                    Message summary;
                    Message title;
                    String lineBreak = this.ui.isCLI() ? Constants.LINE_SEPARATOR : "<br>";
                    switch (directive.getType()) {
                        case ACTION: {
                            title = QuickSetupMessages.INFO_GENERAL_ACTION_REQUIRED.get();
                            summary = QuickSetupMessages.INFO_REVERSION_ORACLE_ACTION.get();
                            details = new MessageBuilder(directive.getMessage()).append(lineBreak).append(lineBreak).append(QuickSetupMessages.INFO_ORACLE_ACTION_PROMPT.get()).toMessage();
                            msgType = UserInteraction.MessageType.WARNING;
                            defaultAction = cancel;
                            break;
                        }
                        case INFO: {
                            title = QuickSetupMessages.INFO_GENERAL_INFO.get();
                            summary = QuickSetupMessages.INFO_REVERSION_ORACLE_INFO.get();
                            details = new MessageBuilder(directive.getMessage()).append(lineBreak).append(lineBreak).append(QuickSetupMessages.INFO_ORACLE_INFO_PROMPT.get()).toMessage();
                            msgType = UserInteraction.MessageType.INFORMATION;
                            defaultAction = cont;
                            break;
                        }
                        case WARNING: {
                            title = QuickSetupMessages.INFO_GENERAL_WARNING.get();
                            summary = QuickSetupMessages.INFO_REVERSION_ORACLE_WARNING.get();
                            details = new MessageBuilder(directive.getMessage()).append(lineBreak).append(lineBreak).append(QuickSetupMessages.INFO_ORACLE_INFO_PROMPT.get()).toMessage();
                            msgType = UserInteraction.MessageType.WARNING;
                            defaultAction = cont;
                            break;
                        }
                        default: {
                            LOG.log(Level.INFO, "Unexpected issue type " + (Object)((Object)directive.getType()));
                            title = Message.EMPTY;
                            summary = Message.EMPTY;
                            details = directive.getMessage();
                            msgType = UserInteraction.MessageType.WARNING;
                            defaultAction = cont;
                        }
                    }
                    if (!cancel.equals(this.ui.confirm(summary, details, title, msgType, new Message[]{cont, cancel}, defaultAction))) continue;
                    throw new ApplicationException(ReturnCode.CANCELED, QuickSetupMessages.INFO_REVERSION_CANCELED.get(), null);
                }
            } else {
                throw new ApplicationException(ReturnCode.APPLICATION_ERROR, QuickSetupMessages.INFO_ORACLE_NO_SILENT.get(), null);
            }
        }
    }

    @Override
    protected Message getLocalizedDetailMessage(VersionCompatibilityIssue.Cause cause) {
        Message msg = cause.getLocalizedReversionMessage();
        Set effects = cause.getEffects();
        if (effects.contains(VersionCompatibilityIssue.Effect.REVERSION_DATA_EXPORT_AND_REIMPORT_REQUIRED)) {
            if (this.ui != null) {
                String lineBreak = this.ui.isCLI() ? Constants.LINE_SEPARATOR : "<br>";
                msg = new MessageBuilder(msg).append(lineBreak).append(this.ui.createUnorderedList(this.getExportImportInstructions())).toMessage();
            } else {
                String lineBreak = Constants.LINE_SEPARATOR;
                msg = new MessageBuilder(msg).append(lineBreak).append(this.createUnorderedList(this.getExportImportInstructions())).toMessage();
            }
        }
        return msg;
    }

    @Override
    protected boolean isActionRequired(VersionCompatibilityIssue.Cause cause) {
        boolean isAction = false;
        if (cause != null) {
            Set effects = cause.getEffects();
            isAction = effects.contains(VersionCompatibilityIssue.Effect.REVERSION_DATA_EXPORT_AND_REIMPORT_REQUIRED) || effects.contains(VersionCompatibilityIssue.Effect.REVERSION_MANUAL_ACTION_REQUIRED) && cause.getLocalizedUpgradeMessage() != null;
        }
        return isAction;
    }

    @Override
    protected boolean isWarning(VersionCompatibilityIssue.Cause cause) {
        boolean isWarning = false;
        if (cause != null && !this.isActionRequired(cause)) {
            Set effects = cause.getEffects();
            isWarning = effects.contains(VersionCompatibilityIssue.Effect.REVERSION_SHOW_WARNING_MESSAGE) && cause.getLocalizedUpgradeMessage() != null;
        }
        return isWarning;
    }

    @Override
    protected boolean isUnsupported(VersionCompatibilityIssue.Cause cause) {
        boolean isUnsupported = false;
        if (cause != null) {
            Set effects = cause.getEffects();
            for (VersionCompatibilityIssue.Effect effect : effects) {
                switch (effect) {
                    case REVERSION_NOT_POSSIBLE: {
                        isUnsupported = true;
                        break;
                    }
                }
            }
        }
        return isUnsupported;
    }
}

