/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.CliApplication;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.Launcher;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.UserDataException;
import org.opends.quicksetup.event.ProgressUpdateListener;
import org.opends.quicksetup.upgrader.BuildExtractorCliHelper;
import org.opends.quicksetup.upgrader.UpgradeLauncher;
import org.opends.quicksetup.upgrader.UpgradeUserData;
import org.opends.quicksetup.util.FileManager;
import org.opends.quicksetup.util.ProgressMessageFormatter;
import org.opends.quicksetup.util.Utils;
import org.opends.quicksetup.util.ZipExtractor;

public class BuildExtractor
extends UpgradeLauncher
implements CliApplication {
    private static final Logger LOG = Logger.getLogger(BuildExtractor.class.getName());
    private static final int RC_CONTINUE_WITH_UPGRADE = 99;
    private static final int RC_CONTINUE_WITH_REVERSION = 98;
    private UpgradeUserData userData;
    private boolean finished;
    private ApplicationException error;
    private ReturnCode rc;

    public static void main(String[] args) {
        try {
            QuickSetupLog.initLogFileHandler(File.createTempFile("opends-upgrade-ext-", ".log"));
        }
        catch (Throwable t) {
            System.err.println(QuickSetupMessages.INFO_ERROR_INITIALIZING_LOG.get());
            t.printStackTrace();
        }
        new BuildExtractor(args).launch();
    }

    private BuildExtractor(String[] args) {
        super(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block9: {
            UpgradeUserData uud = (UpgradeUserData)this.getUserData();
            if (UpgradeUserData.Operation.REVERSION.equals((Object)uud.getOperation())) {
                this.rc = new ReturnCode(98);
            } else {
                try {
                    File buildFile = uud.getInstallPackage();
                    if (buildFile != null) {
                        LOG.log(Level.INFO, "Expanding zip file " + buildFile.getPath());
                        File stageDirectory = this.initStageDirectory();
                        ZipExtractor extractor = new ZipExtractor(buildFile);
                        extractor.extract(stageDirectory);
                        LOG.log(Level.INFO, "Extraction finished");
                        Installation installation = new Installation(stageDirectory, stageDirectory);
                        if (!installation.isValid(stageDirectory)) {
                            LOG.log(Level.INFO, "Extraction produed an invalid OpenDSinstallation: " + installation.getInvalidityReason());
                            Message invalidMsg = QuickSetupMessages.INFO_BUILD_EXTRACTOR_FILE_INVALID.get(Utils.getPath(buildFile), installation.getInvalidityReason());
                            this.error = new ApplicationException(ReturnCode.APPLICATION_ERROR, invalidMsg, null);
                            System.err.println(invalidMsg);
                        }
                        this.rc = new ReturnCode(99);
                        break block9;
                    }
                    LOG.log(Level.INFO, "Build extractor failed to specify valid installation zip file");
                    throw new IllegalStateException("Build extractor failed to specify valid installation zip file");
                }
                catch (Throwable t) {
                    LOG.log(Level.INFO, "Unexpected error extracting build", t);
                    String reason = t.getLocalizedMessage();
                    this.error = new ApplicationException(ReturnCode.APPLICATION_ERROR, QuickSetupMessages.INFO_BUILD_EXTRACTOR_ERROR.get(reason), t);
                    System.err.println(reason);
                }
                finally {
                    this.finished = true;
                }
            }
        }
    }

    private File initStageDirectory() throws ApplicationException {
        Installation installation = new Installation(this.getInstallationPath(), this.getInstancePath());
        File stageDir = installation.getTemporaryUpgradeDirectory();
        if (stageDir.exists()) {
            FileManager fm = new FileManager();
            fm.deleteRecursively(stageDir);
        }
        if (!stageDir.mkdirs()) {
            Message msg = QuickSetupMessages.INFO_ERROR_FAILED_TO_CREATE_STAGE_DIRECTORY.get(Utils.getPath(stageDir));
            throw ApplicationException.createFileSystemException(msg, null);
        }
        LOG.log(Level.INFO, "stage directory " + stageDir.getPath());
        return stageDir;
    }

    @Override
    protected CliApplication createCliApplication() {
        return this;
    }

    public String getInstallationPath() {
        return Utils.getInstallPathFromClasspath();
    }

    public String getInstancePath() {
        return Utils.getInstancePathFromInstallPath(this.getInstallationPath());
    }

    @Override
    public UserData createUserData(Launcher launcher) throws UserDataException {
        BuildExtractorCliHelper helper = new BuildExtractorCliHelper((UpgradeLauncher)launcher);
        UpgradeUserData uud = helper.createUserData(this.args);
        if (uud != null) {
            uud.setQuiet(true);
            if (UpgradeUserData.Operation.UPGRADE.equals((Object)uud.getOperation())) {
                this.isUpgrade = true;
            } else if (UpgradeUserData.Operation.REVERSION.equals((Object)uud.getOperation())) {
                this.isReversion = true;
            }
        }
        return uud;
    }

    @Override
    public UserData getUserData() {
        return this.userData;
    }

    @Override
    public void setUserData(UserData userData) {
        if (userData instanceof UpgradeUserData) {
            this.userData = (UpgradeUserData)userData;
        }
    }

    @Override
    public void setProgressMessageFormatter(ProgressMessageFormatter formatter) {
    }

    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public ApplicationException getRunError() {
        return this.error;
    }

    @Override
    public ReturnCode getReturnCode() {
        return this.rc;
    }

    @Override
    public void addProgressUpdateListener(ProgressUpdateListener l) {
    }

    @Override
    public void removeProgressUpdateListener(ProgressUpdateListener l) {
    }

    @Override
    public void notifyListeners(Integer ratio, Message currentPhaseSummary, Message newLogDetail) {
    }
}

