/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ui.HeaderRenderer;
import org.opends.quicksetup.ui.LabelFieldDescriptor;
import org.opends.quicksetup.ui.ProgressJEditorPane;
import org.opends.quicksetup.ui.SortableTableModel;
import org.opends.quicksetup.ui.TextFieldFocusListener;

public class UIFactory {
    private static boolean initialized = false;
    private static String parentPackagePath;
    private static final Logger LOG;
    public static final int HORIZONTAL_INSET_BETWEEN_BUTTONS = 5;
    public static final int HORIZONTAL_INSET_CONTROL_PANEL_SUBSECTION = 20;
    public static final int TOP_INSET_STEP = 15;
    public static final int LEFT_INSET_STEP = 5;
    public static final int LEFT_INSET_SUBSTEP = 20;
    public static final int TOP_INSET_INSTRUCTIONS_SUBPANEL = 5;
    public static final int TOP_INSET_INPUT_SUBPANEL = 10;
    public static final int TOP_INSET_PRIMARY_FIELD = 10;
    public static final int TOP_INSET_SECONDARY_FIELD = 5;
    public static final int TOP_INSET_RADIOBUTTON = 0;
    public static final int TOP_INSET_RADIO_SUBORDINATE = 0;
    public static final int TOP_INSET_PROGRESS_BAR = 5;
    public static final int TOP_INSET_PROGRESS_TEXTAREA = 4;
    public static final int TOP_INSET_BACKGROUND = 70;
    public static final int TOP_INSET_ERROR_MESSAGE = 10;
    public static final int TOP_INSET_BROWSE = 5;
    public static final int TOP_INSET_CONTROL_PANEL_SUBSECTION = 30;
    public static final int RIGHT_INSET_BACKGROUND = 20;
    public static final int LEFT_INSET_PRIMARY_FIELD = 10;
    public static final int LEFT_INSET_BROWSE = 10;
    public static final int LEFT_INSET_RADIO_SUBORDINATE = 35;
    public static final int LEFT_INSET_SECONDARY_FIELD = 5;
    public static final int LEFT_INSET_BACKGROUND = 20;
    public static final int LEFT_INSET_COPY_BUTTON = 10;
    public static final int LEFT_INSET_SUBPANEL_SUBORDINATE = 30;
    public static final int BOTTOM_INSET_PROGRESS_BAR = 10;
    public static final int BOTTOM_INSET_BACKGROUND = 30;
    public static final int PATH_FIELD_SIZE = 20;
    public static final int RELATIVE_PATH_FIELD_SIZE = 10;
    public static final int HOST_FIELD_SIZE = 20;
    public static final int UID_FIELD_SIZE = 15;
    public static final int PORT_FIELD_SIZE = 5;
    public static final int DN_FIELD_SIZE = 20;
    public static final int PASSWORD_FIELD_SIZE = 15;
    public static final int NUMBER_ENTRIES_FIELD_SIZE = 7;
    public static final int PROGRESS_BAR_SIZE = 220;
    public static final int EXTRA_DIALOG_HEIGHT = 75;
    private static final Insets BUTTONS_PANEL_INSETS;
    private static final Insets STEPS_PANEL_INSETS;
    private static final Insets CURRENT_STEP_PANEL_INSETS;
    private static final Insets EMPTY_INSETS;
    public static final Color DEFAULT_BACKGROUND;
    public static final Color CURRENT_STEP_PANEL_BACKGROUND;
    public static final Color DEFAULT_LABEL_COLOR;
    public static final Color FIELD_VALID_COLOR;
    public static final Color FIELD_INVALID_COLOR;
    public static final Color READ_ONLY_COLOR;
    public static final Color CHECKBOX_COLOR;
    public static final Color PROGRESS_COLOR;
    public static final Color INSTRUCTIONS_COLOR;
    public static final Color TEXTFIELD_COLOR;
    public static final Color PASSWORDFIELD_COLOR;
    public static final Color INLINE_HELP_COLOR;
    public static final Color PANEL_BORDER_COLOR;
    public static final Border CURRENT_STEP_PANEL_BORDER;
    public static final Border TEXT_AREA_BORDER;
    public static final Border DIALOG_PANEL_BORDER;
    private static Font defaultFont;
    public static final Font NOT_CURRENT_STEP_FONT;
    public static final Font CURRENT_STEP_FONT;
    public static final Font TITLE_FONT;
    public static final Font INSTRUCTIONS_FONT;
    public static final Font INSTRUCTIONS_MONOSPACE_FONT;
    public static final Font PRIMARY_FIELD_VALID_FONT;
    public static final Font SECONDARY_FIELD_VALID_FONT;
    public static final Font PRIMARY_FIELD_INVALID_FONT;
    public static final Font SECONDARY_FIELD_INVALID_FONT;
    public static final Font SECONDARY_STATUS_FONT;
    public static final Font READ_ONLY_FONT;
    public static final Font CHECKBOX_FONT;
    public static final Font PROGRESS_FONT;
    public static final Font TEXTFIELD_FONT;
    public static final Font PASSWORD_FIELD_FONT;
    public static final Font PROGRESS_POINTS_FONT;
    public static final Font PROGRESS_DONE_FONT;
    public static final Font PROGRESS_LOG_FONT;
    public static final Font PROGRESS_LOG_ERROR_FONT;
    public static final Font PROGRESS_ERROR_FONT;
    public static final Font PROGRESS_WARNING_FONT;
    public static final Font STACK_FONT;
    public static final Font ERROR_DIALOG_FONT;
    public static final Font INLINE_HELP_FONT;
    private static final String SPAN_CLOSE = "</span>";
    private static final String DIV_CLOSE = "</div>";
    private static final String DIV_OPEN_ERROR_BACKGROUND;
    private static final String DIV_OPEN_WARNING_BACKGROUND;
    private static final String DIV_OPEN_SUCCESSFUL_BACKGROUND;
    public static final String HTML_SEPARATOR;
    private static final HashMap<IconType, ImageIcon> hmIcons;

    public static void initializeLookAndFeel() throws Throwable {
        final Throwable[] ts = new Throwable[]{null};
        Runnable r = new Runnable(){

            @Override
            public void run() {
                System.setProperty("swing.aatext", "true");
                try {
                    String lf = UIManager.getSystemLookAndFeelClassName();
                    if (lf.equalsIgnoreCase("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
                        lf = UIManager.getCrossPlatformLookAndFeelClassName();
                    }
                    UIManager.setLookAndFeel(lf);
                }
                catch (Throwable t) {
                    ts[0] = t;
                }
                JFrame.setDefaultLookAndFeelDecorated(false);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (Throwable t) {
                ts[0] = t;
            }
        }
        if (ts[0] != null) {
            throw ts[0];
        }
    }

    public static void initialize() throws Throwable {
        if (!initialized) {
            try {
                UIManager.put("OptionPane.background", UIFactory.getColor(QuickSetupMessages.INFO_OPTIONPANE_BACKGROUND_COLOR.get()));
                UIManager.put("Panel.background", UIFactory.getColor(QuickSetupMessages.INFO_PANEL_BACKGROUND_COLOR.get()));
                UIManager.put("ComboBox.background", UIFactory.getColor(QuickSetupMessages.INFO_COMBOBOX_BACKGROUND_COLOR.get()));
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Error updating UIManager: " + t, t);
            }
            UIFactory.initializeLookAndFeel();
            initialized = true;
        }
    }

    public static JPanel makeJPanel() {
        JPanel pnl = new JPanel();
        pnl.setOpaque(false);
        return pnl;
    }

    public static JComboBox makeJComboBox() {
        JComboBox cbo = new JComboBox();
        cbo.setBorder(BorderFactory.createBevelBorder(1));
        return cbo;
    }

    public static JButton makeJButton(Message label, Message tooltip) {
        JButton b = new JButton();
        if (label != null) {
            b.setText(label.toString());
        }
        if (tooltip != null) {
            b.setToolTipText(tooltip.toString());
        }
        b.setOpaque(false);
        return b;
    }

    public static JLabel makeJLabel(LabelFieldDescriptor desc) {
        TextStyle style = desc.getLabelType() == LabelFieldDescriptor.LabelType.PRIMARY ? TextStyle.PRIMARY_FIELD_VALID : TextStyle.SECONDARY_FIELD_VALID;
        return UIFactory.makeJLabel(IconType.NO_ICON, desc.getLabel(), style);
    }

    public static JLabel makeJLabel(IconType iconName, Message text, TextStyle style) {
        JLabel l = new JLabel();
        if (text != null) {
            l.setText(text.toString());
        }
        ImageIcon icon = UIFactory.getImageIcon(iconName);
        l.setIcon(icon);
        Message tooltip = UIFactory.getIconTooltip(iconName);
        if (tooltip != null) {
            l.setToolTipText(tooltip.toString());
        }
        UIFactory.setTextStyle(l, style);
        return l;
    }

    public static JTextComponent makeJTextComponent(LabelFieldDescriptor desc, String defaultValue) {
        JTextComponent field;
        switch (desc.getType()) {
            case TEXTFIELD: {
                field = UIFactory.makeJTextField(Message.raw(defaultValue, new Object[0]), desc.getTooltip(), desc.getSize(), TextStyle.TEXTFIELD);
                break;
            }
            case PASSWORD: {
                field = UIFactory.makeJPasswordField(Message.raw(defaultValue, new Object[0]), desc.getTooltip(), desc.getSize(), TextStyle.PASSWORD_FIELD);
                break;
            }
            case READ_ONLY: {
                field = UIFactory.makeTextPane(Message.raw(defaultValue, new Object[0]), TextStyle.READ_ONLY);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)desc.getType()));
            }
        }
        return field;
    }

    public static JTextField makeJTextField(Message text, Message tooltip, int size, TextStyle style) {
        JTextField f = new JTextField();
        UIFactory.updateTextFieldComponent(f, text, tooltip, size, style);
        f.addFocusListener(new TextFieldFocusListener(f));
        return f;
    }

    public static JPasswordField makeJPasswordField(Message text, Message tooltip, int size, TextStyle style) {
        JPasswordField f = new JPasswordField();
        UIFactory.updateTextFieldComponent(f, text, tooltip, size, style);
        f.addFocusListener(new TextFieldFocusListener(f));
        return f;
    }

    public static JRadioButton makeJRadioButton(Message text, Message tooltip, TextStyle style) {
        JRadioButton rb = new JRadioButton();
        rb.setOpaque(false);
        if (text != null) {
            rb.setText(text.toString());
        }
        if (tooltip != null) {
            rb.setToolTipText(tooltip.toString());
        }
        UIFactory.setTextStyle(rb, style);
        return rb;
    }

    public static JCheckBox makeJCheckBox(Message text, Message tooltip, TextStyle style) {
        JCheckBox cb = new JCheckBox();
        cb.setOpaque(false);
        if (text != null) {
            cb.setText(text.toString());
        }
        if (tooltip != null) {
            cb.setToolTipText(tooltip.toString());
        }
        UIFactory.setTextStyle(cb, style);
        return cb;
    }

    public static JList makeJList(TextStyle textStyle) {
        JList list = new JList();
        list.setCellRenderer(UIFactory.makeCellRenderer(textStyle));
        return list;
    }

    public static void setTextStyle(JComponent l, TextStyle style) {
        switch (style) {
            case NOT_CURRENT_STEP: {
                l.setFont(NOT_CURRENT_STEP_FONT);
                l.setForeground(DEFAULT_LABEL_COLOR);
                break;
            }
            case CURRENT_STEP: {
                l.setFont(CURRENT_STEP_FONT);
                l.setForeground(DEFAULT_LABEL_COLOR);
                break;
            }
            case TITLE: {
                l.setFont(TITLE_FONT);
                l.setForeground(DEFAULT_LABEL_COLOR);
                break;
            }
            case PRIMARY_FIELD_VALID: {
                l.setFont(PRIMARY_FIELD_VALID_FONT);
                l.setForeground(FIELD_VALID_COLOR);
                break;
            }
            case PRIMARY_FIELD_INVALID: {
                l.setFont(PRIMARY_FIELD_INVALID_FONT);
                l.setForeground(FIELD_INVALID_COLOR);
                break;
            }
            case SECONDARY_FIELD_VALID: {
                l.setFont(SECONDARY_FIELD_VALID_FONT);
                l.setForeground(FIELD_VALID_COLOR);
                break;
            }
            case SECONDARY_FIELD_INVALID: {
                l.setFont(SECONDARY_FIELD_INVALID_FONT);
                l.setForeground(FIELD_INVALID_COLOR);
                break;
            }
            case SECONDARY_STATUS: {
                l.setFont(SECONDARY_STATUS_FONT);
                l.setForeground(FIELD_VALID_COLOR);
                break;
            }
            case READ_ONLY: {
                l.setFont(READ_ONLY_FONT);
                l.setForeground(READ_ONLY_COLOR);
                break;
            }
            case CHECKBOX: {
                l.setFont(CHECKBOX_FONT);
                l.setForeground(CHECKBOX_COLOR);
                break;
            }
            case PROGRESS: {
                l.setFont(PROGRESS_FONT);
                l.setForeground(PROGRESS_COLOR);
                break;
            }
            case INSTRUCTIONS: {
                l.setFont(INSTRUCTIONS_FONT);
                l.setForeground(INSTRUCTIONS_COLOR);
                break;
            }
            case TEXTFIELD: {
                l.setFont(TEXTFIELD_FONT);
                l.setForeground(TEXTFIELD_COLOR);
                break;
            }
            case PASSWORD_FIELD: {
                l.setFont(PASSWORD_FIELD_FONT);
                l.setForeground(PASSWORDFIELD_COLOR);
                break;
            }
            case INLINE_HELP: {
                l.setFont(INLINE_HELP_FONT);
                l.setForeground(INLINE_HELP_COLOR);
                break;
            }
            case NO_STYLE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown textStyle: " + (Object)((Object)style));
            }
        }
    }

    public static String getIconHtml(IconType iconType) {
        String url = String.valueOf(UIFactory.class.getClassLoader().getResource(UIFactory.getIconPath(iconType)));
        Message description = UIFactory.getIconDescription(iconType);
        Message title = UIFactory.getIconTooltip(iconType);
        return "<img src=\"" + url + "\" alt=\"" + description + "\" align=\"middle\" title=\"" + title + "\" >";
    }

    public static ImageIcon getImageIcon(IconType iconType) {
        ImageIcon icon;
        if (iconType == null) {
            iconType = IconType.NO_ICON;
        }
        if ((icon = hmIcons.get((Object)iconType)) == null && iconType != IconType.NO_ICON) {
            String path = UIFactory.getIconPath(iconType);
            Message description = UIFactory.getIconDescription(iconType);
            try {
                Image im = Toolkit.getDefaultToolkit().createImage(UIFactory.class.getClassLoader().getResource(path));
                icon = new ImageIcon(im);
                String ds = description != null ? description.toString() : null;
                icon.setDescription(ds);
                hmIcons.put(iconType, icon);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IllegalStateException("Could not load icon for path " + path, ex);
            }
        }
        return icon;
    }

    public static JEditorPane makeProgressPane(JScrollPane scroll) {
        return new ProgressJEditorPane(scroll);
    }

    public static JEditorPane makeHtmlPane(Message text, Font font) {
        return UIFactory.makeHtmlPane(text, null, font);
    }

    public static JEditorPane makeHtmlPane(Message text, HTMLEditorKit ek, Font font) {
        JEditorPane pane = new JEditorPane();
        if (ek != null) {
            pane.setEditorKit(ek);
        }
        pane.setContentType("text/html");
        String s = text != null ? String.valueOf(text) : null;
        pane.setText(UIFactory.applyFontToHtmlWithDiv(s, font));
        pane.setEditable(false);
        pane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return pane;
    }

    public static JEditorPane makeTextPane(Message text, TextStyle style) {
        String s = text != null ? String.valueOf(text) : null;
        JEditorPane pane = new JEditorPane("text/plain", s);
        UIFactory.setTextStyle(pane, style);
        pane.setEditable(false);
        pane.setBorder(new EmptyBorder(0, 0, 0, 0));
        pane.setOpaque(false);
        return pane;
    }

    public static JScrollPane createBorderLessScrollBar(Component comp) {
        JScrollPane scroll = new JScrollPane(comp);
        scroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        scroll.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        scroll.getViewport().setBackground(DEFAULT_BACKGROUND);
        scroll.setBackground(DEFAULT_BACKGROUND);
        UIFactory.setScrollIncrementUnit(scroll);
        return scroll;
    }

    public static void setScrollIncrementUnit(JScrollPane scroll) {
        int increment;
        if (scroll.getVerticalScrollBar() != null && (increment = scroll.getVerticalScrollBar().getUnitIncrement()) < 16) {
            scroll.getVerticalScrollBar().setUnitIncrement(16);
        }
    }

    public static Insets getEmptyInsets() {
        return (Insets)EMPTY_INSETS.clone();
    }

    public static Insets getButtonsPanelInsets() {
        return (Insets)BUTTONS_PANEL_INSETS.clone();
    }

    public static Insets getStepsPanelInsets() {
        return (Insets)STEPS_PANEL_INSETS.clone();
    }

    public static Insets getCurrentStepPanelInsets() {
        return (Insets)CURRENT_STEP_PANEL_INSETS.clone();
    }

    public static String applyFontToHtml(String html, Font font) {
        StringBuilder buf = new StringBuilder();
        buf.append("<span style=\"").append(UIFactory.getFontStyle(font)).append("\">").append(html).append(SPAN_CLOSE);
        return buf.toString();
    }

    public static JTable makeSortableTable(final SortableTableModel tableModel, TableCellRenderer renderer, TableCellRenderer headerRenderer) {
        final JTable table = new JTable(tableModel);
        table.setShowGrid(true);
        table.setGridColor(PANEL_BORDER_COLOR);
        table.setAutoResizeMode(2);
        table.setBackground(CURRENT_STEP_PANEL_BACKGROUND);
        table.getTableHeader().setBackground(DEFAULT_BACKGROUND);
        table.setRowMargin(0);
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            TableColumn col = table.getColumn(table.getColumnName(i));
            col.setCellRenderer(renderer);
            col.setHeaderRenderer(headerRenderer);
        }
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = table.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int sortedBy = table.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && sortedBy != -1) {
                    tableModel.setSortAscending(!tableModel.isSortAscending());
                    tableModel.setSortColumn(sortedBy);
                    tableModel.forceResort();
                }
            }
        };
        table.getTableHeader().addMouseListener(listMouseListener);
        return table;
    }

    public static TableCellRenderer makeHeaderRenderer() {
        return new HeaderRenderer();
    }

    public static String applyFontToHtmlWithDiv(String html, Font font) {
        StringBuilder buf = new StringBuilder();
        buf.append("<div style=\"").append(UIFactory.getFontStyle(font)).append("\">").append(html).append(DIV_CLOSE);
        return buf.toString();
    }

    private static String getFontStyle(Font font) {
        StringBuilder buf = new StringBuilder();
        buf.append("font-family:" + font.getName()).append(";font-size:" + font.getSize() + "pt");
        if (font.isItalic()) {
            buf.append(";font-style:italic");
        }
        if (font.isBold()) {
            buf.append(";font-weight:bold;");
        }
        return buf.toString();
    }

    public static String applyErrorBackgroundToHtml(String html) {
        return DIV_OPEN_ERROR_BACKGROUND + html + DIV_CLOSE;
    }

    public static String applyWarningBackgroundToHtml(String html) {
        return DIV_OPEN_WARNING_BACKGROUND + html + DIV_CLOSE;
    }

    public static String applySuccessfulBackgroundToHtml(String html) {
        return DIV_OPEN_SUCCESSFUL_BACKGROUND + html + DIV_CLOSE;
    }

    public static String applyMargin(String html, int top, int right, int bottom, int left) {
        String result = "<div style=\"margin:" + top + "px " + right + "px " + bottom + "px " + left + "px;\">" + html + DIV_CLOSE;
        return result;
    }

    private static void updateTextFieldComponent(JTextField field, Message text, Message tooltip, int size, TextStyle textStyle) {
        field.setColumns(size);
        if (text != null) {
            field.setText(text.toString());
        }
        if (tooltip != null) {
            field.setToolTipText(tooltip.toString());
        }
        if (textStyle != null) {
            UIFactory.setTextStyle(field, textStyle);
        }
    }

    private static Color getColor(Message l) {
        String s = String.valueOf(l);
        String[] colors = s.split(",");
        int r = Integer.parseInt(colors[0].trim());
        int g = Integer.parseInt(colors[1].trim());
        int b = Integer.parseInt(colors[2].trim());
        return new Color(r, g, b);
    }

    private static String getParentPackagePath() {
        if (parentPackagePath == null) {
            String packageName = UIFactory.class.getPackage().getName();
            int lastDot = packageName.lastIndexOf(46);
            String parentPackage = packageName.substring(0, lastDot);
            parentPackagePath = parentPackage.replace(".", "/");
        }
        return parentPackagePath;
    }

    private static String getIconPath(IconType iconType) {
        Message key = null;
        switch (iconType) {
            case CURRENT_STEP: {
                key = QuickSetupMessages.INFO_CURRENT_STEP_ICON.get();
                break;
            }
            case SPLASH: {
                key = QuickSetupMessages.INFO_SPLASH_ICON.get();
                break;
            }
            case BACKGROUND: {
                key = QuickSetupMessages.INFO_BACKGROUND_ICON.get();
                break;
            }
            case MINIMIZED: {
                key = QuickSetupMessages.INFO_MINIMIZED_ICON.get();
                break;
            }
            case MINIMIZED_MAC: {
                key = QuickSetupMessages.INFO_MINIMIZED_MAC_ICON.get();
                break;
            }
            case WARNING: {
                key = QuickSetupMessages.INFO_WARNING_ICON.get();
                break;
            }
            case WARNING_LARGE: {
                key = QuickSetupMessages.INFO_WARNING_LARGE_ICON.get();
                break;
            }
            case INFORMATION: {
                key = QuickSetupMessages.INFO_INFORMATION_ICON.get();
                break;
            }
            case INFORMATION_LARGE: {
                key = QuickSetupMessages.INFO_INFORMATION_LARGE_ICON.get();
                break;
            }
            case SUBSECTION_LEFT: {
                key = QuickSetupMessages.INFO_SUBSECTION_LEFT_ICON.get();
                break;
            }
            case SUBSECTION_RIGHT: {
                key = QuickSetupMessages.INFO_SUBSECTION_RIGHT_ICON.get();
                break;
            }
            case HELP_SMALL: {
                key = QuickSetupMessages.INFO_HELP_SMALL_ICON.get();
                break;
            }
            case ERROR: {
                key = QuickSetupMessages.INFO_ERROR_ICON.get();
                break;
            }
            case ERROR_LARGE: {
                key = QuickSetupMessages.INFO_ERROR_LARGE_ICON.get();
                break;
            }
            case WAIT_TINY: {
                key = QuickSetupMessages.INFO_WAIT_TINY.get();
                break;
            }
            case WAIT: {
                key = QuickSetupMessages.INFO_WAIT.get();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown iconName: " + (Object)((Object)iconType));
            }
        }
        return UIFactory.getParentPackagePath() + "/" + key.toString();
    }

    private static Message getIconDescription(IconType iconType) {
        Message description = null;
        switch (iconType) {
            case CURRENT_STEP: {
                description = QuickSetupMessages.INFO_CURRENT_STEP_ICON_DESCRIPTION.get();
                break;
            }
            case SPLASH: {
                description = QuickSetupMessages.INFO_SPLASH_ICON_DESCRIPTION.get();
                break;
            }
            case BACKGROUND: {
                description = QuickSetupMessages.INFO_BACKGROUND_ICON_DESCRIPTION.get();
                break;
            }
            case MINIMIZED: {
                description = QuickSetupMessages.INFO_MINIMIZED_ICON_DESCRIPTION.get();
                break;
            }
            case MINIMIZED_MAC: {
                description = QuickSetupMessages.INFO_MINIMIZED_ICON_DESCRIPTION.get();
                break;
            }
            case WARNING: {
                description = QuickSetupMessages.INFO_WARNING_ICON_DESCRIPTION.get();
                break;
            }
            case WARNING_LARGE: {
                description = QuickSetupMessages.INFO_WARNING_ICON_DESCRIPTION.get();
                break;
            }
            case ERROR: {
                description = QuickSetupMessages.INFO_ERROR_ICON_DESCRIPTION.get();
                break;
            }
            case ERROR_LARGE: {
                description = QuickSetupMessages.INFO_ERROR_ICON_DESCRIPTION.get();
                break;
            }
            case INFORMATION: {
                description = QuickSetupMessages.INFO_INFORMATION_ICON_DESCRIPTION.get();
                break;
            }
            case INFORMATION_LARGE: {
                description = QuickSetupMessages.INFO_INFORMATION_ICON_DESCRIPTION.get();
                break;
            }
            case SUBSECTION_LEFT: {
                description = QuickSetupMessages.INFO_SUBSECTION_LEFT_ICON_DESCRIPTION.get();
                break;
            }
            case SUBSECTION_RIGHT: {
                description = QuickSetupMessages.INFO_SUBSECTION_RIGHT_ICON_DESCRIPTION.get();
                break;
            }
            case HELP_SMALL: {
                description = QuickSetupMessages.INFO_HELP_SMALL_ICON_DESCRIPTION.get();
                break;
            }
            case WAIT_TINY: {
                description = QuickSetupMessages.INFO_HELP_WAIT_DESCRIPTION.get();
                break;
            }
            case WAIT: {
                description = QuickSetupMessages.INFO_HELP_WAIT_DESCRIPTION.get();
                break;
            }
            case NO_ICON: {
                description = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown iconName: " + (Object)((Object)iconType));
            }
        }
        return description;
    }

    private static Message getIconTooltip(IconType iconType) {
        Message tooltip;
        if (iconType == null) {
            iconType = IconType.NO_ICON;
        }
        switch (iconType) {
            case CURRENT_STEP: {
                tooltip = QuickSetupMessages.INFO_CURRENT_STEP_ICON_TOOLTIP.get();
                break;
            }
            case SPLASH: {
                tooltip = QuickSetupMessages.INFO_SPLASH_ICON_TOOLTIP.get();
                break;
            }
            case BACKGROUND: {
                tooltip = QuickSetupMessages.INFO_BACKGROUND_ICON_TOOLTIP.get();
                break;
            }
            case MINIMIZED: {
                tooltip = QuickSetupMessages.INFO_MINIMIZED_ICON_TOOLTIP.get();
                break;
            }
            case MINIMIZED_MAC: {
                tooltip = QuickSetupMessages.INFO_MINIMIZED_ICON_TOOLTIP.get();
                break;
            }
            case WARNING: {
                tooltip = QuickSetupMessages.INFO_WARNING_ICON_TOOLTIP.get();
                break;
            }
            case WARNING_LARGE: {
                tooltip = QuickSetupMessages.INFO_WARNING_ICON_TOOLTIP.get();
                break;
            }
            case ERROR: {
                tooltip = QuickSetupMessages.INFO_ERROR_ICON_TOOLTIP.get();
                break;
            }
            case ERROR_LARGE: {
                tooltip = QuickSetupMessages.INFO_ERROR_ICON_TOOLTIP.get();
                break;
            }
            case INFORMATION: {
                tooltip = QuickSetupMessages.INFO_INFORMATION_ICON_TOOLTIP.get();
                break;
            }
            case INFORMATION_LARGE: {
                tooltip = QuickSetupMessages.INFO_INFORMATION_ICON_TOOLTIP.get();
                break;
            }
            case SUBSECTION_LEFT: {
                tooltip = null;
                break;
            }
            case SUBSECTION_RIGHT: {
                tooltip = null;
                break;
            }
            case HELP_SMALL: {
                tooltip = null;
                break;
            }
            case WAIT_TINY: {
                tooltip = null;
                break;
            }
            case WAIT: {
                tooltip = null;
                break;
            }
            case NO_ICON: {
                tooltip = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown iconName: " + (Object)((Object)iconType));
            }
        }
        return tooltip;
    }

    private static ListCellRenderer makeCellRenderer(final TextStyle textStyle) {
        ListCellRenderer renderer = new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel l = UIFactory.makeJLabel(IconType.NO_ICON, Message.fromObject(value, new Object[0]), textStyle);
                l.setBorder(new EmptyBorder(5, 0, 0, 0));
                return l;
            }
        };
        return renderer;
    }

    static {
        LOG = Logger.getLogger(UIFactory.class.getName());
        BUTTONS_PANEL_INSETS = new Insets(5, 0, 5, 10);
        STEPS_PANEL_INSETS = new Insets(15, 10, 5, 10);
        CURRENT_STEP_PANEL_INSETS = new Insets(15, 15, 15, 15);
        EMPTY_INSETS = new Insets(0, 0, 0, 0);
        DEFAULT_BACKGROUND = UIFactory.getColor(QuickSetupMessages.INFO_DEFAULT_BACKGROUND_COLOR.get());
        CURRENT_STEP_PANEL_BACKGROUND = UIFactory.getColor(QuickSetupMessages.INFO_CURRENT_STEP_PANEL_BACKGROUND_COLOR.get());
        DEFAULT_LABEL_COLOR = UIFactory.getColor(QuickSetupMessages.INFO_DEFAULT_LABEL_COLOR.get());
        FIELD_VALID_COLOR = UIFactory.getColor(QuickSetupMessages.INFO_FIELD_VALID_COLOR.get());
        FIELD_INVALID_COLOR = UIFactory.getColor(QuickSetupMessages.INFO_FIELD_INVALID_COLOR.get());
        READ_ONLY_COLOR = UIFactory.getColor(QuickSetupMessages.INFO_READ_ONLY_COLOR.get());
        CHECKBOX_COLOR = UIFactory.getColor(QuickSetupMessages.INFO_CHECKBOX_COLOR.get());
        PROGRESS_COLOR = UIFactory.getColor(QuickSetupMessages.INFO_PROGRESS_COLOR.get());
        INSTRUCTIONS_COLOR = UIFactory.getColor(QuickSetupMessages.INFO_INSTRUCTIONS_COLOR.get());
        TEXTFIELD_COLOR = UIFactory.getColor(QuickSetupMessages.INFO_TEXTFIELD_COLOR.get());
        PASSWORDFIELD_COLOR = UIFactory.getColor(QuickSetupMessages.INFO_PASSWORDFIELD_COLOR.get());
        INLINE_HELP_COLOR = UIFactory.getColor(QuickSetupMessages.INFO_INLINE_HELP_COLOR.get());
        PANEL_BORDER_COLOR = UIFactory.getColor(QuickSetupMessages.INFO_PANEL_BORDER_COLOR.get());
        CURRENT_STEP_PANEL_BORDER = BorderFactory.createMatteBorder(0, 2, 2, 0, PANEL_BORDER_COLOR);
        TEXT_AREA_BORDER = BorderFactory.createMatteBorder(1, 1, 1, 1, UIFactory.getColor(QuickSetupMessages.INFO_TEXT_AREA_BORDER_COLOR.get()));
        DIALOG_PANEL_BORDER = BorderFactory.createMatteBorder(0, 0, 2, 0, PANEL_BORDER_COLOR);
        try {
            defaultFont = UIManager.getFont("Label.font").deriveFont(0).deriveFont(12.0f);
        }
        catch (Throwable t) {
            defaultFont = Font.decode("SansSerif-PLAIN-12");
        }
        NOT_CURRENT_STEP_FONT = defaultFont.deriveFont(14.0f);
        CURRENT_STEP_FONT = defaultFont.deriveFont(14.0f).deriveFont(1);
        TITLE_FONT = defaultFont.deriveFont(14.0f).deriveFont(1);
        INSTRUCTIONS_FONT = defaultFont;
        INSTRUCTIONS_MONOSPACE_FONT = Font.decode("Monospaced-PLAIN-14");
        PRIMARY_FIELD_VALID_FONT = defaultFont.deriveFont(1);
        SECONDARY_FIELD_VALID_FONT = defaultFont;
        PRIMARY_FIELD_INVALID_FONT = defaultFont.deriveFont(3);
        SECONDARY_FIELD_INVALID_FONT = defaultFont.deriveFont(2);
        SECONDARY_STATUS_FONT = defaultFont.deriveFont(2);
        READ_ONLY_FONT = defaultFont;
        CHECKBOX_FONT = defaultFont;
        PROGRESS_FONT = defaultFont;
        TEXTFIELD_FONT = defaultFont;
        PASSWORD_FIELD_FONT = defaultFont;
        PROGRESS_DONE_FONT = PROGRESS_POINTS_FONT = defaultFont.deriveFont(1);
        PROGRESS_LOG_FONT = Font.decode("Monospaced-PLAIN-12");
        PROGRESS_LOG_ERROR_FONT = Font.decode("Monospaced-PLAIN-12");
        PROGRESS_ERROR_FONT = defaultFont.deriveFont(1);
        PROGRESS_WARNING_FONT = defaultFont.deriveFont(1);
        STACK_FONT = defaultFont;
        ERROR_DIALOG_FONT = defaultFont;
        INLINE_HELP_FONT = defaultFont.deriveFont((float)(defaultFont.getSize() - 2));
        DIV_OPEN_WARNING_BACKGROUND = DIV_OPEN_ERROR_BACKGROUND = "<div style=\"color:#" + QuickSetupMessages.INFO_DIV_OPEN_ERROR_BACKGROUND_1_COLOR.get() + ";background-color:#" + QuickSetupMessages.INFO_DIV_OPEN_ERROR_BACKGROUND_2_COLOR.get() + ";padding:10px 10px 10px 10px;" + "border-style:solid;border-width:3px;border-color:#" + QuickSetupMessages.INFO_DIV_OPEN_ERROR_BACKGROUND_3_COLOR.get() + ";vertical-align:middle;text-align:left\">";
        DIV_OPEN_SUCCESSFUL_BACKGROUND = "<div style=\"color:#" + QuickSetupMessages.INFO_DIV_OPEN_SUCCESSFUL_BACKGROUND_1_COLOR.get() + ";background-color:#" + QuickSetupMessages.INFO_DIV_OPEN_SUCCESSFUL_BACKGROUND_2_COLOR.get() + ";padding:10px 10px 10px 10px;" + "border-style:solid;border-width:3px;border-color:#" + QuickSetupMessages.INFO_DIV_OPEN_SUCCESSFUL_BACKGROUND_3_COLOR.get() + ";vertical-align:middle;text-align:left\">";
        HTML_SEPARATOR = "<div style=\"font-size:1px;background-color:#" + QuickSetupMessages.INFO_HTML_SEPARATOR_COLOR.get() + ";margin:10px 5px 10px 5px;\"></div>";
        hmIcons = new HashMap();
    }

    public static enum TextStyle {
        CURRENT_STEP,
        NOT_CURRENT_STEP,
        TITLE,
        PRIMARY_FIELD_VALID,
        PRIMARY_FIELD_INVALID,
        SECONDARY_FIELD_VALID,
        SECONDARY_FIELD_INVALID,
        SECONDARY_STATUS,
        TEXTFIELD,
        PASSWORD_FIELD,
        READ_ONLY,
        CHECKBOX,
        PROGRESS,
        INSTRUCTIONS,
        INLINE_HELP,
        NO_STYLE;

    }

    public static enum IconType {
        SPLASH,
        CURRENT_STEP,
        MINIMIZED,
        MINIMIZED_MAC,
        BACKGROUND,
        WARNING,
        WARNING_LARGE,
        ERROR,
        ERROR_LARGE,
        INFORMATION,
        INFORMATION_LARGE,
        SUBSECTION_LEFT,
        SUBSECTION_RIGHT,
        HELP_SMALL,
        WAIT,
        WAIT_TINY,
        NO_ICON;

    }
}

