/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer;

import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NamingSecurityException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.Rdn;
import javax.swing.JPanel;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ADSContextException;
import org.opends.admin.ads.ReplicaDescriptor;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.SuffixDescriptor;
import org.opends.admin.ads.TopologyCache;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.TopologyCacheFilter;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.admin.ads.util.PreferredConnection;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Application;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.ButtonName;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.JavaArguments;
import org.opends.quicksetup.LicenseFile;
import org.opends.quicksetup.ProgressStep;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.SecurityOptions;
import org.opends.quicksetup.Step;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.UserDataCertificateException;
import org.opends.quicksetup.UserDataConfirmationException;
import org.opends.quicksetup.UserDataException;
import org.opends.quicksetup.WizardStep;
import org.opends.quicksetup.event.ButtonActionListener;
import org.opends.quicksetup.event.ButtonEvent;
import org.opends.quicksetup.installer.AuthenticationData;
import org.opends.quicksetup.installer.ConfiguredReplication;
import org.opends.quicksetup.installer.DataReplicationOptions;
import org.opends.quicksetup.installer.InstallProgressStep;
import org.opends.quicksetup.installer.InstallerHelper;
import org.opends.quicksetup.installer.InvokeThread;
import org.opends.quicksetup.installer.NewSuffixOptions;
import org.opends.quicksetup.installer.PeerNotFoundException;
import org.opends.quicksetup.installer.SuffixesToReplicateOptions;
import org.opends.quicksetup.installer.ui.DataOptionsPanel;
import org.opends.quicksetup.installer.ui.DataReplicationPanel;
import org.opends.quicksetup.installer.ui.GlobalAdministratorPanel;
import org.opends.quicksetup.installer.ui.InstallLicensePanel;
import org.opends.quicksetup.installer.ui.InstallReviewPanel;
import org.opends.quicksetup.installer.ui.InstallWelcomePanel;
import org.opends.quicksetup.installer.ui.RemoteReplicationPortsPanel;
import org.opends.quicksetup.installer.ui.RuntimeOptionsPanel;
import org.opends.quicksetup.installer.ui.ServerSettingsPanel;
import org.opends.quicksetup.installer.ui.SuffixesToReplicatePanel;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.FinishedPanel;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.ProgressPanel;
import org.opends.quicksetup.ui.QuickSetup;
import org.opends.quicksetup.ui.QuickSetupDialog;
import org.opends.quicksetup.ui.QuickSetupErrorPanel;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.IncompatibleVersionException;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.CertificateManager;
import org.opends.server.util.DynamicConstants;
import org.opends.server.util.SetupUtils;

public abstract class Installer
extends GuiApplication {
    private TopologyCache lastLoadedCache;
    boolean forceToDisplaySetup = false;
    protected boolean canceled = false;
    private boolean javaVersionCheckFailed;
    Map<ServerDescriptor, ConfiguredReplication> hmConfiguredRemoteReplication = new HashMap<ServerDescriptor, ConfiguredReplication>();
    private static final int MIN_DIRECTORY_MANAGER_PWD = 1;
    private static final Logger LOG = Logger.getLogger(Installer.class.getName());
    public static final int MIN_PORT_VALUE = 1;
    public static final int MAX_PORT_VALUE = 65535;
    private static final int MIN_NUMBER_ENTRIES = 1;
    private static final int MAX_NUMBER_ENTRIES = 10000000;
    private static final int THRESOLD_AUTOMATIC_DATA_VERBOSE = 20000;
    private static final int NENTRIES_THRESOLD_FOR_VERBOSE_START = 100000;
    protected Set<InstallProgressStep> completedProgress = new HashSet<InstallProgressStep>();
    private final List<WizardStep> lstSteps = new ArrayList<WizardStep>();
    private final HashSet<WizardStep> SUBSTEPS = new HashSet();
    private final HashMap<WizardStep, WizardStep> hmPreviousSteps;
    private char[] selfSignedCertPw;
    private boolean registeredNewServerOnRemote;
    private boolean createdAdministrator;
    private boolean createdRemoteAds;
    private String lastImportProgress;
    protected static final String DEFAULT_CONFIG_CLASS_NAME = "org.opends.server.extensions.ConfigFileHandler";
    protected static final String SELF_SIGNED_CERT_ALIAS = "server-cert";
    public static final int WARNING_CLOCK_DIFFERENCE_THRESOLD_MINUTES = 5;
    private InstallProgressStep currentProgressStep;

    public Installer() {
        this.SUBSTEPS.add(Step.CREATE_GLOBAL_ADMINISTRATOR);
        this.SUBSTEPS.add(Step.SUFFIXES_OPTIONS);
        this.SUBSTEPS.add(Step.NEW_SUFFIX_OPTIONS);
        this.SUBSTEPS.add(Step.REMOTE_REPLICATION_PORTS);
        this.hmPreviousSteps = new HashMap();
        this.selfSignedCertPw = null;
        this.currentProgressStep = InstallProgressStep.NOT_STARTED;
        this.lstSteps.add(Step.WELCOME);
        if (LicenseFile.exists()) {
            this.lstSteps.add(Step.LICENSE);
        }
        this.lstSteps.add(Step.SERVER_SETTINGS);
        this.lstSteps.add(Step.REPLICATION_OPTIONS);
        this.lstSteps.add(Step.CREATE_GLOBAL_ADMINISTRATOR);
        this.lstSteps.add(Step.SUFFIXES_OPTIONS);
        this.lstSteps.add(Step.REMOTE_REPLICATION_PORTS);
        this.lstSteps.add(Step.NEW_SUFFIX_OPTIONS);
        this.lstSteps.add(Step.RUNTIME_OPTIONS);
        this.lstSteps.add(Step.REVIEW);
        this.lstSteps.add(Step.PROGRESS);
        this.lstSteps.add(Step.FINISHED);
        try {
            if (!QuickSetupLog.isInitialized()) {
                QuickSetupLog.initLogFileHandler(File.createTempFile("opends-setup-", ".log"));
            }
        }
        catch (IOException e) {
            System.err.println("Failed to initialize log");
        }
    }

    @Override
    public boolean isCancellable() {
        return true;
    }

    @Override
    public UserData createUserData() {
        UserData ud = new UserData();
        ud.setServerLocation(Utils.getDefaultServerLocation());
        this.initializeUserDataWithUserArguments(ud, this.getUserArguments());
        return ud;
    }

    private void initializeUserDataWithUserArguments(UserData ud, String[] userArguments) {
        for (int i = 0; i < userArguments.length; ++i) {
            if (!userArguments[i].equalsIgnoreCase("--connectTimeout")) continue;
            if (i >= userArguments.length - 1) break;
            String sTimeout = userArguments[i + 1];
            try {
                ud.setConnectTimeout(new Integer(sTimeout));
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Error getting connect timeout: " + t, t);
            }
            break;
        }
    }

    @Override
    public void forceToDisplay() {
        this.forceToDisplaySetup = true;
    }

    @Override
    public boolean canGoBack(WizardStep step) {
        return step != Step.WELCOME && step != Step.PROGRESS && step != Step.FINISHED;
    }

    @Override
    public boolean canGoForward(WizardStep step) {
        return step != Step.REVIEW && step != Step.PROGRESS && step != Step.FINISHED;
    }

    @Override
    public boolean canFinish(WizardStep step) {
        return step == Step.REVIEW;
    }

    @Override
    public boolean canQuit(WizardStep step) {
        return step != Step.PROGRESS && step != Step.FINISHED;
    }

    @Override
    public boolean isSubStep(WizardStep step) {
        return this.SUBSTEPS.contains(step);
    }

    @Override
    public boolean isVisible(WizardStep step, UserData userData) {
        DataReplicationOptions repl;
        SuffixesToReplicateOptions suf;
        boolean isVisible = step == Step.CREATE_GLOBAL_ADMINISTRATOR ? userData.mustCreateAdministrator() : (step == Step.NEW_SUFFIX_OPTIONS ? ((suf = userData.getSuffixesToReplicateOptions()) != null ? suf.getType() != SuffixesToReplicateOptions.Type.REPLICATE_WITH_EXISTING_SUFFIXES : false) : (step == Step.SUFFIXES_OPTIONS ? ((repl = userData.getReplicationOptions()) != null ? repl.getType() != DataReplicationOptions.Type.STANDALONE && repl.getType() != DataReplicationOptions.Type.FIRST_IN_TOPOLOGY : false) : (step == Step.REMOTE_REPLICATION_PORTS ? this.isVisible((WizardStep)Step.SUFFIXES_OPTIONS, userData) && userData.getRemoteWithNoReplicationPort().size() > 0 && userData.getSuffixesToReplicateOptions().getType() == SuffixesToReplicateOptions.Type.REPLICATE_WITH_EXISTING_SUFFIXES : true)));
        return isVisible;
    }

    @Override
    public boolean isVisible(WizardStep step, QuickSetup qs) {
        return this.isVisible(step, this.getUserData());
    }

    @Override
    public boolean finishClicked(WizardStep cStep, QuickSetup qs) {
        if (cStep != Step.REVIEW) {
            throw new IllegalStateException("Cannot click on finish when we are not in the Review window");
        }
        this.updateUserDataForReviewPanel(qs);
        qs.launch();
        qs.setCurrentStep(Step.PROGRESS);
        return false;
    }

    @Override
    public void nextClicked(WizardStep cStep, QuickSetup qs) {
        if (cStep == Step.PROGRESS) {
            throw new IllegalStateException("Cannot click on next from progress step");
        }
        if (cStep == Step.REVIEW) {
            throw new IllegalStateException("Cannot click on next from review step");
        }
        if (cStep == Step.FINISHED) {
            throw new IllegalStateException("Cannot click on next from finished step");
        }
    }

    @Override
    public void closeClicked(WizardStep cStep, QuickSetup qs) {
        if (cStep == Step.PROGRESS) {
            if (this.isFinished() || qs.displayConfirmation(QuickSetupMessages.INFO_CONFIRM_CLOSE_INSTALL_MSG.get(), QuickSetupMessages.INFO_CONFIRM_CLOSE_INSTALL_TITLE.get())) {
                qs.quit();
            }
        } else if (cStep == Step.FINISHED) {
            qs.quit();
        } else {
            throw new IllegalStateException("Close only can be clicked on PROGRESS step");
        }
    }

    @Override
    public boolean isFinished() {
        return this.getCurrentProgressStep() == InstallProgressStep.FINISHED_SUCCESSFULLY || this.getCurrentProgressStep() == InstallProgressStep.FINISHED_CANCELED || this.getCurrentProgressStep() == InstallProgressStep.FINISHED_WITH_ERROR;
    }

    @Override
    public void cancel() {
        this.setCurrentProgressStep(InstallProgressStep.WAITING_TO_CANCEL);
        this.notifyListeners(null);
        this.canceled = true;
    }

    @Override
    public void quitClicked(WizardStep cStep, QuickSetup qs) {
        if (cStep == Step.FINISHED) {
            qs.quit();
        } else {
            if (cStep == Step.PROGRESS) {
                throw new IllegalStateException("Cannot click on quit from progress step");
            }
            if (this.installStatus.isInstalled()) {
                qs.quit();
            } else if (this.javaVersionCheckFailed) {
                qs.quit();
            } else if (qs.displayConfirmation(QuickSetupMessages.INFO_CONFIRM_QUIT_INSTALL_MSG.get(), QuickSetupMessages.INFO_CONFIRM_QUIT_INSTALL_TITLE.get())) {
                qs.quit();
            }
        }
    }

    @Override
    public ButtonName getInitialFocusButtonName() {
        ButtonName name = null;
        name = !this.installStatus.isInstalled() || this.forceToDisplaySetup ? ButtonName.NEXT : (this.installStatus.canOverwriteCurrentInstall() ? ButtonName.CONTINUE_INSTALL : ButtonName.QUIT);
        return name;
    }

    @Override
    public JPanel createFramePanel(QuickSetupDialog dlg) {
        JPanel p;
        this.javaVersionCheckFailed = true;
        try {
            Utils.checkJavaVersion();
            this.javaVersionCheckFailed = false;
            p = this.installStatus.isInstalled() && !this.forceToDisplaySetup ? dlg.getInstalledPanel() : super.createFramePanel(dlg);
        }
        catch (IncompatibleVersionException ijv) {
            MessageBuilder sb = new MessageBuilder();
            sb.append(Utils.breakHtmlString(Utils.getHtml(ijv.getMessageObject().toString()), 100));
            QuickSetupErrorPanel errPanel = new QuickSetupErrorPanel((GuiApplication)this, sb.toMessage());
            final QuickSetupDialog fDlg = dlg;
            errPanel.addButtonActionListener(new ButtonActionListener(){

                @Override
                public void buttonActionPerformed(ButtonEvent ev) {
                    fDlg.notifyButtonEvent(ButtonName.QUIT);
                }
            });
            p = errPanel;
        }
        return p;
    }

    @Override
    public Set<? extends WizardStep> getWizardSteps() {
        return Collections.unmodifiableSet(new HashSet<WizardStep>(this.lstSteps));
    }

    @Override
    public QuickSetupStepPanel createWizardStepPanel(WizardStep step) {
        QuickSetupStepPanel p = null;
        if (step == Step.WELCOME) {
            p = new InstallWelcomePanel(this);
        } else if (step == Step.LICENSE) {
            p = new InstallLicensePanel(this);
        } else if (step == Step.SERVER_SETTINGS) {
            p = new ServerSettingsPanel(this);
        } else if (step == Step.REPLICATION_OPTIONS) {
            p = new DataReplicationPanel(this);
        } else if (step == Step.CREATE_GLOBAL_ADMINISTRATOR) {
            p = new GlobalAdministratorPanel(this);
        } else if (step == Step.SUFFIXES_OPTIONS) {
            p = new SuffixesToReplicatePanel(this);
        } else if (step == Step.REMOTE_REPLICATION_PORTS) {
            p = new RemoteReplicationPortsPanel(this);
        } else if (step == Step.NEW_SUFFIX_OPTIONS) {
            p = new DataOptionsPanel(this);
        } else if (step == Step.RUNTIME_OPTIONS) {
            p = new RuntimeOptionsPanel(this);
        } else if (step == Step.REVIEW) {
            p = new InstallReviewPanel(this);
        } else if (step == Step.PROGRESS) {
            p = new ProgressPanel(this);
        } else if (step == Step.FINISHED) {
            p = new FinishedPanel(this);
        }
        return p;
    }

    @Override
    public void windowClosing(QuickSetupDialog dlg, WindowEvent evt) {
        if (this.installStatus.isInstalled() && this.forceToDisplaySetup) {
            dlg.notifyButtonEvent(ButtonName.QUIT);
        } else if (dlg.getDisplayedStep() == Step.PROGRESS) {
            dlg.notifyButtonEvent(ButtonName.CLOSE);
        } else {
            dlg.notifyButtonEvent(ButtonName.QUIT);
        }
    }

    @Override
    public Message getCloseButtonToolTip() {
        return QuickSetupMessages.INFO_CLOSE_BUTTON_INSTALL_TOOLTIP.get();
    }

    @Override
    public Message getQuitButtonToolTip() {
        return QuickSetupMessages.INFO_QUIT_BUTTON_INSTALL_TOOLTIP.get();
    }

    @Override
    public Message getFinishButtonToolTip() {
        return QuickSetupMessages.INFO_FINISH_BUTTON_INSTALL_TOOLTIP.get();
    }

    @Override
    public int getExtraDialogHeight() {
        return 75;
    }

    @Override
    public void previousClicked(WizardStep cStep, QuickSetup qs) {
        if (cStep == Step.WELCOME) {
            throw new IllegalStateException("Cannot click on previous from progress step");
        }
        if (cStep == Step.PROGRESS) {
            throw new IllegalStateException("Cannot click on previous from progress step");
        }
        if (cStep == Step.FINISHED) {
            throw new IllegalStateException("Cannot click on previous from finished step");
        }
    }

    @Override
    public Message getFrameTitle() {
        return Utils.getCustomizedObject("INFO_FRAME_INSTALL_TITLE", QuickSetupMessages.INFO_FRAME_INSTALL_TITLE.get(DynamicConstants.PRODUCT_NAME), Message.class);
    }

    @Override
    public void setWizardDialogState(QuickSetupDialog dlg, UserData userData, WizardStep step) {
        if (!this.installStatus.isInstalled() || this.forceToDisplaySetup) {
            if (step == Step.REVIEW) {
                dlg.setFocusOnButton(ButtonName.FINISH);
                dlg.setDefaultButton(ButtonName.FINISH);
            } else if (step == Step.WELCOME) {
                dlg.setDefaultButton(ButtonName.NEXT);
                dlg.setFocusOnButton(ButtonName.NEXT);
            } else if (step == Step.PROGRESS || step == Step.FINISHED) {
                dlg.setDefaultButton(ButtonName.CLOSE);
                dlg.setFocusOnButton(ButtonName.CLOSE);
            } else {
                dlg.setDefaultButton(ButtonName.NEXT);
            }
        }
    }

    @Override
    public ProgressStep getCurrentProgressStep() {
        return this.currentProgressStep;
    }

    @Override
    public WizardStep getFirstWizardStep() {
        return Step.WELCOME;
    }

    @Override
    public WizardStep getNextWizardStep(WizardStep step) {
        WizardStep next = null;
        if (step == Step.REPLICATION_OPTIONS) {
            if (this.getUserData().mustCreateAdministrator()) {
                next = Step.CREATE_GLOBAL_ADMINISTRATOR;
            } else {
                switch (this.getUserData().getReplicationOptions().getType()) {
                    case FIRST_IN_TOPOLOGY: {
                        next = Step.NEW_SUFFIX_OPTIONS;
                        break;
                    }
                    case STANDALONE: {
                        next = Step.NEW_SUFFIX_OPTIONS;
                        break;
                    }
                    default: {
                        next = Step.SUFFIXES_OPTIONS;
                        break;
                    }
                }
            }
        } else if (step == Step.SUFFIXES_OPTIONS) {
            switch (this.getUserData().getSuffixesToReplicateOptions().getType()) {
                case REPLICATE_WITH_EXISTING_SUFFIXES: {
                    if (this.getUserData().getRemoteWithNoReplicationPort().size() > 0) {
                        next = Step.REMOTE_REPLICATION_PORTS;
                        break;
                    }
                    next = Step.RUNTIME_OPTIONS;
                    break;
                }
                default: {
                    next = Step.NEW_SUFFIX_OPTIONS;
                    break;
                }
            }
        } else if (step == Step.REMOTE_REPLICATION_PORTS) {
            next = Step.RUNTIME_OPTIONS;
        } else {
            int i = this.lstSteps.indexOf(step);
            if (i != -1 && i + 1 < this.lstSteps.size()) {
                next = this.lstSteps.get(i + 1);
            }
        }
        if (next != null) {
            this.hmPreviousSteps.put(next, step);
        }
        return next;
    }

    @Override
    public LinkedHashSet<WizardStep> getOrderedSteps() {
        LinkedHashSet<WizardStep> orderedSteps = new LinkedHashSet<WizardStep>();
        orderedSteps.add(Step.WELCOME);
        if (this.lstSteps.contains(Step.LICENSE)) {
            orderedSteps.add(Step.LICENSE);
        }
        orderedSteps.add(Step.SERVER_SETTINGS);
        orderedSteps.add(Step.REPLICATION_OPTIONS);
        orderedSteps.add(Step.CREATE_GLOBAL_ADMINISTRATOR);
        orderedSteps.add(Step.SUFFIXES_OPTIONS);
        orderedSteps.add(Step.REMOTE_REPLICATION_PORTS);
        orderedSteps.add(Step.NEW_SUFFIX_OPTIONS);
        orderedSteps.add(Step.RUNTIME_OPTIONS);
        orderedSteps.add(Step.REVIEW);
        orderedSteps.add(Step.PROGRESS);
        orderedSteps.add(Step.FINISHED);
        return orderedSteps;
    }

    @Override
    public WizardStep getPreviousWizardStep(WizardStep step) {
        int i;
        WizardStep prev = this.hmPreviousSteps.get(step);
        if (prev == null && (i = this.lstSteps.indexOf(step)) != -1 && i > 0) {
            prev = this.lstSteps.get(i - 1);
        }
        return prev;
    }

    @Override
    public WizardStep getFinishedStep() {
        return Step.FINISHED;
    }

    protected void uninstallServices() {
        if (this.completedProgress.contains(InstallProgressStep.ENABLING_WINDOWS_SERVICE)) {
            try {
                new InstallerHelper().disableWindowsService();
            }
            catch (ApplicationException ae) {
                LOG.log(Level.INFO, "Error disabling Windows service", ae);
            }
        }
        this.unconfigureRemote();
    }

    private File createTemplateFile() throws ApplicationException {
        File file;
        try {
            LinkedHashSet<String> baseDNs = new LinkedHashSet<String>(this.getUserData().getNewSuffixOptions().getBaseDns());
            int nEntries = this.getUserData().getNewSuffixOptions().getNumberEntries();
            file = SetupUtils.createTemplateFile(baseDNs, nEntries);
        }
        catch (IOException ioe) {
            Message failedMsg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CREATING_TEMP_FILE.get(), ioe);
            throw new ApplicationException(ReturnCode.FILE_SYSTEM_ACCESS_ERROR, failedMsg, ioe);
        }
        return file;
    }

    protected void configureServer() throws ApplicationException {
        String aliasInKeyStore;
        this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CONFIGURING.get()));
        this.writeOpenDSJavaHome();
        this.writeHostName();
        if (Utils.isWebStart()) {
            String installDir = this.getUserData().getServerLocation();
            this.setInstallation(new Installation(installDir, installDir));
        }
        this.checkAbort();
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-C");
        argList.add(this.getConfigurationClassName());
        argList.add("-c");
        argList.add(this.getConfigurationFile());
        argList.add("-p");
        argList.add(String.valueOf(this.getUserData().getServerPort()));
        argList.add("--adminConnectorPort");
        argList.add(String.valueOf(this.getUserData().getAdminConnectorPort()));
        SecurityOptions sec = this.getUserData().getSecurityOptions();
        if (sec.getEnableSSL()) {
            argList.add("-P");
            argList.add(String.valueOf(sec.getSslPort()));
        }
        if (sec.getEnableStartTLS()) {
            argList.add("-q");
        }
        String aliasInTrustStore = (aliasInKeyStore = sec.getAliasToUse()) == null ? SELF_SIGNED_CERT_ALIAS : aliasInKeyStore;
        switch (sec.getCertificateType()) {
            case SELF_SIGNED_CERTIFICATE: {
                argList.add("-k");
                argList.add("cn=JKS,cn=Key Manager Providers,cn=config");
                argList.add("-t");
                argList.add("cn=JKS,cn=Trust Manager Providers,cn=config");
                break;
            }
            case JKS: {
                argList.add("-k");
                argList.add("cn=JKS,cn=Key Manager Providers,cn=config");
                argList.add("-t");
                argList.add("cn=JKS,cn=Trust Manager Providers,cn=config");
                argList.add("-m");
                argList.add(sec.getKeystorePath());
                if (aliasInKeyStore == null) break;
                argList.add("-a");
                argList.add(aliasInKeyStore);
                break;
            }
            case JCEKS: {
                argList.add("-k");
                argList.add("cn=JCEKS,cn=Key Manager Providers,cn=config");
                argList.add("-t");
                argList.add("cn=JCEKS,cn=Trust Manager Providers,cn=config");
                argList.add("-m");
                argList.add(sec.getKeystorePath());
                if (aliasInKeyStore == null) break;
                argList.add("-a");
                argList.add(aliasInKeyStore);
                break;
            }
            case PKCS12: {
                argList.add("-k");
                argList.add("cn=PKCS12,cn=Key Manager Providers,cn=config");
                argList.add("-t");
                argList.add("cn=JKS,cn=Trust Manager Providers,cn=config");
                argList.add("-m");
                argList.add(sec.getKeystorePath());
                if (aliasInKeyStore == null) break;
                argList.add("-a");
                argList.add(aliasInKeyStore);
                break;
            }
            case PKCS11: {
                argList.add("-k");
                argList.add("cn=PKCS11,cn=Key Manager Providers,cn=config");
                argList.add("-t");
                argList.add("cn=JKS,cn=Trust Manager Providers,cn=config");
                if (aliasInKeyStore == null) break;
                argList.add("-a");
                argList.add(aliasInKeyStore);
                break;
            }
            case NO_CERTIFICATE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown certificate type: " + (Object)((Object)sec.getCertificateType()));
            }
        }
        if (this.getUserData().getServerJMXPort() > 0) {
            argList.add("-x");
            argList.add(String.valueOf(this.getUserData().getServerJMXPort()));
        }
        argList.add("-D");
        argList.add(this.getUserData().getDirectoryManagerDn());
        argList.add("-w");
        argList.add(this.getUserData().getDirectoryManagerPwd());
        if (this.createNotReplicatedSuffix()) {
            LinkedList<String> baseDns = this.getUserData().getNewSuffixOptions().getBaseDns();
            for (String baseDn : baseDns) {
                argList.add("-b");
                argList.add(baseDn);
            }
        }
        argList.add("-R");
        argList.add(this.getInstallation().getRootDirectory().getAbsolutePath());
        final String[] args = new String[argList.size()];
        argList.toArray(args);
        StringBuilder cmd = new StringBuilder();
        boolean nextPassword = false;
        for (String s : argList) {
            if (cmd.length() > 0) {
                cmd.append(" ");
            }
            if (nextPassword) {
                cmd.append("{rootUserPassword}");
            } else {
                cmd.append(s);
            }
            nextPassword = "-w".equals(s);
        }
        LOG.log(Level.INFO, "configure DS cmd: " + cmd);
        final InstallerHelper helper = new InstallerHelper();
        this.setNotifyListeners(false);
        InvokeThread thread = new InvokeThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int result = -1;
                try {
                    result = helper.invokeConfigureServer(args);
                    if (result != 0) {
                        this.ae = new ApplicationException(ReturnCode.CONFIGURATION_ERROR, QuickSetupMessages.INFO_ERROR_CONFIGURING.get(), null);
                    } else if (Installer.this.getUserData().getNewSuffixOptions().getBaseDns().isEmpty()) {
                        helper.deleteBackend(Installer.this.getBackendName());
                    }
                }
                catch (ApplicationException aex) {
                    this.ae = aex;
                }
                catch (Throwable t) {
                    this.ae = new ApplicationException(ReturnCode.CONFIGURATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONFIGURING.get(), t), t);
                }
                finally {
                    Installer.this.setNotifyListeners(true);
                }
                this.isOver = true;
            }

            @Override
            public void abort() {
            }
        };
        this.invokeLongOperation(thread);
        this.notifyListeners(this.getFormattedDoneWithLineBreak());
        this.checkAbort();
        try {
            SecurityOptions.CertificateType certType = sec.getCertificateType();
            if (certType != SecurityOptions.CertificateType.NO_CERTIFICATE) {
                this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_UPDATING_CERTIFICATES.get()));
            }
            switch (certType) {
                case NO_CERTIFICATE: {
                    break;
                }
                case SELF_SIGNED_CERTIFICATE: {
                    String pwd = this.getSelfSignedCertificatePwd();
                    CertificateManager certManager = new CertificateManager(this.getSelfSignedKeystorePath(), "JKS", pwd);
                    certManager.generateSelfSignedCertificate(SELF_SIGNED_CERT_ALIAS, this.getSelfSignedCertificateSubjectDN(), this.getSelfSignedCertificateValidity());
                    SetupUtils.exportCertificate(certManager, SELF_SIGNED_CERT_ALIAS, this.getTemporaryCertificatePath());
                    CertificateManager trustManager = new CertificateManager(this.getTrustManagerPath(), "JKS", pwd);
                    trustManager.addCertificate(SELF_SIGNED_CERT_ALIAS, new File(this.getTemporaryCertificatePath()));
                    Utils.createProtectedFile(this.getKeystorePinPath(), pwd);
                    File f = new File(this.getTemporaryCertificatePath());
                    f.delete();
                    break;
                }
                case JKS: {
                    CertificateManager certManager = new CertificateManager(sec.getKeystorePath(), "JKS", sec.getKeystorePassword());
                    if (aliasInKeyStore != null) {
                        SetupUtils.exportCertificate(certManager, aliasInKeyStore, this.getTemporaryCertificatePath());
                    } else {
                        SetupUtils.exportCertificate(certManager, this.getTemporaryCertificatePath());
                    }
                    CertificateManager trustManager = new CertificateManager(this.getTrustManagerPath(), "JKS", sec.getKeystorePassword());
                    trustManager.addCertificate(aliasInTrustStore, new File(this.getTemporaryCertificatePath()));
                    Utils.createProtectedFile(this.getKeystorePinPath(), sec.getKeystorePassword());
                    File f = new File(this.getTemporaryCertificatePath());
                    f.delete();
                    break;
                }
                case JCEKS: {
                    CertificateManager certManager = new CertificateManager(sec.getKeystorePath(), "JCEKS", sec.getKeystorePassword());
                    if (aliasInKeyStore != null) {
                        SetupUtils.exportCertificate(certManager, aliasInKeyStore, this.getTemporaryCertificatePath());
                    } else {
                        SetupUtils.exportCertificate(certManager, this.getTemporaryCertificatePath());
                    }
                    CertificateManager trustManager = new CertificateManager(this.getTrustManagerPath(), "JCEKS", sec.getKeystorePassword());
                    trustManager.addCertificate(aliasInTrustStore, new File(this.getTemporaryCertificatePath()));
                    Utils.createProtectedFile(this.getKeystorePinPath(), sec.getKeystorePassword());
                    File f = new File(this.getTemporaryCertificatePath());
                    f.delete();
                    break;
                }
                case PKCS12: {
                    CertificateManager certManager = new CertificateManager(sec.getKeystorePath(), "PKCS12", sec.getKeystorePassword());
                    if (aliasInKeyStore != null) {
                        SetupUtils.exportCertificate(certManager, aliasInKeyStore, this.getTemporaryCertificatePath());
                    } else {
                        SetupUtils.exportCertificate(certManager, this.getTemporaryCertificatePath());
                    }
                    CertificateManager trustManager = new CertificateManager(this.getTrustManagerPath(), "JKS", sec.getKeystorePassword());
                    trustManager.addCertificate(aliasInTrustStore, new File(this.getTemporaryCertificatePath()));
                    Utils.createProtectedFile(this.getKeystorePinPath(), sec.getKeystorePassword());
                    File f = new File(this.getTemporaryCertificatePath());
                    f.delete();
                    break;
                }
                case PKCS11: {
                    CertificateManager certManager = new CertificateManager("NONE", "PKCS11", sec.getKeystorePassword());
                    if (aliasInKeyStore != null) {
                        SetupUtils.exportCertificate(certManager, aliasInKeyStore, this.getTemporaryCertificatePath());
                    } else {
                        SetupUtils.exportCertificate(certManager, this.getTemporaryCertificatePath());
                    }
                    CertificateManager trustManager = new CertificateManager(this.getTrustManagerPath(), "JKS", sec.getKeystorePassword());
                    trustManager.addCertificate(aliasInTrustStore, new File(this.getTemporaryCertificatePath()));
                    Utils.createProtectedFile(this.getKeystorePinPath(), sec.getKeystorePassword());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown certificate type: " + (Object)((Object)certType));
                }
            }
            if (certType != SecurityOptions.CertificateType.NO_CERTIFICATE) {
                this.notifyListeners(this.getFormattedDoneWithLineBreak());
            }
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Error configuring certificate: " + t, t);
            throw new ApplicationException(ReturnCode.CONFIGURATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONFIGURING_CERTIFICATE.get(), t), t);
        }
    }

    private void createBaseEntry() throws ApplicationException {
        LinkedList<String> baseDns = this.getUserData().getNewSuffixOptions().getBaseDns();
        if (baseDns.size() == 1) {
            this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CREATING_BASE_ENTRY.get(baseDns.getFirst())));
        } else {
            this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CREATING_BASE_ENTRIES.get()));
        }
        final InstallerHelper helper = new InstallerHelper();
        LinkedList<File> ldifFiles = new LinkedList<File>();
        for (String baseDn : baseDns) {
            ldifFiles.add(helper.createBaseEntryTempFile(baseDn));
        }
        this.checkAbort();
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-n");
        argList.add(this.getBackendName());
        for (File f : ldifFiles) {
            argList.add("-l");
            argList.add(f.getAbsolutePath());
        }
        argList.add("-F");
        argList.add("-Q");
        argList.add("--noPropertiesFile");
        final String[] args = new String[argList.size()];
        argList.toArray(args);
        this.setNotifyListeners(false);
        InvokeThread thread = new InvokeThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int result = helper.invokeImportLDIF(Installer.this, args);
                    if (result != 0) {
                        this.ae = new ApplicationException(ReturnCode.IMPORT_ERROR, QuickSetupMessages.INFO_ERROR_CREATING_BASE_ENTRY.get(), null);
                    }
                }
                catch (Throwable t) {
                    this.ae = new ApplicationException(ReturnCode.IMPORT_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CREATING_BASE_ENTRY.get(), t), t);
                }
                finally {
                    Installer.this.setNotifyListeners(true);
                }
                this.isOver = true;
            }

            @Override
            public void abort() {
            }
        };
        this.invokeLongOperation(thread);
        this.notifyListeners(this.getFormattedDoneWithLineBreak());
    }

    private void importLDIF() throws ApplicationException {
        String skippedFile;
        LinkedList<String> ldifPaths = this.getUserData().getNewSuffixOptions().getLDIFPaths();
        MessageBuilder mb = new MessageBuilder();
        if (ldifPaths.size() > 1) {
            if (this.isVerbose()) {
                mb.append(this.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_IMPORTING_LDIFS.get(Utils.getStringFromCollection(ldifPaths, ", "))));
                mb.append(this.getLineBreak());
            } else {
                mb.append(this.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_IMPORTING_LDIFS_NON_VERBOSE.get(Utils.getStringFromCollection(ldifPaths, ", "))));
            }
        } else if (this.isVerbose()) {
            mb.append(this.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_IMPORTING_LDIF.get(ldifPaths.getFirst())));
            mb.append(this.getLineBreak());
        } else {
            mb.append(this.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_IMPORTING_LDIF_NON_VERBOSE.get(ldifPaths.getFirst())));
        }
        this.notifyListeners(mb.toMessage());
        final Application.PointAdder pointAdder = new Application.PointAdder();
        if (!this.isVerbose()) {
            this.setNotifyListeners(false);
            pointAdder.start();
        }
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-n");
        argList.add(this.getBackendName());
        for (String ldifPath : ldifPaths) {
            argList.add("-l");
            argList.add(ldifPath);
        }
        argList.add("-F");
        String rejectedFile = this.getUserData().getNewSuffixOptions().getRejectedFile();
        if (rejectedFile != null) {
            argList.add("-R");
            argList.add(rejectedFile);
        }
        if ((skippedFile = this.getUserData().getNewSuffixOptions().getSkippedFile()) != null) {
            argList.add("--skipFile");
            argList.add(skippedFile);
        }
        final String[] args = new String[argList.size()];
        argList.toArray(args);
        InvokeThread thread = new InvokeThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    InstallerHelper helper = new InstallerHelper();
                    int result = helper.invokeImportLDIF(Installer.this, args);
                    if (result != 0) {
                        this.ae = new ApplicationException(ReturnCode.IMPORT_ERROR, QuickSetupMessages.INFO_ERROR_IMPORTING_LDIF.get(), null);
                    }
                }
                catch (Throwable t) {
                    this.ae = new ApplicationException(ReturnCode.IMPORT_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_IMPORTING_LDIF.get(), t), t);
                }
                finally {
                    if (!Installer.this.isVerbose()) {
                        Installer.this.setNotifyListeners(true);
                        pointAdder.stop();
                    }
                }
                this.isOver = true;
            }

            @Override
            public void abort() {
            }
        };
        try {
            this.invokeLongOperation(thread);
        }
        catch (ApplicationException ae) {
            if (!this.isVerbose() && this.lastImportProgress != null) {
                this.notifyListeners(this.getFormattedProgress(Message.raw(this.lastImportProgress, new Object[0])));
                this.notifyListeners(this.getLineBreak());
            }
            throw ae;
        }
        if (!this.isVerbose()) {
            if (this.lastImportProgress == null) {
                this.notifyListeners(this.getFormattedDoneWithLineBreak());
            } else {
                this.notifyListeners(this.getFormattedProgress(Message.raw(this.lastImportProgress, new Object[0])));
                this.notifyListeners(this.getLineBreak());
            }
        }
    }

    private void importAutomaticallyGenerated() throws ApplicationException {
        File templatePath = this.createTemplateFile();
        int nEntries = this.getUserData().getNewSuffixOptions().getNumberEntries();
        MessageBuilder mb = new MessageBuilder();
        if (this.isVerbose() || nEntries > 20000) {
            mb.append(this.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_IMPORT_AUTOMATICALLY_GENERATED.get(String.valueOf(nEntries))));
            mb.append(this.getLineBreak());
        } else {
            mb.append(this.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_IMPORT_AUTOMATICALLY_GENERATED_NON_VERBOSE.get(String.valueOf(nEntries))));
        }
        this.notifyListeners(mb.toMessage());
        final Application.PointAdder pointAdder = new Application.PointAdder();
        if (!this.isVerbose()) {
            pointAdder.start();
        }
        if (!this.isVerbose()) {
            this.setNotifyListeners(false);
        }
        final ArrayList<String> argList = new ArrayList<String>();
        argList.add("-n");
        argList.add(this.getBackendName());
        argList.add("-A");
        argList.add(templatePath.getAbsolutePath());
        argList.add("-s");
        argList.add("0");
        argList.add("-F");
        final String[] args = new String[argList.size()];
        argList.toArray(args);
        InvokeThread thread = new InvokeThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    InstallerHelper helper = new InstallerHelper();
                    int result = helper.invokeImportLDIF(Installer.this, args);
                    if (result != 0) {
                        this.ae = new ApplicationException(ReturnCode.IMPORT_ERROR, QuickSetupMessages.INFO_ERROR_IMPORT_LDIF_TOOL_RETURN_CODE.get(Integer.toString(result)), null);
                    }
                }
                catch (Throwable t) {
                    this.ae = new ApplicationException(ReturnCode.IMPORT_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_IMPORT_AUTOMATICALLY_GENERATED.get(Utils.listToString(argList, " "), t.getLocalizedMessage()), t), t);
                }
                finally {
                    if (!Installer.this.isVerbose()) {
                        Installer.this.setNotifyListeners(true);
                        if (this.ae != null) {
                            pointAdder.stop();
                        }
                    }
                }
                this.isOver = true;
            }

            @Override
            public void abort() {
            }
        };
        this.invokeLongOperation(thread);
        if (!this.isVerbose()) {
            pointAdder.stop();
            this.notifyListeners(this.getFormattedDoneWithLineBreak());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unconfigureRemote() {
        InitialContext ctx = null;
        if (this.registeredNewServerOnRemote || this.createdAdministrator || this.createdRemoteAds) {
            DataReplicationOptions repl = this.getUserData().getReplicationOptions();
            AuthenticationData auth = repl.getAuthenticationData();
            String ldapUrl = this.getLdapUrl(auth);
            String dn = auth.getDn();
            String pwd = auth.getPwd();
            if (this.isVerbose()) {
                this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_UNCONFIGURING_ADS_ON_REMOTE.get(this.getHostDisplay(auth))));
            }
            try {
                if (auth.useSecureConnection()) {
                    ApplicationTrustManager trustManager = this.getTrustManager();
                    trustManager.setHost(auth.getHostName());
                    ctx = Utils.createLdapsContext(ldapUrl, dn, pwd, this.getConnectTimeout(), null, trustManager);
                } else {
                    ctx = Utils.createLdapContext(ldapUrl, dn, pwd, this.getConnectTimeout(), null);
                }
                ADSContext adsContext = new ADSContext((InitialLdapContext)ctx);
                if (this.createdRemoteAds) {
                    adsContext.removeAdminData();
                } else {
                    block29: {
                        if (this.registeredNewServerOnRemote) {
                            try {
                                adsContext.unregisterServer(this.getNewServerAdsProperties(this.getUserData()));
                            }
                            catch (ADSContextException ace) {
                                if (ace.getError() == ADSContextException.ErrorType.NOT_YET_REGISTERED) break block29;
                                throw ace;
                            }
                        }
                    }
                    if (this.createdAdministrator) {
                        adsContext.deleteAdministrator(this.getAdministratorProperties(this.getUserData()));
                    }
                }
                if (this.isVerbose()) {
                    this.notifyListeners(this.getFormattedDoneWithLineBreak());
                }
            }
            catch (Throwable t) {
                this.notifyListeners(this.getFormattedError(t, true));
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
        InstallerHelper helper = new InstallerHelper();
        for (ServerDescriptor server : this.hmConfiguredRemoteReplication.keySet()) {
            this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_UNCONFIGURING_REPLICATION_REMOTE.get(this.getHostPort(server))));
            try {
                ctx = this.getRemoteConnection(server, this.getTrustManager(), this.getPreferredConnections());
                helper.unconfigureReplication((InitialLdapContext)ctx, this.hmConfiguredRemoteReplication.get(server), ConnectionUtils.getHostPort((InitialLdapContext)ctx));
            }
            catch (ApplicationException ae) {
                this.notifyListeners(this.getFormattedError(ae, true));
            }
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            this.notifyListeners(this.getFormattedDoneWithLineBreak());
        }
    }

    protected void createReplicatedBackendsIfRequired() throws ApplicationException {
        if (this.getUserData().getReplicationOptions().getType() == DataReplicationOptions.Type.FIRST_IN_TOPOLOGY && this.getUserData().getNewSuffixOptions().getBaseDns().isEmpty()) {
            return;
        }
        this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CREATING_REPLICATED_BACKENDS.get()));
        HashMap hmBackendSuffix = new HashMap();
        boolean deleteUserRoot = false;
        if (this.getUserData().getReplicationOptions().getType() == DataReplicationOptions.Type.FIRST_IN_TOPOLOGY) {
            HashSet<String> baseDns = new HashSet<String>(this.getUserData().getNewSuffixOptions().getBaseDns());
            hmBackendSuffix.put(this.getBackendName(), baseDns);
        } else {
            Set<SuffixDescriptor> suffixes = this.getUserData().getSuffixesToReplicateOptions().getSuffixes();
            LinkedHashSet<ServerDescriptor> serverList = new LinkedHashSet<ServerDescriptor>();
            for (SuffixDescriptor suffix : suffixes) {
                for (ReplicaDescriptor replica : suffix.getReplicas()) {
                    serverList.add(replica.getServer());
                }
            }
            for (SuffixDescriptor suffix : suffixes) {
                String backendName = null;
                for (ServerDescriptor server : serverList) {
                    for (ReplicaDescriptor replica : suffix.getReplicas()) {
                        if (replica.getServer() != server) continue;
                        backendName = replica.getBackendName();
                        break;
                    }
                    if (backendName == null) continue;
                    break;
                }
                boolean found = false;
                for (String storedBackend : hmBackendSuffix.keySet()) {
                    if (!storedBackend.equalsIgnoreCase(backendName)) continue;
                    found = true;
                    ((Set)hmBackendSuffix.get(storedBackend)).add(suffix.getDN());
                    break;
                }
                if (found) continue;
                HashSet<String> baseDns = new HashSet<String>();
                baseDns.add(suffix.getDN());
                hmBackendSuffix.put(backendName, baseDns);
            }
            deleteUserRoot = true;
            for (String backendName : hmBackendSuffix.keySet()) {
                if (!backendName.equalsIgnoreCase(this.getBackendName())) continue;
                deleteUserRoot = false;
                break;
            }
        }
        InstallerHelper helper = new InstallerHelper();
        InitialLdapContext ctx = null;
        try {
            ctx = this.createLocalContext();
            if (deleteUserRoot) {
                helper.deleteBackend(ctx, this.getBackendName(), ConnectionUtils.getHostPort(ctx));
            }
            for (String backendName : hmBackendSuffix.keySet()) {
                if (backendName.equalsIgnoreCase(this.getBackendName())) {
                    helper.setBaseDns(ctx, backendName, (Set)hmBackendSuffix.get(backendName), ConnectionUtils.getHostPort(ctx));
                    continue;
                }
                helper.createLocalDBBackend(ctx, backendName, (Set)hmBackendSuffix.get(backendName), ConnectionUtils.getHostPort(ctx));
            }
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (NamingException ne) {
            Message failedMsg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONNECTING_TO_LOCAL.get(), ne);
            throw new ApplicationException(ReturnCode.CONFIGURATION_ERROR, failedMsg, ne);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Throwable t) {}
        }
        this.notifyListeners(this.getFormattedDoneWithLineBreak());
        this.checkAbort();
    }

    protected void configureReplication() throws ApplicationException {
        this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CONFIGURING_REPLICATION.get()));
        InstallerHelper helper = new InstallerHelper();
        HashSet<Integer> knownServerIds = new HashSet<Integer>();
        HashSet<Integer> knownReplicationServerIds = new HashSet<Integer>();
        if (this.lastLoadedCache != null) {
            for (SuffixDescriptor suffix : this.lastLoadedCache.getSuffixes()) {
                for (ReplicaDescriptor replica : suffix.getReplicas()) {
                    knownServerIds.add(replica.getReplicationId());
                }
            }
            for (ServerDescriptor server : this.lastLoadedCache.getServers()) {
                Object v = server.getServerProperties().get((Object)ServerDescriptor.ServerProperty.REPLICATION_SERVER_ID);
                if (v == null) continue;
                knownReplicationServerIds.add((Integer)v);
            }
        } else {
            for (SuffixDescriptor suffix : this.getUserData().getSuffixesToReplicateOptions().getAvailableSuffixes()) {
                for (ReplicaDescriptor replica : suffix.getReplicas()) {
                    knownServerIds.add(replica.getReplicationId());
                    Object v = replica.getServer().getServerProperties().get((Object)ServerDescriptor.ServerProperty.REPLICATION_SERVER_ID);
                    if (v == null) continue;
                    knownReplicationServerIds.add((Integer)v);
                }
            }
        }
        HashMap<String, Set<String>> replicationServers = new HashMap<String, Set<String>>();
        HashSet<String> adsServers = new HashSet<String>();
        if (this.getUserData().getReplicationOptions().getType() == DataReplicationOptions.Type.FIRST_IN_TOPOLOGY) {
            LinkedList<String> baseDns = this.getUserData().getNewSuffixOptions().getBaseDns();
            HashSet<String> h = new HashSet<String>();
            h.add(this.getLocalReplicationServer());
            adsServers.add(this.getLocalReplicationServer());
            for (String dn : baseDns) {
                replicationServers.put(dn, new HashSet(h));
            }
        } else {
            Set<SuffixDescriptor> suffixes = this.getUserData().getSuffixesToReplicateOptions().getSuffixes();
            for (SuffixDescriptor suffix : suffixes) {
                HashSet<String> h = new HashSet<String>();
                h.addAll(suffix.getReplicationServers());
                adsServers.addAll(suffix.getReplicationServers());
                h.add(this.getLocalReplicationServer());
                adsServers.add(this.getLocalReplicationServer());
                for (ReplicaDescriptor replica : suffix.getReplicas()) {
                    ServerDescriptor server = replica.getServer();
                    AuthenticationData repPort = this.getUserData().getRemoteWithNoReplicationPort().get(server);
                    if (repPort == null) continue;
                    h.add(server.getHostName() + ":" + repPort.getPort());
                    adsServers.add(server.getHostName() + ":" + repPort.getPort());
                }
                replicationServers.put(suffix.getDN(), h);
            }
        }
        replicationServers.put(ADSContext.getAdministrationSuffixDN(), adsServers);
        replicationServers.put("cn=schema", new HashSet(adsServers));
        InitialLdapContext ctx = null;
        long localTime = -1L;
        long localTimeMeasureTime = -1L;
        String localServerDisplay = null;
        try {
            ctx = this.createLocalContext();
            helper.configureReplication(ctx, replicationServers, this.getUserData().getReplicationOptions().getReplicationPort(), this.getUserData().getReplicationOptions().useSecureReplication(), this.getLocalHostPort(), knownReplicationServerIds, knownServerIds);
            localTimeMeasureTime = System.currentTimeMillis();
            localTime = Utils.getServerClock(ctx);
            localServerDisplay = ConnectionUtils.getHostPort(ctx);
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (NamingException ne) {
            Message failedMsg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONNECTING_TO_LOCAL.get(), ne);
            throw new ApplicationException(ReturnCode.CONFIGURATION_ERROR, failedMsg, ne);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Throwable t) {}
        }
        this.notifyListeners(this.getFormattedDoneWithLineBreak());
        this.checkAbort();
        if (this.getUserData().getReplicationOptions().getType() == DataReplicationOptions.Type.IN_EXISTING_TOPOLOGY) {
            HashMap<ServerDescriptor, HashSet<ReplicaDescriptor>> hm = new HashMap<ServerDescriptor, HashSet<ReplicaDescriptor>>();
            for (SuffixDescriptor suffix : this.getUserData().getSuffixesToReplicateOptions().getSuffixes()) {
                for (ReplicaDescriptor replica : suffix.getReplicas()) {
                    HashSet<ReplicaDescriptor> replicas = (HashSet<ReplicaDescriptor>)hm.get(replica.getServer());
                    if (replicas == null) {
                        replicas = new HashSet<ReplicaDescriptor>();
                        hm.put(replica.getServer(), replicas);
                    }
                    replicas.add(replica);
                }
            }
            for (ServerDescriptor server : hm.keySet()) {
                boolean enableSecureReplication;
                int replicationPort;
                this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CONFIGURING_REPLICATION_REMOTE.get(this.getHostPort(server))));
                Integer v = (Integer)server.getServerProperties().get((Object)ServerDescriptor.ServerProperty.REPLICATION_SERVER_PORT);
                if (v != null) {
                    replicationPort = v;
                    enableSecureReplication = false;
                } else {
                    AuthenticationData authData = this.getUserData().getRemoteWithNoReplicationPort().get(server);
                    if (authData != null) {
                        replicationPort = authData.getPort();
                        enableSecureReplication = authData.useSecureConnection();
                    } else {
                        replicationPort = 8989;
                        enableSecureReplication = false;
                        LOG.log(Level.WARNING, "Could not find replication port for: " + this.getHostPort(server));
                    }
                }
                HashSet<String> dns = new HashSet<String>();
                for (ReplicaDescriptor replica : (Set)hm.get(server)) {
                    dns.add(replica.getSuffix().getDN());
                }
                dns.add(ADSContext.getAdministrationSuffixDN());
                dns.add("cn=schema");
                HashMap<String, Set<String>> remoteReplicationServers = new HashMap<String, Set<String>>();
                for (String dn : dns) {
                    Set repServer = (Set)replicationServers.get(dn);
                    if (repServer == null) {
                        for (String dn1 : replicationServers.keySet()) {
                            if (!Utils.areDnsEqual(dn, dn1)) continue;
                            repServer = (Set)replicationServers.get(dn1);
                            dn = dn1;
                            break;
                        }
                    }
                    if (repServer != null) {
                        remoteReplicationServers.put(dn, repServer);
                        continue;
                    }
                    LOG.log(Level.WARNING, "Could not find replication server for: " + dn);
                }
                ctx = this.getRemoteConnection(server, this.getTrustManager(), this.getPreferredConnections());
                ConfiguredReplication repl = helper.configureReplication(ctx, remoteReplicationServers, replicationPort, enableSecureReplication, ConnectionUtils.getHostPort(ctx), knownReplicationServerIds, knownServerIds);
                long remoteTimeMeasureTime = System.currentTimeMillis();
                long remoteTime = Utils.getServerClock(ctx);
                if (localTime != -1L && remoteTime != -1L && Math.abs(localTime - remoteTime - localTimeMeasureTime + remoteTimeMeasureTime) > 300000L) {
                    this.notifyListeners(this.getFormattedWarning(QuickSetupMessages.INFO_WARNING_SERVERS_CLOCK_DIFFERENCE.get(localServerDisplay, ConnectionUtils.getHostPort(ctx), String.valueOf(5))));
                }
                this.hmConfiguredRemoteReplication.put(server, repl);
                try {
                    ctx.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                this.notifyListeners(this.getFormattedDoneWithLineBreak());
                this.checkAbort();
            }
        }
    }

    protected void enableWindowsService() throws ApplicationException {
        this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_ENABLING_WINDOWS_SERVICE.get()));
        InstallerHelper helper = new InstallerHelper();
        helper.enableWindowsService();
        this.notifyListeners(this.getLineBreak());
    }

    protected void initSummaryMap(Map<InstallProgressStep, Message> hmSummary) {
        hmSummary.put(InstallProgressStep.NOT_STARTED, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_INSTALL_NOT_STARTED.get()));
        hmSummary.put(InstallProgressStep.DOWNLOADING, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_DOWNLOADING.get()));
        hmSummary.put(InstallProgressStep.EXTRACTING, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_EXTRACTING.get()));
        hmSummary.put(InstallProgressStep.CONFIGURING_SERVER, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_CONFIGURING.get()));
        hmSummary.put(InstallProgressStep.CREATING_BASE_ENTRY, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_CREATING_BASE_ENTRY.get()));
        hmSummary.put(InstallProgressStep.IMPORTING_LDIF, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_IMPORTING_LDIF.get()));
        hmSummary.put(InstallProgressStep.IMPORTING_AUTOMATICALLY_GENERATED, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_IMPORTING_AUTOMATICALLY_GENERATED.get()));
        hmSummary.put(InstallProgressStep.CONFIGURING_REPLICATION, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_CONFIGURING_REPLICATION.get()));
        hmSummary.put(InstallProgressStep.STARTING_SERVER, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_STARTING.get()));
        hmSummary.put(InstallProgressStep.STOPPING_SERVER, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_STOPPING.get()));
        hmSummary.put(InstallProgressStep.CONFIGURING_ADS, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_CONFIGURING_ADS.get()));
        hmSummary.put(InstallProgressStep.INITIALIZE_REPLICATED_SUFFIXES, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_INITIALIZE_REPLICATED_SUFFIXES.get()));
        hmSummary.put(InstallProgressStep.ENABLING_WINDOWS_SERVICE, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_ENABLING_WINDOWS_SERVICE.get()));
        hmSummary.put(InstallProgressStep.WAITING_TO_CANCEL, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_WAITING_TO_CANCEL.get()));
        hmSummary.put(InstallProgressStep.CANCELING, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_CANCELING.get()));
        Installation installation = this.getInstallation();
        String cmd = Utils.addWordBreaks(Utils.getPath(installation.getControlPanelCommandFile()), 60, 5);
        cmd = UIFactory.applyFontToHtml(cmd, UIFactory.INSTRUCTIONS_MONOSPACE_FONT);
        String formattedPath = Utils.addWordBreaks(this.formatter.getFormattedText(Message.raw(Utils.getPath(new File(this.getInstancePath())), new Object[0])).toString(), 60, 5);
        Message successMessage = Utils.getCustomizedObject("INFO_SUMMARY_INSTALL_FINISHED_SUCCESSFULLY", QuickSetupMessages.INFO_SUMMARY_INSTALL_FINISHED_SUCCESSFULLY.get(DynamicConstants.PRODUCT_NAME, DynamicConstants.PRODUCT_NAME, formattedPath, QuickSetupMessages.INFO_GENERAL_SERVER_STOPPED.get(), DynamicConstants.DOC_QUICK_REFERENCE_GUIDE, DynamicConstants.PRODUCT_NAME, cmd), Message.class);
        hmSummary.put(InstallProgressStep.FINISHED_SUCCESSFULLY, this.getFormattedSuccess(successMessage));
        hmSummary.put(InstallProgressStep.FINISHED_CANCELED, this.getFormattedSuccess(QuickSetupMessages.INFO_SUMMARY_INSTALL_FINISHED_CANCELED.get()));
        hmSummary.put(InstallProgressStep.FINISHED_WITH_ERROR, this.getFormattedError(QuickSetupMessages.INFO_SUMMARY_INSTALL_FINISHED_WITH_ERROR.get(QuickSetupMessages.INFO_GENERAL_SERVER_STOPPED.get(), cmd)));
    }

    protected void updateSummaryWithServerState(Map<InstallProgressStep, Message> hmSummary) {
        Installation installation = this.getInstallation();
        String cmd = Utils.getPath(installation.getControlPanelCommandFile());
        cmd = Utils.addWordBreaks(UIFactory.applyFontToHtml(cmd, UIFactory.INSTRUCTIONS_MONOSPACE_FONT), 60, 5);
        Message status = installation.getStatus().isServerRunning() ? QuickSetupMessages.INFO_GENERAL_SERVER_STARTED.get() : QuickSetupMessages.INFO_GENERAL_SERVER_STOPPED.get();
        String formattedPath = Utils.addWordBreaks(this.formatter.getFormattedText(Message.raw(Utils.getPath(new File(this.getInstancePath())), new Object[0])).toString(), 60, 5);
        Message successMessage = Utils.getCustomizedObject("INFO_SUMMARY_INSTALL_FINISHED_SUCCESSFULLY", QuickSetupMessages.INFO_SUMMARY_INSTALL_FINISHED_SUCCESSFULLY.get(DynamicConstants.PRODUCT_NAME, DynamicConstants.PRODUCT_NAME, formattedPath, status, DynamicConstants.DOC_QUICK_REFERENCE_GUIDE, DynamicConstants.PRODUCT_NAME, cmd), Message.class);
        hmSummary.put(InstallProgressStep.FINISHED_SUCCESSFULLY, this.getFormattedSuccess(successMessage));
        hmSummary.put(InstallProgressStep.FINISHED_WITH_ERROR, this.getFormattedError(QuickSetupMessages.INFO_SUMMARY_INSTALL_FINISHED_WITH_ERROR.get(status, cmd)));
    }

    @Override
    public void checkAbort() throws ApplicationException {
        if (this.canceled) {
            this.setCurrentProgressStep(InstallProgressStep.CANCELING);
            this.notifyListeners(null);
            throw new ApplicationException(ReturnCode.CANCELED, QuickSetupMessages.INFO_INSTALL_CANCELED.get(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHostName() {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.getHostNameFile(), false));
            writer.append(this.getUserData().getHostName());
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, "Error writing host name file: " + ioe, ioe);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private String getHostNameFile() {
        String file = Utils.getPath(this.getInstallation().getRootDirectory().getAbsolutePath(), SetupUtils.HOST_NAME_FILE);
        return file;
    }

    private void writeOpenDSJavaHome() {
        try {
            InstallerHelper helper = new InstallerHelper();
            helper.writeSetOpenDSJavaHome(this.getUserData(), this.getInstallationPath());
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error writing OpenDS Java Home file: " + e, e);
        }
    }

    @Override
    public void updateUserData(WizardStep cStep, QuickSetup qs) throws UserDataException {
        if (cStep == Step.SERVER_SETTINGS) {
            this.updateUserDataForServerSettingsPanel(qs);
        } else if (cStep == Step.REPLICATION_OPTIONS) {
            this.updateUserDataForReplicationOptionsPanel(qs);
        } else if (cStep == Step.CREATE_GLOBAL_ADMINISTRATOR) {
            this.updateUserDataForCreateAdministratorPanel(qs);
        } else if (cStep == Step.SUFFIXES_OPTIONS) {
            this.updateUserDataForSuffixesOptionsPanel(qs);
        } else if (cStep == Step.REMOTE_REPLICATION_PORTS) {
            this.updateUserDataForRemoteReplicationPorts(qs);
        } else if (cStep == Step.NEW_SUFFIX_OPTIONS) {
            this.updateUserDataForNewSuffixOptionsPanel(qs);
        } else if (cStep == Step.RUNTIME_OPTIONS) {
            this.updateUserDataForRuntimeOptionsPanel(qs);
        } else if (cStep == Step.REVIEW) {
            this.updateUserDataForReviewPanel(qs);
        }
    }

    private String getBackendName() {
        return "userRoot";
    }

    protected void setCurrentProgressStep(InstallProgressStep currentProgressStep) {
        if (currentProgressStep != null) {
            this.completedProgress.add(currentProgressStep);
        }
        this.currentProgressStep = currentProgressStep;
    }

    protected void createData() throws ApplicationException {
        if (this.createNotReplicatedSuffix()) {
            switch (this.getUserData().getNewSuffixOptions().getType()) {
                case CREATE_BASE_ENTRY: {
                    this.currentProgressStep = InstallProgressStep.CREATING_BASE_ENTRY;
                    if (this.isVerbose()) {
                        this.notifyListeners(this.getTaskSeparator());
                    }
                    this.createBaseEntry();
                    break;
                }
                case IMPORT_FROM_LDIF_FILE: {
                    this.currentProgressStep = InstallProgressStep.IMPORTING_LDIF;
                    if (this.isVerbose()) {
                        this.notifyListeners(this.getTaskSeparator());
                    }
                    this.importLDIF();
                    break;
                }
                case IMPORT_AUTOMATICALLY_GENERATED_DATA: {
                    this.currentProgressStep = InstallProgressStep.IMPORTING_AUTOMATICALLY_GENERATED;
                    if (this.isVerbose()) {
                        this.notifyListeners(this.getTaskSeparator());
                    }
                    this.importAutomaticallyGenerated();
                }
            }
        }
    }

    protected void initializeSuffixes() throws ApplicationException {
        InitialLdapContext ctx = null;
        try {
            ctx = this.createLocalContext();
        }
        catch (Throwable t) {
            Message failedMsg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONNECTING_TO_LOCAL.get(), t);
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Throwable t1) {
                // empty catch block
            }
            throw new ApplicationException(ReturnCode.CONFIGURATION_ERROR, failedMsg, t);
        }
        Set<SuffixDescriptor> suffixes = this.getUserData().getSuffixesToReplicateOptions().getSuffixes();
        ServerDescriptor server = suffixes.iterator().next().getReplicas().iterator().next().getServer();
        InitialContext rCtx = null;
        try {
            rCtx = this.getRemoteConnection(server, this.getTrustManager(), this.getPreferredConnections());
            TopologyCacheFilter filter = new TopologyCacheFilter();
            filter.setSearchMonitoringInformation(false);
            filter.addBaseDNToSearch(ADSContext.getAdministrationSuffixDN());
            filter.addBaseDNToSearch("cn=schema");
            ServerDescriptor s = ServerDescriptor.createStandalone((InitialLdapContext)rCtx, filter);
            for (ReplicaDescriptor replica : s.getReplicas()) {
                String dn = replica.getSuffix().getDN();
                if (Utils.areDnsEqual(dn, ADSContext.getAdministrationSuffixDN())) {
                    suffixes.add(replica.getSuffix());
                    continue;
                }
                if (!Utils.areDnsEqual(dn, "cn=schema")) continue;
                suffixes.add(replica.getSuffix());
            }
        }
        catch (NamingException ne) {
            Message msg = Utils.isCertificateException(ne) ? QuickSetupMessages.INFO_ERROR_READING_CONFIG_LDAP_CERTIFICATE_SERVER.get(this.getHostPort(server), ne.toString(true)) : QuickSetupMessages.INFO_CANNOT_CONNECT_TO_REMOTE_GENERIC.get(this.getHostPort(server), ne.toString(true));
            throw new ApplicationException(ReturnCode.CONFIGURATION_ERROR, msg, ne);
        }
        finally {
            try {
                rCtx.close();
            }
            catch (Throwable t) {}
        }
        for (SuffixDescriptor suffix : suffixes) {
            String dn = suffix.getDN();
            ReplicaDescriptor replica = suffix.getReplicas().iterator().next();
            ServerDescriptor server2 = replica.getServer();
            String hostPort = this.getHostPort(server2);
            boolean isADS = Utils.areDnsEqual(dn, ADSContext.getAdministrationSuffixDN());
            boolean isSchema = Utils.areDnsEqual(dn, "cn=schema");
            if (isADS) {
                if (this.isVerbose()) {
                    this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_INITIALIZING_ADS.get()));
                }
            } else if (isSchema) {
                if (this.isVerbose()) {
                    this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_INITIALIZING_SCHEMA.get()));
                }
            } else {
                this.notifyListeners(this.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_INITIALIZING_SUFFIX.get(dn, hostPort)));
                this.notifyListeners(this.getLineBreak());
            }
            try {
                int replicationId = replica.getReplicationId();
                if (replicationId == -1) {
                    InitialContext rCtx2 = null;
                    try {
                        rCtx2 = this.getRemoteConnection(server2, this.getTrustManager(), this.getPreferredConnections());
                        TopologyCacheFilter filter = new TopologyCacheFilter();
                        filter.setSearchMonitoringInformation(false);
                        filter.addBaseDNToSearch(dn);
                        ServerDescriptor s = ServerDescriptor.createStandalone((InitialLdapContext)rCtx2, filter);
                        for (ReplicaDescriptor r : s.getReplicas()) {
                            if (!Utils.areDnsEqual(r.getSuffix().getDN(), dn)) continue;
                            replicationId = r.getReplicationId();
                        }
                    }
                    catch (NamingException ne) {
                        Message msg = Utils.isCertificateException(ne) ? QuickSetupMessages.INFO_ERROR_READING_CONFIG_LDAP_CERTIFICATE_SERVER.get(this.getHostPort(server2), ne.toString(true)) : QuickSetupMessages.INFO_CANNOT_CONNECT_TO_REMOTE_GENERIC.get(this.getHostPort(server2), ne.toString(true));
                        throw new ApplicationException(ReturnCode.CONFIGURATION_ERROR, msg, ne);
                    }
                    finally {
                        try {
                            rCtx2.close();
                        }
                        catch (Throwable t) {}
                    }
                }
                if (replicationId == -1) {
                    throw new ApplicationException(ReturnCode.APPLICATION_ERROR, QuickSetupMessages.ERR_COULD_NOT_FIND_REPLICATIONID.get(dn), null);
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                int nTries = 5;
                boolean initDone = false;
                while (!initDone) {
                    try {
                        LOG.log(Level.INFO, "Calling initializeSuffix with base DN: " + dn);
                        LOG.log(Level.INFO, "Try number: " + (6 - nTries));
                        LOG.log(Level.INFO, "replicationId of source replica: " + replicationId);
                        this.initializeSuffix(ctx, replicationId, dn, !isADS && !isSchema, hostPort);
                        initDone = true;
                    }
                    catch (PeerNotFoundException pnfe) {
                        LOG.log(Level.INFO, "Peer could not be found");
                        if (nTries == 1) {
                            throw new ApplicationException(ReturnCode.APPLICATION_ERROR, pnfe.getMessageObject(), null);
                        }
                        try {
                            Thread.sleep((5 - nTries) * 3000);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    --nTries;
                }
            }
            catch (ApplicationException ae) {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (Throwable t1) {
                    // empty catch block
                }
                throw ae;
            }
            if ((isADS || isSchema) && this.isVerbose()) {
                this.notifyListeners(this.getFormattedDone());
                this.notifyListeners(this.getLineBreak());
            }
            this.checkAbort();
        }
    }

    protected void updateADS() throws ApplicationException {
        block36: {
            DataReplicationOptions repl = this.getUserData().getReplicationOptions();
            boolean isRemoteServer = repl.getType() == DataReplicationOptions.Type.IN_EXISTING_TOPOLOGY;
            AuthenticationData auth = isRemoteServer ? repl.getAuthenticationData() : null;
            InitialContext remoteCtx = null;
            InitialLdapContext localCtx = null;
            ADSContext adsContext = null;
            try {
                if (isRemoteServer) {
                    String ldapUrl = this.getLdapUrl(auth);
                    String dn = auth.getDn();
                    String pwd = auth.getPwd();
                    if (auth.useSecureConnection()) {
                        ApplicationTrustManager trustManager = this.getTrustManager();
                        trustManager.setHost(auth.getHostName());
                        remoteCtx = Utils.createLdapsContext(ldapUrl, dn, pwd, this.getConnectTimeout(), null, trustManager);
                    } else {
                        remoteCtx = Utils.createLdapContext(ldapUrl, dn, pwd, this.getConnectTimeout(), null);
                    }
                    adsContext = new ADSContext((InitialLdapContext)remoteCtx);
                    if (!adsContext.hasAdminData()) {
                        if (this.isVerbose()) {
                            this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CREATING_ADS_ON_REMOTE.get(this.getHostDisplay(auth))));
                        }
                        adsContext.createAdminData(null);
                        TopologyCacheFilter filter = new TopologyCacheFilter();
                        filter.setSearchMonitoringInformation(false);
                        filter.setSearchBaseDNInformation(false);
                        ServerDescriptor server = ServerDescriptor.createStandalone((InitialLdapContext)remoteCtx, filter);
                        server.updateAdsPropertiesWithServerProperties();
                        adsContext.registerServer(server.getAdsProperties());
                        this.createdRemoteAds = true;
                        if (this.isVerbose()) {
                            this.notifyListeners(this.getFormattedDoneWithLineBreak());
                        }
                        this.checkAbort();
                    }
                }
                if (this.isVerbose()) {
                    this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CREATING_ADS.get()));
                }
                localCtx = this.createLocalContext();
                if (!isRemoteServer) {
                    adsContext = new ADSContext(localCtx);
                    adsContext.createAdminData(null);
                }
                assert (null != adsContext);
                TopologyCacheFilter filter = new TopologyCacheFilter();
                filter.setSearchMonitoringInformation(false);
                filter.setSearchBaseDNInformation(false);
                ServerDescriptor server = ServerDescriptor.createStandalone(localCtx, filter);
                server.updateAdsPropertiesWithServerProperties();
                if (0 == adsContext.registerOrUpdateServer(server.getAdsProperties())) {
                    if (isRemoteServer) {
                        this.registeredNewServerOnRemote = true;
                    }
                } else {
                    LOG.log(Level.WARNING, "Server was already registered. Updating server registration.");
                }
                if (isRemoteServer) {
                    ServerDescriptor.seedAdsTrustStore(localCtx, adsContext.getTrustedCertificates());
                }
                if (this.isVerbose()) {
                    this.notifyListeners(this.getFormattedDoneWithLineBreak());
                }
                this.checkAbort();
                if (!this.getUserData().mustCreateAdministrator()) break block36;
                try {
                    if (this.isVerbose()) {
                        this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CREATING_ADMINISTRATOR.get()));
                    }
                    adsContext.createAdministrator(this.getAdministratorProperties(this.getUserData()));
                    if (isRemoteServer && !this.createdRemoteAds) {
                        this.createdAdministrator = true;
                    }
                    if (this.isVerbose()) {
                        this.notifyListeners(this.getFormattedDoneWithLineBreak());
                    }
                    this.checkAbort();
                }
                catch (ADSContextException ade) {
                    if (ade.getError() == ADSContextException.ErrorType.ALREADY_REGISTERED) {
                        this.notifyListeners(this.getFormattedWarning(QuickSetupMessages.INFO_ADMINISTRATOR_ALREADY_REGISTERED.get()));
                        adsContext.unregisterServer(server.getAdsProperties());
                        adsContext.registerServer(server.getAdsProperties());
                        break block36;
                    }
                    throw ade;
                }
            }
            catch (NamingException ne) {
                Message msg = isRemoteServer ? Utils.getMessageForException(ne, this.getHostDisplay(auth)) : Utils.getMessageForException(ne);
                throw new ApplicationException(ReturnCode.CONFIGURATION_ERROR, msg, ne);
            }
            catch (ADSContextException ace) {
                throw new ApplicationException(ReturnCode.CONFIGURATION_ERROR, isRemoteServer ? QuickSetupMessages.INFO_REMOTE_ADS_EXCEPTION.get(this.getHostDisplay(auth), ace.getMessageObject()) : QuickSetupMessages.INFO_ADS_EXCEPTION.get(ace.toString()), ace);
            }
            finally {
                if (null != remoteCtx) {
                    try {
                        remoteCtx.close();
                    }
                    catch (NamingException x) {}
                }
                if (null != localCtx) {
                    try {
                        localCtx.close();
                    }
                    catch (NamingException x) {}
                }
            }
        }
    }

    protected boolean createNotReplicatedSuffix() {
        DataReplicationOptions repl = this.getUserData().getReplicationOptions();
        SuffixesToReplicateOptions suf = this.getUserData().getSuffixesToReplicateOptions();
        boolean createSuffix = repl.getType() == DataReplicationOptions.Type.FIRST_IN_TOPOLOGY || repl.getType() == DataReplicationOptions.Type.STANDALONE || suf.getType() == SuffixesToReplicateOptions.Type.NEW_SUFFIX_IN_TOPOLOGY;
        return createSuffix;
    }

    protected boolean mustConfigureReplication() {
        return this.getUserData().getReplicationOptions().getType() != DataReplicationOptions.Type.STANDALONE;
    }

    protected boolean mustCreateAds() {
        return this.getUserData().getReplicationOptions().getType() != DataReplicationOptions.Type.STANDALONE;
    }

    protected boolean mustStart() {
        return this.getUserData().getStartServer() || this.mustCreateAds();
    }

    protected boolean isStartVerbose() {
        int nEntries;
        if (this.isVerbose()) {
            return true;
        }
        boolean manyEntriesToImport = false;
        NewSuffixOptions.Type type = this.getUserData().getNewSuffixOptions().getType();
        if (type == NewSuffixOptions.Type.IMPORT_FROM_LDIF_FILE) {
            long mbTotalSize = 0L;
            LinkedList<String> ldifPaths = this.getUserData().getNewSuffixOptions().getLDIFPaths();
            for (String ldifPath : ldifPaths) {
                File f = new File(ldifPath);
                mbTotalSize += f.length();
            }
            if (mbTotalSize > 102400000L) {
                manyEntriesToImport = true;
            }
        } else if (type == NewSuffixOptions.Type.IMPORT_AUTOMATICALLY_GENERATED_DATA && (nEntries = this.getUserData().getNewSuffixOptions().getNumberEntries()) > 100000) {
            manyEntriesToImport = true;
        }
        return manyEntriesToImport;
    }

    protected boolean mustStop() {
        return !this.getUserData().getStartServer() && this.mustCreateAds();
    }

    protected boolean mustInitializeSuffixes() {
        return this.getUserData().getReplicationOptions().getType() == DataReplicationOptions.Type.IN_EXISTING_TOPOLOGY;
    }

    private LinkedHashSet<PreferredConnection> getPreferredConnections() {
        AuthenticationData auth;
        LinkedHashSet<PreferredConnection> cnx = new LinkedHashSet<PreferredConnection>();
        DataReplicationOptions repl = this.getUserData().getReplicationOptions();
        if (repl.getType() == DataReplicationOptions.Type.IN_EXISTING_TOPOLOGY && (auth = repl.getAuthenticationData()) != null) {
            PreferredConnection.Type type = auth.useSecureConnection() ? PreferredConnection.Type.LDAPS : PreferredConnection.Type.LDAP;
            cnx.add(new PreferredConnection(this.getLdapUrl(auth), type));
        }
        return cnx;
    }

    private String getLdapUrl(AuthenticationData auth) {
        String ldapUrl = auth.useSecureConnection() ? "ldaps://" + auth.getHostName() + ":" + auth.getPort() : "ldap://" + auth.getHostName() + ":" + auth.getPort();
        return ldapUrl;
    }

    private String getHostDisplay(AuthenticationData auth) {
        return auth.getHostName() + ":" + auth.getPort();
    }

    private Map<ADSContext.ServerProperty, Object> getNewServerAdsProperties(UserData userData) {
        HashMap<ADSContext.ServerProperty, Object> serverProperties = new HashMap<ADSContext.ServerProperty, Object>();
        serverProperties.put(ADSContext.ServerProperty.HOST_NAME, userData.getHostName());
        serverProperties.put(ADSContext.ServerProperty.LDAP_PORT, String.valueOf(userData.getServerPort()));
        serverProperties.put(ADSContext.ServerProperty.LDAP_ENABLED, "true");
        SecurityOptions sec = userData.getSecurityOptions();
        if (sec.getEnableSSL()) {
            serverProperties.put(ADSContext.ServerProperty.LDAPS_PORT, String.valueOf(sec.getSslPort()));
            serverProperties.put(ADSContext.ServerProperty.LDAPS_ENABLED, "true");
        } else {
            serverProperties.put(ADSContext.ServerProperty.LDAPS_PORT, "636");
            serverProperties.put(ADSContext.ServerProperty.LDAPS_ENABLED, "false");
        }
        if (sec.getEnableStartTLS()) {
            serverProperties.put(ADSContext.ServerProperty.STARTTLS_ENABLED, "true");
        } else {
            serverProperties.put(ADSContext.ServerProperty.STARTTLS_ENABLED, "false");
        }
        serverProperties.put(ADSContext.ServerProperty.JMX_PORT, "1689");
        serverProperties.put(ADSContext.ServerProperty.JMX_ENABLED, "false");
        String path = Utils.isWebStart() ? userData.getServerLocation() : Utils.getInstallPathFromClasspath();
        serverProperties.put(ADSContext.ServerProperty.INSTANCE_PATH, path);
        String serverID = serverProperties.get((Object)ADSContext.ServerProperty.HOST_NAME) + ":" + userData.getServerPort();
        serverProperties.put(ADSContext.ServerProperty.ID, serverID);
        serverProperties.put(ADSContext.ServerProperty.HOST_OS, Utils.getOSString());
        return serverProperties;
    }

    private Map<ADSContext.AdministratorProperty, Object> getAdministratorProperties(UserData userData) {
        HashMap<ADSContext.AdministratorProperty, Object> adminProperties = new HashMap<ADSContext.AdministratorProperty, Object>();
        adminProperties.put(ADSContext.AdministratorProperty.UID, userData.getGlobalAdministratorUID());
        adminProperties.put(ADSContext.AdministratorProperty.PASSWORD, userData.getGlobalAdministratorPassword());
        adminProperties.put(ADSContext.AdministratorProperty.DESCRIPTION, QuickSetupMessages.INFO_GLOBAL_ADMINISTRATOR_DESCRIPTION.get().toString());
        return adminProperties;
    }

    private void updateUserDataForServerSettingsPanel(QuickSetup qs) throws UserDataException {
        int defaultJMXPort;
        String hostName;
        ArrayList<Message> errorMsgs = new ArrayList<Message>();
        Message confirmationMsg = null;
        if (Utils.isWebStart()) {
            String serverLocation = qs.getFieldStringValue(FieldName.SERVER_LOCATION);
            if (serverLocation == null || "".equals(serverLocation.trim())) {
                errorMsgs.add(QuickSetupMessages.INFO_EMPTY_SERVER_LOCATION.get());
                qs.displayFieldInvalid(FieldName.SERVER_LOCATION, true);
            } else if (!Utils.parentDirectoryExists(serverLocation)) {
                String existingParentDirectory = null;
                File f = new File(serverLocation);
                while (existingParentDirectory == null && f != null) {
                    if ((f = f.getParentFile()) == null || !f.exists()) continue;
                    if (f.isDirectory()) {
                        existingParentDirectory = f.getAbsolutePath();
                        continue;
                    }
                    f = null;
                }
                if (existingParentDirectory == null) {
                    errorMsgs.add(QuickSetupMessages.INFO_PARENT_DIRECTORY_COULD_NOT_BE_FOUND.get(serverLocation));
                    qs.displayFieldInvalid(FieldName.SERVER_LOCATION, true);
                } else if (!Utils.canWrite(existingParentDirectory)) {
                    errorMsgs.add(QuickSetupMessages.INFO_DIRECTORY_NOT_WRITABLE.get(existingParentDirectory));
                    qs.displayFieldInvalid(FieldName.SERVER_LOCATION, true);
                } else if (!Utils.hasEnoughSpace(existingParentDirectory, this.getRequiredInstallSpace())) {
                    long requiredInMb = this.getRequiredInstallSpace() / 0x100000L;
                    errorMsgs.add(QuickSetupMessages.INFO_NOT_ENOUGH_DISK_SPACE.get(existingParentDirectory, String.valueOf(requiredInMb)));
                    qs.displayFieldInvalid(FieldName.SERVER_LOCATION, true);
                } else {
                    confirmationMsg = QuickSetupMessages.INFO_PARENT_DIRECTORY_DOES_NOT_EXIST_CONFIRMATION.get(serverLocation);
                    this.getUserData().setServerLocation(serverLocation);
                }
            } else if (Utils.fileExists(serverLocation)) {
                errorMsgs.add(QuickSetupMessages.INFO_FILE_EXISTS.get(serverLocation));
                qs.displayFieldInvalid(FieldName.SERVER_LOCATION, true);
            } else if (Utils.directoryExistsAndIsNotEmpty(serverLocation)) {
                errorMsgs.add(QuickSetupMessages.INFO_DIRECTORY_EXISTS_NOT_EMPTY.get(serverLocation));
                qs.displayFieldInvalid(FieldName.SERVER_LOCATION, true);
            } else if (!Utils.canWrite(serverLocation)) {
                errorMsgs.add(QuickSetupMessages.INFO_DIRECTORY_NOT_WRITABLE.get(serverLocation));
                qs.displayFieldInvalid(FieldName.SERVER_LOCATION, true);
            } else if (!Utils.hasEnoughSpace(serverLocation, this.getRequiredInstallSpace())) {
                long requiredInMb = this.getRequiredInstallSpace() / 0x100000L;
                errorMsgs.add(QuickSetupMessages.INFO_NOT_ENOUGH_DISK_SPACE.get(serverLocation, String.valueOf(requiredInMb)));
                qs.displayFieldInvalid(FieldName.SERVER_LOCATION, true);
            } else if (Utils.isWindows() && serverLocation.indexOf("%") != -1) {
                errorMsgs.add(QuickSetupMessages.INFO_INVALID_CHAR_IN_PATH.get("%"));
                qs.displayFieldInvalid(FieldName.SERVER_LOCATION, true);
            } else {
                this.getUserData().setServerLocation(serverLocation);
                qs.displayFieldInvalid(FieldName.SERVER_LOCATION, false);
            }
        }
        if ((hostName = qs.getFieldStringValue(FieldName.HOST_NAME)) == null || hostName.trim().length() == 0) {
            errorMsgs.add(QuickSetupMessages.INFO_EMPTY_HOST_NAME.get());
            qs.displayFieldInvalid(FieldName.HOST_NAME, true);
        } else {
            qs.displayFieldInvalid(FieldName.HOST_NAME, false);
            this.getUserData().setHostName(hostName);
        }
        String sPort = qs.getFieldStringValue(FieldName.SERVER_PORT);
        int port = -1;
        try {
            port = Integer.parseInt(sPort);
            if (port < 1 || port > 65535) {
                errorMsgs.add(QuickSetupMessages.INFO_INVALID_PORT_VALUE_RANGE.get(String.valueOf(1), String.valueOf(65535)));
                qs.displayFieldInvalid(FieldName.SERVER_PORT, true);
            } else if (!Utils.canUseAsPort(port)) {
                if (Utils.isPriviledgedPort(port)) {
                    errorMsgs.add(QuickSetupMessages.INFO_CANNOT_BIND_PRIVILEDGED_PORT.get(String.valueOf(port)));
                } else {
                    errorMsgs.add(QuickSetupMessages.INFO_CANNOT_BIND_PORT.get(String.valueOf(port)));
                }
                qs.displayFieldInvalid(FieldName.SERVER_PORT, true);
            } else {
                this.getUserData().setServerPort(port);
                qs.displayFieldInvalid(FieldName.SERVER_PORT, false);
            }
        }
        catch (NumberFormatException nfe) {
            errorMsgs.add(QuickSetupMessages.INFO_INVALID_PORT_VALUE_RANGE.get(String.valueOf(1), String.valueOf(65535)));
            qs.displayFieldInvalid(FieldName.SERVER_PORT, true);
        }
        sPort = qs.getFieldStringValue(FieldName.ADMIN_CONNECTOR_PORT);
        int adminConnectorPort = -1;
        try {
            adminConnectorPort = Integer.parseInt(sPort);
            if (adminConnectorPort < 1 || adminConnectorPort > 65535) {
                errorMsgs.add(QuickSetupMessages.INFO_INVALID_PORT_VALUE_RANGE.get(String.valueOf(1), String.valueOf(65535)));
                qs.displayFieldInvalid(FieldName.ADMIN_CONNECTOR_PORT, true);
            } else if (!Utils.canUseAsPort(adminConnectorPort)) {
                if (Utils.isPriviledgedPort(adminConnectorPort)) {
                    errorMsgs.add(QuickSetupMessages.INFO_CANNOT_BIND_PRIVILEDGED_PORT.get(String.valueOf(adminConnectorPort)));
                } else {
                    errorMsgs.add(QuickSetupMessages.INFO_CANNOT_BIND_PORT.get(String.valueOf(adminConnectorPort)));
                }
                qs.displayFieldInvalid(FieldName.ADMIN_CONNECTOR_PORT, true);
            } else if (adminConnectorPort == port) {
                errorMsgs.add(QuickSetupMessages.INFO_ADMIN_CONNECTOR_VALUE_SEVERAL_TIMES.get());
                qs.displayFieldInvalid(FieldName.SERVER_PORT, true);
                qs.displayFieldInvalid(FieldName.ADMIN_CONNECTOR_PORT, true);
            } else {
                this.getUserData().setAdminConnectorPort(adminConnectorPort);
                qs.displayFieldInvalid(FieldName.ADMIN_CONNECTOR_PORT, false);
            }
        }
        catch (NumberFormatException nfe) {
            errorMsgs.add(QuickSetupMessages.INFO_INVALID_PORT_VALUE_RANGE.get(String.valueOf(1), String.valueOf(65535)));
            qs.displayFieldInvalid(FieldName.ADMIN_CONNECTOR_PORT, true);
        }
        SecurityOptions sec = (SecurityOptions)qs.getFieldValue(FieldName.SECURITY_OPTIONS);
        int securePort = sec.getSslPort();
        if (sec.getEnableSSL()) {
            if (securePort < 1 || securePort > 65535) {
                errorMsgs.add(QuickSetupMessages.INFO_INVALID_SECURE_PORT_VALUE_RANGE.get(String.valueOf(1), String.valueOf(65535)));
                qs.displayFieldInvalid(FieldName.SECURITY_OPTIONS, true);
            } else if (!Utils.canUseAsPort(securePort)) {
                if (Utils.isPriviledgedPort(securePort)) {
                    errorMsgs.add(QuickSetupMessages.INFO_CANNOT_BIND_PRIVILEDGED_PORT.get(String.valueOf(securePort)));
                } else {
                    errorMsgs.add(QuickSetupMessages.INFO_CANNOT_BIND_PORT.get(String.valueOf(securePort)));
                }
                qs.displayFieldInvalid(FieldName.SECURITY_OPTIONS, true);
            } else if (port == securePort) {
                errorMsgs.add(QuickSetupMessages.INFO_EQUAL_PORTS.get());
                qs.displayFieldInvalid(FieldName.SECURITY_OPTIONS, true);
                qs.displayFieldInvalid(FieldName.SERVER_PORT, true);
            } else if (adminConnectorPort == securePort) {
                errorMsgs.add(QuickSetupMessages.INFO_ADMIN_CONNECTOR_VALUE_SEVERAL_TIMES.get());
                qs.displayFieldInvalid(FieldName.SECURITY_OPTIONS, true);
                qs.displayFieldInvalid(FieldName.ADMIN_CONNECTOR_PORT, true);
            } else {
                this.getUserData().setSecurityOptions(sec);
                qs.displayFieldInvalid(FieldName.SECURITY_OPTIONS, false);
            }
        } else {
            this.getUserData().setSecurityOptions(sec);
            qs.displayFieldInvalid(FieldName.SECURITY_OPTIONS, false);
        }
        String dmDn = qs.getFieldStringValue(FieldName.DIRECTORY_MANAGER_DN);
        if (dmDn == null || dmDn.trim().length() == 0) {
            errorMsgs.add(QuickSetupMessages.INFO_EMPTY_DIRECTORY_MANAGER_DN.get());
            qs.displayFieldInvalid(FieldName.DIRECTORY_MANAGER_DN, true);
        } else if (!Utils.isDn(dmDn)) {
            errorMsgs.add(QuickSetupMessages.INFO_NOT_A_DIRECTORY_MANAGER_DN.get());
            qs.displayFieldInvalid(FieldName.DIRECTORY_MANAGER_DN, true);
        } else if (Utils.isConfigurationDn(dmDn)) {
            errorMsgs.add(QuickSetupMessages.INFO_DIRECTORY_MANAGER_DN_IS_CONFIG_DN.get());
            qs.displayFieldInvalid(FieldName.DIRECTORY_MANAGER_DN, true);
        } else {
            this.getUserData().setDirectoryManagerDn(dmDn);
            qs.displayFieldInvalid(FieldName.DIRECTORY_MANAGER_DN, false);
        }
        String pwd1 = qs.getFieldStringValue(FieldName.DIRECTORY_MANAGER_PWD);
        String pwd2 = qs.getFieldStringValue(FieldName.DIRECTORY_MANAGER_PWD_CONFIRM);
        if (pwd1 == null) {
            pwd1 = "";
        }
        boolean pwdValid = true;
        if (!pwd1.equals(pwd2)) {
            errorMsgs.add(QuickSetupMessages.INFO_NOT_EQUAL_PWD.get());
            qs.displayFieldInvalid(FieldName.DIRECTORY_MANAGER_PWD_CONFIRM, true);
            pwdValid = false;
        }
        if (pwd1.length() < 1) {
            errorMsgs.add(QuickSetupMessages.INFO_PWD_TOO_SHORT.get(String.valueOf(1)));
            qs.displayFieldInvalid(FieldName.DIRECTORY_MANAGER_PWD, true);
            if (pwd2 == null || pwd2.length() < 1) {
                qs.displayFieldInvalid(FieldName.DIRECTORY_MANAGER_PWD_CONFIRM, true);
            }
            pwdValid = false;
        }
        if (pwdValid) {
            this.getUserData().setDirectoryManagerPwd(pwd1);
            qs.displayFieldInvalid(FieldName.DIRECTORY_MANAGER_PWD, false);
            qs.displayFieldInvalid(FieldName.DIRECTORY_MANAGER_PWD_CONFIRM, false);
        }
        if ((defaultJMXPort = UserData.getDefaultJMXPort(new int[]{port, securePort})) != -1) {
            this.getUserData().setServerJMXPort(-1);
        }
        if (errorMsgs.size() > 0) {
            throw new UserDataException(Step.SERVER_SETTINGS, Utils.getMessageFromCollection(errorMsgs, "\n"));
        }
        if (confirmationMsg != null) {
            throw new UserDataConfirmationException(Step.SERVER_SETTINGS, confirmationMsg);
        }
    }

    private void updateUserDataForReplicationOptionsPanel(QuickSetup qs) throws UserDataException {
        boolean hasGlobalAdministrators = false;
        Integer replicationPort = -1;
        boolean secureReplication = false;
        String host = null;
        Integer port = null;
        String dn = null;
        String pwd = null;
        ArrayList<Message> errorMsgs = new ArrayList<Message>();
        DataReplicationOptions.Type type = (DataReplicationOptions.Type)((Object)qs.getFieldValue(FieldName.REPLICATION_OPTIONS));
        host = qs.getFieldStringValue(FieldName.REMOTE_SERVER_HOST);
        dn = qs.getFieldStringValue(FieldName.REMOTE_SERVER_DN);
        pwd = qs.getFieldStringValue(FieldName.REMOTE_SERVER_PWD);
        if (type != DataReplicationOptions.Type.STANDALONE) {
            replicationPort = this.checkReplicationPort(qs, errorMsgs);
            secureReplication = (Boolean)qs.getFieldValue(FieldName.REPLICATION_SECURE);
        }
        UserDataConfirmationException confirmEx = null;
        switch (type) {
            case IN_EXISTING_TOPOLOGY: {
                String sPort = qs.getFieldStringValue(FieldName.REMOTE_SERVER_PORT);
                this.checkRemoteHostPortDnAndPwd(host, sPort, dn, pwd, qs, errorMsgs);
                if (errorMsgs.size() != 0) break;
                port = Integer.parseInt(sPort);
                boolean[] globalAdmin = new boolean[]{hasGlobalAdministrators};
                String[] effectiveDn = new String[]{dn};
                try {
                    this.updateUserDataWithADS(host, port, dn, pwd, qs, errorMsgs, globalAdmin, effectiveDn);
                }
                catch (UserDataConfirmationException e) {
                    confirmEx = e;
                }
                hasGlobalAdministrators = globalAdmin[0];
                dn = effectiveDn[0];
                break;
            }
            case STANDALONE: {
                this.getUserData().setSuffixesToReplicateOptions(new SuffixesToReplicateOptions(SuffixesToReplicateOptions.Type.NO_SUFFIX_TO_REPLICATE, new HashSet(), new HashSet()));
                break;
            }
            case FIRST_IN_TOPOLOGY: {
                this.getUserData().setSuffixesToReplicateOptions(new SuffixesToReplicateOptions(SuffixesToReplicateOptions.Type.NEW_SUFFIX_IN_TOPOLOGY, new HashSet(), new HashSet()));
                break;
            }
            default: {
                throw new IllegalStateException("Do not know what to do with type: " + (Object)((Object)type));
            }
        }
        if (errorMsgs.size() == 0) {
            DataReplicationOptions repl;
            AuthenticationData auth = new AuthenticationData();
            auth.setHostName(host);
            if (port != null) {
                auth.setPort(port);
            }
            auth.setDn(dn);
            auth.setPwd(pwd);
            auth.setUseSecureConnection(true);
            switch (type) {
                case IN_EXISTING_TOPOLOGY: {
                    repl = DataReplicationOptions.createInExistingTopology(auth, replicationPort, secureReplication);
                    break;
                }
                case STANDALONE: {
                    repl = DataReplicationOptions.createStandalone();
                    break;
                }
                case FIRST_IN_TOPOLOGY: {
                    repl = DataReplicationOptions.createFirstInTopology(replicationPort, secureReplication);
                    break;
                }
                default: {
                    throw new IllegalStateException("Do not know what to do with type: " + (Object)((Object)type));
                }
            }
            this.getUserData().setReplicationOptions(repl);
            this.getUserData().createAdministrator(!hasGlobalAdministrators && type == DataReplicationOptions.Type.IN_EXISTING_TOPOLOGY);
        }
        if (errorMsgs.size() > 0) {
            throw new UserDataException(Step.REPLICATION_OPTIONS, Utils.getMessageFromCollection(errorMsgs, "\n"));
        }
        if (confirmEx != null) {
            throw confirmEx;
        }
    }

    private int checkReplicationPort(QuickSetup qs, ArrayList<Message> errorMsgs) {
        int replicationPort = -1;
        String sPort = qs.getFieldStringValue(FieldName.REPLICATION_PORT);
        try {
            replicationPort = Integer.parseInt(sPort);
            if (replicationPort < 1 || replicationPort > 65535) {
                errorMsgs.add(QuickSetupMessages.INFO_INVALID_REPLICATION_PORT_VALUE_RANGE.get(String.valueOf(1), String.valueOf(65535)));
                qs.displayFieldInvalid(FieldName.SERVER_PORT, true);
            } else if (!Utils.canUseAsPort(replicationPort)) {
                if (Utils.isPriviledgedPort(replicationPort)) {
                    errorMsgs.add(QuickSetupMessages.INFO_CANNOT_BIND_PRIVILEDGED_PORT.get(String.valueOf(replicationPort)));
                } else {
                    errorMsgs.add(QuickSetupMessages.INFO_CANNOT_BIND_PORT.get(String.valueOf(replicationPort)));
                }
                qs.displayFieldInvalid(FieldName.REPLICATION_PORT, true);
            } else {
                SecurityOptions sec = this.getUserData().getSecurityOptions();
                if (replicationPort == this.getUserData().getServerPort() || replicationPort == this.getUserData().getServerJMXPort() || replicationPort == sec.getSslPort() && sec.getEnableSSL()) {
                    errorMsgs.add(QuickSetupMessages.INFO_REPLICATION_PORT_ALREADY_CHOSEN_FOR_OTHER_PROTOCOL.get());
                    qs.displayFieldInvalid(FieldName.REPLICATION_PORT, true);
                } else {
                    qs.displayFieldInvalid(FieldName.REPLICATION_PORT, false);
                }
            }
        }
        catch (NumberFormatException nfe) {
            errorMsgs.add(QuickSetupMessages.INFO_INVALID_REPLICATION_PORT_VALUE_RANGE.get(String.valueOf(1), String.valueOf(65535)));
            qs.displayFieldInvalid(FieldName.REPLICATION_PORT, true);
        }
        return replicationPort;
    }

    private void checkRemoteHostPortDnAndPwd(String host, String sPort, String dn, String pwd, QuickSetup qs, ArrayList<Message> errorMsgs) {
        if (host == null || host.length() == 0) {
            errorMsgs.add(QuickSetupMessages.INFO_EMPTY_REMOTE_HOST.get());
            qs.displayFieldInvalid(FieldName.REMOTE_SERVER_HOST, true);
        } else {
            qs.displayFieldInvalid(FieldName.REMOTE_SERVER_HOST, false);
        }
        try {
            Integer.parseInt(sPort);
            qs.displayFieldInvalid(FieldName.REMOTE_SERVER_PORT, false);
        }
        catch (Throwable t) {
            errorMsgs.add(QuickSetupMessages.INFO_INVALID_REMOTE_PORT.get());
            qs.displayFieldInvalid(FieldName.REMOTE_SERVER_PORT, true);
        }
        if (dn == null || dn.length() == 0) {
            errorMsgs.add(QuickSetupMessages.INFO_EMPTY_REMOTE_DN.get());
            qs.displayFieldInvalid(FieldName.REMOTE_SERVER_DN, true);
        } else {
            qs.displayFieldInvalid(FieldName.REMOTE_SERVER_DN, false);
        }
        if (pwd == null || pwd.length() == 0) {
            errorMsgs.add(QuickSetupMessages.INFO_EMPTY_REMOTE_PWD.get());
            qs.displayFieldInvalid(FieldName.REMOTE_SERVER_PWD, true);
        } else {
            qs.displayFieldInvalid(FieldName.REMOTE_SERVER_PWD, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUserDataWithADS(String host, int port, String dn, String pwd, QuickSetup qs, ArrayList<Message> errorMsgs, boolean[] hasGlobalAdministrators, String[] effectiveDn) throws UserDataException {
        block31: {
            host = Utils.getHostNameForLdapUrl(host);
            String ldapUrl = "ldaps://" + host + ":" + port;
            InitialContext ctx = null;
            ApplicationTrustManager trustManager = this.getTrustManager();
            trustManager.setHost(host);
            trustManager.resetLastRefusedItems();
            try {
                effectiveDn[0] = dn;
                try {
                    ctx = Utils.createLdapsContext(ldapUrl, dn, pwd, this.getConnectTimeout(), null, trustManager);
                }
                catch (Throwable t) {
                    if (!Utils.isCertificateException(t)) {
                        effectiveDn[0] = dn = ADSContext.getAdministratorDN(dn);
                        ctx = Utils.createLdapsContext(ldapUrl, dn, pwd, this.getConnectTimeout(), null, trustManager);
                    }
                    throw t;
                }
                ADSContext adsContext = new ADSContext((InitialLdapContext)ctx);
                if (adsContext.hasAdminData()) {
                    Set<Map<ADSContext.AdministratorProperty, Object>> administrators = adsContext.readAdministratorRegistry();
                    hasGlobalAdministrators[0] = administrators.size() > 0;
                    Set<TopologyCacheException> exceptions = this.updateUserDataWithSuffixesInADS(adsContext, trustManager);
                    LinkedHashSet<Message> exceptionMsgs = new LinkedHashSet<Message>();
                    for (TopologyCacheException e : exceptions) {
                        switch (e.getType()) {
                            case NOT_GLOBAL_ADMINISTRATOR: {
                                Message errorMsg = QuickSetupMessages.INFO_NOT_GLOBAL_ADMINISTRATOR_PROVIDED.get();
                                throw new UserDataException(Step.REPLICATION_OPTIONS, errorMsg);
                            }
                            case GENERIC_CREATING_CONNECTION: {
                                int p;
                                String h;
                                if (e.getCause() == null || !Utils.isCertificateException(e.getCause())) break;
                                ApplicationTrustManager.Cause cause = null;
                                if (e.getTrustManager() != null) {
                                    cause = e.getTrustManager().getLastRefusedCause();
                                }
                                LOG.log(Level.INFO, "Certificate exception cause: " + (Object)((Object)cause));
                                UserDataCertificateException.Type excType = cause == ApplicationTrustManager.Cause.NOT_TRUSTED ? UserDataCertificateException.Type.NOT_TRUSTED : (cause == ApplicationTrustManager.Cause.HOST_NAME_MISMATCH ? UserDataCertificateException.Type.HOST_NAME_MISMATCH : null);
                                if (excType == null) break;
                                try {
                                    URI uri = new URI(e.getLdapUrl());
                                    h = uri.getHost();
                                    p = uri.getPort();
                                }
                                catch (Throwable t) {
                                    LOG.log(Level.WARNING, "Error parsing ldap url of TopologyCacheException.", t);
                                    h = QuickSetupMessages.INFO_NOT_AVAILABLE_LABEL.get().toString();
                                    p = -1;
                                }
                                throw new UserDataCertificateException(Step.REPLICATION_OPTIONS, QuickSetupMessages.INFO_CERTIFICATE_EXCEPTION.get(h, String.valueOf(p)), e.getCause(), h, p, e.getTrustManager().getLastRefusedChain(), e.getTrustManager().getLastRefusedAuthType(), excType);
                            }
                        }
                        exceptionMsgs.add(this.getMessage(e));
                    }
                    if (exceptionMsgs.size() > 0) {
                        Message confirmationMsg = QuickSetupMessages.INFO_ERROR_READING_REGISTERED_SERVERS_CONFIRM.get(Utils.getMessageFromCollection(exceptionMsgs, "\n"));
                        throw new UserDataConfirmationException(Step.REPLICATION_OPTIONS, confirmationMsg);
                    }
                    break block31;
                }
                this.updateUserDataWithSuffixesInServer((InitialLdapContext)ctx);
            }
            catch (UserDataException ude) {
                throw ude;
            }
            catch (Throwable t) {
                LOG.log(Level.INFO, "Error connecting to remote server.", t);
                if (Utils.isCertificateException(t)) {
                    ApplicationTrustManager.Cause cause = trustManager.getLastRefusedCause();
                    LOG.log(Level.INFO, "Certificate exception cause: " + (Object)((Object)cause));
                    UserDataCertificateException.Type excType = cause == ApplicationTrustManager.Cause.NOT_TRUSTED ? UserDataCertificateException.Type.NOT_TRUSTED : (cause == ApplicationTrustManager.Cause.HOST_NAME_MISMATCH ? UserDataCertificateException.Type.HOST_NAME_MISMATCH : null);
                    if (excType != null) {
                        throw new UserDataCertificateException(Step.REPLICATION_OPTIONS, QuickSetupMessages.INFO_CERTIFICATE_EXCEPTION.get(host, String.valueOf(port)), t, host, port, trustManager.getLastRefusedChain(), trustManager.getLastRefusedAuthType(), excType);
                    }
                    qs.displayFieldInvalid(FieldName.REMOTE_SERVER_HOST, true);
                    qs.displayFieldInvalid(FieldName.REMOTE_SERVER_PORT, true);
                    qs.displayFieldInvalid(FieldName.REMOTE_SERVER_DN, true);
                    qs.displayFieldInvalid(FieldName.REMOTE_SERVER_PWD, true);
                    errorMsgs.add(QuickSetupMessages.INFO_CANNOT_CONNECT_TO_REMOTE_GENERIC.get(host + ":" + port, t.toString()));
                    break block31;
                }
                if (t instanceof NamingException) {
                    errorMsgs.add(Utils.getMessageForException((NamingException)t, host + ":" + port));
                    qs.displayFieldInvalid(FieldName.REMOTE_SERVER_DN, true);
                    qs.displayFieldInvalid(FieldName.REMOTE_SERVER_PWD, true);
                    if (!(t instanceof NamingSecurityException)) {
                        qs.displayFieldInvalid(FieldName.REMOTE_SERVER_HOST, true);
                        qs.displayFieldInvalid(FieldName.REMOTE_SERVER_PORT, true);
                    }
                    break block31;
                }
                if (t instanceof ADSContextException) {
                    errorMsgs.add(QuickSetupMessages.INFO_REMOTE_ADS_EXCEPTION.get(host + ":" + port, t.toString()));
                    break block31;
                }
                throw new UserDataException(Step.REPLICATION_OPTIONS, Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), t));
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
    }

    private void updateUserDataForCreateAdministratorPanel(QuickSetup qs) throws UserDataException {
        ArrayList<Message> errorMsgs = new ArrayList<Message>();
        String uid = qs.getFieldStringValue(FieldName.GLOBAL_ADMINISTRATOR_UID);
        if (uid == null || uid.trim().length() == 0) {
            errorMsgs.add(QuickSetupMessages.INFO_EMPTY_ADMINISTRATOR_UID.get());
            qs.displayFieldInvalid(FieldName.GLOBAL_ADMINISTRATOR_UID, true);
        } else {
            this.getUserData().setGlobalAdministratorUID(uid);
            qs.displayFieldInvalid(FieldName.GLOBAL_ADMINISTRATOR_UID, false);
        }
        String pwd1 = qs.getFieldStringValue(FieldName.GLOBAL_ADMINISTRATOR_PWD);
        String pwd2 = qs.getFieldStringValue(FieldName.GLOBAL_ADMINISTRATOR_PWD_CONFIRM);
        if (pwd1 == null) {
            pwd1 = "";
        }
        boolean pwdValid = true;
        if (!pwd1.equals(pwd2)) {
            errorMsgs.add(QuickSetupMessages.INFO_NOT_EQUAL_PWD.get());
            qs.displayFieldInvalid(FieldName.GLOBAL_ADMINISTRATOR_PWD_CONFIRM, true);
            pwdValid = false;
        }
        if (pwd1.length() < 1) {
            errorMsgs.add(QuickSetupMessages.INFO_PWD_TOO_SHORT.get(String.valueOf(1)));
            qs.displayFieldInvalid(FieldName.GLOBAL_ADMINISTRATOR_PWD, true);
            if (pwd2 == null || pwd2.length() < 1) {
                qs.displayFieldInvalid(FieldName.GLOBAL_ADMINISTRATOR_PWD_CONFIRM, true);
            }
            pwdValid = false;
        }
        if (pwdValid) {
            this.getUserData().setGlobalAdministratorPassword(pwd1);
            qs.displayFieldInvalid(FieldName.GLOBAL_ADMINISTRATOR_PWD, false);
            qs.displayFieldInvalid(FieldName.GLOBAL_ADMINISTRATOR_PWD_CONFIRM, false);
        }
        if (errorMsgs.size() > 0) {
            throw new UserDataException(Step.CREATE_GLOBAL_ADMINISTRATOR, Utils.getMessageFromCollection(errorMsgs, "\n"));
        }
    }

    private void updateUserDataForSuffixesOptionsPanel(QuickSetup qs) throws UserDataException {
        ArrayList<Message> errorMsgs = new ArrayList<Message>();
        if (qs.getFieldValue(FieldName.SUFFIXES_TO_REPLICATE_OPTIONS) == SuffixesToReplicateOptions.Type.REPLICATE_WITH_EXISTING_SUFFIXES) {
            Set s = (Set)qs.getFieldValue(FieldName.SUFFIXES_TO_REPLICATE);
            if (s.size() == 0) {
                errorMsgs.add(QuickSetupMessages.INFO_NO_SUFFIXES_CHOSEN_TO_REPLICATE.get());
                qs.displayFieldInvalid(FieldName.SUFFIXES_TO_REPLICATE, true);
            } else {
                HashSet<SuffixDescriptor> chosen = new HashSet<SuffixDescriptor>();
                for (Object o : s) {
                    chosen.add((SuffixDescriptor)o);
                }
                qs.displayFieldInvalid(FieldName.SUFFIXES_TO_REPLICATE, false);
                Set<SuffixDescriptor> available = this.getUserData().getSuffixesToReplicateOptions().getAvailableSuffixes();
                SuffixesToReplicateOptions options = new SuffixesToReplicateOptions(SuffixesToReplicateOptions.Type.REPLICATE_WITH_EXISTING_SUFFIXES, available, chosen);
                this.getUserData().setSuffixesToReplicateOptions(options);
            }
            this.getUserData().setRemoteWithNoReplicationPort(this.getRemoteWithNoReplicationPort(this.getUserData()));
        } else {
            Set<SuffixDescriptor> available = this.getUserData().getSuffixesToReplicateOptions().getAvailableSuffixes();
            Set<SuffixDescriptor> chosen = this.getUserData().getSuffixesToReplicateOptions().getSuffixes();
            SuffixesToReplicateOptions options = new SuffixesToReplicateOptions(SuffixesToReplicateOptions.Type.NEW_SUFFIX_IN_TOPOLOGY, available, chosen);
            this.getUserData().setSuffixesToReplicateOptions(options);
        }
        if (errorMsgs.size() > 0) {
            throw new UserDataException(Step.SUFFIXES_OPTIONS, Utils.getMessageFromCollection(errorMsgs, "\n"));
        }
    }

    private void updateUserDataForRemoteReplicationPorts(QuickSetup qs) throws UserDataException {
        ArrayList<Message> errorMsgs = new ArrayList<Message>();
        Map<ServerDescriptor, AuthenticationData> servers = this.getUserData().getRemoteWithNoReplicationPort();
        Map hm = (Map)qs.getFieldValue(FieldName.REMOTE_REPLICATION_PORT);
        Map hmSecure = (Map)qs.getFieldValue(FieldName.REMOTE_REPLICATION_SECURE);
        for (ServerDescriptor server : servers.keySet()) {
            String hostName = server.getHostName();
            int replicationPort = -1;
            boolean secureReplication = (Boolean)hmSecure.get(server.getId());
            String sPort = (String)hm.get(server.getId());
            try {
                replicationPort = Integer.parseInt(sPort);
                if (replicationPort < 1 || replicationPort > 65535) {
                    errorMsgs.add(QuickSetupMessages.INFO_INVALID_REMOTE_REPLICATION_PORT_VALUE_RANGE.get(this.getHostPort(server), String.valueOf(1), String.valueOf(65535)));
                }
                if (hostName.equalsIgnoreCase(this.getUserData().getHostName())) {
                    int securePort = -1;
                    if (this.getUserData().getSecurityOptions().getEnableSSL()) {
                        securePort = this.getUserData().getSecurityOptions().getSslPort();
                    }
                    if (replicationPort == this.getUserData().getServerPort() || replicationPort == this.getUserData().getServerJMXPort() || replicationPort == this.getUserData().getReplicationOptions().getReplicationPort() || replicationPort == securePort) {
                        errorMsgs.add(QuickSetupMessages.INFO_REMOTE_REPLICATION_PORT_ALREADY_CHOSEN_FOR_OTHER_PROTOCOL.get(this.getHostPort(server)));
                    }
                }
                AuthenticationData authData = new AuthenticationData();
                authData.setPort(replicationPort);
                authData.setUseSecureConnection(secureReplication);
                servers.put(server, authData);
            }
            catch (NumberFormatException nfe) {
                errorMsgs.add(QuickSetupMessages.INFO_INVALID_REMOTE_REPLICATION_PORT_VALUE_RANGE.get(hostName, String.valueOf(1), String.valueOf(65535)));
            }
        }
        if (errorMsgs.size() > 0) {
            qs.displayFieldInvalid(FieldName.REMOTE_REPLICATION_PORT, true);
            throw new UserDataException(Step.REMOTE_REPLICATION_PORTS, Utils.getMessageFromCollection(errorMsgs, "\n"));
        }
        qs.displayFieldInvalid(FieldName.REMOTE_REPLICATION_PORT, false);
        this.getUserData().setRemoteWithNoReplicationPort(servers);
    }

    private void updateUserDataForNewSuffixOptionsPanel(QuickSetup qs) throws UserDataException {
        ArrayList<Message> errorMsgs = new ArrayList<Message>();
        NewSuffixOptions dataOptions = null;
        boolean validBaseDn = false;
        String baseDn = qs.getFieldStringValue(FieldName.DIRECTORY_BASE_DN);
        if (baseDn == null || baseDn.trim().length() == 0) {
            baseDn = "";
        } else if (!Utils.isDn(baseDn)) {
            errorMsgs.add(QuickSetupMessages.INFO_NOT_A_BASE_DN.get());
            qs.displayFieldInvalid(FieldName.DIRECTORY_BASE_DN, true);
        } else if (Utils.isConfigurationDn(baseDn)) {
            errorMsgs.add(QuickSetupMessages.INFO_BASE_DN_IS_CONFIGURATION_DN.get());
            qs.displayFieldInvalid(FieldName.DIRECTORY_BASE_DN, true);
        } else {
            qs.displayFieldInvalid(FieldName.DIRECTORY_BASE_DN, false);
            validBaseDn = true;
        }
        if (baseDn.equals("")) {
            LinkedList<String> baseDns = new LinkedList<String>();
            dataOptions = NewSuffixOptions.createEmpty(baseDns);
        } else {
            NewSuffixOptions.Type type = (NewSuffixOptions.Type)((Object)qs.getFieldValue(FieldName.DATA_OPTIONS));
            switch (type) {
                case IMPORT_FROM_LDIF_FILE: {
                    String ldifPath = qs.getFieldStringValue(FieldName.LDIF_PATH);
                    if (ldifPath == null || ldifPath.trim().equals("")) {
                        errorMsgs.add(QuickSetupMessages.INFO_NO_LDIF_PATH.get());
                        qs.displayFieldInvalid(FieldName.LDIF_PATH, true);
                        break;
                    }
                    if (!Utils.fileExists(ldifPath)) {
                        errorMsgs.add(QuickSetupMessages.INFO_LDIF_FILE_DOES_NOT_EXIST.get());
                        qs.displayFieldInvalid(FieldName.LDIF_PATH, true);
                        break;
                    }
                    if (!validBaseDn) break;
                    LinkedList<String> baseDns = new LinkedList<String>();
                    baseDns.add(baseDn);
                    LinkedList<String> ldifPaths = new LinkedList<String>();
                    ldifPaths.add(ldifPath);
                    dataOptions = NewSuffixOptions.createImportFromLDIF(baseDns, ldifPaths, null, null);
                    qs.displayFieldInvalid(FieldName.LDIF_PATH, false);
                    break;
                }
                case IMPORT_AUTOMATICALLY_GENERATED_DATA: {
                    int startErrors = errorMsgs.size();
                    String nEntries = qs.getFieldStringValue(FieldName.NUMBER_ENTRIES);
                    if (nEntries == null || nEntries.trim().equals("")) {
                        errorMsgs.add(QuickSetupMessages.INFO_NO_NUMBER_ENTRIES.get());
                        qs.displayFieldInvalid(FieldName.NUMBER_ENTRIES, true);
                    } else {
                        boolean nEntriesValid = false;
                        try {
                            int n = Integer.parseInt(nEntries);
                            nEntriesValid = n >= 1 && n <= 10000000;
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                        if (!nEntriesValid) {
                            errorMsgs.add(QuickSetupMessages.INFO_INVALID_NUMBER_ENTRIES_RANGE.get(String.valueOf(1), String.valueOf(10000000)));
                            qs.displayFieldInvalid(FieldName.NUMBER_ENTRIES, true);
                        } else {
                            qs.displayFieldInvalid(FieldName.NUMBER_ENTRIES, false);
                        }
                    }
                    if (startErrors != errorMsgs.size() || !validBaseDn) break;
                    LinkedList<String> baseDns = new LinkedList<String>();
                    baseDns.add(baseDn);
                    dataOptions = NewSuffixOptions.createAutomaticallyGenerated(baseDns, Integer.parseInt(nEntries));
                    break;
                }
                default: {
                    qs.displayFieldInvalid(FieldName.LDIF_PATH, false);
                    qs.displayFieldInvalid(FieldName.NUMBER_ENTRIES, false);
                    if (!validBaseDn) break;
                    LinkedList<String> baseDns = new LinkedList<String>();
                    baseDns.add(baseDn);
                    dataOptions = type == NewSuffixOptions.Type.CREATE_BASE_ENTRY ? NewSuffixOptions.createBaseEntry(baseDns) : NewSuffixOptions.createEmpty(baseDns);
                }
            }
        }
        if (dataOptions != null) {
            this.getUserData().setNewSuffixOptions(dataOptions);
        }
        if (errorMsgs.size() > 0) {
            throw new UserDataException(Step.NEW_SUFFIX_OPTIONS, Utils.getMessageFromCollection(errorMsgs, "\n"));
        }
    }

    private void updateUserDataForRuntimeOptionsPanel(QuickSetup qs) {
        this.getUserData().setJavaArguments(UserData.SERVER_SCRIPT_NAME, (JavaArguments)qs.getFieldValue(FieldName.SERVER_JAVA_ARGUMENTS));
        this.getUserData().setJavaArguments(UserData.IMPORT_SCRIPT_NAME, (JavaArguments)qs.getFieldValue(FieldName.IMPORT_JAVA_ARGUMENTS));
    }

    private void updateUserDataForReviewPanel(QuickSetup qs) {
        Boolean b = (Boolean)qs.getFieldValue(FieldName.SERVER_START_INSTALLER);
        this.getUserData().setStartServer(b);
        b = (Boolean)qs.getFieldValue(FieldName.ENABLE_WINDOWS_SERVICE);
        this.getUserData().setEnableWindowsService(b);
    }

    private long getRequiredInstallSpace() {
        return 0x1400000L;
    }

    private Set<TopologyCacheException> updateUserDataWithSuffixesInADS(ADSContext adsContext, ApplicationTrustManager trustManager) throws TopologyCacheException {
        HashSet<TopologyCacheException> exceptions = new HashSet<TopologyCacheException>();
        SuffixesToReplicateOptions suf = this.getUserData().getSuffixesToReplicateOptions();
        SuffixesToReplicateOptions.Type type = suf == null || suf.getType() == SuffixesToReplicateOptions.Type.NO_SUFFIX_TO_REPLICATE ? SuffixesToReplicateOptions.Type.NO_SUFFIX_TO_REPLICATE : SuffixesToReplicateOptions.Type.NEW_SUFFIX_IN_TOPOLOGY;
        this.lastLoadedCache = new TopologyCache(adsContext, trustManager, this.getConnectTimeout());
        LinkedHashSet<PreferredConnection> cnx = new LinkedHashSet<PreferredConnection>();
        cnx.add(PreferredConnection.getPreferredConnection(adsContext.getDirContext()));
        this.lastLoadedCache.setPreferredConnections(cnx);
        this.lastLoadedCache.reloadTopology();
        Set<SuffixDescriptor> suffixes = this.lastLoadedCache.getSuffixes();
        this.getUserData().setSuffixesToReplicateOptions(new SuffixesToReplicateOptions(type, suffixes, suf.getSuffixes()));
        Set<ServerDescriptor> servers = this.lastLoadedCache.getServers();
        for (ServerDescriptor server : servers) {
            TopologyCacheException e = server.getLastException();
            if (e == null) continue;
            exceptions.add(e);
        }
        return exceptions;
    }

    private void updateUserDataWithSuffixesInServer(InitialLdapContext ctx) throws NamingException {
        SuffixesToReplicateOptions suf = this.getUserData().getSuffixesToReplicateOptions();
        HashSet<SuffixDescriptor> suffixes = new HashSet<SuffixDescriptor>();
        SuffixesToReplicateOptions.Type type = suf == null ? SuffixesToReplicateOptions.Type.NEW_SUFFIX_IN_TOPOLOGY : suf.getType();
        ServerDescriptor s = ServerDescriptor.createStandalone(ctx, new TopologyCacheFilter());
        Set<ReplicaDescriptor> replicas = s.getReplicas();
        for (ReplicaDescriptor replica : replicas) {
            suffixes.add(replica.getSuffix());
        }
        this.getUserData().setSuffixesToReplicateOptions(new SuffixesToReplicateOptions(type, suffixes, suf.getSuffixes()));
    }

    protected String getSelfSignedKeystorePath() {
        String parentFile = Utils.getPath(this.getInstancePath(), "config");
        return Utils.getPath(parentFile, "keystore");
    }

    private String getTrustManagerPath() {
        String parentFile = Utils.getPath(this.getInstancePath(), "config");
        return Utils.getPath(parentFile, "truststore");
    }

    private String getTemporaryCertificatePath() {
        String parentFile = Utils.getPath(this.getInstancePath(), "config");
        return Utils.getPath(parentFile, "server-cert.txt");
    }

    private String getKeystorePinPath() {
        String parentFile = Utils.getPath(this.getInstancePath(), "config");
        return Utils.getPath(parentFile, "keystore.pin");
    }

    private int getSelfSignedCertificateValidity() {
        return 730;
    }

    private String getSelfSignedCertificateSubjectDN() {
        return "cn=" + Rdn.escapeValue(this.getUserData().getHostName()) + ",O=OpenDS Self-Signed Certificate";
    }

    protected String getSelfSignedCertificatePwd() {
        if (this.selfSignedCertPw == null) {
            this.selfSignedCertPw = SetupUtils.createSelfSignedCertificatePwd();
        }
        return new String(this.selfSignedCertPw);
    }

    private Map<ServerDescriptor, AuthenticationData> getRemoteWithNoReplicationPort(UserData userData) {
        HashMap<ServerDescriptor, AuthenticationData> servers = new HashMap<ServerDescriptor, AuthenticationData>();
        Set<SuffixDescriptor> suffixes = userData.getSuffixesToReplicateOptions().getSuffixes();
        for (SuffixDescriptor suffix : suffixes) {
            for (ReplicaDescriptor replica : suffix.getReplicas()) {
                ServerDescriptor server = replica.getServer();
                Object v = server.getServerProperties().get((Object)ServerDescriptor.ServerProperty.IS_REPLICATION_SERVER);
                if (Boolean.TRUE.equals(v)) continue;
                AuthenticationData authData = new AuthenticationData();
                authData.setPort(8989);
                authData.setUseSecureConnection(false);
                servers.put(server, authData);
            }
        }
        return servers;
    }

    private InitialLdapContext createLocalContext() throws NamingException {
        String ldapUrl = "ldaps://" + Utils.getHostNameForLdapUrl(this.getUserData().getHostName()) + ":" + this.getUserData().getAdminConnectorPort();
        String dn = this.getUserData().getDirectoryManagerDn();
        String pwd = this.getUserData().getDirectoryManagerPwd();
        return Utils.createLdapsContext(ldapUrl, dn, pwd, this.getConnectTimeout(), null, null);
    }

    private InitialLdapContext getRemoteConnection(ServerDescriptor server, ApplicationTrustManager trustManager, LinkedHashSet<PreferredConnection> cnx) throws ApplicationException {
        AuthenticationData auth = this.getUserData().getReplicationOptions().getAuthenticationData();
        if (!server.isRegistered()) {
            HashMap<ADSContext.ServerProperty, Object> adsProperties = new HashMap<ADSContext.ServerProperty, Object>();
            adsProperties.put(ADSContext.ServerProperty.HOST_NAME, server.getHostName());
            if (auth.useSecureConnection()) {
                adsProperties.put(ADSContext.ServerProperty.LDAPS_PORT, String.valueOf(auth.getPort()));
                adsProperties.put(ADSContext.ServerProperty.LDAPS_ENABLED, "true");
            } else {
                adsProperties.put(ADSContext.ServerProperty.LDAP_PORT, String.valueOf(auth.getPort()));
                adsProperties.put(ADSContext.ServerProperty.LDAP_ENABLED, "true");
            }
            server.setAdsProperties(adsProperties);
        }
        return this.getRemoteConnection(server, auth.getDn(), auth.getPwd(), trustManager, this.getConnectTimeout(), cnx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeSuffix(InitialLdapContext ctx, int replicaId, String suffixDn, boolean displayProgress, String sourceServerDisplay) throws ApplicationException, PeerNotFoundException {
        boolean taskCreated = false;
        int i = 1;
        boolean isOver = false;
        String dn = null;
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add("ds-task");
        oc.add("ds-task-initialize-from-remote-replica");
        attrs.put(oc);
        attrs.put("ds-task-class-name", "org.opends.server.tasks.InitializeTask");
        attrs.put("ds-task-initialize-domain-dn", suffixDn);
        attrs.put("ds-task-initialize-replica-server-id", String.valueOf(replicaId));
        while (!taskCreated) {
            this.checkAbort();
            String id = "quicksetup-initialize" + i;
            dn = "ds-task-id=" + id + ",cn=Scheduled Tasks,cn=Tasks";
            attrs.put("ds-task-id", id);
            try {
                DirContext dirCtx = ctx.createSubcontext(dn, (Attributes)attrs);
                taskCreated = true;
                LOG.log(Level.INFO, "created task entry: " + attrs);
                dirCtx.close();
            }
            catch (NameAlreadyBoundException x) {
                LOG.log(Level.WARNING, "A task with dn: " + dn + " already existed.");
            }
            catch (NamingException ne) {
                LOG.log(Level.SEVERE, "Error creating task " + attrs, ne);
                throw new ApplicationException(ReturnCode.APPLICATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_LAUNCHING_INITIALIZATION.get(sourceServerDisplay), ne), ne);
            }
            ++i;
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(0);
        String filter = "objectclass=*";
        searchControls.setReturningAttributes(new String[]{"ds-task-unprocessed-entry-count", "ds-task-processed-entry-count", "ds-task-log-message", "ds-task-state"});
        Message lastDisplayedMsg = null;
        String lastLogMsg = null;
        long lastTimeMsgDisplayed = -1L;
        long lastTimeMsgLogged = -1L;
        int totalEntries = 0;
        while (!isOver) {
            if (this.canceled) {
                this.checkAbort();
            }
            try {
                Thread.sleep(500L);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (this.canceled) {
                this.checkAbort();
            }
            try {
                String state;
                InstallerHelper helper;
                String logMsg;
                Message msg;
                NamingEnumeration<SearchResult> res = ctx.search(dn, filter, searchControls);
                SearchResult sr = null;
                try {
                    while (res.hasMore()) {
                        sr = res.next();
                    }
                }
                finally {
                    res.close();
                }
                String sProcessed = Utils.getFirstValue(sr, "ds-task-processed-entry-count");
                String sUnprocessed = Utils.getFirstValue(sr, "ds-task-unprocessed-entry-count");
                int processed = -1;
                int unprocessed = -1;
                if (sProcessed != null) {
                    processed = Integer.parseInt(sProcessed);
                }
                if (sUnprocessed != null) {
                    unprocessed = Integer.parseInt(sUnprocessed);
                }
                totalEntries = Math.max(totalEntries, processed + unprocessed);
                if (processed != -1 && unprocessed != -1) {
                    if (processed + unprocessed > 0) {
                        int perc = 100 * processed / (processed + unprocessed);
                        msg = QuickSetupMessages.INFO_INITIALIZE_PROGRESS_WITH_PERCENTAGE.get(sProcessed, String.valueOf(perc));
                    } else {
                        msg = null;
                    }
                } else {
                    msg = processed != -1 ? QuickSetupMessages.INFO_INITIALIZE_PROGRESS_WITH_PROCESSED.get(sProcessed) : (unprocessed != -1 ? QuickSetupMessages.INFO_INITIALIZE_PROGRESS_WITH_UNPROCESSED.get(sUnprocessed) : lastDisplayedMsg);
                }
                if (msg != null) {
                    long minRefreshPeriod;
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - (minRefreshPeriod = totalEntries < 100 ? 0L : (totalEntries < 1000 ? 1000L : (totalEntries < 10000 ? 5000L : 10000L))) > lastTimeMsgLogged) {
                        lastTimeMsgLogged = currentTime;
                        LOG.log(Level.INFO, "Progress msg: " + msg);
                    }
                    if (displayProgress && currentTime - minRefreshPeriod > lastTimeMsgDisplayed && !msg.equals(lastDisplayedMsg)) {
                        this.notifyListeners(this.getFormattedProgress(msg));
                        lastDisplayedMsg = msg;
                        this.notifyListeners(this.getLineBreak());
                        lastTimeMsgDisplayed = currentTime;
                    }
                }
                if ((logMsg = Utils.getFirstValue(sr, "ds-task-log-message")) != null && !logMsg.equals(lastLogMsg)) {
                    LOG.log(Level.INFO, logMsg);
                    lastLogMsg = logMsg;
                }
                if (!(helper = new InstallerHelper()).isDone(state = Utils.getFirstValue(sr, "ds-task-state")) && !helper.isStoppedByError(state)) continue;
                isOver = true;
                LOG.log(Level.INFO, "Last task entry: " + sr);
                if (displayProgress && msg != null && !msg.equals(lastDisplayedMsg)) {
                    this.notifyListeners(this.getFormattedProgress(msg));
                    lastDisplayedMsg = msg;
                    this.notifyListeners(this.getLineBreak());
                }
                Message errorMsg = lastLogMsg == null ? QuickSetupMessages.INFO_ERROR_DURING_INITIALIZATION_NO_LOG.get(sourceServerDisplay, state, sourceServerDisplay) : QuickSetupMessages.INFO_ERROR_DURING_INITIALIZATION_LOG.get(sourceServerDisplay, lastLogMsg, state, sourceServerDisplay);
                LOG.log(Level.WARNING, "Processed errorMsg: " + errorMsg);
                if (helper.isCompletedWithErrors(state)) {
                    if (!displayProgress) continue;
                    this.notifyListeners(this.getFormattedWarning(errorMsg));
                    continue;
                }
                if (!helper.isSuccessful(state) || helper.isStoppedByError(state)) {
                    ApplicationException ae = new ApplicationException(ReturnCode.APPLICATION_ERROR, errorMsg, null);
                    if (lastLogMsg == null || helper.isPeersNotFoundError(lastLogMsg)) {
                        LOG.log(Level.WARNING, "Throwing peer not found error.  Last Log Msg: " + lastLogMsg);
                        throw new PeerNotFoundException(errorMsg);
                    }
                    LOG.log(Level.SEVERE, "Throwing ApplicationException.");
                    throw ae;
                }
                if (!displayProgress) continue;
                LOG.log(Level.INFO, "Initialization completed successfully.");
                this.notifyListeners(this.getFormattedProgress(QuickSetupMessages.INFO_SUFFIX_INITIALIZED_SUCCESSFULLY.get()));
                this.notifyListeners(this.getLineBreak());
            }
            catch (NameNotFoundException x) {
                isOver = true;
                LOG.log(Level.INFO, "Initialization entry not found.");
                if (!displayProgress) continue;
                this.notifyListeners(this.getFormattedProgress(QuickSetupMessages.INFO_SUFFIX_INITIALIZED_SUCCESSFULLY.get()));
                this.notifyListeners(this.getLineBreak());
            }
            catch (NamingException ne) {
                throw new ApplicationException(ReturnCode.APPLICATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_POOLING_INITIALIZATION.get(sourceServerDisplay), ne), ne);
            }
        }
        this.resetGenerationId(ctx, suffixDn, sourceServerDisplay);
    }

    private String getConfigurationFile() {
        String file = this.getUserData().getConfigurationFile();
        if (file == null) {
            file = Utils.getPath(this.getInstallation().getCurrentConfigurationFile());
        }
        return file;
    }

    private String getConfigurationClassName() {
        String className = this.getUserData().getConfigurationClassName();
        if (className == null) {
            className = DEFAULT_CONFIG_CLASS_NAME;
        }
        return className;
    }

    private String getLocalReplicationServer() {
        return this.getUserData().getHostName() + ":" + this.getUserData().getReplicationOptions().getReplicationPort();
    }

    private String getLocalHostPort() {
        return this.getUserData().getHostName() + ":" + this.getUserData().getServerPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetGenerationId(InitialLdapContext ctx, String suffixDn, String sourceServerDisplay) throws ApplicationException {
        boolean taskCreated = false;
        int i = 1;
        boolean isOver = false;
        String dn = null;
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add("ds-task");
        oc.add("ds-task-reset-generation-id");
        attrs.put(oc);
        attrs.put("ds-task-class-name", "org.opends.server.tasks.SetGenerationIdTask");
        attrs.put("ds-task-reset-generation-id-domain-base-dn", suffixDn);
        while (!taskCreated) {
            this.checkAbort();
            String id = "quicksetup-reset-generation-id-" + i;
            dn = "ds-task-id=" + id + ",cn=Scheduled Tasks,cn=Tasks";
            attrs.put("ds-task-id", id);
            try {
                DirContext dirCtx = ctx.createSubcontext(dn, (Attributes)attrs);
                taskCreated = true;
                LOG.log(Level.INFO, "created task entry: " + attrs);
                dirCtx.close();
            }
            catch (NameAlreadyBoundException x) {
            }
            catch (NamingException ne) {
                LOG.log(Level.SEVERE, "Error creating task " + attrs, ne);
                throw new ApplicationException(ReturnCode.APPLICATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_LAUNCHING_INITIALIZATION.get(sourceServerDisplay), ne), ne);
            }
            ++i;
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(0);
        String filter = "objectclass=*";
        searchControls.setReturningAttributes(new String[]{"ds-task-log-message", "ds-task-state"});
        String lastLogMsg = null;
        while (!isOver) {
            try {
                Thread.sleep(500L);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                String state;
                InstallerHelper helper;
                NamingEnumeration<SearchResult> res = ctx.search(dn, filter, searchControls);
                SearchResult sr = null;
                try {
                    while (res.hasMore()) {
                        sr = res.next();
                    }
                }
                finally {
                    res.close();
                }
                String logMsg = Utils.getFirstValue(sr, "ds-task-log-message");
                if (logMsg != null && !logMsg.equals(lastLogMsg)) {
                    LOG.log(Level.INFO, logMsg);
                    lastLogMsg = logMsg;
                }
                if (!(helper = new InstallerHelper()).isDone(state = Utils.getFirstValue(sr, "ds-task-state")) && !helper.isStoppedByError(state)) continue;
                isOver = true;
                Message errorMsg = lastLogMsg == null ? QuickSetupMessages.INFO_ERROR_DURING_INITIALIZATION_NO_LOG.get(sourceServerDisplay, state, sourceServerDisplay) : QuickSetupMessages.INFO_ERROR_DURING_INITIALIZATION_LOG.get(sourceServerDisplay, lastLogMsg, state, sourceServerDisplay);
                if (helper.isCompletedWithErrors(state)) {
                    LOG.log(Level.WARNING, "Completed with error: " + errorMsg);
                    this.notifyListeners(this.getFormattedWarning(errorMsg));
                    continue;
                }
                if (helper.isSuccessful(state) && !helper.isStoppedByError(state)) continue;
                LOG.log(Level.WARNING, "Error: " + errorMsg);
                ApplicationException ae = new ApplicationException(ReturnCode.APPLICATION_ERROR, errorMsg, null);
                throw ae;
            }
            catch (NameNotFoundException x) {
                isOver = true;
            }
            catch (NamingException ne) {
                throw new ApplicationException(ReturnCode.APPLICATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_POOLING_INITIALIZATION.get(sourceServerDisplay), ne), ne);
            }
        }
    }

    private void invokeLongOperation(InvokeThread thread) throws ApplicationException {
        try {
            thread.start();
            while (!thread.isOver() && thread.isAlive()) {
                if (this.canceled) {
                    try {
                        thread.abort();
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, "Error cancelling thread: " + t, t);
                    }
                    continue;
                }
                if (thread.getException() != null) {
                    throw thread.getException();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Throwable t) {}
            }
            if (thread.getException() != null) {
                throw thread.getException();
            }
            if (this.canceled) {
                this.checkAbort();
            }
        }
        catch (ApplicationException e) {
            LOG.log(Level.SEVERE, "Error: " + e, e);
            throw e;
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Error: " + t, t);
            throw new ApplicationException(ReturnCode.BUG, Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), t), t);
        }
    }

    protected String getHostPort(ServerDescriptor server) {
        String hostPort = null;
        for (PreferredConnection connection : this.getPreferredConnections()) {
            String url = connection.getLDAPURL();
            if (url.equals(server.getLDAPURL())) {
                hostPort = server.getHostPort(false);
                continue;
            }
            if (!url.equals(server.getLDAPsURL())) continue;
            hostPort = server.getHostPort(true);
        }
        if (hostPort == null) {
            hostPort = server.getHostPort(true);
        }
        return hostPort;
    }

    @Override
    protected void applicationPrintStreamReceived(String message) {
        InstallerHelper helper = new InstallerHelper();
        String parsedMessage = helper.getImportProgressMessage(message);
        if (parsedMessage != null) {
            this.lastImportProgress = parsedMessage;
        }
    }

    protected int getConnectTimeout() {
        return this.getUserData().getConnectTimeout();
    }
}

