/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.quicksetup.JavaArguments;
import org.opends.quicksetup.SecurityOptions;
import org.opends.quicksetup.installer.AuthenticationData;
import org.opends.quicksetup.installer.DataReplicationOptions;
import org.opends.quicksetup.installer.NewSuffixOptions;
import org.opends.quicksetup.installer.SuffixesToReplicateOptions;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.SetupUtils;

public class UserData {
    private String serverLocation;
    private String hostName;
    private int serverPort;
    private int adminConnectorPort;
    private String directoryManagerDn;
    private String directoryManagerPwd;
    private String globalAdministratorUID;
    private String globalAdministratorPassword;
    private SecurityOptions securityOptions;
    private int serverJMXPort = -1;
    private boolean startServer = true;
    private boolean stopServer;
    private boolean enableWindowsService = false;
    private NewSuffixOptions newSuffixOptions;
    private DataReplicationOptions replicationOptions;
    private boolean createAdministrator;
    private SuffixesToReplicateOptions suffixesToReplicateOptions;
    private final Map<ServerDescriptor, AuthenticationData> remoteWithNoReplicationPort;
    private boolean quiet;
    private boolean verbose = false;
    private boolean interactive = true;
    private boolean forceOnError = true;
    private String configurationFile;
    private String configurationClass;
    private Map<String, JavaArguments> hmJavaArguments;
    private Map<String, JavaArguments> hmDefaultJavaArguments;
    private static String defaultHostName;
    private int connectTimeout = ConnectionUtils.getDefaultLDAPTimeout();
    public static String SERVER_SCRIPT_NAME;
    public static String IMPORT_SCRIPT_NAME;

    public UserData() {
        int defaultAdminPort;
        LinkedList<String> baseDn = new LinkedList<String>();
        baseDn.add("dc=example,dc=com");
        NewSuffixOptions defaultNewSuffixOptions = NewSuffixOptions.createBaseEntry(baseDn);
        this.setNewSuffixOptions(defaultNewSuffixOptions);
        int defaultLdapPort = UserData.getDefaultPort();
        if (defaultLdapPort != -1) {
            this.setServerPort(defaultLdapPort);
        }
        if ((defaultAdminPort = UserData.getDefaultAdminConnectorPort()) != -1) {
            this.setAdminConnectorPort(defaultAdminPort);
        }
        this.setHostName(UserData.getDefaultHostName());
        this.setDirectoryManagerDn("cn=Directory Manager");
        this.setNewSuffixOptions(defaultNewSuffixOptions);
        DataReplicationOptions repl = DataReplicationOptions.createStandalone();
        this.setReplicationOptions(repl);
        this.setGlobalAdministratorUID("admin");
        SuffixesToReplicateOptions suffixes = new SuffixesToReplicateOptions(SuffixesToReplicateOptions.Type.REPLICATE_WITH_EXISTING_SUFFIXES, new HashSet(), new HashSet());
        this.setSuffixesToReplicateOptions(suffixes);
        SecurityOptions sec = SecurityOptions.createNoCertificateOptions();
        sec.setSslPort(UserData.getDefaultSslPort(defaultLdapPort));
        this.setSecurityOptions(sec);
        this.remoteWithNoReplicationPort = new HashMap<ServerDescriptor, AuthenticationData>();
        this.createDefaultJavaArguments();
    }

    public void setServerLocation(String serverLocation) {
        this.serverLocation = serverLocation;
    }

    public String getServerLocation() {
        return this.serverLocation;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setAdminConnectorPort(int adminConnectorPort) {
        this.adminConnectorPort = adminConnectorPort;
    }

    public int getAdminConnectorPort() {
        return this.adminConnectorPort;
    }

    public void setServerJMXPort(int serverJMXPort) {
        this.serverJMXPort = serverJMXPort;
    }

    public int getServerJMXPort() {
        return this.serverJMXPort;
    }

    public String getDirectoryManagerDn() {
        return this.directoryManagerDn;
    }

    public void setDirectoryManagerDn(String directoryManagerDn) {
        this.directoryManagerDn = directoryManagerDn;
    }

    public String getDirectoryManagerPwd() {
        return this.directoryManagerPwd;
    }

    public void setDirectoryManagerPwd(String directoryManagerPwd) {
        this.directoryManagerPwd = directoryManagerPwd;
    }

    public boolean getStartServer() {
        return this.startServer;
    }

    public void setStartServer(boolean startServer) {
        this.startServer = startServer;
    }

    public void setStopServer(boolean stopServer) {
        this.stopServer = stopServer;
    }

    public boolean getStopServer() {
        return this.stopServer;
    }

    public boolean getEnableWindowsService() {
        return this.enableWindowsService;
    }

    public void setEnableWindowsService(boolean enableWindowsService) {
        this.enableWindowsService = enableWindowsService;
    }

    public NewSuffixOptions getNewSuffixOptions() {
        return this.newSuffixOptions;
    }

    public void setNewSuffixOptions(NewSuffixOptions newSuffixOptions) {
        this.newSuffixOptions = newSuffixOptions;
    }

    public DataReplicationOptions getReplicationOptions() {
        return this.replicationOptions;
    }

    public void setReplicationOptions(DataReplicationOptions replicationOptions) {
        this.replicationOptions = replicationOptions;
    }

    public boolean mustCreateAdministrator() {
        return this.createAdministrator;
    }

    public void createAdministrator(boolean createAdministrator) {
        this.createAdministrator = createAdministrator;
    }

    public String getGlobalAdministratorUID() {
        return this.globalAdministratorUID;
    }

    public void setGlobalAdministratorUID(String globalAdministratorUID) {
        this.globalAdministratorUID = globalAdministratorUID;
    }

    public String getGlobalAdministratorPassword() {
        return this.globalAdministratorPassword;
    }

    public void setGlobalAdministratorPassword(String globalAdministratorPwd) {
        this.globalAdministratorPassword = globalAdministratorPwd;
    }

    public void setSuffixesToReplicateOptions(SuffixesToReplicateOptions suffixesToReplicateOptions) {
        this.suffixesToReplicateOptions = suffixesToReplicateOptions;
    }

    public SuffixesToReplicateOptions getSuffixesToReplicateOptions() {
        return this.suffixesToReplicateOptions;
    }

    public SecurityOptions getSecurityOptions() {
        return this.securityOptions;
    }

    public void setSecurityOptions(SecurityOptions securityOptions) {
        this.securityOptions = securityOptions;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setForceOnError(boolean forceOnError) {
        this.forceOnError = forceOnError;
    }

    public boolean isForceOnError() {
        return this.forceOnError;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public static int getDefaultPort() {
        int defaultPort = -1;
        for (int i = 0; i < 10000 && defaultPort == -1; i += 1000) {
            int port = i + 389;
            if (!Utils.canUseAsPort(port)) continue;
            defaultPort = port;
        }
        return defaultPort;
    }

    public static int getDefaultAdminConnectorPort() {
        int defaultPort = -1;
        for (int i = 0; i < 10000 && defaultPort == -1; i += 1000) {
            int port = i + 4444;
            if (!Utils.canUseAsPort(port)) continue;
            defaultPort = port;
        }
        return defaultPort;
    }

    public static int getDefaultSslPort(int defaultLdapPort) {
        int defaultPort = -1;
        int port = defaultLdapPort - 389 + 636;
        if (Utils.canUseAsPort(port)) {
            defaultPort = port;
        }
        for (int i = 0; i < 10000 && defaultPort == -1; i += 1000) {
            port = i + 636;
            if (!Utils.canUseAsPort(port)) continue;
            defaultPort = port;
        }
        return defaultPort;
    }

    public static int getDefaultJMXPort(int[] forbiddenPorts) {
        int defaultJMXPort = -1;
        for (int i = 0; i < 65000 && defaultJMXPort == -1; i += 1000) {
            int port = i + SetupUtils.getDefaultJMXPort();
            boolean isForbidden = false;
            if (forbiddenPorts != null) {
                for (int j = 0; j < forbiddenPorts.length && !isForbidden; ++j) {
                    isForbidden = forbiddenPorts[j] == port;
                }
            }
            if (isForbidden || !Utils.canUseAsPort(port)) continue;
            defaultJMXPort = port;
        }
        return defaultJMXPort;
    }

    public static String getDefaultHostName() {
        if (defaultHostName == null) {
            try {
                defaultHostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Throwable t) {
                defaultHostName = "localhost";
            }
        }
        return defaultHostName;
    }

    public Map<ServerDescriptor, AuthenticationData> getRemoteWithNoReplicationPort() {
        HashMap<ServerDescriptor, AuthenticationData> copy = new HashMap<ServerDescriptor, AuthenticationData>();
        copy.putAll(this.remoteWithNoReplicationPort);
        return copy;
    }

    public void setRemoteWithNoReplicationPort(Map<ServerDescriptor, AuthenticationData> remoteWithNoReplicationPort) {
        this.remoteWithNoReplicationPort.clear();
        this.remoteWithNoReplicationPort.putAll(remoteWithNoReplicationPort);
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public void setConfigurationFile(String configurationFile) {
        this.configurationFile = configurationFile;
    }

    public String getConfigurationClassName() {
        return this.configurationClass;
    }

    public void setConfigurationClassName(String configurationClass) {
        this.configurationClass = configurationClass;
    }

    public Set<String> getScriptNamesForJavaArguments() {
        return this.hmJavaArguments.keySet();
    }

    public JavaArguments getJavaArguments(String scriptName) {
        return this.hmJavaArguments.get(scriptName);
    }

    public JavaArguments getDefaultJavaArguments(String scriptName) {
        return this.hmDefaultJavaArguments.get(scriptName);
    }

    public void setJavaArguments(String scriptName, JavaArguments args) {
        this.hmJavaArguments.put(scriptName, args);
    }

    private void createDefaultJavaArguments() {
        JavaArguments javaArgument;
        this.hmJavaArguments = new HashMap<String, JavaArguments>();
        int maxMemoryMb = 256;
        int minMemoryMb = 128;
        int maxMemoryBytes = maxMemoryMb * 1024 * 1024;
        long currentMaxMemoryBytes = Runtime.getRuntime().maxMemory();
        if (currentMaxMemoryBytes > (long)maxMemoryBytes) {
            maxMemoryMb = -1;
            minMemoryMb = -1;
        }
        for (String clientScript : this.getClientScripts()) {
            javaArgument = new JavaArguments();
            javaArgument.setInitialMemory(8);
            javaArgument.setAdditionalArguments(new String[]{"-client"});
            this.hmJavaArguments.put(clientScript, javaArgument);
        }
        for (String serverScript : this.getServerScripts()) {
            javaArgument = new JavaArguments();
            javaArgument.setInitialMemory(minMemoryMb);
            javaArgument.setMaxMemory(maxMemoryMb);
            javaArgument.setAdditionalArguments(new String[]{"-server"});
            this.hmJavaArguments.put(serverScript, javaArgument);
        }
        JavaArguments controlPanelJavaArgument = new JavaArguments();
        controlPanelJavaArgument.setInitialMemory(64);
        controlPanelJavaArgument.setMaxMemory(128);
        controlPanelJavaArgument.setAdditionalArguments(new String[]{"-client"});
        this.hmJavaArguments.put("control-panel", controlPanelJavaArgument);
        this.hmDefaultJavaArguments = new HashMap<String, JavaArguments>(this.hmJavaArguments);
    }

    private String[] getClientScripts() {
        return new String[]{"backup.online", "base64", "create-rc-script", "dsconfig", "dsreplication", "dsframework", "export-ldif.online", "import-ldif.online", "ldapcompare", "ldapdelete", "ldapmodify", "ldappasswordmodify", "ldapsearch", "list-backends", "manage-account", "manage-tasks", "restore.online", "stop-ds", "status", "uninstall", "setup"};
    }

    private String[] getServerScripts() {
        return new String[]{"backup.offline", "dsreplication.offline", "encode-password", "export-ldif.offline", IMPORT_SCRIPT_NAME, "ldif-diff", "ldifmodify", "ldifsearch", "make-ldif", "rebuild-index", "restore.offline", SERVER_SCRIPT_NAME, "upgrade", "verify-index", "dbtest"};
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    static {
        SERVER_SCRIPT_NAME = "start-ds";
        IMPORT_SCRIPT_NAME = "import-ldif.offline";
    }
}

