/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.TopologyCacheFilter;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.PreferredConnection;
import org.opends.admin.ads.util.ServerLoader;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.BuildInformation;
import org.opends.quicksetup.CliUserInteraction;
import org.opends.quicksetup.CurrentInstallStatus;
import org.opends.quicksetup.HistoricalLog;
import org.opends.quicksetup.HistoricalRecord;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.ProgressStep;
import org.opends.quicksetup.ProgressUpdateListenerDelegate;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.UserInteraction;
import org.opends.quicksetup.event.ProgressNotifier;
import org.opends.quicksetup.event.ProgressUpdateListener;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.util.ProgressMessageFormatter;
import org.opends.quicksetup.util.ServerController;
import org.opends.quicksetup.util.UIKeyStore;
import org.opends.quicksetup.util.Utils;

public abstract class Application
implements ProgressNotifier,
Runnable {
    private static final Logger LOG = Logger.getLogger(Application.class.getName());
    protected CurrentInstallStatus installStatus;
    private UserData userData;
    private Installation installation;
    private ServerController serverController;
    private ApplicationTrustManager trustManager;
    private boolean notifyListeners = true;
    protected ProgressMessageFormatter formatter;
    protected ProgressUpdateListenerDelegate listenerDelegate;
    private ErrorPrintStream err = new ErrorPrintStream();
    private OutputPrintStream out = new OutputPrintStream();

    public static GuiApplication create() throws RuntimeException {
        GuiApplication app;
        String appClassName = System.getProperty("org.opends.quicksetup.Application.class");
        if (appClassName != null) {
            Class<?> appClass = null;
            try {
                appClass = Class.forName(appClassName);
                app = (GuiApplication)appClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                LOG.log(Level.INFO, "error creating quicksetup application", e);
                String msg = "Application class " + appClass + " not found";
                throw new RuntimeException(msg, e);
            }
            catch (IllegalAccessException e) {
                LOG.log(Level.INFO, "error creating quicksetup application", e);
                String msg = "Could not access class " + appClass;
                throw new RuntimeException(msg, e);
            }
            catch (InstantiationException e) {
                LOG.log(Level.INFO, "error creating quicksetup application", e);
                String msg = "Error instantiating class " + appClass;
                throw new RuntimeException(msg, e);
            }
            catch (ClassCastException e) {
                String msg = "The class indicated by the system property 'org.opends.quicksetup.Application.class' must  must be of type Application";
                throw new RuntimeException(msg, e);
            }
        } else {
            String msg = "System property 'org.opends.quicksetup.Application.class' must specify class quicksetup application";
            throw new RuntimeException(msg);
        }
        return app;
    }

    public void setUserData(UserData userData) {
        this.userData = userData;
    }

    public UserData createUserData() {
        return new UserData();
    }

    @Override
    public void addProgressUpdateListener(ProgressUpdateListener l) {
        this.listenerDelegate.addProgressUpdateListener(l);
    }

    @Override
    public void removeProgressUpdateListener(ProgressUpdateListener l) {
        this.listenerDelegate.removeProgressUpdateListener(l);
    }

    public Installation getInstallation() {
        if (this.installation == null) {
            String installPath = this.getInstallationPath();
            String instancePath = this.getInstancePath();
            if (installPath != null) {
                this.installation = instancePath == null ? new Installation(installPath, installPath) : new Installation(installPath, instancePath);
            }
        }
        return this.installation;
    }

    public void setInstallation(Installation installation) {
        this.installation = installation;
    }

    public ServerController getServerController() {
        if (this.serverController == null) {
            this.serverController = new ServerController(this);
        }
        return this.serverController;
    }

    public UserData getUserData() {
        if (this.userData == null) {
            this.userData = this.createUserData();
        }
        return this.userData;
    }

    public void notifyListenersDone(Integer ratio) {
        this.notifyListeners(ratio, this.getSummary(this.getCurrentProgressStep()), this.getFormattedDoneWithLineBreak());
    }

    public void notifyListenersRatioChange(Integer ratio) {
        this.notifyListeners(ratio, this.getSummary(this.getCurrentProgressStep()), null);
    }

    @Override
    public void notifyListeners(Integer ratio, Message currentPhaseSummary, Message newLogDetail) {
        if (this.notifyListeners) {
            this.listenerDelegate.notifyListeners(this.getCurrentProgressStep(), ratio, currentPhaseSummary, newLogDetail);
        }
    }

    public void notifyListenersWithPoints(Integer ratio, Message newLogDetail) {
        this.notifyListeners(ratio, this.getSummary(this.getCurrentProgressStep()), this.formatter.getFormattedWithPoints(newLogDetail));
    }

    public void setProgressMessageFormatter(ProgressMessageFormatter formatter) {
        this.formatter = formatter;
        this.listenerDelegate = new ProgressUpdateListenerDelegate();
    }

    public ProgressMessageFormatter getProgressMessageFormatter() {
        return this.formatter;
    }

    protected Message getFormattedSummary(Message text) {
        return this.formatter.getFormattedSummary(text);
    }

    protected Message getFormattedErrorWithLineBreak() {
        return new MessageBuilder(this.formatter.getFormattedError()).append(this.formatter.getLineBreak()).toMessage();
    }

    protected Message getFormattedError(Message text) {
        return this.formatter.getFormattedError(text, false);
    }

    protected Message getFormattedErrorWithLineBreak(Message m, boolean b) {
        return new MessageBuilder(this.formatter.getFormattedError(m, b)).append(this.formatter.getLineBreak()).toMessage();
    }

    protected Message getFormattedErrorWithLineBreak(Throwable t, boolean b) {
        return new MessageBuilder(this.formatter.getFormattedError(t, b)).append(this.formatter.getLineBreak()).toMessage();
    }

    public Message getFormattedWarning(Message text) {
        return this.formatter.getFormattedWarning(text, false);
    }

    protected Message getFormattedSuccess(Message text) {
        return this.formatter.getFormattedSuccess(text);
    }

    public Message getFormattedLogError(Message text) {
        return this.formatter.getFormattedLogError(text);
    }

    public Message getFormattedLog(Message text) {
        return this.formatter.getFormattedLog(text);
    }

    public Message getFormattedDone() {
        return Message.raw(this.formatter.getFormattedDone(), new Object[0]);
    }

    public Message getFormattedDoneWithLineBreak() {
        return new MessageBuilder(this.formatter.getFormattedDone()).append(this.formatter.getLineBreak()).toMessage();
    }

    public Message getFormattedWithPoints(Message text) {
        return this.formatter.getFormattedWithPoints(text);
    }

    public Message getFormattedProgress(Message text) {
        return this.formatter.getFormattedProgress(text);
    }

    public Message getFormattedProgressWithLineBreak(Message text) {
        return new MessageBuilder(this.formatter.getFormattedProgress(text)).append(this.getLineBreak()).toMessage();
    }

    protected Message getFormattedError(Throwable t, boolean applyMargin) {
        return this.formatter.getFormattedError(t, applyMargin);
    }

    protected Message getFormattedError(Message m, boolean applyMargin) {
        return this.formatter.getFormattedError(m, applyMargin);
    }

    public Message getLineBreak() {
        return this.formatter.getLineBreak();
    }

    protected Message getTaskSeparator() {
        return this.formatter.getTaskSeparator();
    }

    public void notifyListeners(Message newLogDetail) {
        Integer ratio = this.getRatio(this.getCurrentProgressStep());
        Message currentPhaseSummary = this.getSummary(this.getCurrentProgressStep());
        this.notifyListeners(ratio, currentPhaseSummary, newLogDetail);
    }

    public abstract String getInstallationPath();

    public abstract String getInstancePath();

    public abstract ProgressStep getCurrentProgressStep();

    public abstract Integer getRatio(ProgressStep var1);

    public abstract Message getSummary(ProgressStep var1);

    public void setCurrentInstallStatus(CurrentInstallStatus installStatus) {
        this.installStatus = installStatus;
    }

    public abstract boolean isFinished();

    public ApplicationTrustManager getTrustManager() {
        if (this.trustManager == null) {
            if (!Utils.isCli()) {
                try {
                    this.trustManager = new ApplicationTrustManager(UIKeyStore.getInstance());
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Error retrieving UI key store: " + t, t);
                    this.trustManager = new ApplicationTrustManager(null);
                }
            } else {
                this.trustManager = new ApplicationTrustManager(null);
            }
        }
        return this.trustManager;
    }

    public abstract boolean isCancellable();

    public abstract void cancel();

    public void checkAbort() throws ApplicationException {
    }

    public UserInteraction userInteraction() {
        CliUserInteraction ui = null;
        UserData ud = this.getUserData();
        if (ud != null && ud.isInteractive()) {
            ui = new CliUserInteraction();
        }
        return ui;
    }

    protected void notifyListenersOfLog() {
        File logFile = QuickSetupLog.getLogFile();
        if (logFile != null) {
            this.notifyListeners(this.getFormattedProgress(QuickSetupMessages.INFO_GENERAL_SEE_FOR_DETAILS.get(logFile.getPath())));
            this.notifyListeners(this.getLineBreak());
        }
    }

    protected void notifyListenersOfLogAfterError() {
        File logFile = QuickSetupLog.getLogFile();
        if (logFile != null) {
            this.notifyListeners(this.getFormattedProgress(QuickSetupMessages.INFO_GENERAL_PROVIDE_LOG_IN_ERROR.get(logFile.getPath())));
            this.notifyListeners(this.getLineBreak());
        }
    }

    protected Long writeInitialHistoricalRecord(BuildInformation fromVersion, BuildInformation toVersion) throws ApplicationException {
        Long id;
        try {
            HistoricalLog log = new HistoricalLog(this.getInstallation().getHistoryLogFile());
            id = log.append(fromVersion, toVersion, HistoricalRecord.Status.STARTED, "log file '" + QuickSetupLog.getLogFile().getPath() + "'");
        }
        catch (IOException e) {
            Message msg = QuickSetupMessages.INFO_ERROR_LOGGING_OPERATION.get();
            throw ApplicationException.createFileSystemException(msg, e);
        }
        return id;
    }

    protected void writeHistoricalRecord(Long id, BuildInformation from, BuildInformation to, HistoricalRecord.Status status, String note) throws ApplicationException {
        try {
            HistoricalLog log = new HistoricalLog(this.getInstallation().getHistoryLogFile());
            log.append(id, from, to, status, note);
        }
        catch (IOException e) {
            Message msg = QuickSetupMessages.INFO_ERROR_LOGGING_OPERATION.get();
            throw ApplicationException.createFileSystemException(msg, e);
        }
    }

    protected Message getMessage(TopologyCacheException e) {
        return Utils.getMessage(e);
    }

    protected InitialLdapContext getRemoteConnection(ServerDescriptor server, String dn, String pwd, ApplicationTrustManager trustManager, int timeout, LinkedHashSet<PreferredConnection> cnx) throws ApplicationException {
        Map<ADSContext.ServerProperty, Object> adsProperties = server.getAdsProperties();
        TopologyCacheFilter filter = new TopologyCacheFilter();
        filter.setSearchMonitoringInformation(false);
        filter.setSearchBaseDNInformation(false);
        ServerLoader loader = new ServerLoader(adsProperties, dn, pwd, trustManager, timeout, cnx, filter);
        InitialLdapContext ctx = null;
        try {
            ctx = loader.createContext();
        }
        catch (NamingException ne) {
            Message msg = Utils.isCertificateException(ne) ? QuickSetupMessages.INFO_ERROR_READING_CONFIG_LDAP_CERTIFICATE_SERVER.get(server.getHostPort(true), ne.toString(true)) : QuickSetupMessages.INFO_CANNOT_CONNECT_TO_REMOTE_GENERIC.get(server.getHostPort(true), ne.toString(true));
            throw new ApplicationException(ReturnCode.CONFIGURATION_ERROR, msg, ne);
        }
        return ctx;
    }

    public boolean isVerbose() {
        return this.getUserData().isVerbose();
    }

    public ErrorPrintStream getApplicationErrorStream() {
        return this.err;
    }

    public OutputPrintStream getApplicationOutputStream() {
        return this.out;
    }

    public boolean isNotifyListeners() {
        return this.notifyListeners;
    }

    public void setNotifyListeners(boolean notifyListeners) {
        this.notifyListeners = notifyListeners;
    }

    protected void applicationPrintStreamReceived(String message) {
    }

    protected class PointAdder
    implements Runnable {
        private Thread t;
        private boolean stopPointAdder;
        private boolean pointAdderStopped;

        public void start() {
            MessageBuilder mb = new MessageBuilder();
            mb.append(Application.this.formatter.getSpace());
            for (int i = 0; i < 5; ++i) {
                mb.append(Application.this.formatter.getFormattedPoint());
            }
            Integer ratio = Application.this.getRatio(Application.this.getCurrentProgressStep());
            Message currentPhaseSummary = Application.this.getSummary(Application.this.getCurrentProgressStep());
            Application.this.listenerDelegate.notifyListeners(Application.this.getCurrentProgressStep(), ratio, currentPhaseSummary, mb.toMessage());
            this.t = new Thread(this);
            this.t.start();
        }

        public synchronized void stop() {
            this.stopPointAdder = true;
            while (!this.pointAdderStopped) {
                try {
                    this.t.interrupt();
                    Thread.sleep(100L);
                }
                catch (Throwable throwable) {}
            }
        }

        @Override
        public void run() {
            Message currentPhaseSummary;
            Integer ratio;
            while (!this.stopPointAdder) {
                try {
                    Thread.sleep(3000L);
                    ratio = Application.this.getRatio(Application.this.getCurrentProgressStep());
                    currentPhaseSummary = Application.this.getSummary(Application.this.getCurrentProgressStep());
                    Application.this.listenerDelegate.notifyListeners(Application.this.getCurrentProgressStep(), ratio, currentPhaseSummary, Application.this.formatter.getFormattedPoint());
                }
                catch (Throwable t) {}
            }
            this.pointAdderStopped = true;
            ratio = Application.this.getRatio(Application.this.getCurrentProgressStep());
            currentPhaseSummary = Application.this.getSummary(Application.this.getCurrentProgressStep());
            Application.this.listenerDelegate.notifyListeners(Application.this.getCurrentProgressStep(), ratio, currentPhaseSummary, Application.this.formatter.getSpace());
        }
    }

    protected abstract class ApplicationPrintStream
    extends PrintStream {
        private boolean isFirstLine;

        protected abstract Message formatString(String var1);

        public ApplicationPrintStream() {
            super(new ByteArrayOutputStream(), true);
            this.isFirstLine = true;
        }

        @Override
        public void println(String msg) {
            MessageBuilder mb = new MessageBuilder();
            if (this.isFirstLine) {
                mb.append(this.formatString(msg));
            } else {
                if (!Utils.isCli()) {
                    mb.append(Application.this.getLineBreak());
                }
                mb.append(this.formatString(msg));
            }
            Application.this.notifyListeners(mb.toMessage());
            Application.this.applicationPrintStreamReceived(msg);
            LOG.log(Level.INFO, msg);
            this.isFirstLine = false;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            if (b == null) {
                throw new NullPointerException("b is null");
            }
            if (off + len > b.length) {
                throw new IndexOutOfBoundsException("len + off are bigger than the length of the byte array");
            }
            this.println(new String(b, off, len));
        }
    }

    public class OutputPrintStream
    extends ApplicationPrintStream {
        @Override
        protected Message formatString(String s) {
            return Application.this.getFormattedLog(Message.raw(s, new Object[0]));
        }
    }

    public class ErrorPrintStream
    extends ApplicationPrintStream {
        @Override
        protected Message formatString(String s) {
            return Application.this.getFormattedLogError(Message.raw(s, new Object[0]));
        }
    }
}

