/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class TrustedSocketFactory
extends SSLSocketFactory {
    private static Map<Thread, TrustManager> hmTrustManager = new HashMap<Thread, TrustManager>();
    private static Map<Thread, KeyManager> hmKeyManager = new HashMap<Thread, KeyManager>();
    private static Map<TrustManager, SocketFactory> hmDefaultFactoryTm = new HashMap<TrustManager, SocketFactory>();
    private static Map<KeyManager, SocketFactory> hmDefaultFactoryKm = new HashMap<KeyManager, SocketFactory>();
    private SSLSocketFactory innerFactory;
    private TrustManager trustManager;
    private KeyManager keyManager;

    public TrustedSocketFactory(TrustManager trustManager, KeyManager keyManager) {
        this.trustManager = trustManager;
        this.keyManager = keyManager;
    }

    public static synchronized void setCurrentThreadTrustManager(TrustManager trustManager, KeyManager keyManager) {
        TrustedSocketFactory.setThreadTrustManager(trustManager, Thread.currentThread());
        TrustedSocketFactory.setThreadKeyManager(keyManager, Thread.currentThread());
    }

    public static synchronized void setThreadTrustManager(TrustManager trustManager, Thread thread) {
        TrustManager trustManager2 = hmTrustManager.get(thread);
        if (trustManager2 != null) {
            hmDefaultFactoryTm.remove(trustManager2);
            hmTrustManager.remove(thread);
        }
        if (trustManager != null) {
            hmTrustManager.put(thread, trustManager);
        }
    }

    public static synchronized void setThreadKeyManager(KeyManager keyManager, Thread thread) {
        KeyManager keyManager2 = hmKeyManager.get(thread);
        if (keyManager2 != null) {
            hmDefaultFactoryKm.remove(keyManager2);
            hmKeyManager.remove(thread);
        }
        if (keyManager != null) {
            hmKeyManager.put(thread, keyManager);
        }
    }

    public static synchronized SocketFactory getDefault() {
        SocketFactory socketFactory;
        Thread thread = Thread.currentThread();
        TrustManager trustManager = hmTrustManager.get(thread);
        KeyManager keyManager = hmKeyManager.get(thread);
        if (trustManager == null) {
            if (keyManager == null) {
                socketFactory = new TrustedSocketFactory(null, null);
            } else {
                socketFactory = hmDefaultFactoryKm.get(keyManager);
                if (socketFactory == null) {
                    socketFactory = new TrustedSocketFactory(null, keyManager);
                    hmDefaultFactoryKm.put(keyManager, socketFactory);
                }
            }
        } else if (keyManager == null) {
            socketFactory = hmDefaultFactoryTm.get(trustManager);
            if (socketFactory == null) {
                socketFactory = new TrustedSocketFactory(trustManager, null);
                hmDefaultFactoryTm.put(trustManager, socketFactory);
            }
        } else {
            SocketFactory socketFactory2 = hmDefaultFactoryTm.get(trustManager);
            SocketFactory socketFactory3 = hmDefaultFactoryKm.get(keyManager);
            if (socketFactory2 == null || socketFactory3 == null) {
                socketFactory = new TrustedSocketFactory(trustManager, keyManager);
                hmDefaultFactoryTm.put(trustManager, socketFactory);
                hmDefaultFactoryKm.put(keyManager, socketFactory);
            } else if (!socketFactory2.equals(socketFactory3)) {
                socketFactory = new TrustedSocketFactory(trustManager, keyManager);
                hmDefaultFactoryTm.put(trustManager, socketFactory);
                hmDefaultFactoryKm.put(keyManager, socketFactory);
            } else {
                socketFactory = socketFactory2;
            }
        }
        return socketFactory;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.getInnerFactory().createSocket(inetAddress, n);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        return this.getInnerFactory().createSocket(inetAddress, n, inetAddress2, n2);
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException {
        return this.getInnerFactory().createSocket(string, n);
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        return this.getInnerFactory().createSocket(string, n, inetAddress, n2);
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        return this.getInnerFactory().createSocket(socket, string, n, bl);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        try {
            return this.getInnerFactory().getDefaultCipherSuites();
        }
        catch (IOException iOException) {
            return new String[0];
        }
    }

    @Override
    public String[] getSupportedCipherSuites() {
        try {
            return this.getInnerFactory().getSupportedCipherSuites();
        }
        catch (IOException iOException) {
            return new String[0];
        }
    }

    private SSLSocketFactory getInnerFactory() throws IOException {
        if (this.innerFactory == null) {
            String string = "TLSv1";
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = null;
            try {
                SSLContext sSLContext = SSLContext.getInstance(string);
                if (this.trustManager != null) {
                    trustManagerArray = new TrustManager[]{this.trustManager};
                }
                if (this.keyManager != null) {
                    keyManagerArray = new KeyManager[]{this.keyManager};
                }
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                this.innerFactory = sSLContext.getSocketFactory();
            }
            catch (GeneralSecurityException generalSecurityException) {
                SSLKeyException sSLKeyException = new SSLKeyException("Failed to create SSLContext for " + string);
                sSLKeyException.initCause(generalSecurityException);
                throw sSLKeyException;
            }
        }
        return this.innerFactory;
    }
}

