/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.TimeLimitExceededException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.TopologyCacheFilter;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.admin.ads.util.PreferredConnection;

public class ServerLoader
extends Thread {
    private Map<ADSContext.ServerProperty, Object> serverProperties;
    private boolean isOver;
    private boolean isInterrupted;
    private String lastLdapUrl;
    private TopologyCacheException lastException;
    private ServerDescriptor serverDescriptor;
    private ApplicationTrustManager trustManager;
    private int timeout;
    private String dn;
    private String pwd;
    private LinkedHashSet<PreferredConnection> preferredLDAPURLs;
    private TopologyCacheFilter filter;
    private static final Logger LOG = Logger.getLogger(ServerLoader.class.getName());

    public ServerLoader(Map<ADSContext.ServerProperty, Object> map, String string, String string2, ApplicationTrustManager applicationTrustManager, int n, LinkedHashSet<PreferredConnection> linkedHashSet, TopologyCacheFilter topologyCacheFilter) {
        this.serverProperties = map;
        this.dn = string;
        this.pwd = string2;
        this.trustManager = applicationTrustManager;
        this.timeout = n;
        this.preferredLDAPURLs = new LinkedHashSet<PreferredConnection>(linkedHashSet);
        this.filter = topologyCacheFilter;
    }

    public ServerDescriptor getServerDescriptor() {
        if (this.serverDescriptor == null) {
            this.serverDescriptor = ServerDescriptor.createStandalone(this.serverProperties);
        }
        this.serverDescriptor.setLastException(this.lastException);
        return this.serverDescriptor;
    }

    public TopologyCacheException getLastException() {
        return this.lastException;
    }

    @Override
    public void interrupt() {
        if (!this.isOver) {
            LinkedHashSet<PreferredConnection> linkedHashSet;
            this.isInterrupted = true;
            String string = this.getLastLdapUrl();
            if (string == null && !(linkedHashSet = this.getLDAPURLsByPreference()).isEmpty()) {
                string = ((PreferredConnection)linkedHashSet.iterator().next()).getLDAPURL();
            }
            this.lastException = new TopologyCacheException(TopologyCacheException.Type.TIMEOUT, new TimeLimitExceededException("Timeout reading server: " + string), this.trustManager, string);
            LOG.log(Level.WARNING, "Timeout reading server: " + string);
        }
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.lastException = null;
        InitialLdapContext initialLdapContext = null;
        try {
            initialLdapContext = this.createContext();
            this.serverDescriptor = ServerDescriptor.createStandalone(initialLdapContext, this.filter);
            this.serverDescriptor.setAdsProperties(this.serverProperties);
            this.serverDescriptor.updateAdsPropertiesWithServerProperties();
        }
        catch (NoPermissionException noPermissionException) {
            LOG.log(Level.WARNING, "Permissions error reading server: " + this.getLastLdapUrl(), noPermissionException);
            this.lastException = !this.isAdministratorDn() ? new TopologyCacheException(TopologyCacheException.Type.NOT_GLOBAL_ADMINISTRATOR, noPermissionException, this.trustManager, this.getLastLdapUrl()) : new TopologyCacheException(TopologyCacheException.Type.NO_PERMISSIONS, noPermissionException, this.trustManager, this.getLastLdapUrl());
        }
        catch (AuthenticationException authenticationException) {
            LOG.log(Level.WARNING, "Authentication exception: " + this.getLastLdapUrl(), authenticationException);
            this.lastException = !this.isAdministratorDn() ? new TopologyCacheException(TopologyCacheException.Type.NOT_GLOBAL_ADMINISTRATOR, authenticationException, this.trustManager, this.getLastLdapUrl()) : new TopologyCacheException(TopologyCacheException.Type.GENERIC_READING_SERVER, authenticationException, this.trustManager, this.getLastLdapUrl());
        }
        catch (NamingException namingException) {
            LOG.log(Level.WARNING, "NamingException error reading server: " + this.getLastLdapUrl(), namingException);
            this.lastException = initialLdapContext == null ? new TopologyCacheException(TopologyCacheException.Type.GENERIC_CREATING_CONNECTION, namingException, this.trustManager, this.getLastLdapUrl()) : new TopologyCacheException(TopologyCacheException.Type.GENERIC_READING_SERVER, namingException, this.trustManager, this.getLastLdapUrl());
        }
        catch (Throwable throwable) {
            if (!this.isInterrupted) {
                LOG.log(Level.WARNING, "Generic error reading server: " + this.getLastLdapUrl(), throwable);
                LOG.log(Level.WARNING, "server Properties: " + this.serverProperties);
                this.lastException = new TopologyCacheException(TopologyCacheException.Type.BUG, throwable);
            }
        }
        finally {
            this.isOver = true;
            try {
                if (initialLdapContext != null) {
                    initialLdapContext.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public InitialLdapContext createContext() throws NamingException {
        Object object;
        InitialLdapContext initialLdapContext = null;
        if (this.trustManager != null) {
            this.trustManager.resetLastRefusedItems();
            object = (String)this.serverProperties.get((Object)ADSContext.ServerProperty.HOST_NAME);
            this.trustManager.setHost((String)object);
        }
        object = this.getLDAPURLsByPreference();
        Iterator iterator = ((HashSet)object).iterator();
        block4: while (iterator.hasNext()) {
            PreferredConnection preferredConnection = (PreferredConnection)iterator.next();
            if (initialLdapContext != null) continue;
            this.lastLdapUrl = preferredConnection.getLDAPURL();
            switch (preferredConnection.getType()) {
                case LDAPS: {
                    initialLdapContext = ConnectionUtils.createLdapsContext(this.lastLdapUrl, this.dn, this.pwd, this.timeout, null, this.trustManager, null);
                    continue block4;
                }
                case START_TLS: {
                    initialLdapContext = ConnectionUtils.createStartTLSContext(this.lastLdapUrl, this.dn, this.pwd, this.timeout, null, this.trustManager, null, null);
                    continue block4;
                }
            }
            initialLdapContext = ConnectionUtils.createLdapContext(this.lastLdapUrl, this.dn, this.pwd, this.timeout, null);
        }
        return initialLdapContext;
    }

    private String getLastLdapUrl() {
        return this.lastLdapUrl;
    }

    private String getLdapUrl(Map<ADSContext.ServerProperty, Object> map) {
        boolean bl;
        String string = null;
        Object object = map.get((Object)ADSContext.ServerProperty.LDAP_ENABLED);
        boolean bl2 = bl = object != null && "true".equalsIgnoreCase(object.toString());
        if (bl) {
            string = "ldap://" + this.getHostNameForLdapUrl(map) + ":" + map.get((Object)ADSContext.ServerProperty.LDAP_PORT);
        }
        return string;
    }

    private String getStartTlsLdapUrl(Map<ADSContext.ServerProperty, Object> map) {
        boolean bl;
        String string = null;
        Object object = map.get((Object)ADSContext.ServerProperty.LDAP_ENABLED);
        boolean bl2 = object != null && "true".equalsIgnoreCase(object.toString());
        object = map.get((Object)ADSContext.ServerProperty.STARTTLS_ENABLED);
        boolean bl3 = bl = object != null && "true".equalsIgnoreCase(object.toString());
        if (bl2 && bl) {
            string = "ldap://" + this.getHostNameForLdapUrl(map) + ":" + map.get((Object)ADSContext.ServerProperty.LDAP_PORT);
        }
        return string;
    }

    private String getLdapsUrl(Map<ADSContext.ServerProperty, Object> map) {
        boolean bl;
        String string = null;
        Object object = map.get((Object)ADSContext.ServerProperty.LDAPS_ENABLED);
        boolean bl2 = bl = object != null && "true".equalsIgnoreCase(object.toString());
        if (bl) {
            string = "ldaps://" + this.getHostNameForLdapUrl(map) + ":" + map.get((Object)ADSContext.ServerProperty.LDAPS_PORT);
        }
        return string;
    }

    private String getAdminConnectorUrl(Map<ADSContext.ServerProperty, Object> map) {
        String string = null;
        Object object = map.get((Object)ADSContext.ServerProperty.ADMIN_ENABLED);
        boolean bl = object != null && "true".equalsIgnoreCase(String.valueOf(object)) ? (object = map.get((Object)ADSContext.ServerProperty.ADMIN_PORT)) != null : false;
        if (bl) {
            string = "ldaps://" + this.getHostNameForLdapUrl(map) + ":" + map.get((Object)ADSContext.ServerProperty.ADMIN_PORT);
        }
        return string;
    }

    private String getHostNameForLdapUrl(Map<ADSContext.ServerProperty, Object> map) {
        String string = (String)map.get((Object)ADSContext.ServerProperty.HOST_NAME);
        return ConnectionUtils.getHostNameForLdapUrl(string);
    }

    private boolean isAdministratorDn() {
        boolean bl = false;
        try {
            LdapName ldapName = new LdapName(this.dn);
            LdapName ldapName2 = new LdapName(ADSContext.getAdministratorContainerDN());
            bl = ldapName.startsWith(ldapName2);
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "Error parsing authentication DNs.", throwable);
        }
        return bl;
    }

    private LinkedHashSet<PreferredConnection> getLDAPURLsByPreference() {
        LinkedHashSet<PreferredConnection> linkedHashSet = new LinkedHashSet<PreferredConnection>();
        String string = this.getAdminConnectorUrl(this.serverProperties);
        String string2 = this.getLdapsUrl(this.serverProperties);
        String string3 = this.getStartTlsLdapUrl(this.serverProperties);
        String string4 = this.getLdapUrl(this.serverProperties);
        for (PreferredConnection preferredConnection : this.preferredLDAPURLs) {
            String string5 = preferredConnection.getLDAPURL();
            if (string5.equalsIgnoreCase(string)) {
                linkedHashSet.add(preferredConnection);
                continue;
            }
            if (string5.equalsIgnoreCase(string2) && preferredConnection.getType() == PreferredConnection.Type.LDAPS) {
                linkedHashSet.add(preferredConnection);
                continue;
            }
            if (string5.equalsIgnoreCase(string3) && preferredConnection.getType() == PreferredConnection.Type.START_TLS) {
                linkedHashSet.add(preferredConnection);
                continue;
            }
            if (!string5.equalsIgnoreCase(string4) || preferredConnection.getType() != PreferredConnection.Type.LDAP) continue;
            linkedHashSet.add(preferredConnection);
        }
        if (string != null) {
            linkedHashSet.add(new PreferredConnection(string, PreferredConnection.Type.LDAPS));
        }
        if (string2 != null) {
            linkedHashSet.add(new PreferredConnection(string2, PreferredConnection.Type.LDAPS));
        }
        if (string3 != null) {
            linkedHashSet.add(new PreferredConnection(string3, PreferredConnection.Type.START_TLS));
        }
        if (string4 != null) {
            linkedHashSet.add(new PreferredConnection(string4, PreferredConnection.Type.LDAP));
        }
        return linkedHashSet;
    }
}

