/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads.util;

import java.util.LinkedHashSet;
import javax.naming.ldap.InitialLdapContext;
import org.opends.admin.ads.util.ConnectionUtils;

public class PreferredConnection {
    private String ldapUrl;
    private Type type;

    public PreferredConnection(String string, Type type) {
        this.ldapUrl = string;
        this.type = type;
    }

    public String getLDAPURL() {
        return this.ldapUrl;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return ((Object)((Object)this.type) + this.ldapUrl.toLowerCase()).hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this != object) {
            if (object != null && object instanceof PreferredConnection) {
                PreferredConnection preferredConnection = (PreferredConnection)object;
                bl = this.type == preferredConnection.getType() && this.ldapUrl.equalsIgnoreCase(preferredConnection.getLDAPURL());
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public static PreferredConnection getPreferredConnection(InitialLdapContext initialLdapContext) {
        String string = ConnectionUtils.getLdapUrl(initialLdapContext);
        Type type = ConnectionUtils.isStartTLS(initialLdapContext) ? Type.START_TLS : (ConnectionUtils.isSSL(initialLdapContext) ? Type.LDAPS : Type.LDAP);
        PreferredConnection preferredConnection = new PreferredConnection(string, type);
        return preferredConnection;
    }

    public static LinkedHashSet<PreferredConnection> getPreferredConnections(InitialLdapContext initialLdapContext) {
        PreferredConnection preferredConnection = PreferredConnection.getPreferredConnection(initialLdapContext);
        LinkedHashSet<PreferredConnection> linkedHashSet = new LinkedHashSet<PreferredConnection>();
        linkedHashSet.add(preferredConnection);
        return linkedHashSet;
    }

    public static enum Type {
        LDAP,
        LDAPS,
        START_TLS;

    }
}

