/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads;

import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ADSContextException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.ldap.JNDIDirContextAdaptor;
import org.opends.server.admin.client.ldap.LDAPConnection;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.admin.std.client.BackendCfgClient;
import org.opends.server.admin.std.client.LDIFBackendCfgClient;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.admin.std.meta.BackendCfgDefn;
import org.opends.server.admin.std.meta.LDIFBackendCfgDefn;
import org.opends.server.crypto.CryptoManagerImpl;
import org.opends.server.types.CryptoManagerException;
import org.opends.server.types.DN;

public class ADSContextHelper {
    public void removeAdministrationSuffix(InitialLdapContext initialLdapContext, String string) throws ADSContextException {
        try {
            SortedSet sortedSet;
            ManagementContext managementContext = LDAPManagementContext.createFromContext((LDAPConnection)JNDIDirContextAdaptor.adapt((DirContext)initialLdapContext));
            RootCfgClient rootCfgClient = managementContext.getRootConfiguration();
            BackendCfgClient backendCfgClient = null;
            try {
                backendCfgClient = rootCfgClient.getBackend(string);
            }
            catch (ManagedObjectNotFoundException managedObjectNotFoundException) {
                // empty catch block
            }
            if (backendCfgClient != null && (sortedSet = backendCfgClient.getBaseDN()) != null && sortedSet.remove(DN.decode((String)ADSContext.getAdministrationSuffixDN()))) {
                if (sortedSet.size() > 0) {
                    backendCfgClient.setBaseDN((Collection)sortedSet);
                    backendCfgClient.commit();
                } else {
                    rootCfgClient.removeBackend(string);
                }
            }
        }
        catch (Throwable throwable) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, throwable);
        }
    }

    public void createAdministrationSuffix(InitialLdapContext initialLdapContext, String string) throws ADSContextException {
        try {
            DN dN;
            Object object;
            ManagementContext managementContext = LDAPManagementContext.createFromContext((LDAPConnection)JNDIDirContextAdaptor.adapt((DirContext)initialLdapContext));
            RootCfgClient rootCfgClient = managementContext.getRootConfiguration();
            LDIFBackendCfgClient lDIFBackendCfgClient = null;
            try {
                lDIFBackendCfgClient = (LDIFBackendCfgClient)rootCfgClient.getBackend(string);
            }
            catch (ManagedObjectNotFoundException managedObjectNotFoundException) {
            }
            catch (ClassCastException classCastException) {
                throw new ADSContextException(ADSContextException.ErrorType.UNEXPECTED_ADS_BACKEND_TYPE, (Throwable)classCastException);
            }
            if (lDIFBackendCfgClient == null) {
                object = LDIFBackendCfgDefn.getInstance();
                lDIFBackendCfgClient = (LDIFBackendCfgClient)rootCfgClient.createBackend((ManagedObjectDefinition)object, string, null);
                lDIFBackendCfgClient.setEnabled(true);
                lDIFBackendCfgClient.setLDIFFile(ADSContext.getAdminLDIFFile());
                lDIFBackendCfgClient.setBackendId(string);
                lDIFBackendCfgClient.setWritabilityMode(BackendCfgDefn.WritabilityMode.ENABLED);
                lDIFBackendCfgClient.setIsPrivateBackend(Boolean.valueOf(true));
            }
            if ((object = lDIFBackendCfgClient.getBaseDN()) == null) {
                object = new TreeSet();
            }
            if (!object.contains(dN = DN.decode((String)ADSContext.getAdministrationSuffixDN()))) {
                object.add(dN);
                lDIFBackendCfgClient.setBaseDN((Collection)object);
                lDIFBackendCfgClient.commit();
            }
        }
        catch (Throwable throwable) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, throwable);
        }
    }

    public void registerInstanceKeyCertificate(InitialLdapContext initialLdapContext, Map<ADSContext.ServerProperty, Object> map, LdapName ldapName) throws ADSContextException {
        assert (map.containsKey((Object)ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE));
        if (!map.containsKey((Object)ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE)) {
            return;
        }
        String string = (String)map.get((Object)ADSContext.ServerProperty.INSTANCE_KEY_ID);
        BasicAttributes basicAttributes = new BasicAttributes();
        BasicAttribute basicAttribute = new BasicAttribute("objectclass");
        basicAttribute.add("top");
        basicAttribute.add("ds-cfg-instance-key");
        basicAttributes.put(basicAttribute);
        if (null != string) {
            basicAttributes.put(new BasicAttribute(ADSContext.ServerProperty.INSTANCE_KEY_ID.getAttributeName(), string));
        }
        basicAttributes.put(new BasicAttribute(ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE.getAttributeName() + ";binary", map.get((Object)ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE)));
        String[] stringArray = new String[]{"ds-cfg-key-id"};
        NamingEnumeration<SearchResult> namingEnumeration = null;
        try {
            Cloneable cloneable;
            namingEnumeration = initialLdapContext.search(ADSContext.getInstanceKeysContainerDN(), (Attributes)basicAttributes, stringArray);
            boolean bl = false;
            while (namingEnumeration.hasMore()) {
                cloneable = namingEnumeration.next().getAttributes().get(stringArray[0]);
                if (null != cloneable) {
                    string = (String)cloneable.get();
                }
                bl = true;
            }
            if (!bl) {
                if (null == string) {
                    string = CryptoManagerImpl.getInstanceKeyID((byte[])((byte[])map.get((Object)ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE)));
                    basicAttributes.put(new BasicAttribute(ADSContext.ServerProperty.INSTANCE_KEY_ID.getAttributeName(), string));
                }
                cloneable = new LdapName(ADSContext.ServerProperty.INSTANCE_KEY_ID.getAttributeName() + "=" + Rdn.escapeValue(string) + "," + ADSContext.getInstanceKeysContainerDN());
                initialLdapContext.createSubcontext((Name)cloneable, (Attributes)basicAttributes).close();
            }
            if (ldapName != null) {
                initialLdapContext.modifyAttributes(ldapName, 2, (Attributes)new BasicAttributes(ADSContext.ServerProperty.INSTANCE_KEY_ID.getAttributeName(), string));
            }
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
        }
        catch (CryptoManagerException cryptoManagerException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)cryptoManagerException);
        }
        finally {
            this.handleCloseNamingEnumeration(namingEnumeration);
        }
    }

    public void unregisterInstanceKeyCertificate(InitialLdapContext initialLdapContext, Map<ADSContext.ServerProperty, Object> map, LdapName ldapName) throws ADSContextException {
        assert (map.containsKey((Object)ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE));
        if (!map.containsKey((Object)ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE)) {
            return;
        }
        BasicAttributes basicAttributes = new BasicAttributes();
        BasicAttribute basicAttribute = new BasicAttribute("objectclass");
        basicAttribute.add("top");
        basicAttribute.add("ds-cfg-instance-key");
        basicAttributes.put(basicAttribute);
        basicAttributes.put(new BasicAttribute(ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE.getAttributeName() + ";binary", map.get((Object)ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE)));
        String[] stringArray = new String[]{"ds-cfg-key-id"};
        NamingEnumeration<SearchResult> namingEnumeration = null;
        try {
            namingEnumeration = initialLdapContext.search(ADSContext.getInstanceKeysContainerDN(), (Attributes)basicAttributes, stringArray);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                initialLdapContext.destroySubcontext(searchResult.getNameInNamespace());
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
        }
        finally {
            this.handleCloseNamingEnumeration(namingEnumeration);
        }
    }

    public String getOcCryptoInstanceKey() {
        return "ds-cfg-instance-key";
    }

    public String getAttrCryptoKeyCompromisedTime() {
        return "ds-cfg-key-compromised-time";
    }

    private void handleCloseNamingEnumeration(NamingEnumeration<?> namingEnumeration) throws ADSContextException {
        if (namingEnumeration != null) {
            try {
                namingEnumeration.close();
            }
            catch (NamingException namingException) {
                throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
            }
        }
    }
}

