/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads;

import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.server.types.OpenDsException;

public class ADSContextException
extends OpenDsException {
    private static final long serialVersionUID = 1984039711031042813L;
    private String toString;
    ErrorType error;
    Throwable embeddedException;

    public ADSContextException(ErrorType errorType) {
        this(errorType, null);
    }

    public ADSContextException(ErrorType errorType, Throwable throwable) {
        this(errorType, ADSContextException.getMessage(errorType, throwable), throwable);
    }

    public ADSContextException(ErrorType errorType, Message message, Throwable throwable) {
        super(message);
        this.error = errorType;
        this.embeddedException = throwable;
        this.toString = "ADSContextException: error type " + (Object)((Object)errorType) + ".";
        if (this.getCause() != null) {
            this.toString = this.toString + "  Root cause: " + this.getCause().toString();
        }
    }

    public ErrorType getError() {
        return this.error;
    }

    @Override
    public Throwable getCause() {
        return this.embeddedException;
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        if (this.embeddedException != null) {
            System.out.println("embeddedException = {");
            this.embeddedException.printStackTrace();
            System.out.println("}");
        }
    }

    @Override
    public String toString() {
        return this.toString;
    }

    private static Message getMessage(ErrorType errorType, Throwable throwable) {
        Message message = throwable != null ? (throwable instanceof OpenDsException ? QuickSetupMessages.INFO_ADS_CONTEXT_EXCEPTION_WITH_DETAILS_MSG.get(errorType.toString(), ((OpenDsException)throwable).getMessageObject()) : QuickSetupMessages.INFO_ADS_CONTEXT_EXCEPTION_WITH_DETAILS_MSG.get(errorType.toString(), throwable.toString())) : QuickSetupMessages.INFO_ADS_CONTEXT_EXCEPTION_MSG.get(errorType.toString());
        return message;
    }

    public static enum ErrorType {
        MISSING_HOSTNAME,
        NOVALID_HOSTNAME,
        MISSING_IPATH,
        NOVALID_IPATH,
        ACCESS_PERMISSION,
        ALREADY_REGISTERED,
        BROKEN_INSTALL,
        NOT_YET_REGISTERED,
        MISSING_PORT,
        NOVALID_PORT,
        MISSING_NAME,
        MISSING_ADMIN_UID,
        MISSING_ADMIN_PASSWORD,
        UNEXPECTED_ADS_BACKEND_TYPE,
        ERROR_MERGING,
        ERROR_UNEXPECTED;

    }
}

