/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.NotContextException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.opends.admin.ads.ADSContextException;
import org.opends.admin.ads.ADSContextHelper;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.SubtreeDeleteControl;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.util.Utils;

public class ADSContext {
    private static final Logger LOG = Logger.getLogger(ADSContext.class.getName());
    public static final String GLOBAL_ADMIN_UID = "admin";
    private static HashMap<String, ServerProperty> nameToServerProperty = null;
    private static final Set<ServerProperty> MULTIVALUED_SERVER_PROPERTIES = new HashSet<ServerProperty>();
    public static final String ALL_SERVERGROUP_NAME = "all-servers";
    private static final Set<ServerGroupProperty> MULTIVALUED_SERVER_GROUP_PROPERTIES;
    private static HashMap<String, AdministratorProperty> nameToAdminUserProperty;
    private final InitialLdapContext dirContext;

    public static ServerProperty getServerPropFromName(String string) {
        if (nameToServerProperty == null) {
            nameToServerProperty = new HashMap();
            for (ServerProperty serverProperty : ServerProperty.values()) {
                nameToServerProperty.put(serverProperty.getAttributeName(), serverProperty);
            }
        }
        return nameToServerProperty.get(string);
    }

    public static AdministratorProperty getAdminUserPropFromName(String string) {
        if (nameToAdminUserProperty == null) {
            nameToAdminUserProperty = new HashMap();
            for (AdministratorProperty administratorProperty : AdministratorProperty.values()) {
                nameToAdminUserProperty.put(administratorProperty.getAttributeName(), administratorProperty);
            }
        }
        return nameToAdminUserProperty.get(string);
    }

    public ADSContext(InitialLdapContext initialLdapContext) {
        this.dirContext = initialLdapContext;
    }

    public InitialLdapContext getDirContext() {
        return this.dirContext;
    }

    public void registerServer(Map<ServerProperty, Object> map) throws ADSContextException {
        LdapName ldapName = ADSContext.makeDNFromServerProperties(map);
        BasicAttributes basicAttributes = ADSContext.makeAttrsFromServerProperties(map, true);
        try {
            if (!this.isExistingEntry(ADSContext.nameFromDN(ADSContext.getServerContainerDN()))) {
                this.createContainerEntry(ADSContext.getServerContainerDN());
            }
            this.dirContext.createSubcontext(ldapName, (Attributes)basicAttributes).close();
            if (map.containsKey((Object)ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE)) {
                this.registerInstanceKeyCertificate(map, ldapName);
            }
            HashMap<ServerGroupProperty, Object> hashMap = new HashMap<ServerGroupProperty, Object>();
            Set<String> set = this.getServerGroupMemberList(ALL_SERVERGROUP_NAME);
            if (set == null) {
                set = new HashSet<String>();
            }
            String string = "cn=" + Rdn.escapeValue(map.get((Object)ServerProperty.ID));
            set.add(string);
            hashMap.put(ServerGroupProperty.MEMBERS, set);
            this.updateServerGroup(ALL_SERVERGROUP_NAME, hashMap);
            Set set2 = (Set)map.get((Object)ServerProperty.GROUPS);
            HashSet<String> hashSet = new HashSet<String>();
            if (set2 != null) {
                for (Object object : set2.toArray()) {
                    hashSet.add(object.toString());
                }
            }
            hashSet.add(ALL_SERVERGROUP_NAME);
            map.put(ServerProperty.GROUPS, hashSet);
            this.updateServer(map, null);
        }
        catch (ADSContextException aDSContextException) {
            throw aDSContextException;
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            throw new ADSContextException(ADSContextException.ErrorType.ALREADY_REGISTERED);
        }
        catch (Exception exception) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)exception);
        }
    }

    public void updateServer(Map<ServerProperty, Object> map, String string) throws ADSContextException {
        LdapName ldapName = ADSContext.makeDNFromServerProperties(map);
        try {
            Cloneable cloneable;
            if (string != null) {
                cloneable = new HashMap<ServerProperty, Object>(map);
                ((HashMap)cloneable).put(ServerProperty.ID, string);
                LdapName ldapName2 = ADSContext.makeDNFromServerProperties((Map<ServerProperty, Object>)((Object)cloneable));
                this.dirContext.rename(ldapName, ldapName2);
                ldapName = ldapName2;
                map.put(ServerProperty.ID, string);
            }
            cloneable = ADSContext.makeAttrsFromServerProperties(map, false);
            this.dirContext.modifyAttributes(ldapName, 2, (Attributes)cloneable);
            if (map.containsKey((Object)ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE)) {
                this.registerInstanceKeyCertificate(map, ldapName);
            }
        }
        catch (ADSContextException aDSContextException) {
            throw aDSContextException;
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new ADSContextException(ADSContextException.ErrorType.NOT_YET_REGISTERED);
        }
        catch (Exception exception) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServer(Map<ServerProperty, Object> map) throws ADSContextException {
        block22: {
            String string;
            Serializable serializable;
            Object object;
            Map<ServerGroupProperty, Object> map2;
            Object object2;
            Object object3;
            Object object4;
            LdapName ldapName = ADSContext.makeDNFromServerProperties(map);
            try {
                if (map.containsKey((Object)ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE)) {
                    this.unregisterInstanceKeyCertificate(map, ldapName);
                }
                object4 = "cn=" + Rdn.escapeValue(map.get((Object)ServerProperty.ID));
                object3 = this.readServerGroupRegistry();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    map2 = object2.next();
                    object = (Set)map2.get((Object)ServerGroupProperty.MEMBERS);
                    if (object == null || !object.remove(object4)) continue;
                    serializable = new HashMap<ServerGroupProperty, Object>();
                    ((HashMap)serializable).put(ServerGroupProperty.MEMBERS, object);
                    string = (String)map2.get((Object)ServerGroupProperty.UID);
                    this.updateServerGroup(string, (Map<ServerGroupProperty, Object>)((Object)serializable));
                }
                this.dirContext.destroySubcontext(ldapName);
            }
            catch (NameNotFoundException nameNotFoundException) {
                throw new ADSContextException(ADSContextException.ErrorType.NOT_YET_REGISTERED);
            }
            catch (NamingException namingException) {
                throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
            }
            object4 = null;
            try {
                object3 = new SearchControls();
                object2 = ADSContext.getServerID(map);
                if (object2 == null) break block22;
                map2 = ServerGroupProperty.MEMBERS.getAttributeName();
                object = "(" + (String)((Object)map2) + "=cn=" + (String)object2 + ")";
                ((SearchControls)object3).setSearchScope(1);
                object4 = this.dirContext.search(ADSContext.getServerGroupContainerDN(), (String)object, (SearchControls)object3);
                while (object4.hasMore()) {
                    Cloneable cloneable;
                    serializable = (SearchResult)object4.next();
                    string = ((NameClassPair)serializable).getNameInNamespace();
                    BasicAttribute basicAttribute = new BasicAttribute((String)((Object)map2));
                    NamingEnumeration<? extends Attribute> namingEnumeration = ((SearchResult)serializable).getAttributes().getAll();
                    try {
                        while (namingEnumeration.hasMore()) {
                            cloneable = namingEnumeration.next();
                            String string2 = cloneable.getID();
                            if (!string2.equalsIgnoreCase((String)((Object)map2))) continue;
                            NamingEnumeration<?> namingEnumeration2 = cloneable.getAll();
                            try {
                                while (namingEnumeration2.hasMore()) {
                                    String string3 = (String)namingEnumeration2.next();
                                    if (string3.equalsIgnoreCase("cn=" + (String)object2)) continue;
                                    basicAttribute.add(string3);
                                }
                            }
                            finally {
                                this.handleCloseNamingEnumeration(namingEnumeration2);
                            }
                        }
                    }
                    finally {
                        this.handleCloseNamingEnumeration(namingEnumeration);
                    }
                    cloneable = new BasicAttributes();
                    ((BasicAttributes)cloneable).put(basicAttribute);
                    if (basicAttribute.size() > 0) {
                        this.dirContext.modifyAttributes(string, 2, (Attributes)cloneable);
                        continue;
                    }
                    this.dirContext.modifyAttributes(string, 3, (Attributes)cloneable);
                }
            }
            catch (NameNotFoundException nameNotFoundException) {
                throw new ADSContextException(ADSContextException.ErrorType.BROKEN_INSTALL);
            }
            catch (NoPermissionException noPermissionException) {
                throw new ADSContextException(ADSContextException.ErrorType.ACCESS_PERMISSION);
            }
            catch (NamingException namingException) {
                throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
            }
            finally {
                this.handleCloseNamingEnumeration((NamingEnumeration<?>)object4);
            }
        }
    }

    public boolean isServerAlreadyRegistered(Map<ServerProperty, Object> map) throws ADSContextException {
        LdapName ldapName = ADSContext.makeDNFromServerProperties(map);
        return this.isExistingEntry(ldapName);
    }

    public boolean isAdministratorAlreadyRegistered(String string) throws ADSContextException {
        LdapName ldapName = ADSContext.makeDNFromAdministratorProperties(string);
        return this.isExistingEntry(ldapName);
    }

    public int registerOrUpdateServer(Map<ServerProperty, Object> map) throws ADSContextException {
        int n = 0;
        try {
            this.registerServer(map);
        }
        catch (ADSContextException aDSContextException) {
            if (aDSContextException.getError() == ADSContextException.ErrorType.ALREADY_REGISTERED) {
                this.updateServer(map, null);
                n = 1;
            }
            throw aDSContextException;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<String> getServerGroupMemberList(String string) throws ADSContextException {
        LdapName ldapName = ADSContext.nameFromDN("cn=" + Rdn.escapeValue(string) + "," + ADSContext.getServerGroupContainerDN());
        HashSet<String> hashSet = new HashSet<String>();
        NamingEnumeration<SearchResult> namingEnumeration = null;
        NamingEnumeration<? extends Attribute> namingEnumeration2 = null;
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(0);
            namingEnumeration = this.getDirContext().search((Name)ldapName, "(objectclass=*)", searchControls);
            if (!namingEnumeration.hasMore()) {
                HashSet<String> hashSet2 = hashSet;
                return hashSet2;
            }
            Attributes attributes = namingEnumeration.next().getAttributes();
            namingEnumeration2 = attributes.getAll();
            while (namingEnumeration2.hasMore()) {
                Attribute attribute = namingEnumeration2.next();
                String string2 = attribute.getID();
                if (!string2.toLowerCase().equals(ServerGroupProperty.MEMBERS.getAttributeName().toLowerCase())) continue;
                NamingEnumeration<?> namingEnumeration3 = attribute.getAll();
                try {
                    while (namingEnumeration3.hasMore()) {
                        hashSet.add((String)namingEnumeration3.next());
                    }
                    return hashSet;
                }
                finally {
                    this.handleCloseNamingEnumeration(namingEnumeration3);
                    return hashSet;
                }
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            hashSet = new HashSet();
            return hashSet;
        }
        catch (NoPermissionException noPermissionException) {
            throw new ADSContextException(ADSContextException.ErrorType.ACCESS_PERMISSION);
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
        }
        finally {
            this.handleCloseNamingEnumeration(namingEnumeration);
            this.handleCloseNamingEnumeration(namingEnumeration2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Map<ServerProperty, Object>> readServerRegistry() throws ADSContextException {
        HashSet<Map<ServerProperty, Object>> hashSet = new HashSet<Map<ServerProperty, Object>>();
        NamingEnumeration<SearchResult> namingEnumeration = null;
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(1);
            namingEnumeration = this.dirContext.search(ADSContext.getServerContainerDN(), "(objectclass=*)", searchControls);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                Map<ServerProperty, Object> map = this.makePropertiesFromServerAttrs(searchResult.getAttributes());
                Object object = map.get((Object)ServerProperty.INSTANCE_KEY_ID);
                if (object != null) {
                    NamingEnumeration<SearchResult> namingEnumeration2 = null;
                    try {
                        SearchControls searchControls2 = new SearchControls();
                        searchControls2.setSearchScope(1);
                        String[] stringArray = new String[]{"ds-cfg-public-key-certificate;binary"};
                        searchControls2.setReturningAttributes(stringArray);
                        namingEnumeration2 = this.dirContext.search(ADSContext.getInstanceKeysContainerDN(), "(ds-cfg-key-id=" + object + ")", searchControls);
                        boolean bl = false;
                        while (namingEnumeration2.hasMore()) {
                            SearchResult searchResult2 = namingEnumeration2.next();
                            Attribute attribute = searchResult2.getAttributes().get(stringArray[0]);
                            map.put(ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE, attribute.get());
                            bl = true;
                        }
                        if (!bl) {
                            LOG.log(Level.WARNING, "Could not find public key for " + map);
                        }
                    }
                    catch (NameNotFoundException nameNotFoundException) {
                        LOG.log(Level.WARNING, "Could not find public key for " + map);
                    }
                    finally {
                        this.handleCloseNamingEnumeration(namingEnumeration2);
                    }
                }
                hashSet.add(map);
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new ADSContextException(ADSContextException.ErrorType.BROKEN_INSTALL);
        }
        catch (NoPermissionException noPermissionException) {
            throw new ADSContextException(ADSContextException.ErrorType.ACCESS_PERMISSION);
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
        }
        finally {
            this.handleCloseNamingEnumeration(namingEnumeration);
        }
        return hashSet;
    }

    public void createServerGroup(Map<ServerGroupProperty, Object> map) throws ADSContextException {
        LdapName ldapName = ADSContext.makeDNFromServerGroupProperties(map);
        BasicAttributes basicAttributes = ADSContext.makeAttrsFromServerGroupProperties(map);
        BasicAttribute basicAttribute = new BasicAttribute("objectclass");
        basicAttribute.add("top");
        basicAttribute.add("groupOfUniqueNames");
        basicAttributes.put(basicAttribute);
        try {
            DirContext dirContext = this.dirContext.createSubcontext(ldapName, (Attributes)basicAttributes);
            dirContext.close();
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            throw new ADSContextException(ADSContextException.ErrorType.ALREADY_REGISTERED);
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.BROKEN_INSTALL, (Throwable)namingException);
        }
    }

    public void updateServerGroup(String string, Map<ServerGroupProperty, Object> map) throws ADSContextException {
        LdapName ldapName = ADSContext.nameFromDN("cn=" + Rdn.escapeValue(string) + "," + ADSContext.getServerGroupContainerDN());
        try {
            Object object;
            if (map.containsKey((Object)ServerGroupProperty.UID)) {
                object = map.get((Object)ServerGroupProperty.UID).toString();
                if (!((String)object).equals(string)) {
                    LdapName ldapName2 = ADSContext.nameFromDN("cn=" + Rdn.escapeValue(object) + "," + ADSContext.getServerGroupContainerDN());
                    this.dirContext.rename(ldapName, ldapName2);
                    ldapName = ldapName2;
                }
                map.remove((Object)ServerGroupProperty.UID);
            }
            if (map.isEmpty()) {
                return;
            }
            object = ADSContext.makeAttrsFromServerGroupProperties(map);
            this.dirContext.modifyAttributes(ldapName, 2, (Attributes)object);
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new ADSContextException(ADSContextException.ErrorType.NOT_YET_REGISTERED);
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            throw new ADSContextException(ADSContextException.ErrorType.ALREADY_REGISTERED);
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
        }
    }

    public void removeServerGroupProp(String string, Set<ServerGroupProperty> set) throws ADSContextException {
        LdapName ldapName = ADSContext.nameFromDN("cn=" + Rdn.escapeValue(string) + "," + ADSContext.getServerGroupContainerDN());
        BasicAttributes basicAttributes = ADSContext.makeAttrsFromServerGroupProperties(set);
        try {
            this.dirContext.modifyAttributes(ldapName, 3, (Attributes)basicAttributes);
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            throw new ADSContextException(ADSContextException.ErrorType.ALREADY_REGISTERED);
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
        }
    }

    public void deleteServerGroup(Map<ServerGroupProperty, Object> map) throws ADSContextException {
        LdapName ldapName = ADSContext.makeDNFromServerGroupProperties(map);
        try {
            this.dirContext.destroySubcontext(ldapName);
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
        }
    }

    public Set<Map<ServerGroupProperty, Object>> readServerGroupRegistry() throws ADSContextException {
        HashSet<Map<ServerGroupProperty, Object>> hashSet = new HashSet<Map<ServerGroupProperty, Object>>();
        NamingEnumeration<SearchResult> namingEnumeration = null;
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(1);
            namingEnumeration = this.dirContext.search(ADSContext.getServerGroupContainerDN(), "(objectclass=*)", searchControls);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                Map<ServerGroupProperty, Object> map = this.makePropertiesFromServerGroupAttrs(searchResult.getAttributes());
                hashSet.add(map);
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new ADSContextException(ADSContextException.ErrorType.BROKEN_INSTALL);
        }
        catch (NoPermissionException noPermissionException) {
            throw new ADSContextException(ADSContextException.ErrorType.ACCESS_PERMISSION);
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
        }
        finally {
            this.handleCloseNamingEnumeration(namingEnumeration);
        }
        return hashSet;
    }

    public Set<Map<AdministratorProperty, Object>> readAdministratorRegistry() throws ADSContextException {
        HashSet<Map<AdministratorProperty, Object>> hashSet = new HashSet<Map<AdministratorProperty, Object>>();
        NamingEnumeration<SearchResult> namingEnumeration = null;
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(1);
            String[] stringArray = new String[]{"cn", "userpassword", "ds-privilege-name", "description"};
            searchControls.setReturningAttributes(stringArray);
            namingEnumeration = this.dirContext.search(ADSContext.getAdministratorContainerDN(), "(objectclass=*)", searchControls);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                Map<AdministratorProperty, Object> map = this.makePropertiesFromAdministratorAttrs(ADSContext.getRdn(searchResult.getName()), searchResult.getAttributes());
                hashSet.add(map);
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new ADSContextException(ADSContextException.ErrorType.BROKEN_INSTALL);
        }
        catch (NoPermissionException noPermissionException) {
            throw new ADSContextException(ADSContextException.ErrorType.ACCESS_PERMISSION);
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
        }
        finally {
            this.handleCloseNamingEnumeration(namingEnumeration);
        }
        return hashSet;
    }

    public void createAdminData(String string) throws ADSContextException {
        this.createAdministrationSuffix(string);
        if (!this.isExistingEntry(ADSContext.nameFromDN(ADSContext.getAdministrationSuffixDN()))) {
            this.createTopContainerEntry();
        }
        if (!this.isExistingEntry(ADSContext.nameFromDN(ADSContext.getAdministratorContainerDN()))) {
            this.createAdministratorContainerEntry();
        }
        if (!this.isExistingEntry(ADSContext.nameFromDN(ADSContext.getServerContainerDN()))) {
            this.createContainerEntry(ADSContext.getServerContainerDN());
        }
        if (!this.isExistingEntry(ADSContext.nameFromDN(ADSContext.getServerGroupContainerDN()))) {
            this.createContainerEntry(ADSContext.getServerGroupContainerDN());
        }
        if (!this.isExistingEntry(ADSContext.nameFromDN(ADSContext.getAllServerGroupDN()))) {
            HashMap<ServerGroupProperty, Object> hashMap = new HashMap<ServerGroupProperty, Object>();
            hashMap.put(ServerGroupProperty.UID, ALL_SERVERGROUP_NAME);
            this.createServerGroup(hashMap);
        }
        if (!this.isExistingEntry(ADSContext.nameFromDN(ADSContext.getInstanceKeysContainerDN()))) {
            this.createContainerEntry(ADSContext.getInstanceKeysContainerDN());
        }
        if (!this.isExistingEntry(ADSContext.nameFromDN(ADSContext.getSecretKeysContainerDN()))) {
            this.createContainerEntry(ADSContext.getSecretKeysContainerDN());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAdminData() throws ADSContextException {
        String[] stringArray = new String[]{ADSContext.getServerContainerDN(), ADSContext.getServerGroupContainerDN(), ADSContext.getInstanceKeysContainerDN(), ADSContext.getAdministratorContainerDN()};
        try {
            Control[] controlArray = new Control[]{new SubtreeDeleteControl()};
            LdapContext ldapContext = this.dirContext.newInstance(controlArray);
            try {
                for (String string : stringArray) {
                    LdapName ldapName = ADSContext.nameFromDN(string);
                    if (!this.isExistingEntry(ldapName)) continue;
                    ldapContext.destroySubcontext(string);
                }
            }
            finally {
                ldapContext.close();
            }
            this.createContainerEntry(ADSContext.getServerContainerDN());
            this.createContainerEntry(ADSContext.getServerGroupContainerDN());
            this.createContainerEntry(ADSContext.getInstanceKeysContainerDN());
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
        }
    }

    public boolean hasAdminData() throws ADSContextException {
        String[] stringArray = new String[]{ADSContext.getAdministratorContainerDN(), ADSContext.getAllServerGroupDN(), ADSContext.getServerContainerDN(), ADSContext.getInstanceKeysContainerDN(), ADSContext.getSecretKeysContainerDN()};
        boolean bl = true;
        for (int i = 0; i < stringArray.length && bl; ++i) {
            bl = this.isExistingEntry(ADSContext.nameFromDN(stringArray[i]));
        }
        return bl;
    }

    public static String getAdministratorDN(String string) {
        return "cn=" + Rdn.escapeValue(string) + "," + ADSContext.getAdministratorContainerDN();
    }

    public void createAdministrator(Map<AdministratorProperty, Object> map) throws ADSContextException {
        LdapName ldapName = ADSContext.makeDNFromAdministratorProperties(map);
        BasicAttributes basicAttributes = ADSContext.makeAttrsFromAdministratorProperties(map, true, null);
        try {
            DirContext dirContext = this.dirContext.createSubcontext(ldapName, (Attributes)basicAttributes);
            dirContext.close();
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            throw new ADSContextException(ADSContextException.ErrorType.ALREADY_REGISTERED);
        }
        catch (NoPermissionException noPermissionException) {
            throw new ADSContextException(ADSContextException.ErrorType.ACCESS_PERMISSION);
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
        }
    }

    public void deleteAdministrator(Map<AdministratorProperty, Object> map) throws ADSContextException {
        LdapName ldapName = ADSContext.makeDNFromAdministratorProperties(map);
        try {
            this.dirContext.destroySubcontext(ldapName);
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new ADSContextException(ADSContextException.ErrorType.NOT_YET_REGISTERED);
        }
        catch (NotContextException notContextException) {
            throw new ADSContextException(ADSContextException.ErrorType.NOT_YET_REGISTERED);
        }
        catch (NoPermissionException noPermissionException) {
            throw new ADSContextException(ADSContextException.ErrorType.ACCESS_PERMISSION);
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAdministrator(Map<AdministratorProperty, Object> map, String string) throws ADSContextException {
        String[] stringArray = ADSContext.makeDNFromAdministratorProperties(map);
        boolean bl = map.containsKey((Object)AdministratorProperty.PASSWORD);
        NamingEnumeration<?> namingEnumeration = null;
        try {
            String[] stringArray2;
            Serializable serializable;
            if (string != null) {
                serializable = new HashMap<AdministratorProperty, Object>(map);
                ((HashMap)serializable).put((AdministratorProperty)AdministratorProperty.UID, (Object)string);
                stringArray2 = ADSContext.makeDNFromAdministratorProperties((Map<AdministratorProperty, Object>)((Object)serializable));
                this.dirContext.rename((Name)stringArray, (Name)stringArray2);
                stringArray = stringArray2;
                map.put(AdministratorProperty.UID, string);
            }
            if (map.containsKey((Object)AdministratorProperty.PRIVILEGE)) {
                serializable = new SearchControls();
                ((SearchControls)serializable).setSearchScope(0);
                stringArray2 = new String[]{"ds-privilege-name"};
                ((SearchControls)serializable).setReturningAttributes(stringArray2);
                NamingEnumeration<SearchResult> namingEnumeration2 = this.dirContext.search((Name)stringArray, "(objectclass=*)", (SearchControls)serializable);
                try {
                    while (namingEnumeration2.hasMore()) {
                        SearchResult searchResult = namingEnumeration2.next();
                        namingEnumeration = searchResult.getAttributes().get("ds-privilege-name").getAll();
                    }
                }
                finally {
                    this.handleCloseNamingEnumeration(namingEnumeration2);
                }
            }
            if (map.size() > 1) {
                serializable = ADSContext.makeAttrsFromAdministratorProperties(map, bl, namingEnumeration);
                this.dirContext.modifyAttributes((Name)stringArray, 2, (Attributes)serializable);
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new ADSContextException(ADSContextException.ErrorType.NOT_YET_REGISTERED);
        }
        catch (NoPermissionException noPermissionException) {
            throw new ADSContextException(ADSContextException.ErrorType.ACCESS_PERMISSION);
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
        }
        finally {
            this.handleCloseNamingEnumeration(namingEnumeration);
        }
    }

    public static String getAdministrationSuffixDN() {
        return "cn=admin data";
    }

    private static LdapName makeDNFromHostnameAndPath(String string, String string2) throws ADSContextException {
        String string3 = Rdn.escapeValue(string + "@" + string2);
        return ADSContext.nameFromDN("cn=" + string3 + "," + ADSContext.getServerContainerDN());
    }

    private static LdapName makeDNFromServerUniqueId(String string) throws ADSContextException {
        String string2 = Rdn.escapeValue(string);
        return ADSContext.nameFromDN("cn=" + string2 + "," + ADSContext.getServerContainerDN());
    }

    private static LdapName makeDNFromServerGroupProperties(Map<ServerGroupProperty, Object> map) throws ADSContextException {
        String string = (String)map.get((Object)ServerGroupProperty.UID);
        if (string == null) {
            throw new ADSContextException(ADSContextException.ErrorType.MISSING_NAME);
        }
        return ADSContext.nameFromDN("cn=" + Rdn.escapeValue(string) + "," + ADSContext.getServerGroupContainerDN());
    }

    private static LdapName makeDNFromServerProperties(Map<ServerProperty, Object> map) throws ADSContextException {
        String string = ADSContext.getServerID(map);
        if (string != null) {
            return ADSContext.makeDNFromServerUniqueId(string);
        }
        String string2 = ADSContext.getHostname(map);
        try {
            String string3 = ADSContext.getInstallPath(map);
            return ADSContext.makeDNFromHostnameAndPath(string2, string3);
        }
        catch (ADSContextException aDSContextException) {
            ServerDescriptor serverDescriptor = ServerDescriptor.createStandalone(map);
            return ADSContext.makeDNFromServerUniqueId(serverDescriptor.getHostPort(true));
        }
    }

    public static String getServerIdFromServerProperties(Map<ServerProperty, Object> map) throws ADSContextException {
        LdapName ldapName = ADSContext.makeDNFromServerProperties(map);
        String string = ldapName.get(ldapName.size() - 1);
        int n = string.indexOf("=");
        return string.substring(n + 1);
    }

    private static LdapName makeDNFromAdministratorProperties(Map<AdministratorProperty, Object> map) throws ADSContextException {
        String string = ADSContext.getAdministratorUID(map);
        return ADSContext.makeDNFromAdministratorProperties(string);
    }

    private static LdapName makeDNFromAdministratorProperties(String string) throws ADSContextException {
        String string2 = ADSContext.getAdministratorDN(string);
        return ADSContext.nameFromDN(string2);
    }

    private static BasicAttributes makeAttrsFromAdministratorProperties(Map<AdministratorProperty, Object> map, boolean bl, NamingEnumeration<?> namingEnumeration) throws ADSContextException {
        Attribute attribute;
        BasicAttributes basicAttributes = new BasicAttributes();
        BasicAttribute basicAttribute = new BasicAttribute("objectclass");
        if (bl) {
            basicAttributes.put("userPassword", ADSContext.getAdministratorPassword(map));
        }
        basicAttribute.add("top");
        basicAttribute.add("person");
        basicAttributes.put(basicAttribute);
        basicAttributes.put("sn", GLOBAL_ADMIN_UID);
        if (map.containsKey((Object)AdministratorProperty.DESCRIPTION)) {
            basicAttributes.put("description", map.get((Object)AdministratorProperty.DESCRIPTION));
        }
        if (map.containsKey((Object)AdministratorProperty.PRIVILEGE)) {
            attribute = new BasicAttribute("ds-privilege-name");
            if (namingEnumeration != null) {
                while (namingEnumeration.hasMoreElements()) {
                    attribute.add(namingEnumeration.nextElement().toString());
                }
            }
            LinkedList linkedList = (LinkedList)map.get((Object)AdministratorProperty.PRIVILEGE);
            for (Object e : linkedList) {
                String string = e.toString();
                if (string.startsWith("-")) {
                    attribute.remove(string.substring(1));
                    continue;
                }
                attribute.add(string);
            }
        } else {
            attribute = ADSContext.addRootPrivileges();
        }
        basicAttributes.put(attribute);
        basicAttributes.put("ds-pwp-password-policy-dn", "cn=Root Password Policy,cn=Password Policies,cn=config");
        return basicAttributes;
    }

    private static Attribute addRootPrivileges() {
        BasicAttribute basicAttribute = new BasicAttribute("ds-privilege-name");
        basicAttribute.add("bypass-acl");
        basicAttribute.add("modify-acl");
        basicAttribute.add("config-read");
        basicAttribute.add("config-write");
        basicAttribute.add("ldif-import");
        basicAttribute.add("ldif-export");
        basicAttribute.add("backend-backup");
        basicAttribute.add("backend-restore");
        basicAttribute.add("server-shutdown");
        basicAttribute.add("server-restart");
        basicAttribute.add("disconnect-client");
        basicAttribute.add("cancel-request");
        basicAttribute.add("password-reset");
        basicAttribute.add("update-schema");
        basicAttribute.add("privilege-change");
        basicAttribute.add("unindexed-search");
        basicAttribute.add("subentry-write");
        return basicAttribute;
    }

    private static BasicAttributes makeAttrsFromServerProperties(Map<ServerProperty, Object> map, boolean bl) {
        BasicAttributes basicAttributes = new BasicAttributes();
        for (ServerProperty serverProperty : map.keySet()) {
            Attribute attribute = ADSContext.makeAttrFromServerProperty(serverProperty, map.get((Object)serverProperty));
            if (attribute == null) continue;
            basicAttributes.put(attribute);
        }
        if (bl) {
            BasicAttribute basicAttribute = new BasicAttribute("objectclass");
            basicAttribute.add("top");
            basicAttribute.add("ds-cfg-branch");
            basicAttribute.add("extensibleobject");
            basicAttributes.put(basicAttribute);
        }
        return basicAttributes;
    }

    private static Attribute makeAttrFromServerProperty(ServerProperty serverProperty, Object object) {
        BasicAttribute basicAttribute;
        switch (serverProperty) {
            case INSTANCE_PUBLIC_KEY_CERTIFICATE: {
                basicAttribute = null;
                break;
            }
            case GROUPS: {
                basicAttribute = new BasicAttribute(ServerProperty.GROUPS.getAttributeName());
                for (Object e : (Set)object) {
                    basicAttribute.add(e);
                }
                break;
            }
            default: {
                basicAttribute = new BasicAttribute(serverProperty.getAttributeName(), object);
            }
        }
        return basicAttribute;
    }

    private static BasicAttributes makeAttrsFromServerGroupProperties(Map<ServerGroupProperty, Object> map) {
        BasicAttributes basicAttributes = new BasicAttributes();
        for (ServerGroupProperty serverGroupProperty : map.keySet()) {
            Attribute attribute = ADSContext.makeAttrFromServerGroupProperty(serverGroupProperty, map.get((Object)serverGroupProperty));
            if (attribute == null) continue;
            basicAttributes.put(attribute);
        }
        return basicAttributes;
    }

    private static BasicAttributes makeAttrsFromServerGroupProperties(Set<ServerGroupProperty> set) {
        BasicAttributes basicAttributes = new BasicAttributes();
        for (ServerGroupProperty serverGroupProperty : set) {
            Attribute attribute = ADSContext.makeAttrFromServerGroupProperty(serverGroupProperty, null);
            if (attribute == null) continue;
            basicAttributes.put(attribute);
        }
        return basicAttributes;
    }

    private static Attribute makeAttrFromServerGroupProperty(ServerGroupProperty serverGroupProperty, Object object) {
        BasicAttribute basicAttribute;
        switch (serverGroupProperty) {
            case MEMBERS: {
                basicAttribute = new BasicAttribute(ServerGroupProperty.MEMBERS.getAttributeName());
                for (Object e : (Set)object) {
                    basicAttribute.add(e);
                }
                break;
            }
            default: {
                basicAttribute = new BasicAttribute(serverGroupProperty.getAttributeName(), object);
            }
        }
        return basicAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ServerGroupProperty, Object> makePropertiesFromServerGroupAttrs(Attributes attributes) throws ADSContextException {
        HashMap<ServerGroupProperty, Object> hashMap = new HashMap<ServerGroupProperty, Object>();
        try {
            for (ServerGroupProperty serverGroupProperty : ServerGroupProperty.values()) {
                HashSet<String> hashSet;
                Attribute attribute = attributes.get(serverGroupProperty.getAttributeName());
                if (attribute == null) continue;
                if (attribute.size() >= 1 && MULTIVALUED_SERVER_GROUP_PROPERTIES.contains((Object)serverGroupProperty)) {
                    HashSet<String> hashSet2 = new HashSet<String>();
                    NamingEnumeration<?> namingEnumeration = attribute.getAll();
                    try {
                        while (namingEnumeration.hasMore()) {
                            hashSet2.add((String)namingEnumeration.next());
                        }
                    }
                    finally {
                        namingEnumeration.close();
                    }
                    hashSet = hashSet2;
                } else {
                    hashSet = attribute.get(0);
                }
                hashMap.put(serverGroupProperty, hashSet);
            }
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ServerProperty, Object> makePropertiesFromServerAttrs(Attributes attributes) throws ADSContextException {
        HashMap<ServerProperty, Object> hashMap = new HashMap<ServerProperty, Object>();
        try {
            NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
            while (namingEnumeration.hasMore()) {
                HashSet<String> hashSet;
                Object object;
                Attribute attribute = namingEnumeration.next();
                String string = attribute.getID();
                if (string.endsWith(";binary")) {
                    string = string.substring(0, string.lastIndexOf(";binary"));
                }
                ServerProperty serverProperty = null;
                ServerProperty[] serverPropertyArray = ServerProperty.values();
                for (int i = 0; i < serverPropertyArray.length && serverProperty == null; ++i) {
                    object = serverPropertyArray[i].getAttributeName();
                    if (!string.equalsIgnoreCase((String)object)) continue;
                    serverProperty = serverPropertyArray[i];
                }
                if (serverProperty == null) continue;
                if (attribute.size() >= 1 && MULTIVALUED_SERVER_PROPERTIES.contains((Object)serverProperty)) {
                    HashSet<String> hashSet2 = new HashSet<String>();
                    object = attribute.getAll();
                    try {
                        while (object.hasMore()) {
                            hashSet2.add((String)object.next());
                        }
                    }
                    finally {
                        object.close();
                    }
                    hashSet = hashSet2;
                } else {
                    hashSet = attribute.get(0);
                }
                hashMap.put(serverProperty, hashSet);
            }
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
        }
        return hashMap;
    }

    private Map<AdministratorProperty, Object> makePropertiesFromAdministratorAttrs(String string, Attributes attributes) throws ADSContextException {
        HashMap<AdministratorProperty, Object> hashMap = new HashMap<AdministratorProperty, Object>();
        LdapName ldapName = ADSContext.nameFromDN(string);
        String string2 = ldapName + "," + ADSContext.getAdministratorContainerDN();
        hashMap.put(AdministratorProperty.ADMINISTRATOR_DN, string2);
        NamingEnumeration<? extends Attribute> namingEnumeration = null;
        try {
            namingEnumeration = attributes.getAll();
            while (namingEnumeration.hasMore()) {
                Object object;
                Attribute attribute = namingEnumeration.next();
                String string3 = attribute.getID();
                if (string3.equalsIgnoreCase("cn")) {
                    object = attribute.get(0);
                    hashMap.put(AdministratorProperty.UID, object);
                    continue;
                }
                if (string3.equalsIgnoreCase("userpassword")) {
                    object = new String((byte[])attribute.get());
                    hashMap.put(AdministratorProperty.PASSWORD, object);
                    continue;
                }
                if (string3.equalsIgnoreCase("description")) {
                    object = attribute.get(0);
                    hashMap.put(AdministratorProperty.DESCRIPTION, object);
                    continue;
                }
                if (!string3.equalsIgnoreCase("ds-privilege-name")) continue;
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
                while (namingEnumeration2.hasMoreElements()) {
                    linkedHashSet.add(namingEnumeration2.next().toString());
                }
                hashMap.put(AdministratorProperty.PRIVILEGE, linkedHashSet);
            }
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
        }
        finally {
            this.handleCloseNamingEnumeration(namingEnumeration);
        }
        return hashMap;
    }

    public static String getServerContainerDN() {
        return "cn=Servers," + ADSContext.getAdministrationSuffixDN();
    }

    public static String getAdministratorContainerDN() {
        return "cn=Administrators," + ADSContext.getAdministrationSuffixDN();
    }

    public static String getServerGroupContainerDN() {
        return "cn=Server Groups," + ADSContext.getAdministrationSuffixDN();
    }

    private static String getAllServerGroupDN() {
        return "cn=" + Rdn.escapeValue(ALL_SERVERGROUP_NAME) + "," + ADSContext.getServerGroupContainerDN();
    }

    private static String getHostname(Map<ServerProperty, Object> map) throws ADSContextException {
        String string = (String)map.get((Object)ServerProperty.HOST_NAME);
        if (string == null) {
            throw new ADSContextException(ADSContextException.ErrorType.MISSING_HOSTNAME);
        }
        if (string.length() == 0) {
            throw new ADSContextException(ADSContextException.ErrorType.NOVALID_HOSTNAME);
        }
        return string;
    }

    private static String getServerID(Map<ServerProperty, Object> map) {
        String string = (String)map.get((Object)ServerProperty.ID);
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    private static String getInstallPath(Map<ServerProperty, Object> map) throws ADSContextException {
        String string = (String)map.get((Object)ServerProperty.INSTANCE_PATH);
        if (string == null) {
            throw new ADSContextException(ADSContextException.ErrorType.MISSING_IPATH);
        }
        if (string.length() == 0) {
            throw new ADSContextException(ADSContextException.ErrorType.NOVALID_IPATH);
        }
        return string;
    }

    private static String getAdministratorUID(Map<AdministratorProperty, Object> map) throws ADSContextException {
        String string = (String)map.get((Object)AdministratorProperty.UID);
        if (string == null) {
            throw new ADSContextException(ADSContextException.ErrorType.MISSING_ADMIN_UID);
        }
        return string;
    }

    private static String getAdministratorPassword(Map<AdministratorProperty, Object> map) throws ADSContextException {
        String string = (String)map.get((Object)AdministratorProperty.PASSWORD);
        if (string == null) {
            throw new ADSContextException(ADSContextException.ErrorType.MISSING_ADMIN_PASSWORD);
        }
        return string;
    }

    private static LdapName nameFromDN(String string) throws ADSContextException {
        LdapName ldapName;
        try {
            ldapName = new LdapName(string);
        }
        catch (InvalidNameException invalidNameException) {
            LOG.log(Level.SEVERE, "Error parsing dn " + string, invalidNameException);
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)invalidNameException);
        }
        return ldapName;
    }

    private static String getRdn(String string) throws ADSContextException {
        String string2;
        try {
            CompositeName compositeName = new CompositeName(string);
            string2 = compositeName.get(0);
        }
        catch (InvalidNameException invalidNameException) {
            LOG.log(Level.SEVERE, "Error parsing rdn " + string, invalidNameException);
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)invalidNameException);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExistingEntry(LdapName ldapName) throws ADSContextException {
        boolean bl;
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(0);
            searchControls.setReturningAttributes(new String[]{"1.1"});
            NamingEnumeration<SearchResult> namingEnumeration = this.getDirContext().search((Name)ldapName, "(objectclass=*)", searchControls);
            bl = false;
            try {
                while (namingEnumeration.hasMore()) {
                    namingEnumeration.next();
                    bl = true;
                }
            }
            finally {
                namingEnumeration.close();
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            bl = false;
        }
        catch (NoPermissionException noPermissionException) {
            throw new ADSContextException(ADSContextException.ErrorType.ACCESS_PERMISSION);
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
        }
        return bl;
    }

    private void createContainerEntry(String string) throws ADSContextException {
        BasicAttributes basicAttributes = new BasicAttributes();
        BasicAttribute basicAttribute = new BasicAttribute("objectclass");
        basicAttribute.add("top");
        basicAttribute.add("ds-cfg-branch");
        basicAttributes.put(basicAttribute);
        this.createEntry(string, basicAttributes);
    }

    private void createAdministratorContainerEntry() throws ADSContextException {
        BasicAttributes basicAttributes = new BasicAttributes();
        BasicAttribute basicAttribute = new BasicAttribute("objectclass");
        basicAttribute.add("groupofurls");
        basicAttributes.put(basicAttribute);
        basicAttributes.put("memberURL", "ldap:///" + ADSContext.getAdministratorContainerDN() + "??one?(objectclass=*)");
        basicAttributes.put("description", "Group of identities which have full access.");
        this.createEntry(ADSContext.getAdministratorContainerDN(), basicAttributes);
    }

    private void createTopContainerEntry() throws ADSContextException {
        BasicAttributes basicAttributes = new BasicAttributes();
        BasicAttribute basicAttribute = new BasicAttribute("objectclass");
        basicAttribute.add("top");
        basicAttribute.add("ds-cfg-branch");
        basicAttributes.put(basicAttribute);
        this.createEntry(ADSContext.getAdministrationSuffixDN(), basicAttributes);
    }

    private void createEntry(String string, Attributes attributes) throws ADSContextException {
        try {
            DirContext dirContext = this.getDirContext().createSubcontext(ADSContext.nameFromDN(string), attributes);
            dirContext.close();
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
        }
    }

    public void createAdministrationSuffix(String string) throws ADSContextException {
        ADSContextHelper aDSContextHelper = new ADSContextHelper();
        String string2 = string;
        if (string == null) {
            string2 = ADSContext.getDefaultBackendName();
        }
        aDSContextHelper.createAdministrationSuffix(this.getDirContext(), string2);
    }

    public static String getDefaultBackendName() {
        return "adminRoot";
    }

    public static String getAdminLDIFFile() {
        return "config" + File.separator + "admin-backend.ldif";
    }

    public static String getInstanceKeysContainerDN() {
        return "cn=instance keys," + ADSContext.getAdministrationSuffixDN();
    }

    public static String getSecretKeysContainerDN() {
        return "cn=secret keys," + ADSContext.getAdministrationSuffixDN();
    }

    public static boolean isRegistered(ServerDescriptor serverDescriptor, Set<Map<ServerProperty, Object>> set) {
        boolean bl = false;
        for (Map<ServerProperty, Object> map : set) {
            ServerDescriptor serverDescriptor2 = ServerDescriptor.createStandalone(map);
            if (!serverDescriptor2.getId().equals(serverDescriptor.getId())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void registerInstanceKeyCertificate(Map<ServerProperty, Object> map, LdapName ldapName) throws ADSContextException {
        ADSContextHelper aDSContextHelper = new ADSContextHelper();
        aDSContextHelper.registerInstanceKeyCertificate(this.dirContext, map, ldapName);
    }

    private void unregisterInstanceKeyCertificate(Map<ServerProperty, Object> map, LdapName ldapName) throws ADSContextException {
        ADSContextHelper aDSContextHelper = new ADSContextHelper();
        aDSContextHelper.unregisterInstanceKeyCertificate(this.dirContext, map, ldapName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, byte[]> getTrustedCertificates() throws ADSContextException {
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        String string = ADSContext.getInstanceKeysContainerDN();
        try {
            ADSContextHelper aDSContextHelper = new ADSContextHelper();
            LdapName ldapName = new LdapName(string);
            String string2 = "(objectclass=" + aDSContextHelper.getOcCryptoInstanceKey() + ")";
            String string3 = "(!(" + aDSContextHelper.getAttrCryptoKeyCompromisedTime() + "=*))";
            String string4 = "(&" + string2 + string3 + ")";
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(1);
            String[] stringArray = new String[]{ServerProperty.INSTANCE_KEY_ID.getAttributeName(), ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE.getAttributeName() + ";binary"};
            searchControls.setReturningAttributes(stringArray);
            NamingEnumeration<SearchResult> namingEnumeration = this.dirContext.search((Name)ldapName, string4, searchControls);
            try {
                while (namingEnumeration.hasMore()) {
                    SearchResult searchResult = namingEnumeration.next();
                    Attributes attributes = searchResult.getAttributes();
                    Attribute attribute = attributes.get(stringArray[0]);
                    Attribute attribute2 = attributes.get(stringArray[1]);
                    if (null == attribute || null == attribute2) continue;
                    hashMap.put((String)attribute.get(), (byte[])attribute2.get());
                }
            }
            finally {
                namingEnumeration.close();
            }
        }
        catch (NamingException namingException) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
        }
        return hashMap;
    }

    public void mergeWithRegistry(ADSContext aDSContext) throws ADSContextException {
        try {
            this.mergeAdministrators(aDSContext);
            this.mergeServerGroups(aDSContext);
            this.mergeServers(aDSContext);
        }
        catch (ADSContextException aDSContextException) {
            Message message = QuickSetupMessages.ERR_ADS_MERGE.get(ConnectionUtils.getHostPort(this.getDirContext()), ConnectionUtils.getHostPort(aDSContext.getDirContext()), aDSContextException.getMessageObject());
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_MERGING, message, aDSContextException);
        }
    }

    private void mergeAdministrators(ADSContext aDSContext) throws ADSContextException {
        Set<Map<AdministratorProperty, Object>> set = aDSContext.readAdministratorRegistry();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Map<AdministratorProperty, Object> map : set) {
            String string = (String)map.get((Object)AdministratorProperty.UID);
            if (this.isAdministratorAlreadyRegistered(string)) continue;
            treeSet.add(string);
        }
        if (!treeSet.isEmpty()) {
            Message message = QuickSetupMessages.ERR_ADS_ADMINISTRATOR_MERGE.get(ConnectionUtils.getHostPort(aDSContext.getDirContext()), ConnectionUtils.getHostPort(this.getDirContext()), Utils.getStringFromCollection(treeSet, Constants.LINE_SEPARATOR), ConnectionUtils.getHostPort(this.getDirContext()));
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_MERGING, message, null);
        }
    }

    private void mergeServerGroups(ADSContext aDSContext) throws ADSContextException {
        Set<Map<ServerGroupProperty, Object>> set = this.readServerGroupRegistry();
        Set<Map<ServerGroupProperty, Object>> set2 = aDSContext.readServerGroupRegistry();
        for (Map<ServerGroupProperty, Object> map : set2) {
            Object object;
            Map<ServerGroupProperty, Object> map2 = null;
            String string = (String)map.get((Object)ServerGroupProperty.UID);
            for (Map<ServerGroupProperty, Object> map3 : set) {
                object = (String)map3.get((Object)ServerGroupProperty.UID);
                if (!((String)object).equalsIgnoreCase(string)) continue;
                map2 = map3;
                break;
            }
            if (map2 != null) {
                Map<ServerGroupProperty, Object> map3;
                Set<Object> set3 = this.getServerGroupMemberList(string);
                if (set3 == null) {
                    set3 = new HashSet();
                }
                if ((map3 = aDSContext.getServerGroupMemberList(string)) == null || map3.isEmpty()) continue;
                set3.addAll((Collection<Object>)((Object)map3));
                object = new HashMap();
                object.put(ServerGroupProperty.MEMBERS, set3);
                this.updateServerGroup(string, (Map<ServerGroupProperty, Object>)object);
                continue;
            }
            this.createServerGroup(map);
        }
    }

    private void mergeServers(ADSContext aDSContext) throws ADSContextException {
        Set<Map<ServerProperty, Object>> set = aDSContext.readServerRegistry();
        for (Map<ServerProperty, Object> map : set) {
            if (this.isServerAlreadyRegistered(map)) continue;
            this.registerServer(map);
        }
    }

    private void handleCloseNamingEnumeration(NamingEnumeration<?> namingEnumeration) throws ADSContextException {
        if (namingEnumeration != null) {
            try {
                namingEnumeration.close();
            }
            catch (NamingException namingException) {
                throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)namingException);
            }
        }
    }

    static {
        MULTIVALUED_SERVER_PROPERTIES.add(ServerProperty.GROUPS);
        MULTIVALUED_SERVER_GROUP_PROPERTIES = new HashSet<ServerGroupProperty>();
        MULTIVALUED_SERVER_GROUP_PROPERTIES.add(ServerGroupProperty.MEMBERS);
        nameToAdminUserProperty = null;
    }

    public static enum AdministratorProperty {
        UID("id", ADSPropertySyntax.STRING),
        PASSWORD("password", ADSPropertySyntax.STRING),
        DESCRIPTION("description", ADSPropertySyntax.STRING),
        ADMINISTRATOR_DN("administrator dn", ADSPropertySyntax.STRING),
        PRIVILEGE("privilege", ADSPropertySyntax.STRING);

        private String attrName;
        private ADSPropertySyntax attrSyntax;

        private AdministratorProperty(String string2, ADSPropertySyntax aDSPropertySyntax) {
            this.attrName = string2;
            this.attrSyntax = aDSPropertySyntax;
        }

        public String getAttributeName() {
            return this.attrName;
        }

        public ADSPropertySyntax getAttributeSyntax() {
            return this.attrSyntax;
        }
    }

    public static enum ServerGroupProperty {
        UID("cn"),
        DESCRIPTION("description"),
        MEMBERS("uniqueMember");

        private String attrName;

        private ServerGroupProperty(String string2) {
            this.attrName = string2;
        }

        public String getAttributeName() {
            return this.attrName;
        }
    }

    public static enum ServerProperty {
        ID("id", ADSPropertySyntax.STRING),
        HOST_NAME("hostname", ADSPropertySyntax.STRING),
        LDAP_PORT("ldapport", ADSPropertySyntax.INTEGER),
        JMX_PORT("jmxport", ADSPropertySyntax.INTEGER),
        JMXS_PORT("jmxsport", ADSPropertySyntax.INTEGER),
        LDAPS_PORT("ldapsport", ADSPropertySyntax.INTEGER),
        ADMIN_PORT("adminport", ADSPropertySyntax.INTEGER),
        CERTIFICATE("certificate", ADSPropertySyntax.STRING),
        INSTANCE_PATH("instancepath", ADSPropertySyntax.STRING),
        DESCRIPTION("description", ADSPropertySyntax.STRING),
        HOST_OS("os", ADSPropertySyntax.STRING),
        LDAP_ENABLED("ldapEnabled", ADSPropertySyntax.BOOLEAN),
        LDAPS_ENABLED("ldapsEnabled", ADSPropertySyntax.BOOLEAN),
        ADMIN_ENABLED("adminEnabled", ADSPropertySyntax.BOOLEAN),
        STARTTLS_ENABLED("startTLSEnabled", ADSPropertySyntax.BOOLEAN),
        JMX_ENABLED("jmxEnabled", ADSPropertySyntax.BOOLEAN),
        JMXS_ENABLED("jmxsEnabled", ADSPropertySyntax.BOOLEAN),
        LOCATION("location", ADSPropertySyntax.STRING),
        GROUPS("memberofgroups", ADSPropertySyntax.STRING),
        INSTANCE_KEY_ID("ds-cfg-key-id", ADSPropertySyntax.STRING),
        INSTANCE_PUBLIC_KEY_CERTIFICATE("ds-cfg-public-key-certificate", ADSPropertySyntax.CERTIFICATE_BINARY);

        private String attrName;
        private ADSPropertySyntax attSyntax;

        private ServerProperty(String string2, ADSPropertySyntax aDSPropertySyntax) {
            this.attrName = string2;
            this.attSyntax = aDSPropertySyntax;
        }

        public String getAttributeName() {
            return this.attrName;
        }

        public ADSPropertySyntax getAttributeSyntax() {
            return this.attSyntax;
        }
    }

    public static enum ADSPropertySyntax {
        STRING,
        INTEGER,
        BOOLEAN,
        CERTIFICATE_BINARY;

    }
}

