package GraphAlgorithm;
import java.awt.*;

class Node{
  public int x, y;
  public Color color;
  public boolean exists;

  public Node(int xcoord, int ycoord){
     x = xcoord;
     y = ycoord;
     exists = true;
     color = Color.gray;
  }
  public Node(Node node){
     x = node.x;
     y = node.y;
     exists = node.exists;
     color = node.color;
  }
  public Node(){
     exists = false;
  }
}

class EdgeClass {
  public Color color;
  public int w; //weight
  public boolean exists;
  private int INF2 = 9999;

  public EdgeClass(int weight) {
    exists = (weight==INF2) ? false : true;
    color = Color.black;
    w = weight;
  }
}

class Set {
  boolean node[];
  public int count;

  public Set(int numnodes) {
    node = new boolean[numnodes];
    for(int i=0; i<numnodes; i++)
      node[i] = false;
    count = 0;
  }

  public void add(int vertex){
    count = node[vertex] ? count : count+1;
    node[vertex] = true;
  }

  public void remove(int vertex){
    count = node[vertex] ? count-1 : count;
    node[vertex] = false;
  }

  public boolean contains(int vertex){
    return(node[vertex]);
  }
}