package GraphAlgorithm;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;

class Documentation extends Panel {
// Documentation on top of the screen
    DocOptions docopt = new DocOptions(this);
    DocText doctext = new DocText();

    Documentation() {
	setLayout(new BorderLayout(0, 0));
	add("West", docopt);
	add("Center", doctext);
    }
}

class DocOptions extends Panel {
    public String Methodstr = "Dijkstra";
    public String Graphstr = "Shortest path";
    CheckboxGroup MethodGroup = new CheckboxGroup();
    CheckboxGroup GraphGroup = new CheckboxGroup();
    Documentation parent;

    DocOptions(Documentation myparent) {
        setLayout(new GridLayout(3, 2));
	parent = myparent;
        Checkbox dummy_checkbox;
	add(new Checkbox("Dijkstra", MethodGroup, true));
	add(new Checkbox("Shortest path", GraphGroup, true));
	add(new Checkbox("BFS", MethodGroup, false));
	add(new Checkbox("Disjoint edge", GraphGroup, false));
	add(dummy_checkbox = new Checkbox(null));
	add(new Checkbox("Disjoint vertex", GraphGroup, false));
        dummy_checkbox.setVisible(false);
        dummy_checkbox.setEnabled(false);
    }

    public boolean action(Event evt, Object arg) {
      if (evt.target instanceof Checkbox) {
        Methodstr= MethodGroup.getSelectedCheckbox().getLabel();
        Graphstr = GraphGroup.getSelectedCheckbox().getLabel();
        parent.doctext.showline("Selected algorithm: "+Methodstr+
        "\nSelected graph: "+Graphstr);
      }
      return true;
    }
}

class DocText extends TextArea {
    final String drawnodes = new String("DRAWING NODES:\n"+
	  "Draw a node by clicking the mouse.\n\n");
    final String rmvnodes = new String("REMOVE NODES:\n"+
	  "To remove a node press <ctrl> and click on the node.\n"+
	  "You can not remove the startnode or endnode.\n"+
	  "Select another start/endnode, then you can remove the node.\n\n");
    final String mvnodes = new String("MOVING NODES\n"+
	  "To move a node press <Shift>, click on the node,\nand drag it to"+
	  " its new position.\n\n");
    final String startnode = new String("STARTNODE, ENDNODE:\n"+
	  "The startnode is blue, endnode is green, other nodes are grey.\n"+
	  "The first node you draw on the screen will be the startnode.\n"+
	  "The second node will be the endnode. To select another\n"+
	  "start/endnode press <ctrl>, click on the start/endnode, and \n"+
	  "drag the mouse to another node. To delete the start/endnode,\n"+
	  "first move it to another node, and then remove it the usual way."+
	  "\n\n");
    final String drawarrows = new String("DRAWING EDGES:\n"+
	  "To draw an edge click mouse in a node, "+
	  "and drag it to another node.\n\n");
    final String weight = new String("CHANGING WEIGHTS:\n"+
	  "To change the weight of an edge, click on the handle and drag\n"+
	  "it along the edge.\n\n");
    final String rmvarrows = new String("REMOVE EDGES:\n"+
	  "To remove an edge press <ctrl> and click on the handle.\n\n");
    final String clrreset = new String("<CLEAR> BUTTON: "+
	  "Remove the current graph from the screen.\n\n"+
	  "<RESET> BUTTON: "+
	  "Remove the results of the algorithm from the graph,\n"+
	  " and unlock screen.\n\n");
    final String runalg = new String("<RUN> BUTTON: "+
	  "Run the algorithm on the graph.\n\n");
    final String example = new String("<EXAMPLE> BUTTON: "+
	  "Displays a graph on the screen for you.\n"+
	  "You can then use <RUN>\n\n");
    final String toclose = new String("ERROR: "+
	  "This position is too close to another node or edge.\n");
    final String spfound = new String("Shortest path has been found. It is "+
	  "shown by the yellow edges.\nThe length of the path is written "+
	  "in the nodes.\nGray nodes were not traversed during calculation.\n"+
          "Press <RESET> to reset the graph, or <CLEAR> to clear the screen.");
    final String mpfound = new String("Disjoint path has been found. It is "+
	  "shown by the red and blue edges.\nThe path length is written "+
	  "in the nodes in reverse order, and the startnode shows\ncombined "+
          "path length. Gray nodes were not traversed during calculation.\n"+
          "Press <RESET> to reset the graph, or <CLEAR> to clear the screen.");
    final String spnotfound = new String("ERROR: "+
          "There is no path available between startnode and endnode.\n" +
          "Press <RESET> to reset the graph, or <CLEAR> to clear the screen.");
    final String mpnotfound = new String("Modified path has NOT been found.\n"+
          "Disjoint path from the startnode to endnode is not available.\n"+
          "Press <RESET> to reset the graph, or <CLEAR> to clear the screen.");
    final String maxnodes = new String("ERROR: "+
	  "Maximum number of nodes reached!\n\n");
    final String info = new String("DOCUMENTATION:\n"+
	  "You can scroll the documentation, or read the documentation\n"+
	  "as it appears while work with the graph.\nSelecting <RESET> "+
	  "brings you back to the scrolling text.\n\n");
    final String locked = new String("ERROR: "+
	  "Keyboard/mouse locked for this action.\n"+
	  "Either press <RESET> or <CLEAR>.\n");
    final String cannotsplit = new String("ERROR: "+
	  "Cannot run the algorithm. Too many nodes in the graph.\n"+
          "# of nodes + nodes in shortest path must be less than "+
          "or equal to MAX(20).\n"+
          "Press <RESET> to reset the graph, or <CLEAR> to clear the screen.");
    final String method = new String("METHOD: "+
	  "You can select the shortest path method using the radiobuttons "+
	  "on the left.\nSelect either Dijkstra or Breath-First-Search,\n"+
	  "and select either shortest path, disjoint edge or disjoint "+
	  "vertex.\n\n");

    final String doc = info + method + drawnodes + rmvnodes + mvnodes +
		       startnode + drawarrows + weight + rmvarrows +
		       clrreset + runalg + example;

    DocText() {
	super(5, 2);
	setText(doc);
    }

    public void showline(String str) {
	if (str.equals("draw nodes"))              setText(drawnodes);
	else if (str.equals("remove nodes"))       setText(rmvnodes);
	else if (str.equals("move nodes"))         setText(mvnodes);
	else if (str.equals("the startnode"))      setText(startnode);
	else if (str.equals("draw arrows"))        setText(drawarrows);
	else if (str.equals("change weights"))     setText(weight);
	else if (str.equals("remove arrows"))      setText(rmvarrows);
	else if (str.equals("clear / reset"))      setText(clrreset);
	else if (str.equals("run algorithm"))      setText(runalg);
	else if (str.equals("example"))            setText(example);
	else if (str.equals("all items"))          setText(doc);
	else if (str.equals("toclose"))            setText(toclose);
	else if (str.equals("locked"))             setText(locked);
	else if (str.equals("maxnodes"))           setText(maxnodes);
        else if (str.equals("cannot split"))       setText(cannotsplit);
	else if (str.equals("sp found"))           setText(spfound);
	else if (str.equals("modpathfound"))       setText(mpfound);
        else if (str.equals("sp notfound"))        setText(spnotfound);
        else if (str.equals("no mod. path"))       setText(mpnotfound);
	else setText(str);
    }
}
