package GraphAlgorithm;

import java.awt.*;

class GraphCanvas extends Canvas {
// drawing area for the graph

    int debug = 0;          //debug level 0..2, 0 = no debug
    final int MAX = 20;     // maximum number of vertices (nodes)
    final int NODESIZE = 24;
    final int NODERADIX = 12;
    final int DIJKSTRA = 1;
    final int MODIFIED_DIJKSTRA = 2;
    final int INF  = 10000; //Distances
    final int INF2 = 9999;  // non-existent edge

    // basic graph information
    Node node[] = new Node[MAX];
    EdgeClass edge[][] = new EdgeClass[MAX][MAX];     // weight of arrow
    Point arrow[][] = new Point[MAX][MAX];  // current position of arrowhead
    Point startp[][] = new Point[MAX][MAX]; // start and
    Point endp[][] = new Point[MAX][MAX];   // endpoint of arrow
    float dir_x[][] = new float[MAX][MAX];  // direction of arrow
    float dir_y[][] = new float[MAX][MAX];  // direction of arrow

    // graph information while running algorithm
    boolean algedge[][] = new boolean[MAX][MAX];
    int dist[] = new int[MAX];
    int P[] = new int[MAX];  // Predecessors
    // int Pshort[] = new int[MAX];  // Predecessors for modified path
    int Z[][] = new int[2][MAX];  // predecessors for both paths
    int dj_path[][] = new int[2][MAX];  // edge-disjoint paths
    int newnodes[] = new int[MAX];
    int finaldist[] = new int[MAX];
    boolean changed[] = new boolean[MAX];   // indicates distance change during algorithm
    int numchanged =0;
    int neighbours=0;

    int numnodes=0;      // number of nodes
    int emptyspots=0;    // empty spots in array node[] (due to node deletion)
    int startgraph=0;    // start of graph
    int endgraph=1;      // end of graph
    int hitnode;         // mouse clicked on or close to this node
    int node1, node2;    // numbers of nodes involved in current action

    Point thispoint=new Point(0,0); // current mouseposition
    Node oldpoint;       // previous position of node being moved

    // current action
    boolean newarrow = false;
    boolean movearrow = false;
    boolean movestart = false;
    boolean moveend = false;
    boolean deletenode = false;
    boolean deletearrow = false;
    boolean movenode = false;
    boolean clicked = false;

    // fonts
    Font roman= new Font("TimesRoman", Font.BOLD, 12);
    Font helvetica= new Font("Helvetica", Font.BOLD, 15);
    FontMetrics fmetrics = getFontMetrics(roman);
    int h = (int)fmetrics.getHeight()/3;

    // for double buffering
    private Image offScreenImage;
    private Graphics offScreenGraphics;
    private Dimension offScreenSize;

   // Thread algrthm;
    // current algorithm, (in case more algorithms are added)
    int algorithm;
    // algorithm information to be displayed in documentation panel
    String showstring = new String("");
  //  boolean stepthrough=false;
    // locking the screen while running the algorithm
    boolean Locked = false;
    GraphAlgorithm parent;

    GraphCanvas(GraphAlgorithm myparent) {
       	if(debug>0) System.out.println("GraphCanvas");
	parent = myparent;
	for(int i=0; i<MAX; i++){
          node[i] = new Node();
	  for (int j=0; j<MAX;j++)
            edge[i][j] = new EdgeClass(INF2);
        }
	init();
	//algorithm = DIJKSTRA;
	algorithm = MODIFIED_DIJKSTRA;  // pois !!!!!!!!!!!!!!!
	setBackground(Color.white);
    }

    public void lock() {
    // lock screen while running an algorithm
       	if(debug>0) System.out.println("lock");
	Locked=true;
    }

    public void unlock() {
       	if(debug>0) System.out.println("unlock");
	Locked=false;
    }

    public void init() {
       	if(debug>0) System.out.println("init");
	for (int i=0;i<MAX;i++) {
          node[i].color = Color.gray;
          dist[i] = INF2;
          P[i] = startgraph;
	  for (int j=0; j<MAX;j++)
	    if(i<2)
              Z[i][j]=INF;
	}
        node[startgraph].color = Color.blue;
        node[endgraph].color = Color.green;
    }

    public void clear() {
    // removes graph from screen
       	if(debug>0) System.out.println("clear");
	startgraph=0;
	endgraph=1;
	numnodes=0;
	emptyspots=0;
	init();
	for(int i=0; i<MAX; i++) {
          node[i] = new Node();
	  for (int j=0; j<MAX;j++)
	    edge[i][j] = new EdgeClass(INF2);
	}
	parent.unlock();
	repaint();
    }

    public void reset() {
    // resets a graph after running an algorithm
       	if(debug>0) System.out.println("reset");
	init();
	for (int i=0;i<MAX;i++)
	  for (int j=0; j<MAX;j++)
            edge[i][j].color = Color.black;
        parent.unlock();
	repaint();
    }

    public void runalg() {
      // gives an animation of the algorithm
      if(debug>0) System.out.println("runalg");
      if(numnodes == 0) return; //empty graph: why bother.
      boolean sp_found=false, mod_path_found=false;
      int sp_length=0;  // length of shortest path
      int old_numnodes=0, old_emptyspots=0;
      boolean can_do_split_vertices = false;

      parent.lock();
      initalg();
      if(parent.documentation.docopt.Methodstr.equals("Dijkstra"))
        sp_found = ModifiedDijkstra(edge);
      else if(parent.documentation.docopt.Methodstr.equals("BFS"))
        sp_found = BFS(edge);

      // Make reached nodes orange
      for (int i=0; i<numnodes; i++)
        if(dist[i] < INF2 && i!=startgraph && i!=endgraph)
          node[i].color = Color.orange;

      // The algorithms find shortest path tree for
      // almost all vertices, so we must extract the shortest path
      // between startgraph and endgraph (A-Z). This is placed in Z[0].
      // Shortest path is orange.
      // Also count the shortest path length in reverse order.
      for (int i=0; i<numnodes; i++)
        dist[i] = INF2;
      if( sp_found ) {
        int i = endgraph;
        dist[i] = 0;
        while(i!=startgraph){
          if(parent.documentation.docopt.Graphstr.equals("Shortest path")){
            edge[P[i]][i].color = Color.orange;
            edge[i][P[i]].color = Color.orange;
            dist[P[i]] = edge[P[i]][i].w + dist[i];
          }
          Z[0][i] = P[i];
          i = P[i];
          sp_length++;
        }
        Z[0][i] = startgraph;
      }
      repaint();

      if (!sp_found) {
         // no path available between start and end. Bail out.
          parent.documentation.doctext.showline("sp notfound");
          return;
      }
      //that's all if only shortest path was required
      if(parent.documentation.docopt.Graphstr.equals("Shortest path")){
//	if(sp_found)
          parent.documentation.doctext.showline("sp found");
//        else
//          parent.documentation.doctext.showline("sp notfound");
        return;
      }
      //else we continue with disjoint paths

      //Make copy of edges and predecessors
      EdgeClass modifiededge[][] = new EdgeClass[MAX][MAX];
      for (int i=0; i<MAX; i++){
        //Pshort[i] = P[i];
        for (int j=0; j<MAX; j++)
          modifiededge[i][j] = new EdgeClass(edge[i][j].w);
      }

      if(parent.documentation.docopt.Graphstr.equals("Disjoint edge"))
        //modify graph by reversing the shortest path
        reverse_sp(modifiededge);
      else if(numnodes - emptyspots + sp_length - 1 > MAX){
        // not enough space to do splitting. Results into too many nodes.
        // The maximum is: number of nodes plus nodes in shortest path
        // must not exceed MAX (due to node splitting).
        parent.documentation.doctext.showline("cannot split");
        repaint();
        return;
      }
      else{
        // Disjoint vertices
        // modify graph by splitting vertices
        can_do_split_vertices  = true;
        old_numnodes = numnodes;      // save these before splitting
        old_emptyspots = emptyspots;  //
        // newnodes[]: positive value means it is a new node,
        // and the value defines the 'parent' vertex
        split_vertices(modifiededge, newnodes);
      }

      // shortest paths again for modified graph
      for (int i=0; i<numnodes; i++)
        dist[i] = INF2;
      dist[startgraph] = 0;
      if(parent.documentation.docopt.Methodstr.equals("Dijkstra"))
        mod_path_found = ModifiedDijkstra(modifiededge);
      else if(parent.documentation.docopt.Methodstr.equals("BFS"))
        mod_path_found = BFS(modifiededge);

      // Coalesce split vertices. Handle their predecessors too.
      if(can_do_split_vertices){
        for (int i=0; i<numnodes; i++)
          if(newnodes[i] >= 0)
            node[i] = new Node();
        numnodes = old_numnodes;
        emptyspots = old_emptyspots;
        int i=endgraph, tmp=0;
        while(i!=startgraph){
          if(newnodes[P[i]] >=0){
            tmp = P[i]; // new node as result of splitting
            P[i] = newnodes[tmp];
            P[P[i]] = P[tmp];
          }
          i = P[i];
        }
      }

      // Extract the modified shortest path between
      // startgraph and endgraph into Z[1]
      if(mod_path_found) {
        int i = endgraph;
        while(i!=startgraph){
          Z[1][i] = P[i];
          i = P[i];
        }
        Z[1][i] = startgraph;
      }
      // Clear distances but not for endgraph.
      // Also again make reached nodes orange.
      for (int i=0; i<numnodes; i++)
        if(dist[i] < INF2 && i!=startgraph && i!=endgraph){
          node[i].color = Color.orange;
          dist[i] = INF;
      }

      //Create the edge-disjoint paths
      dj_path[0] = create_dpaths(Z,0);
      dj_path[1] = create_dpaths(Z,1);
      //Make paths between startnode and endnode orange and red
      if(sp_found) {
        int i = endgraph;
        dist[endgraph] = 0;
        while(i!=startgraph){
          edge[dj_path[0][i]][i].color = Color.red;
          edge[i][dj_path[0][i]].color = Color.red;
          dist[dj_path[0][i]] = dist [i] + edge[dj_path[0][i]][i].w;
          i = dj_path[0][i];
        }
      }
      if (mod_path_found){
        int tmp = dist[startgraph];
        int i = endgraph;
        while(i!=startgraph){
          edge[dj_path[1][i]][i].color = Color.blue;
          edge[i][dj_path[1][i]].color = Color.blue;
          dist[dj_path[1][i]] = dist [i] + edge[dj_path[1][i]][i].w;
          i = dj_path[1][i];
        }
        dist[startgraph] += tmp; // this is sum of both paths
        parent.documentation.doctext.showline("modpathfound");
      }
      else {
        parent.documentation.doctext.showline("no mod. path");
      }
      repaint();
    } // runalg

    public void split_vertices(EdgeClass myedge[][], int splits[]){
      // splits[]: positive value means it is a new node,
      // and the value defines the 'parent' vertex
      if(debug>0) System.out.println("split_vertices");
      int i=endgraph;
      while(P[i] != startgraph){
        int j;
        if(emptyspots==0){
          node[numnodes] = new Node(node[P[i]].x+NODESIZE, node[P[i]].y);
          splits[numnodes] = P[i];
          j = numnodes++;
        }
        else{
          for(j=0;j<numnodes;j++)
            if(!node[j].exists) break;
          node[j]=new Node(node[P[i]].x+NODESIZE, node[P[i]].y);
          emptyspots--;
          splits[j] = P[i];
        }
        myedge[i][j] = new EdgeClass(-myedge[i][P[i]].w);
        myedge[i][P[i]] = new EdgeClass(INF2);
        myedge[P[i]][i] = new EdgeClass(INF2);
        myedge[j][P[i]] = new EdgeClass(0);

        //Now split edges connecting to other vertices
        // but not the edges in shortest path
        for(int k=0;k<numnodes;k++)
          if(myedge[k][P[i]].exists && k!=j && k!=P[P[i]]){
            myedge[P[i]][k] = new EdgeClass(INF2);
            myedge[j][k] = new EdgeClass(myedge[k][P[i]].w);
          }
        i = P[i];
      }//while
      // finally do the edge between startgraph and first vertex
      myedge[P[i]][i] = new EdgeClass(INF2);
      myedge[i][P[i]] = new EdgeClass(-myedge[i][P[i]].w);
    } //split_vertices()

    public int[] create_dpaths(int z[][], int which){
      // this returns one disjoint path. Which one, depends on the parameter
      if(debug>0) System.out.println("create_dpaths");
      int a=which, b;  // a is this graph, that we start with
      b = (a==0) ? 1 : 0;   // b is the other graph
      int path[] = new int[MAX];  // first edge-disjoint path
      for(int i=0;i<numnodes;i++)
        path[i] = startgraph;
      if(dist[endgraph] < INF2) {
        int r = endgraph;
        do {
          if( z[b][r] < INF && z[b][z[a][r]]==r){
            path[r] = z[b][r];
            r = z[b][r];
            int tmp=a; a=b; b=tmp; // jump to the other graph
          }
          else {
            path[r] = z[a][r];
            r = z[a][r];
          }
        } while(r!=startgraph);
      }
      return(path);
    }

    public void initalg() {
       	if(debug>0) System.out.println("initalg");
	init();
	for(int i=0; i<MAX; i++) {
	  dist[i]=INF;
          newnodes[i] = -1;
	  finaldist[i]=INF;
	  for (int j=0; j<MAX;j++)
              algedge[i][j]=false;
	}
        dist[startgraph]=0;
	finaldist[startgraph]=0;
    }

    public void showexample() {
    // draws a graph on the screen
       	if(debug>0) System.out.println("showexample");
	int w, h;
	clear();
        endgraph=5;
	numnodes=6;
	emptyspots=0;
	w=this.getSize().width/8;
	h=this.getSize().height/8;
	node[0]=new Node(w, 4*h);     node[1]=new Node(3*w, h);
	node[2]=new Node(3*w, 4*h);   node[3]=new Node(5*w, 4*h);
	node[4]=new Node(5*w, 7*h);   node[5]=new Node(7*w, 4*h);

        node[startgraph].color = Color.blue;
        node[endgraph].color = Color.green;

	edge[0][1] = new EdgeClass(50); edge[1][0] = new EdgeClass(50);
        edge[0][2] = new EdgeClass(10); edge[2][0] = new EdgeClass(10);
        edge[1][3] = new EdgeClass(50); edge[3][1] = new EdgeClass(50);
	edge[2][4] = new EdgeClass(50); edge[4][2] = new EdgeClass(50);
        edge[2][3] = new EdgeClass(10); edge[3][2] = new EdgeClass(10);
	edge[3][5] = new EdgeClass(10); edge[5][3] = new EdgeClass(10);
        edge[4][5] = new EdgeClass(50); edge[5][4] = new EdgeClass(50);

	for (int i=0;i<numnodes;i++)
	   //for (int j=i;j<numnodes;j++)
	   for (int j=0;j<numnodes;j++)
	      if (edge[i][j].exists)
	         arrowupdate(i, j, edge[i][j].w);
	repaint();
    }

    public boolean mouseDown(Event evt, int x, int y) {
       	if(debug>0) System.out.println("mousedown");
	if (Locked)
	  parent.documentation.doctext.showline("locked");
	else {
	  clicked = true;
	  if (evt.shiftDown()) {
	    // move a node
	    if (nodehit(x, y, NODESIZE)) {
	      oldpoint = new Node(node[hitnode]);
	      node1 = hitnode;
	      movenode=true;
	    }
	  } // evt.shiftDown()
	  else if (evt.controlDown()) {
	  // delete a node or edge, or move startnode or endnode
	    if (nodehit(x, y, NODERADIX)) {
	      node1 = hitnode;
	      if (startgraph==node1) {  //can change startnode
	        movestart=true;
	        thispoint = new Point(x,y);
                node[startgraph].color=Color.gray;
	      }
	      else if (endgraph==node1) {  //can change endnode
	        moveend=true;
	        thispoint = new Point(x,y);
                node[endgraph].color=Color.gray;
	      }
	      else
	        deletenode = true;
	    }
            else if(arrowhit(x, y, 10)){
                deletearrow = true;
            }
	  }  //evt.controlDown()
	  else if (arrowhit(x, y, 10)) {
	  // change weight of an edge
	     movearrow = true;
	     repaint();
	  }
	  else if (nodehit(x, y, NODESIZE)) {
	    // draw a new arrow
	    if (!newarrow) {
	      newarrow = true;
	      thispoint = new Point(x, y);
	      node1 = hitnode;
	    }
	  }
	  else if ( !nodehit(x, y, 50) && !arrowhit(x, y, 50) )  {
	    // draw new node
	    if (emptyspots==0) {
	      // take the next available spot in the array
	      if (numnodes < MAX)
	        node[numnodes++]=new Node(x, y);
	      else parent.documentation.doctext.showline("maxnodes");
	    }
	    else {
	      // take an empty spot in the array (from previously deleted node)
	      int i;
	      for (i=0;i<numnodes;i++)
	        if (!node[i].exists) break;
	      node[i]=new Node(x, y);
	      emptyspots--;
	    }
            node[startgraph].color = Color.blue;
            node[endgraph].color = Color.green;
	  } // !nodehit(
	  else
	    // mouseclick to close to a point or arrowhead, so probably an error
	    parent.documentation.doctext.showline("toclose");
	  repaint();
	}
	return true;
    } // mousedown

    public boolean mouseDrag(Event evt, int x, int y) {
       	if(debug>1) System.out.println("mouseDrag");
	if ( (!Locked) && clicked ) {
	   if (movenode) {
	   // move node and adjust arrows coming into/outof the node
	      node[node1].x=x;
	      node[node1].y=y;
	      for (int i=0;i<numnodes;i++) {
	         if (edge[i][node1].exists)
	            arrowupdate(i, node1, edge[i][node1].w);
	         if (edge[node1][i].exists)
	            arrowupdate(node1, i, edge[node1][i].w);
	      }
	      repaint();
	   }
	   else if (movestart || moveend || newarrow) {
	      thispoint = new Point(x, y);
	      repaint();
	   }
	   else if (movearrow) {
	      changeedge(x, y);
	      repaint();
	   }
	}
	return true;
    }

    public boolean mouseUp(Event evt, int x, int y) {
       	if(debug>0) System.out.println("mouseUp");
	if ( (!Locked) && clicked ) {
	   if (movenode) {
	   // move the node if the new position is not to close to
	   // another node or outside of the panel
             node[node1] = new Node(-100,-100);
	      if ( nodehit(x, y, 50) || (x<0) || (x>this.getSize().width) ||
                               (y<0) || (y>this.getSize().height) ) {
	         node[node1] = new Node(oldpoint);
	         parent.documentation.doctext.showline("toclose");
	      }
	      else{
                node[node1].x = x;
                node[node1].y = y;
                node[node1].color = oldpoint.color;
   	        parent.documentation.doctext.showline("all items");
              }
	      for (int i=0;i<numnodes;i++) {
	        if (edge[i][node1].exists)
	          arrowupdate(i, node1, edge[i][node1].w);
	        if (edge[node1][i].exists)
	          arrowupdate(node1, i, edge[node1][i].w);
              }
	      movenode=false;
	   } // if(movenode)
	   else if (deletenode) {
              //check that pressed and released over same node
              if(nodehit(x, y, NODERADIX))
                if(hitnode == node1)
	          nodedelete();
	      deletenode=false;
	   }
	   else if (deletearrow) {
             //check that pressed and released over same arrow
             int oldnode1 = node1, oldnode2 = node2;
              if(arrowhit(x, y, 10) && node1==oldnode1 && node2==oldnode2){
                edge[node1][node2] = new EdgeClass(INF2);
                edge[node2][node1] = new EdgeClass(INF2);
              }
              deletearrow = false;
           }
	   else if (newarrow) {
	      newarrow = false;
	      if (nodehit(x, y, NODESIZE)) {
	         node2=hitnode;
	         if (node1!=node2) {
                    int tmp = edge[node1][node2].exists ? edge[node1][node2].w : 50;
	            arrowupdate(node1, node2, tmp);
	            arrowupdate(node2, node1, tmp);
	            parent.documentation.doctext.showline("change weights");
	         }
	      }
	   }
	   else if (movearrow) {
	      movearrow = false;
	      if (edge[node1][node2].exists)
	         changeedge(x, y);
	   }
	   else if (movestart) {
	   // if new position is a node, this node becomes the startnode
	      if (nodehit(x, y, NODESIZE) && hitnode != endgraph)
	         startgraph=hitnode;
	      node[startgraph].color=Color.blue;
	      movestart=false;
	   }
	   else if (moveend) {
	   // if new position is a node, this node becomes the endnode
	      if (nodehit(x, y, NODESIZE) && hitnode != startgraph)
	         endgraph=hitnode;
              node[endgraph].color=Color.green;
	      moveend=false;
	   }
	   repaint();
	}
	return true;
    }

    public boolean nodehit(int x, int y, int dist) {
    // checks if you hit a node with your mouseclick
       	if(debug>0) System.out.println("nodehit");
	for (int i=0; i<numnodes; i++)
	  if ( (x-node[i].x)*(x-node[i].x) +
				(y-node[i].y)*(y-node[i].y) < dist*dist ) {
	     hitnode = i;
	     return true;
	  }
	return false;
    }

    public boolean arrowhit(int x, int y, int dist) {
    // checks if you hit an arrow with your mouseclick
       	if(debug>0) System.out.println("arrowhit");
	for (int i=0; i<numnodes; i++)
	  for (int j=i; j<numnodes; j++) {
	     if ( ( edge[i][j].exists ) &&(Math.pow(x-arrow[i][j].x, 2) +
			 Math.pow(y-arrow[i][j].y, 2) < Math.pow(dist, 2) ) ) {
	        node1 = i;
	        node2 = j;
	        return true;
	     }
	  }
	return false;
    }

    public void nodedelete() {
    // delete a node and the arrows coming into/outof the node
       	if(debug>0) System.out.println("nodedelete");
	node[node1]=new Node();
	for (int j=0;j<numnodes;j++) {
	   edge[node1][j] = new EdgeClass(INF2);
	   edge[j][node1] = new EdgeClass(INF2);
	}
	emptyspots++;
    }

    public void changeedge(int x, int y) {
    // changes the edge of an arrow (edge in the graph), when a user drags
    // the arrowhead over the edge connecting node node1 and node2.
       	if(debug>0) System.out.println("changeedge");

	// direction of the arrow
	int diff_x = (int)(20*dir_x[node1][node2]);
	int diff_y = (int)(20*dir_y[node1][node2]);

	// depending on the arrow direction, follow the x, or the y
	// position of the mouse while the arrowhead is being dragged
	boolean follow_x=false;
	   if (Math.abs(endp[node1][node2].x-startp[node1][node2].x) >
		     Math.abs(endp[node1][node2].y-startp[node1][node2].y) ) {
	   follow_x = true;
	}

	// find the new position of the arrowhead, and calculate
	// the corresponding edge
	if (follow_x) {
	    int hbound = Math.max(startp[node1][node2].x,
				  endp[node1][node2].x)-Math.abs(diff_x);
	    int lbound = Math.min(startp[node1][node2].x,
				  endp[node1][node2].x)+Math.abs(diff_x);

	    // arrow must stay between the nodes
	    if (x<lbound) { arrow[node1][node2].x=lbound; }
	    else if (x>hbound) { arrow[node1][node2].x=hbound; }
	    else arrow[node1][node2].x=x;

	    arrow[node1][node2].y=
		(arrow[node1][node2].x-startp[node1][node2].x) *
		    (endp[node1][node2].y-startp[node1][node2].y)/
		        (endp[node1][node2].x-startp[node1][node2].x) +
		startp[node1][node2].y;

	    // new edge
	    edge[node1][node2] = new EdgeClass(
		Math.abs(arrow[node1][node2].x-startp[node1][node2].x-diff_x)*
			100/(hbound-lbound));
	}
	// do the same if you follow y
	else {
	    int hbound = Math.max(startp[node1][node2].y,
			 	  endp[node1][node2].y)-Math.abs(diff_y);
	    int lbound = Math.min(startp[node1][node2].y,
			 	  endp[node1][node2].y)+Math.abs(diff_y);

	    if (y<lbound) { arrow[node1][node2].y=lbound; }
	    else if (y>hbound) { arrow[node1][node2].y=hbound; }
	    else arrow[node1][node2].y=y;
	    arrow[node1][node2].x=
		(arrow[node1][node2].y-startp[node1][node2].y) *
		    (endp[node1][node2].x-startp[node1][node2].x)/
			(endp[node1][node2].y-startp[node1][node2].y) +
		startp[node1][node2].x;

	    edge[node1][node2] = new EdgeClass(
		Math.abs(arrow[node1][node2].y-startp[node1][node2].y-diff_y)*
			100/(hbound-lbound));
	}
        edge[node2][node1] = new EdgeClass(edge[node1][node2].w);
    } //changeedge

    public void arrowupdate(int p1, int p2, int w) {
    // make a new arrow from node p1 to p2 with edge w, or change
    // the edge of the existing arrow to w, calculate the resulting
    // position of the arrowhead
       	if(debug>1) System.out.println("arrowupdate");
	int dx, dy;
	float l;
	edge[p1][p2] = new EdgeClass(w);

	// direction line between p1 and p2
	dx = node[p2].x-node[p1].x;
	dy = node[p2].y-node[p1].y;

	// distance between p1 and p2
	l = (float)( Math.sqrt((float)(dx*dx + dy*dy)));
	dir_x[p1][p2]=dx/l;
	dir_y[p1][p2]=dy/l;

	// calculate the start and endpoints of the arrow,
        startp[p1][p2] = new Point(node[p1].x, node[p1].y);
        endp[p1][p2] = new Point(node[p2].x, node[p2].y);

	// range for arrowhead is not all the way to the start/endpoints
	int diff_x = (int)(Math.abs(20*dir_x[p1][p2]));
	int diff_y = (int)(Math.abs(20*dir_y[p1][p2]));

	// calculate new x-position arrowhead
	if (startp[p1][p2].x>endp[p1][p2].x) {
	   arrow[p1][p2] = new Point(endp[p1][p2].x + diff_x +
           (Math.abs(endp[p1][p2].x-startp[p1][p2].x) - 2*diff_x )*(100-w)/100 , 0);
	}
	else {
	   arrow[p1][p2] = new Point(startp[p1][p2].x + diff_x +
           (Math.abs(endp[p1][p2].x-startp[p1][p2].x) - 2*diff_x )*w/100, 0);
	}

	// calculate new y-position arrowhead
	if (startp[p1][p2].y>endp[p1][p2].y) {
	   arrow[p1][p2].y=endp[p1][p2].y + diff_y +
           (Math.abs(endp[p1][p2].y-startp[p1][p2].y) - 2*diff_y )*(100-w)/100;
	}
	else {
	   arrow[p1][p2].y=startp[p1][p2].y + diff_y +
           (Math.abs(endp[p1][p2].y-startp[p1][p2].y) - 2*diff_y )*w/100;
	}
    } //arrowupdate

    public String intToString(int i) {
        if(debug>2) System.out.println("intToString");
	char c=(char)((int)'a'+i);
	return ""+c;
    }

    public final synchronized void update(Graphics g) {
    // prepare new image offscreen
       	if(debug>1) System.out.println("update");
	Dimension d=getSize();
	if ((offScreenImage == null) || (d.width != offScreenSize.width) ||
			(d.height != offScreenSize.height)) {
	    offScreenImage = createImage(d.width, d.height);
	    offScreenSize = d;
	    offScreenGraphics = offScreenImage.getGraphics();
	}
	offScreenGraphics.setColor(Color.white);
	offScreenGraphics.fillRect(0, 0, d.width, d.height);
	paint(offScreenGraphics);
	g.drawImage(offScreenImage, 0, 0, null);
    }

    public void drawarrow(Graphics g, int i, int j) {
    // draw arrow between node i and node j
       	if(debug>1) System.out.println("drawarrow");
	int x1, x2, x3, x4, y1, y2, y3, y4;
       // if(i>j) return;
	// calculate arrowhead
	x1= (int)(arrow[i][j].x - 2*dir_x[i][j] + 4*dir_y[i][j]);
	x2= (int)(arrow[i][j].x - 2*dir_x[i][j] - 4*dir_y[i][j]);
	x3= (int)(arrow[i][j].x + 2*dir_x[i][j] - 4*dir_y[i][j]);
	x4= (int)(arrow[i][j].x + 2*dir_x[i][j] + 4*dir_y[i][j]);

	y1= (int)(arrow[i][j].y - 2*dir_y[i][j] - 4*dir_x[i][j]);
	y2= (int)(arrow[i][j].y - 2*dir_y[i][j] + 4*dir_x[i][j]);
	y3= (int)(arrow[i][j].y + 2*dir_y[i][j] + 4*dir_x[i][j]);
	y4= (int)(arrow[i][j].y + 2*dir_y[i][j] - 4*dir_x[i][j]);

	int arrowhead_x[] = { x1, x2, x3, x4, x1 };
	int arrowhead_y[] = { y1, y2, y3, y4, y1 };

	// if edge already chosen by algorithm change color
	if (algedge[i][j]) g.setColor(Color.orange);
	// draw arrow + "arrowhead" (really arrowhead is just a box)
	g.drawLine(startp[i][j].x, startp[i][j].y, endp[i][j].x, endp[i][j].y);
	g.fillPolygon(arrowhead_x, arrowhead_y, 5);

	// write edge of arrow at an appropriate position
	int dx = (int)(Math.abs(7*dir_y[i][j]));
	int dy = (int)(Math.abs(7*dir_x[i][j]));
	String str = new String("" + edge[i][j].w);
	g.setColor(Color.black);
	if ((startp[i][j].x>endp[i][j].x) && (startp[i][j].y>=endp[i][j].y))
	  g.drawString( str, arrow[i][j].x + dx, arrow[i][j].y - dy);
	if ((startp[i][j].x>=endp[i][j].x) && (startp[i][j].y<endp[i][j].y))
	  g.drawString( str, arrow[i][j].x - fmetrics.stringWidth(str) - dx ,
			     arrow[i][j].y - dy);
	if ((startp[i][j].x<endp[i][j].x) && (startp[i][j].y<=endp[i][j].y))
	  g.drawString( str, arrow[i][j].x - fmetrics.stringWidth(str) ,
			     arrow[i][j].y + fmetrics.getHeight());
	if ((startp[i][j].x<=endp[i][j].x) && (startp[i][j].y>endp[i][j].y))
          g.drawString( str, arrow[i][j].x + dx, arrow[i][j].y + fmetrics.getHeight() );
    } //drawarrow

    public void reverse_sp(EdgeClass myedge[][]){
      //reverse shortest path and make weights negative
      if(debug>0) System.out.println("reverse_sp");
      if(dist[endgraph] < INF2) {
        int i = endgraph;
        while(myedge[P[i]][i].exists){
          myedge[i][P[i]] = new EdgeClass(-myedge[P[i]][i].w);
          myedge[P[i]][i] = new EdgeClass(INF2);
          i = P[i];
        }
      }
    }

    public boolean ModifiedDijkstra(EdgeClass myedge[][]){
      if(debug>0) System.out.println("ModifiedDijkstra");
      int exceeded = 0;
      int J=0; // "j" as in algorithm
      int JDist = INF2;
      boolean bail_out = false;
      // Create set S and add members. There may be emptyspots.
      Set S = new Set(numnodes);
      for (int i=0; i<numnodes; i++){
        if(node[i].exists)
          S.add(i);
          // P[i] was initiated in init()
      }
      S.remove(startgraph);
      // Step 1 done.
      do{
        exceeded++;
        JDist = INF2;
        for (int i=0; i<numnodes; i++)
          for (int j=0; j<numnodes; j++)
            if (myedge[i][j].exists && !S.contains(i) && S.contains(j))
              if(dist[i] + myedge[i][j].w < JDist) {
                JDist = dist[i] + myedge[i][j].w;
                J = j;
                P[j] = i;
              }
        if(JDist < INF2) //found something reachable
          dist[J] = JDist; // Step 2a done.
        else { // done all reachable vertices and the rest are unreachable
          bail_out = true;
          if(debug>0) System.out.println("-------- Bailed out. ");
        }
        if(debug>0 && exceeded == 100) System.out.println("------Exceeded!");
        S.remove(J);  //Step 2b done.
        if(J!=endgraph)  // Enter step 3
          for (int i=0; i<numnodes; i++)
            if (myedge[J][i].exists && dist[J]+myedge[J][i].w < dist[i]) {
              dist[i] = dist[J] + myedge[J][i].w;
              S.add(i);  // causes loop if negative unidirectional edges
            }
      } while(S.count!=0 && J!=endgraph && exceeded<100 && !bail_out);
      
      if(dist[endgraph]<INF2)
        return(true);
      return false;
    } // end ModifiedDijkstra()

    public boolean BFS(EdgeClass myedge[][]){
      if(debug>0) System.out.println("BFS");
      int exceeded = 0;
      Set Gt = new Set(numnodes);
      Gt.add(startgraph);   // GammaT={A}
      do{
        exceeded++;
        Set Gi = new Set(numnodes);  // Gi is empty
        for (int j=0; j<numnodes; j++)
          if(Gt.contains(j))
            for (int i=0; i<numnodes; i++)
              if (myedge[j][i].exists && dist[j] + myedge[j][i].w < dist[i]
                            && dist[j] + myedge[j][i].w < dist[endgraph]) {
                dist[i] = dist[j] + myedge[j][i].w;
                P[i] = j;
                Gi.add(i);
              }
        Gt = new Set(numnodes); // Empty GammaT
        for (int i=0; i<numnodes; i++)
          if(Gi.contains(i) && i!=endgraph)
            Gt.add(i);  // GammaT = GammaI - {Z}
      } while(Gt.count!=0 && exceeded<100);

      if(dist[endgraph]<INF2)
        return(true);
      return false;
    } //end BFS()

    public void paint(Graphics g) {
      if(debug>1) System.out.println("paint");
      g.setFont(roman);
      g.setColor(Color.black);

      // draw a new arrow upto current mouse position
      if (newarrow)
        g.drawLine(node[node1].x, node[node1].y, thispoint.x, thispoint.y);

      // draw all arrows
      for (int i=0; i<numnodes; i++)
	for (int j=0; j<numnodes; j++)
          if(edge[i][j].exists)
            if(i<j || edge[i][j].w != edge[j][i].w) {
              g.setColor(edge[i][j].color);
              drawarrow(g, i, j);
            }
      // draw the nodes
      for (int i=0; i<numnodes; i++)
	if (node[i].exists) {
	  g.setColor(node[i].color);
	  g.fillOval(node[i].x-NODERADIX, node[i].y-NODERADIX, NODESIZE, NODESIZE);
          // draw black circles around nodes, write their names to the screen
          g.setFont(helvetica);
      	  g.setColor(Color.black);
          g.drawOval(node[i].x-NODERADIX, node[i].y-NODERADIX, NODESIZE, NODESIZE);
	  g.setColor(Color.blue);
	  g.drawString(intToString(i), node[i].x-14, node[i].y-14);
          // write distances inside node circle
          if(dist[i] < INF2) {
            String str = new String(""+dist[i]);
	    if(i == startgraph) g.setColor(Color.white);
            g.drawString(str, node[i].x - (int)fmetrics.stringWidth(str)/2 -1,
                  node[i].y + h);
            }
	}
      // reflect the startnode being moved
      if (movestart){
        g.setColor(Color.blue);
        g.fillOval(thispoint.x-NODERADIX, thispoint.y-NODERADIX, NODESIZE, NODESIZE);
      }
      // reflect the endnode being moved
      if (moveend){
        g.setColor(Color.green);
	g.fillOval(thispoint.x-NODERADIX, thispoint.y-NODERADIX, NODESIZE, NODESIZE);
      }
    }
}
