/*
 * Decompiled with CFR 0.152.
 */
package GraphAlgorithm;

import GraphAlgorithm.EdgeClass;
import GraphAlgorithm.GraphAlgorithm;
import GraphAlgorithm.Node;
import GraphAlgorithm.Set;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

class GraphCanvas
extends Canvas {
    int debug = 0;
    final int MAX = 20;
    final int NODESIZE = 24;
    final int NODERADIX = 12;
    final int DIJKSTRA = 1;
    final int MODIFIED_DIJKSTRA = 2;
    final int INF = 10000;
    final int INF2 = 9999;
    Node[] node = new Node[20];
    EdgeClass[][] edge = new EdgeClass[20][20];
    Point[][] arrow = new Point[20][20];
    Point[][] startp = new Point[20][20];
    Point[][] endp = new Point[20][20];
    float[][] dir_x = new float[20][20];
    float[][] dir_y = new float[20][20];
    boolean[][] algedge = new boolean[20][20];
    int[] dist = new int[20];
    int[] P = new int[20];
    int[][] Z = new int[2][20];
    int[][] dj_path = new int[2][20];
    int[] newnodes = new int[20];
    int[] finaldist = new int[20];
    boolean[] changed = new boolean[20];
    int numchanged = 0;
    int neighbours = 0;
    int numnodes = 0;
    int emptyspots = 0;
    int startgraph = 0;
    int endgraph = 1;
    int hitnode;
    int node1;
    int node2;
    Point thispoint = new Point(0, 0);
    Node oldpoint;
    boolean newarrow = false;
    boolean movearrow = false;
    boolean movestart = false;
    boolean moveend = false;
    boolean deletenode = false;
    boolean deletearrow = false;
    boolean movenode = false;
    boolean clicked = false;
    Font roman = new Font("TimesRoman", 1, 12);
    Font helvetica = new Font("Helvetica", 1, 15);
    FontMetrics fmetrics = this.getFontMetrics(this.roman);
    int h = this.fmetrics.getHeight() / 3;
    private Image offScreenImage;
    private Graphics offScreenGraphics;
    private Dimension offScreenSize;
    int algorithm;
    String showstring = new String("");
    boolean Locked = false;
    GraphAlgorithm parent;

    GraphCanvas(GraphAlgorithm myparent) {
        if (this.debug > 0) {
            System.out.println("GraphCanvas");
        }
        this.parent = myparent;
        for (int i = 0; i < 20; ++i) {
            this.node[i] = new Node();
            for (int j = 0; j < 20; ++j) {
                this.edge[i][j] = new EdgeClass(9999);
            }
        }
        this.init();
        this.algorithm = 2;
        this.setBackground(Color.white);
    }

    public void lock() {
        if (this.debug > 0) {
            System.out.println("lock");
        }
        this.Locked = true;
    }

    public void unlock() {
        if (this.debug > 0) {
            System.out.println("unlock");
        }
        this.Locked = false;
    }

    public void init() {
        if (this.debug > 0) {
            System.out.println("init");
        }
        for (int i = 0; i < 20; ++i) {
            this.node[i].color = Color.gray;
            this.dist[i] = 9999;
            this.P[i] = this.startgraph;
            for (int j = 0; j < 20; ++j) {
                if (i >= 2) continue;
                this.Z[i][j] = 10000;
            }
        }
        this.node[this.startgraph].color = Color.blue;
        this.node[this.endgraph].color = Color.green;
    }

    public void clear() {
        if (this.debug > 0) {
            System.out.println("clear");
        }
        this.startgraph = 0;
        this.endgraph = 1;
        this.numnodes = 0;
        this.emptyspots = 0;
        this.init();
        for (int i = 0; i < 20; ++i) {
            this.node[i] = new Node();
            for (int j = 0; j < 20; ++j) {
                this.edge[i][j] = new EdgeClass(9999);
            }
        }
        this.parent.unlock();
        this.repaint();
    }

    public void reset() {
        if (this.debug > 0) {
            System.out.println("reset");
        }
        this.init();
        for (int i = 0; i < 20; ++i) {
            for (int j = 0; j < 20; ++j) {
                this.edge[i][j].color = Color.black;
            }
        }
        this.parent.unlock();
        this.repaint();
    }

    public void runalg() {
        int i;
        int i2;
        if (this.debug > 0) {
            System.out.println("runalg");
        }
        if (this.numnodes == 0) {
            return;
        }
        boolean sp_found = false;
        boolean mod_path_found = false;
        int sp_length = 0;
        int old_numnodes = 0;
        int old_emptyspots = 0;
        boolean can_do_split_vertices = false;
        this.parent.lock();
        this.initalg();
        if (this.parent.documentation.docopt.Methodstr.equals("Dijkstra")) {
            sp_found = this.ModifiedDijkstra(this.edge);
        } else if (this.parent.documentation.docopt.Methodstr.equals("BFS")) {
            sp_found = this.BFS(this.edge);
        }
        for (int i3 = 0; i3 < this.numnodes; ++i3) {
            if (this.dist[i3] >= 9999 || i3 == this.startgraph || i3 == this.endgraph) continue;
            this.node[i3].color = Color.orange;
        }
        for (int i4 = 0; i4 < this.numnodes; ++i4) {
            this.dist[i4] = 9999;
        }
        if (sp_found) {
            int i5 = this.endgraph;
            this.dist[i5] = 0;
            while (i5 != this.startgraph) {
                if (this.parent.documentation.docopt.Graphstr.equals("Shortest path")) {
                    this.edge[this.P[i5]][i5].color = Color.orange;
                    this.edge[i5][this.P[i5]].color = Color.orange;
                    this.dist[this.P[i5]] = this.edge[this.P[i5]][i5].w + this.dist[i5];
                }
                this.Z[0][i5] = this.P[i5];
                i5 = this.P[i5];
                ++sp_length;
            }
            this.Z[0][i5] = this.startgraph;
        }
        this.repaint();
        if (!sp_found) {
            this.parent.documentation.doctext.showline("sp notfound");
            return;
        }
        if (this.parent.documentation.docopt.Graphstr.equals("Shortest path")) {
            this.parent.documentation.doctext.showline("sp found");
            return;
        }
        EdgeClass[][] modifiededge = new EdgeClass[20][20];
        for (int i6 = 0; i6 < 20; ++i6) {
            for (int j = 0; j < 20; ++j) {
                modifiededge[i6][j] = new EdgeClass(this.edge[i6][j].w);
            }
        }
        if (this.parent.documentation.docopt.Graphstr.equals("Disjoint edge")) {
            this.reverse_sp(modifiededge);
        } else {
            if (this.numnodes - this.emptyspots + sp_length - 1 > 20) {
                this.parent.documentation.doctext.showline("cannot split");
                this.repaint();
                return;
            }
            can_do_split_vertices = true;
            old_numnodes = this.numnodes;
            old_emptyspots = this.emptyspots;
            this.split_vertices(modifiededge, this.newnodes);
        }
        for (int i7 = 0; i7 < this.numnodes; ++i7) {
            this.dist[i7] = 9999;
        }
        this.dist[this.startgraph] = 0;
        if (this.parent.documentation.docopt.Methodstr.equals("Dijkstra")) {
            mod_path_found = this.ModifiedDijkstra(modifiededge);
        } else if (this.parent.documentation.docopt.Methodstr.equals("BFS")) {
            mod_path_found = this.BFS(modifiededge);
        }
        if (can_do_split_vertices) {
            for (i2 = 0; i2 < this.numnodes; ++i2) {
                if (this.newnodes[i2] < 0) continue;
                this.node[i2] = new Node();
            }
            this.numnodes = old_numnodes;
            this.emptyspots = old_emptyspots;
            i = this.endgraph;
            int tmp = 0;
            while (i != this.startgraph) {
                if (this.newnodes[this.P[i]] >= 0) {
                    tmp = this.P[i];
                    this.P[i] = this.newnodes[tmp];
                    this.P[this.P[i]] = this.P[tmp];
                }
                i = this.P[i];
            }
        }
        if (mod_path_found) {
            i2 = this.endgraph;
            while (i2 != this.startgraph) {
                this.Z[1][i2] = this.P[i2];
                i2 = this.P[i2];
            }
            this.Z[1][i2] = this.startgraph;
        }
        for (i2 = 0; i2 < this.numnodes; ++i2) {
            if (this.dist[i2] >= 9999 || i2 == this.startgraph || i2 == this.endgraph) continue;
            this.node[i2].color = Color.orange;
            this.dist[i2] = 10000;
        }
        this.dj_path[0] = this.create_dpaths(this.Z, 0);
        this.dj_path[1] = this.create_dpaths(this.Z, 1);
        if (sp_found) {
            i = this.endgraph;
            this.dist[this.endgraph] = 0;
            while (i != this.startgraph) {
                this.edge[this.dj_path[0][i]][i].color = Color.red;
                this.edge[i][this.dj_path[0][i]].color = Color.red;
                this.dist[this.dj_path[0][i]] = this.dist[i] + this.edge[this.dj_path[0][i]][i].w;
                i = this.dj_path[0][i];
            }
        }
        if (mod_path_found) {
            int tmp = this.dist[this.startgraph];
            int i8 = this.endgraph;
            while (i8 != this.startgraph) {
                this.edge[this.dj_path[1][i8]][i8].color = Color.blue;
                this.edge[i8][this.dj_path[1][i8]].color = Color.blue;
                this.dist[this.dj_path[1][i8]] = this.dist[i8] + this.edge[this.dj_path[1][i8]][i8].w;
                i8 = this.dj_path[1][i8];
            }
            int n = this.startgraph;
            this.dist[n] = this.dist[n] + tmp;
            this.parent.documentation.doctext.showline("modpathfound");
        } else {
            this.parent.documentation.doctext.showline("no mod. path");
        }
        this.repaint();
    }

    public void split_vertices(EdgeClass[][] myedge, int[] splits) {
        if (this.debug > 0) {
            System.out.println("split_vertices");
        }
        int i = this.endgraph;
        while (this.P[i] != this.startgraph) {
            int j;
            if (this.emptyspots == 0) {
                this.node[this.numnodes] = new Node(this.node[this.P[i]].x + 24, this.node[this.P[i]].y);
                splits[this.numnodes] = this.P[i];
                ++this.numnodes;
            } else {
                for (j = 0; j < this.numnodes && this.node[j].exists; ++j) {
                }
                this.node[j] = new Node(this.node[this.P[i]].x + 24, this.node[this.P[i]].y);
                --this.emptyspots;
                splits[j] = this.P[i];
            }
            myedge[i][j] = new EdgeClass(-myedge[i][this.P[i]].w);
            myedge[i][this.P[i]] = new EdgeClass(9999);
            myedge[this.P[i]][i] = new EdgeClass(9999);
            myedge[j][this.P[i]] = new EdgeClass(0);
            for (int k = 0; k < this.numnodes; ++k) {
                if (!myedge[k][this.P[i]].exists || k == j || k == this.P[this.P[i]]) continue;
                myedge[this.P[i]][k] = new EdgeClass(9999);
                myedge[j][k] = new EdgeClass(myedge[k][this.P[i]].w);
            }
            i = this.P[i];
        }
        myedge[this.P[i]][i] = new EdgeClass(9999);
        myedge[i][this.P[i]] = new EdgeClass(-myedge[i][this.P[i]].w);
    }

    public int[] create_dpaths(int[][] z, int which) {
        int a;
        if (this.debug > 0) {
            System.out.println("create_dpaths");
        }
        int b = (a = which) == 0 ? 1 : 0;
        int[] path = new int[20];
        for (int i = 0; i < this.numnodes; ++i) {
            path[i] = this.startgraph;
        }
        if (this.dist[this.endgraph] < 9999) {
            int r = this.endgraph;
            do {
                if (z[b][r] < 10000 && z[b][z[a][r]] == r) {
                    path[r] = z[b][r];
                    r = z[b][r];
                    int tmp = a;
                    a = b;
                    b = tmp;
                    continue;
                }
                path[r] = z[a][r];
                r = z[a][r];
            } while (r != this.startgraph);
        }
        return path;
    }

    public void initalg() {
        if (this.debug > 0) {
            System.out.println("initalg");
        }
        this.init();
        for (int i = 0; i < 20; ++i) {
            this.dist[i] = 10000;
            this.newnodes[i] = -1;
            this.finaldist[i] = 10000;
            for (int j = 0; j < 20; ++j) {
                this.algedge[i][j] = false;
            }
        }
        this.dist[this.startgraph] = 0;
        this.finaldist[this.startgraph] = 0;
    }

    public void showexample() {
        if (this.debug > 0) {
            System.out.println("showexample");
        }
        this.clear();
        this.endgraph = 5;
        this.numnodes = 6;
        this.emptyspots = 0;
        int w = this.getSize().width / 8;
        int h = this.getSize().height / 8;
        this.node[0] = new Node(w, 4 * h);
        this.node[1] = new Node(3 * w, h);
        this.node[2] = new Node(3 * w, 4 * h);
        this.node[3] = new Node(5 * w, 4 * h);
        this.node[4] = new Node(5 * w, 7 * h);
        this.node[5] = new Node(7 * w, 4 * h);
        this.node[this.startgraph].color = Color.blue;
        this.node[this.endgraph].color = Color.green;
        this.edge[0][1] = new EdgeClass(50);
        this.edge[1][0] = new EdgeClass(50);
        this.edge[0][2] = new EdgeClass(10);
        this.edge[2][0] = new EdgeClass(10);
        this.edge[1][3] = new EdgeClass(50);
        this.edge[3][1] = new EdgeClass(50);
        this.edge[2][4] = new EdgeClass(50);
        this.edge[4][2] = new EdgeClass(50);
        this.edge[2][3] = new EdgeClass(10);
        this.edge[3][2] = new EdgeClass(10);
        this.edge[3][5] = new EdgeClass(10);
        this.edge[5][3] = new EdgeClass(10);
        this.edge[4][5] = new EdgeClass(50);
        this.edge[5][4] = new EdgeClass(50);
        for (int i = 0; i < this.numnodes; ++i) {
            for (int j = 0; j < this.numnodes; ++j) {
                if (!this.edge[i][j].exists) continue;
                this.arrowupdate(i, j, this.edge[i][j].w);
            }
        }
        this.repaint();
    }

    public boolean mouseDown(Event evt, int x, int y) {
        if (this.debug > 0) {
            System.out.println("mousedown");
        }
        if (this.Locked) {
            this.parent.documentation.doctext.showline("locked");
        } else {
            this.clicked = true;
            if (evt.shiftDown()) {
                if (this.nodehit(x, y, 24)) {
                    this.oldpoint = new Node(this.node[this.hitnode]);
                    this.node1 = this.hitnode;
                    this.movenode = true;
                }
            } else if (evt.controlDown()) {
                if (this.nodehit(x, y, 12)) {
                    this.node1 = this.hitnode;
                    if (this.startgraph == this.node1) {
                        this.movestart = true;
                        this.thispoint = new Point(x, y);
                        this.node[this.startgraph].color = Color.gray;
                    } else if (this.endgraph == this.node1) {
                        this.moveend = true;
                        this.thispoint = new Point(x, y);
                        this.node[this.endgraph].color = Color.gray;
                    } else {
                        this.deletenode = true;
                    }
                } else if (this.arrowhit(x, y, 10)) {
                    this.deletearrow = true;
                }
            } else if (this.arrowhit(x, y, 10)) {
                this.movearrow = true;
                this.repaint();
            } else if (this.nodehit(x, y, 24)) {
                if (!this.newarrow) {
                    this.newarrow = true;
                    this.thispoint = new Point(x, y);
                    this.node1 = this.hitnode;
                }
            } else if (!this.nodehit(x, y, 50) && !this.arrowhit(x, y, 50)) {
                if (this.emptyspots == 0) {
                    if (this.numnodes < 20) {
                        this.node[this.numnodes++] = new Node(x, y);
                    } else {
                        this.parent.documentation.doctext.showline("maxnodes");
                    }
                } else {
                    for (int i = 0; i < this.numnodes && this.node[i].exists; ++i) {
                    }
                    this.node[i] = new Node(x, y);
                    --this.emptyspots;
                }
                this.node[this.startgraph].color = Color.blue;
                this.node[this.endgraph].color = Color.green;
            } else {
                this.parent.documentation.doctext.showline("toclose");
            }
            this.repaint();
        }
        return true;
    }

    public boolean mouseDrag(Event evt, int x, int y) {
        if (this.debug > 1) {
            System.out.println("mouseDrag");
        }
        if (!this.Locked && this.clicked) {
            if (this.movenode) {
                this.node[this.node1].x = x;
                this.node[this.node1].y = y;
                for (int i = 0; i < this.numnodes; ++i) {
                    if (this.edge[i][this.node1].exists) {
                        this.arrowupdate(i, this.node1, this.edge[i][this.node1].w);
                    }
                    if (!this.edge[this.node1][i].exists) continue;
                    this.arrowupdate(this.node1, i, this.edge[this.node1][i].w);
                }
                this.repaint();
            } else if (this.movestart || this.moveend || this.newarrow) {
                this.thispoint = new Point(x, y);
                this.repaint();
            } else if (this.movearrow) {
                this.changeedge(x, y);
                this.repaint();
            }
        }
        return true;
    }

    public boolean mouseUp(Event evt, int x, int y) {
        if (this.debug > 0) {
            System.out.println("mouseUp");
        }
        if (!this.Locked && this.clicked) {
            if (this.movenode) {
                this.node[this.node1] = new Node(-100, -100);
                if (this.nodehit(x, y, 50) || x < 0 || x > this.getSize().width || y < 0 || y > this.getSize().height) {
                    this.node[this.node1] = new Node(this.oldpoint);
                    this.parent.documentation.doctext.showline("toclose");
                } else {
                    this.node[this.node1].x = x;
                    this.node[this.node1].y = y;
                    this.node[this.node1].color = this.oldpoint.color;
                    this.parent.documentation.doctext.showline("all items");
                }
                for (int i = 0; i < this.numnodes; ++i) {
                    if (this.edge[i][this.node1].exists) {
                        this.arrowupdate(i, this.node1, this.edge[i][this.node1].w);
                    }
                    if (!this.edge[this.node1][i].exists) continue;
                    this.arrowupdate(this.node1, i, this.edge[this.node1][i].w);
                }
                this.movenode = false;
            } else if (this.deletenode) {
                if (this.nodehit(x, y, 12) && this.hitnode == this.node1) {
                    this.nodedelete();
                }
                this.deletenode = false;
            } else if (this.deletearrow) {
                int oldnode1 = this.node1;
                int oldnode2 = this.node2;
                if (this.arrowhit(x, y, 10) && this.node1 == oldnode1 && this.node2 == oldnode2) {
                    this.edge[this.node1][this.node2] = new EdgeClass(9999);
                    this.edge[this.node2][this.node1] = new EdgeClass(9999);
                }
                this.deletearrow = false;
            } else if (this.newarrow) {
                this.newarrow = false;
                if (this.nodehit(x, y, 24)) {
                    this.node2 = this.hitnode;
                    if (this.node1 != this.node2) {
                        int tmp = this.edge[this.node1][this.node2].exists ? this.edge[this.node1][this.node2].w : 50;
                        this.arrowupdate(this.node1, this.node2, tmp);
                        this.arrowupdate(this.node2, this.node1, tmp);
                        this.parent.documentation.doctext.showline("change weights");
                    }
                }
            } else if (this.movearrow) {
                this.movearrow = false;
                if (this.edge[this.node1][this.node2].exists) {
                    this.changeedge(x, y);
                }
            } else if (this.movestart) {
                if (this.nodehit(x, y, 24) && this.hitnode != this.endgraph) {
                    this.startgraph = this.hitnode;
                }
                this.node[this.startgraph].color = Color.blue;
                this.movestart = false;
            } else if (this.moveend) {
                if (this.nodehit(x, y, 24) && this.hitnode != this.startgraph) {
                    this.endgraph = this.hitnode;
                }
                this.node[this.endgraph].color = Color.green;
                this.moveend = false;
            }
            this.repaint();
        }
        return true;
    }

    public boolean nodehit(int x, int y, int dist) {
        if (this.debug > 0) {
            System.out.println("nodehit");
        }
        for (int i = 0; i < this.numnodes; ++i) {
            if ((x - this.node[i].x) * (x - this.node[i].x) + (y - this.node[i].y) * (y - this.node[i].y) >= dist * dist) continue;
            this.hitnode = i;
            return true;
        }
        return false;
    }

    public boolean arrowhit(int x, int y, int dist) {
        if (this.debug > 0) {
            System.out.println("arrowhit");
        }
        for (int i = 0; i < this.numnodes; ++i) {
            for (int j = i; j < this.numnodes; ++j) {
                if (!this.edge[i][j].exists || !(Math.pow(x - this.arrow[i][j].x, 2.0) + Math.pow(y - this.arrow[i][j].y, 2.0) < Math.pow(dist, 2.0))) continue;
                this.node1 = i;
                this.node2 = j;
                return true;
            }
        }
        return false;
    }

    public void nodedelete() {
        if (this.debug > 0) {
            System.out.println("nodedelete");
        }
        this.node[this.node1] = new Node();
        for (int j = 0; j < this.numnodes; ++j) {
            this.edge[this.node1][j] = new EdgeClass(9999);
            this.edge[j][this.node1] = new EdgeClass(9999);
        }
        ++this.emptyspots;
    }

    public void changeedge(int x, int y) {
        if (this.debug > 0) {
            System.out.println("changeedge");
        }
        int diff_x = (int)((float)20 * this.dir_x[this.node1][this.node2]);
        int diff_y = (int)((float)20 * this.dir_y[this.node1][this.node2]);
        boolean follow_x = false;
        if (Math.abs(this.endp[this.node1][this.node2].x - this.startp[this.node1][this.node2].x) > Math.abs(this.endp[this.node1][this.node2].y - this.startp[this.node1][this.node2].y)) {
            follow_x = true;
        }
        if (follow_x) {
            int hbound = Math.max(this.startp[this.node1][this.node2].x, this.endp[this.node1][this.node2].x) - Math.abs(diff_x);
            int lbound = Math.min(this.startp[this.node1][this.node2].x, this.endp[this.node1][this.node2].x) + Math.abs(diff_x);
            this.arrow[this.node1][this.node2].x = x < lbound ? lbound : (x > hbound ? hbound : x);
            this.arrow[this.node1][this.node2].y = (this.arrow[this.node1][this.node2].x - this.startp[this.node1][this.node2].x) * (this.endp[this.node1][this.node2].y - this.startp[this.node1][this.node2].y) / (this.endp[this.node1][this.node2].x - this.startp[this.node1][this.node2].x) + this.startp[this.node1][this.node2].y;
            this.edge[this.node1][this.node2] = new EdgeClass(Math.abs(this.arrow[this.node1][this.node2].x - this.startp[this.node1][this.node2].x - diff_x) * 100 / (hbound - lbound));
        } else {
            int hbound = Math.max(this.startp[this.node1][this.node2].y, this.endp[this.node1][this.node2].y) - Math.abs(diff_y);
            int lbound = Math.min(this.startp[this.node1][this.node2].y, this.endp[this.node1][this.node2].y) + Math.abs(diff_y);
            this.arrow[this.node1][this.node2].y = y < lbound ? lbound : (y > hbound ? hbound : y);
            this.arrow[this.node1][this.node2].x = (this.arrow[this.node1][this.node2].y - this.startp[this.node1][this.node2].y) * (this.endp[this.node1][this.node2].x - this.startp[this.node1][this.node2].x) / (this.endp[this.node1][this.node2].y - this.startp[this.node1][this.node2].y) + this.startp[this.node1][this.node2].x;
            this.edge[this.node1][this.node2] = new EdgeClass(Math.abs(this.arrow[this.node1][this.node2].y - this.startp[this.node1][this.node2].y - diff_y) * 100 / (hbound - lbound));
        }
        this.edge[this.node2][this.node1] = new EdgeClass(this.edge[this.node1][this.node2].w);
    }

    public void arrowupdate(int p1, int p2, int w) {
        if (this.debug > 1) {
            System.out.println("arrowupdate");
        }
        this.edge[p1][p2] = new EdgeClass(w);
        int dx = this.node[p2].x - this.node[p1].x;
        int dy = this.node[p2].y - this.node[p1].y;
        float l = (float)Math.sqrt(dx * dx + dy * dy);
        this.dir_x[p1][p2] = (float)dx / l;
        this.dir_y[p1][p2] = (float)dy / l;
        this.startp[p1][p2] = new Point(this.node[p1].x, this.node[p1].y);
        this.endp[p1][p2] = new Point(this.node[p2].x, this.node[p2].y);
        int diff_x = (int)Math.abs((float)20 * this.dir_x[p1][p2]);
        int diff_y = (int)Math.abs((float)20 * this.dir_y[p1][p2]);
        this.arrow[p1][p2] = this.startp[p1][p2].x > this.endp[p1][p2].x ? new Point(this.endp[p1][p2].x + diff_x + (Math.abs(this.endp[p1][p2].x - this.startp[p1][p2].x) - 2 * diff_x) * (100 - w) / 100, 0) : new Point(this.startp[p1][p2].x + diff_x + (Math.abs(this.endp[p1][p2].x - this.startp[p1][p2].x) - 2 * diff_x) * w / 100, 0);
        this.arrow[p1][p2].y = this.startp[p1][p2].y > this.endp[p1][p2].y ? this.endp[p1][p2].y + diff_y + (Math.abs(this.endp[p1][p2].y - this.startp[p1][p2].y) - 2 * diff_y) * (100 - w) / 100 : this.startp[p1][p2].y + diff_y + (Math.abs(this.endp[p1][p2].y - this.startp[p1][p2].y) - 2 * diff_y) * w / 100;
    }

    public String intToString(int i) {
        if (this.debug > 2) {
            System.out.println("intToString");
        }
        char c = (char)(97 + i);
        return String.valueOf("").concat(String.valueOf(c));
    }

    public final synchronized void update(Graphics g) {
        if (this.debug > 1) {
            System.out.println("update");
        }
        Dimension d = this.getSize();
        if (this.offScreenImage == null || d.width != this.offScreenSize.width || d.height != this.offScreenSize.height) {
            this.offScreenImage = this.createImage(d.width, d.height);
            this.offScreenSize = d;
            this.offScreenGraphics = this.offScreenImage.getGraphics();
        }
        this.offScreenGraphics.setColor(Color.white);
        this.offScreenGraphics.fillRect(0, 0, d.width, d.height);
        this.paint(this.offScreenGraphics);
        g.drawImage(this.offScreenImage, 0, 0, null);
    }

    public void drawarrow(Graphics g, int i, int j) {
        if (this.debug > 1) {
            System.out.println("drawarrow");
        }
        int x1 = (int)((float)this.arrow[i][j].x - (float)2 * this.dir_x[i][j] + (float)4 * this.dir_y[i][j]);
        int x2 = (int)((float)this.arrow[i][j].x - (float)2 * this.dir_x[i][j] - (float)4 * this.dir_y[i][j]);
        int x3 = (int)((float)this.arrow[i][j].x + (float)2 * this.dir_x[i][j] - (float)4 * this.dir_y[i][j]);
        int x4 = (int)((float)this.arrow[i][j].x + (float)2 * this.dir_x[i][j] + (float)4 * this.dir_y[i][j]);
        int y1 = (int)((float)this.arrow[i][j].y - (float)2 * this.dir_y[i][j] - (float)4 * this.dir_x[i][j]);
        int y2 = (int)((float)this.arrow[i][j].y - (float)2 * this.dir_y[i][j] + (float)4 * this.dir_x[i][j]);
        int y3 = (int)((float)this.arrow[i][j].y + (float)2 * this.dir_y[i][j] + (float)4 * this.dir_x[i][j]);
        int y4 = (int)((float)this.arrow[i][j].y + (float)2 * this.dir_y[i][j] - (float)4 * this.dir_x[i][j]);
        int[] arrowhead_x = new int[]{x1, x2, x3, x4, x1};
        int[] arrowhead_y = new int[]{y1, y2, y3, y4, y1};
        if (this.algedge[i][j]) {
            g.setColor(Color.orange);
        }
        g.drawLine(this.startp[i][j].x, this.startp[i][j].y, this.endp[i][j].x, this.endp[i][j].y);
        g.fillPolygon(arrowhead_x, arrowhead_y, 5);
        int dx = (int)Math.abs((float)7 * this.dir_y[i][j]);
        int dy = (int)Math.abs((float)7 * this.dir_x[i][j]);
        String str = new String(String.valueOf("").concat(String.valueOf(this.edge[i][j].w)));
        g.setColor(Color.black);
        if (this.startp[i][j].x > this.endp[i][j].x && this.startp[i][j].y >= this.endp[i][j].y) {
            g.drawString(str, this.arrow[i][j].x + dx, this.arrow[i][j].y - dy);
        }
        if (this.startp[i][j].x >= this.endp[i][j].x && this.startp[i][j].y < this.endp[i][j].y) {
            g.drawString(str, this.arrow[i][j].x - this.fmetrics.stringWidth(str) - dx, this.arrow[i][j].y - dy);
        }
        if (this.startp[i][j].x < this.endp[i][j].x && this.startp[i][j].y <= this.endp[i][j].y) {
            g.drawString(str, this.arrow[i][j].x - this.fmetrics.stringWidth(str), this.arrow[i][j].y + this.fmetrics.getHeight());
        }
        if (this.startp[i][j].x <= this.endp[i][j].x && this.startp[i][j].y > this.endp[i][j].y) {
            g.drawString(str, this.arrow[i][j].x + dx, this.arrow[i][j].y + this.fmetrics.getHeight());
        }
    }

    public void reverse_sp(EdgeClass[][] myedge) {
        if (this.debug > 0) {
            System.out.println("reverse_sp");
        }
        if (this.dist[this.endgraph] < 9999) {
            int i = this.endgraph;
            while (myedge[this.P[i]][i].exists) {
                myedge[i][this.P[i]] = new EdgeClass(-myedge[this.P[i]][i].w);
                myedge[this.P[i]][i] = new EdgeClass(9999);
                i = this.P[i];
            }
        }
    }

    public boolean ModifiedDijkstra(EdgeClass[][] myedge) {
        if (this.debug > 0) {
            System.out.println("ModifiedDijkstra");
        }
        int exceeded = 0;
        int J = 0;
        int JDist = 9999;
        boolean bail_out = false;
        Set S = new Set(this.numnodes);
        for (int i = 0; i < this.numnodes; ++i) {
            if (!this.node[i].exists) continue;
            S.add(i);
        }
        S.remove(this.startgraph);
        do {
            ++exceeded;
            JDist = 9999;
            for (int i = 0; i < this.numnodes; ++i) {
                for (int j = 0; j < this.numnodes; ++j) {
                    if (!myedge[i][j].exists || S.contains(i) || !S.contains(j) || this.dist[i] + myedge[i][j].w >= JDist) continue;
                    JDist = this.dist[i] + myedge[i][j].w;
                    J = j;
                    this.P[j] = i;
                }
            }
            if (JDist < 9999) {
                this.dist[J] = JDist;
            } else {
                bail_out = true;
                if (this.debug > 0) {
                    System.out.println("-------- Bailed out. ");
                }
            }
            if (this.debug > 0 && exceeded == 100) {
                System.out.println("------Exceeded!");
            }
            S.remove(J);
            if (J == this.endgraph) continue;
            for (int i = 0; i < this.numnodes; ++i) {
                if (!myedge[J][i].exists || this.dist[J] + myedge[J][i].w >= this.dist[i]) continue;
                this.dist[i] = this.dist[J] + myedge[J][i].w;
                S.add(i);
            }
        } while (S.count != 0 && J != this.endgraph && exceeded < 100 && !bail_out);
        return this.dist[this.endgraph] < 9999;
    }

    public boolean BFS(EdgeClass[][] myedge) {
        if (this.debug > 0) {
            System.out.println("BFS");
        }
        int exceeded = 0;
        Set Gt = new Set(this.numnodes);
        Gt.add(this.startgraph);
        do {
            int i;
            ++exceeded;
            Set Gi = new Set(this.numnodes);
            for (int j = 0; j < this.numnodes; ++j) {
                if (!Gt.contains(j)) continue;
                for (i = 0; i < this.numnodes; ++i) {
                    if (!myedge[j][i].exists || this.dist[j] + myedge[j][i].w >= this.dist[i] || this.dist[j] + myedge[j][i].w >= this.dist[this.endgraph]) continue;
                    this.dist[i] = this.dist[j] + myedge[j][i].w;
                    this.P[i] = j;
                    Gi.add(i);
                }
            }
            Gt = new Set(this.numnodes);
            for (i = 0; i < this.numnodes; ++i) {
                if (!Gi.contains(i) || i == this.endgraph) continue;
                Gt.add(i);
            }
        } while (Gt.count != 0 && exceeded < 100);
        return this.dist[this.endgraph] < 9999;
    }

    public void paint(Graphics g) {
        if (this.debug > 1) {
            System.out.println("paint");
        }
        g.setFont(this.roman);
        g.setColor(Color.black);
        if (this.newarrow) {
            g.drawLine(this.node[this.node1].x, this.node[this.node1].y, this.thispoint.x, this.thispoint.y);
        }
        for (int i = 0; i < this.numnodes; ++i) {
            for (int j = 0; j < this.numnodes; ++j) {
                if (!this.edge[i][j].exists || i >= j && this.edge[i][j].w == this.edge[j][i].w) continue;
                g.setColor(this.edge[i][j].color);
                this.drawarrow(g, i, j);
            }
        }
        for (int i = 0; i < this.numnodes; ++i) {
            if (!this.node[i].exists) continue;
            g.setColor(this.node[i].color);
            g.fillOval(this.node[i].x - 12, this.node[i].y - 12, 24, 24);
            g.setFont(this.helvetica);
            g.setColor(Color.black);
            g.drawOval(this.node[i].x - 12, this.node[i].y - 12, 24, 24);
            g.setColor(Color.blue);
            g.drawString(this.intToString(i), this.node[i].x - 14, this.node[i].y - 14);
            if (this.dist[i] >= 9999) continue;
            String str = new String(String.valueOf("").concat(String.valueOf(this.dist[i])));
            if (i == this.startgraph) {
                g.setColor(Color.white);
            }
            g.drawString(str, this.node[i].x - this.fmetrics.stringWidth(str) / 2 - 1, this.node[i].y + this.h);
        }
        if (this.movestart) {
            g.setColor(Color.blue);
            g.fillOval(this.thispoint.x - 12, this.thispoint.y - 12, 24, 24);
        }
        if (this.moveend) {
            g.setColor(Color.green);
            g.fillOval(this.thispoint.x - 12, this.thispoint.y - 12, 24, 24);
        }
    }
}

