clear all;

dratios_dtn_av=[];
adelays_dtn_av=[];
medelays_dtn_av=[];
pdelays_dtn_av=[];
abuffers_dtn_av=[];
mbuffers_dtn_av=[];
aholblock_dtn_av=[];
mholblock_dtn_av=[];
hopcounts_dtn_av=[];

dratios_dtn_ci=[];
adelays_dtn_ci=[];
medelays_dtn_ci=[];
pdelays_dtn_ci=[];
abuffers_dtn_ci=[];
mbuffers_dtn_ci=[];
aholblock_dtn_ci=[];
mholblock_dtn_ci=[];
hopcounts_dtn_ci=[];

for n=1:8,
  if (n==1), cd DTN_SF_SW_UDP; end;
  if (n==2), cd DTN_SF_SW_CC_UDP; end;
  if (n==3), cd DTN_SF_UDP; end;
  if (n==4), cd DTN_SF_CC_0_7_UDP; end;
  if (n==5), cd DTN_SF_CC_UDP; end;
  if (n==6), cd DTN_SF_CC_0_9_UDP; end;
  if (n==7), cd DTN_SF_CC_Ad_UDP; end;
  if (n==8), cd DTN_SF; end;
  dratios_dtn=[];
  adelays_dtn=[];
  medelays_dtn=[];
  pdelays_dtn=[];
  abuffers_dtn=[];
  mbuffers_dtn=[];
  aholblock_dtn=[];
  mholblock_dtn=[];
  hopcounts_dtn=[];
  for m=1:6,
    if (m==1), load Run1/bundle_delays.tr; load Run1/qtrace.tr; end;
    if (m==2), load Run2/bundle_delays.tr; load Run2/qtrace.tr; end;
    if (m==3), load Run3/bundle_delays.tr; load Run3/qtrace.tr; end;
    if (m==4), load Run4/bundle_delays.tr; load Run4/qtrace.tr; end;
    if (m==5), load Run5/bundle_delays.tr; load Run5/qtrace.tr; end;
    if (m==6), load Run6/bundle_delays.tr; load Run6/qtrace.tr; end;
      
    sids_b=bundle_delays(:,1);
    bdelay=bundle_delays(:,2);
    hc_b=bundle_delays(:,3);
    recv_b=bundle_delays(:,4);
      
    one_way_delays=[];
    hopcounts=[];

    for i=1:length(sids_b),
      if (((recv_b(i)-bdelay(i))>=810)&&((recv_b(i)-bdelay(i))<=2809.98)),
	retx_found=0;
        source_id=sids_b(i);
        send_time=floor(recv_b(i)-bdelay(i));
        for j=i+1:length(sids_b),
          if ((sids_b(j)==source_id)&&(floor(recv_b(j)-bdelay(j))==send_time)),
            retx_found=1;
          end
        end
        if (retx_found==0),
          one_way_delays=[one_way_delays bdelay(i)];  
          hopcounts=[hopcounts hc_b(i)];
        end    
      end
    end
    
    dratios_dtn=[dratios_dtn length(one_way_delays)/1160]; % 10*116 = 1160
    adelays_dtn=[adelays_dtn mean(one_way_delays)];
    [temp,x]=hist(one_way_delays,0.001:0.001:3600);
    cdf_delay=cumsum(temp)/sum(temp);
    medelays_dtn=[medelays_dtn x(length(cdf_delay(cdf_delay<=0.5)))];
    pdelays_dtn=[pdelays_dtn x(length(cdf_delay(cdf_delay<=0.95)))];
    hopcounts_dtn=[hopcounts_dtn mean(hopcounts)];
    
    bsize=qtrace(:,5);
    holblock=qtrace(:,6);
    av_buffer_size=[];
    max_buffer_size=[];
    av_holblock=[];
    max_holblock=[];
    j=1;
    for i=1:3600,
      av_buffer_size(i)=mean(bsize(j:j+115));
      max_buffer_size(i)=max(bsize(j:j+115));
      av_holblock(i)=mean(holblock(j:j+115));
      max_holblock(i)=max(holblock(j:j+115));
      j=j+116;
    end
    
    abuffers_dtn=[abuffers_dtn mean(av_buffer_size(810:3600))];
    mbuffers_dtn=[mbuffers_dtn max(max_buffer_size)];
    aholblock_dtn=[aholblock_dtn mean(av_holblock(810:3600))];
    mholblock_dtn=[mholblock_dtn max(max_holblock)];
     
    n
    m
    
  end
  dratios_dtn_ci=[dratios_dtn_ci 2.571*std(dratios_dtn)/sqrt(6)]; dratios_dtn_av=[dratios_dtn_av mean(dratios_dtn)]
  adelays_dtn_ci=[adelays_dtn_ci 2.571*std(adelays_dtn)/sqrt(6)]; adelays_dtn_av=[adelays_dtn_av mean(adelays_dtn)]
  medelays_dtn_ci=[medelays_dtn_ci 2.571*std(medelays_dtn)/sqrt(6)]; medelays_dtn_av=[medelays_dtn_av mean(medelays_dtn)]
  pdelays_dtn_ci=[pdelays_dtn_ci 2.571*std(pdelays_dtn)/sqrt(6)]; pdelays_dtn_av=[pdelays_dtn_av mean(pdelays_dtn)]
  abuffers_dtn_ci=[abuffers_dtn_ci 2.571*std(abuffers_dtn)/sqrt(6)]; abuffers_dtn_av=[abuffers_dtn_av mean(abuffers_dtn)]
  mbuffers_dtn_ci=[mbuffers_dtn_ci 2.571*std(mbuffers_dtn)/sqrt(6)]; mbuffers_dtn_av=[mbuffers_dtn_av mean(mbuffers_dtn)]
  aholblock_dtn_ci=[aholblock_dtn_ci 2.571*std(aholblock_dtn)/sqrt(6)]; aholblock_dtn_av=[aholblock_dtn_av mean(aholblock_dtn)]
  mholblock_dtn_ci=[mholblock_dtn_ci 2.571*std(mholblock_dtn)/sqrt(6)]; mholblock_dtn_av=[mholblock_dtn_av mean(mholblock_dtn)]
  hopcounts_dtn_ci=[hopcounts_dtn_ci 2.571*std(hopcounts_dtn)/sqrt(6)]; hopcounts_dtn_av=[hopcounts_dtn_av mean(hopcounts_dtn)]
  cd ..
end

set(gca,'FontSize',15);
h=bar('v6',[abuffers_dtn_av([1:8]); mbuffers_dtn_av([1:8])],'grouped');
colormap(pink);
hold on;
set(gca,'XTick',1:2);
set(gca,'XTickLabel',{'Average','Maximum'});
title(sprintf('Buffer Occupancy'),'FontSize',15);
%legend('Binary SnW', 'Binary SnW + CC, T_C = 0.8', 'Epidemic','Epidemic + CC, T_C = 0.7', 'Epidemic + CC, T_C = 0.8', 'Epidemic + CC, T_C = 0.9','Epidemic + CC, Adaptive T_C','Epidemic + TCP',2)
set(gca,'XMinorGrid','on')
grid;
%axis auto;
axis([0.5 2.5 0 12000000]);
ylabel('Buffer occupancy [bytes]','FontSize',15);
% Error bars
b = [abuffers_dtn_av([1:8]); mbuffers_dtn_av([1:8])];
errdata = [abuffers_dtn_ci([1:8]); mbuffers_dtn_ci([1:8])];
xdata = get(h,'XData');
sizz = size(b);
NumGroups = sizz(1);
SizeGroups = sizz(2);
NumBars = SizeGroups * NumGroups;
INZY = [1 3];
xb = [];
for i = 1:SizeGroups
  for j = 1:NumGroups
    xb = [xb xdata{i}(INZY, j)];
  end
end
for i = 1:NumBars
  centerX(i) = (xb(1,i) + xb(2,i))/2;
end
hold on;
eh = errorbar('v6',centerX,b,errdata);
set(eh(1),'linewidth',1);      % This changes the thickness of the errorbars
set(eh(1),'color','k');        % This changes the color of the errorbars
set(eh(2),'linestyle','none'); % This removes the connecting line
print -depsc2 -tiff -r450 buffers_trace.eps;
print -dpng -r250 buffers_trace.png;
print -dpdf -r250 buffers_trace.pdf;
hold off;
close;

set(gca,'FontSize',15);
h=bar('v6',[aholblock_dtn_av([1:8]); mholblock_dtn_av([1:8])],'grouped');
colormap(pink);
hold on;
set(gca,'XTick',1:2);
set(gca,'XTickLabel',{'Average','Maximum'});
title(sprintf('Number of Neighbors'),'FontSize',15);
%legend('Binary SnW', 'Binary SnW + CC, T_C = 0.8', 'Epidemic','Epidemic + CC, T_C = 0.7', 'Epidemic + CC, T_C = 0.8', 'Epidemic + CC, T_C = 0.9','Epidemic + CC, Adaptive T_C','Epidemic + TCP',2)
set(gca,'XMinorGrid','on')
grid;
%axis auto;
axis([0.5 2.5 0 10]);
ylabel('Neighbors','FontSize',15);
% Error bars
b = [aholblock_dtn_av([1:8]); mholblock_dtn_av([1:8])];
errdata = [aholblock_dtn_ci([1:8]); mholblock_dtn_ci([1:8])];
xdata = get(h,'XData');
sizz = size(b);
NumGroups = sizz(1);
SizeGroups = sizz(2);
NumBars = SizeGroups * NumGroups;
INZY = [1 3];
xb = [];
for i = 1:SizeGroups
  for j = 1:NumGroups
    xb = [xb xdata{i}(INZY, j)];
  end
end
for i = 1:NumBars
  centerX(i) = (xb(1,i) + xb(2,i))/2;
end
hold on;
eh = errorbar('v6',centerX,b,errdata);
set(eh(1),'linewidth',1);      % This changes the thickness of the errorbars
set(eh(1),'color','k');        % This changes the color of the errorbars
set(eh(2),'linestyle','none'); % This removes the connecting line
print -depsc2 -tiff -r450 holblock_trace.eps;
print -dpng -r250 holblock_trace.png;
print -dpdf -r250 holblock_trace.pdf;
hold off;
close;

set(gca,'FontSize',15);
h=bar('v6',[adelays_dtn_av([1:8]); pdelays_dtn_av([1:8])],'grouped');
colormap(pink);
hold on;
set(gca,'XTick',1:2);
set(gca,'XTickLabel',{'Average','95th Percentile'});
title(sprintf('Delay'),'FontSize',15);
%legend('Binary SnW', 'Binary SnW + CC, T_C = 0.8', 'Epidemic','Epidemic + CC, T_C = 0.7', 'Epidemic + CC, T_C = 0.8', 'Epidemic + CC, T_C = 0.9','Epidemic + CC, Adaptive T_C','Epidemic + TCP',2)
set(gca,'XMinorGrid','on')
grid;
%axis auto;
axis([0.5 2.5 0 2500]);
ylabel('Delay [s]','FontSize',15);
% Error bars
b = [adelays_dtn_av([1:8]); pdelays_dtn_av([1:8])];
errdata = [adelays_dtn_ci([1:8]); pdelays_dtn_ci([1:8])];
xdata = get(h,'XData');
sizz = size(b);
NumGroups = sizz(1);
SizeGroups = sizz(2);
NumBars = SizeGroups * NumGroups;
INZY = [1 3];
xb = [];
for i = 1:SizeGroups
  for j = 1:NumGroups
    xb = [xb xdata{i}(INZY, j)];
  end
end
for i = 1:NumBars
  centerX(i) = (xb(1,i) + xb(2,i))/2;
end
hold on;
eh = errorbar('v6',centerX,b,errdata);
set(eh(1),'linewidth',1);      % This changes the thickness of the errorbars
set(eh(1),'color','k');        % This changes the color of the errorbars
set(eh(2),'linestyle','none'); % This removes the connecting line
print -depsc2 -tiff -r450 delays_trace.eps;
print -dpng -r250 delays_trace.png;
print -dpdf -r250 delays_trace.pdf;
hold off;
close;

set(gca,'FontSize',15);
h=bar('v6',[dratios_dtn_av([1:8]); hopcounts_dtn_av([1:8])/10],'grouped');
colormap(pink);
hold on;
set(gca,'XTick',1:2);
set(gca,'XTickLabel',{'Delivery ratio','Hop count / 10'});
title(sprintf('Delivery Ratio and Hop Count'),'FontSize',15);
legend('Binary SnW', 'Binary SnW + CC, T_C = 0.8', 'Epidemic','Epidemic + CC, T_C = 0.7', 'Epidemic + CC, T_C = 0.8', 'Epidemic + CC, T_C = 0.9','Epidemic + CC, Adaptive T_C','Epidemic + TCP',1)
set(gca,'XMinorGrid','on')
grid;
%axis auto;
axis([0.5 2.5 0 0.8]);
% Error bars
b = [dratios_dtn_av([1:8]); hopcounts_dtn_av([1:8])/10];
errdata = [dratios_dtn_ci([1:8]); hopcounts_dtn_ci([1:8])/10];
xdata = get(h,'XData');
sizz = size(b);
NumGroups = sizz(1);
SizeGroups = sizz(2);
NumBars = SizeGroups * NumGroups;
INZY = [1 3];
xb = [];
for i = 1:SizeGroups
  for j = 1:NumGroups
    xb = [xb xdata{i}(INZY, j)];
  end
end
for i = 1:NumBars
  centerX(i) = (xb(1,i) + xb(2,i))/2;
end
hold on;
eh = errorbar('v6',centerX,b,errdata);
set(eh(1),'linewidth',1);      % This changes the thickness of the errorbars
set(eh(1),'color','k');        % This changes the color of the errorbars
set(eh(2),'linestyle','none'); % This removes the connecting line
print -depsc2 -tiff -r450 dratio_hopcount_trace.eps;
print -dpng -r250 dratio_hopcount_trace.png;
print -dpdf -r250 dratio_hopcount_trace.pdf;
hold off;
close;
