# Create an HTTP-pagepool, define session parameters and call 'launchSession'
proc launchHttp {clnt svr} {
    global ns

    # Assign traffic parameters. Note! these are mean values of an exponential distribution
    set sessionSize_  5     ;# Number of pages in a session
    set interSession_ 5     ;# Time between session arrivals (seconds)
    set pageSize_     3     ;# Number of objects in a page
    set interPage_    12    ;# Time between page requests (seconds)
    set objSize_      3300  ;# Object size (bytes)
    set interObj_     0.1   ;# Time between object requests (seconds)

    puts "HTTP-session parameters (averages): sessionSize=$sessionSize_, interSession=$interSession_, pageSize=$pageSize_, interPage=$interPage_, objSize=$objSize_, interObj=$interObj_"

    # Create page pool
    set pool [new PagePool/WebTraf]

    $pool set-interPageOption 0 ;# Set inter-page time to be measured from the launch-time of the previous page
    $pool set application_ 31

    # Set up session-monitoring
    $ns set httpMonFile [open "smon_http.mon" w]

    launchSession $pool $clnt $svr $sessionSize_ $interSession_ $pageSize_ $interPage_ $objSize_ $interObj_
}

# Create an FTP-pagepool, define session parameters and call 'launchSession'
proc launchFtp {clnt svr} {
    global ns

    set sessionSize_  5
    set interSession_ 30
    set pageSize_     1     ;# always 1
    set interPage_    0_   ;# used for determining the first send time
    set objSize_      [expr 1e6]
    set interObj_     0     ;# doesn't affect anything

    puts "FTP-session parameters (averages): interSession_=$interSession_, numFiles=$sessionSize_, objSize=$objSize_"

    # Create page pool
    set pool [new PagePool/WebTraf]

    # Set up session-monitoring
    $ns set ftpMonFile [open "smon_ftp.mon" w]

    $pool set-interPageOption 1 ;# Set inter-page time to be measured from the closing-time of the previous page
    $pool set application_ 27

    launchSession $pool $clnt $svr $sessionSize_ $interSession_ $pageSize_ $interPage_ $objSize_ $interObj_
}

set vf [open "smon_exp.mon" w]

# Create an UDP-connection, define VoIP-session parameters and start an
# exponential ON-OFF-connection (exponential idle and call holding times)
proc launchVoip {src dst id} {

    global ns n testTime

    # Load to the system is defined as mean_holding_time/mean_interarrival_time
    set load 0.6

    set udp [new Agent/UDP]
    set null [new Agent/UDPsink]
    $ns attach-agent $n($src) $udp
    $ns attach-agent $n($dst) $null
    $ns connect $udp $null

    #VoIP-client configuration
    set expoo [new Application/Traffic/Exponential]
    $expoo attach-agent $udp
    $expoo set packetSize_  [expr 160+40]; # data + header
    $expoo set burst_time_  180
    $expoo set idle_time_   [format %.1f [expr [$expoo set burst_time_]*(1/$load - 1)]]
    $expoo set rate_        100000
    $expoo set id_          $id
    $expoo session-monitoring

    puts "Creating voip $id with pSize=[$expoo set packetSize_], bTime=[$expoo set burst_time_], idleTime=[$expoo set idle_time_], rate=[$expoo set rate_]"

    $expoo set sink_ $null
    $expoo proc voip-start { size estTime } {
	global ns vf
	$self instvar id_
	puts $vf "[format %.6f [$ns now]] VOIP $id_ starting, size $size pkts, estTxTime $estTime"
    }
    $expoo proc voip-stop { packetsSent txTime } {
	global ns vf
	$self instvar sink_ id_
	puts $vf "[format %.6f [$ns now]] VOIP $id_ stopped, sent $packetsSent pkts, txTime $txTime"
    }
    $expoo proc finish-stats {} {
	global ns vf
	$self instvar sink_ id_
	if { [$sink_ set udpPackRecs_] > 0 } {
	    set avgDelay_ [format %.6f [expr [$sink_ set udpSumDelays_]/[$sink_ set udpPackRecs_]]]
	} else {
	    set avgDelay_ 0
	}
	puts $vf "Final statistics VOIP $id_ received [$sink_ set udpPackRecs_] pkts, avgDelay $avgDelay_"
    }

    $ns at 0.0 "$expoo start"       ;# Start client
    $ns at $testTime "$expoo stop"  ;# Stop client
    $ns at [expr $testTime+5] "$expoo finish-stats" ;# Take statistics after the tx-pipe has emptied
}

# Is called by 'launchHttp' and 'launchFtp'.
# Create needed random variables and assign start-up times for each session.
proc launchSession {pool clnt svr sessionSize_ interSession_ pageSize_ interPage_ objSize_ interObj_} {
    global ns n testTime

    # Maximum number of sessions to be created
    set numSession_   [expr round(1.4*$testTime/$interSession_)]
    puts "Creating max $numSession_ sessions"

    # Bind TCL-variable to C-variable
    $pool set testTime_ $testTime

    # Add this session to the session list
    $ns set sessionList "[$ns set sessionList] $pool"

    # Setup servers and clients: add nodes listed in src_ and dst_
    # to pagepools server- and client-pool
    $pool set-num-client [llength $clnt]
    $pool set-num-server [llength $svr]
    set i 0
    foreach s $clnt {
	    $pool set-client $i $n($s)
	    incr i
    }
    set i 0
    foreach s $svr {
	    $pool set-server $i $n($s)
	    incr i
    }

    # Number of Sessions
    set numSession $numSession_

    # Inter-session Interval
    set interSession [new RandomVariable/Exponential]
    $interSession set avg_ $interSession_

    # Number of pages in a session
    set sessionSize [new RandomVariable/Exponential]
    $sessionSize set avg_ $sessionSize_

    # Create sessions
    $pool set-num-session $numSession
    set launchTime [$interSession value]
    for {set i 0} {$i < $numSession} {incr i} {
	
	## Number of objects per page
	if {[$pool set application_] == 27 } {
	    # FTP always has a page size of 1 -> a page represents a file
	    set pageSize [new RandomVariable/Constant]
	    $pageSize set val_ $pageSize_
	} else {
	    set pageSize [new RandomVariable/Exponential]
	    $pageSize set avg_ $pageSize_
	}

	set interPage [new RandomVariable/Exponential]
	$interPage set avg_ $interPage_
	
	set interObj [new RandomVariable/Exponential]
	$interObj set avg_ $interObj_
	
	set objSize [new RandomVariable/Exponential]
	$objSize set avg_ $objSize_
	
	if { $launchTime < $testTime } {
	    #set pageTimeOut [new RandomVariable/Exponential]
	    #$pageTimeOut set avg_ 6 ;# NOTE! pageTimeOut has a constant offset of 10s
	    $pool create-session $i [$sessionSize value] $launchTime \
		    $interPage $pageSize $interObj $objSize
	}
	set launchTime [expr $launchTime + [$interSession value]]
    }

}