# Outputs to the screen the simulated time and the test time every 'interval'-seconds (simulated)
proc timeStats { interval } {
    global ns alku pf

    set openConnections 0
    # Print the number of open connections in each WebTraf or FTPtraf pagepool
    foreach s [$ns set sessionList] {
	set temp [llength [$s set connList]]
	puts "[$s info class] ([$s set application_]) open connections: $temp"
	set openConnections [expr $openConnections + $temp]
    }
    puts "Total: $openConnections\n"

    # Print simulated and runtime on the screen and to file
    puts "Simulated time: [$ns now] s, real time: [expr [clock seconds] - $alku] s"
    puts $pf "[$ns now] [expr [clock seconds] - $alku]   Open connections $openConnections Number of events [$ns numEvents]"

    $ns at [expr [$ns now] + $interval] "timeStats $interval" ;# Call timeStats in 100s intervals
}

# Print sample and average queue lengths to files every 'interval' seconds (simulated)
proc printDSQueueLength { q q_num interval outfile outfile_avg } {
    global ns
    set now_ [format %.2f [$ns now]]
    foreach qn $q_num {
	puts $outfile "$now_ queue number $qn: length [$q getCurrent $qn]"
	puts $outfile_avg "$now_ queue number $qn: length [$q getAverage $qn]"
    }
    $ns at [expr [$ns now]+$interval] "printDSQueueLength $q [list $q_num] $interval $outfile $outfile_avg"
}

# DiffServ-specific statistics
proc diffservStats {} {
    global ns q testTime monitor_qlengths
    
    # Print policy and policer information before simulation starts
    $ns at 0.0 "$q(r6r7) printPHBTable"
    $ns at 0.0 "$q(voip1voip5) printPolicyTable"
    $ns at 0.0 "$q(ftpS1ftpC4) printPolicyTable"
    $ns at 0.0 "$q(httpS1httpC3) printPolicyTable"

    # Print sample and avarage queue size for the bottleneck link every 'q_interval' seconds
    if { $monitor_qlengths } {
	set q_interval 0.2                      ;# Sample interval
	set q_num [list "0 1 2"]                ;# Physical queues in diffserv routers
	set q_r6r7 [open q_r6r7.mon w]          ;# Output files for sample qlengths
	set q_r7r6 [open q_r7r6.mon w]          ;#
	set q_r6r7_avg [open q_r6r7_avg.mon w]  ;# Output files for average qlengths
	set q_r7r6_avg [open q_r7r6_avg.mon w]  ;#
	$ns at $q_interval "printDSQueueLength $q(r6r7) $q_num $q_interval $q_r6r7 $q_r6r7_avg"
	$ns at $q_interval "printDSQueueLength $q(r7r6) $q_num $q_interval $q_r7r6 $q_r7r6_avg"
    }

    # Print statistics for diffserv bottleneck routers every 'interval' seconds
    set interval 50
    for {set i 1} {$i < [expr $testTime/$interval]} {incr i} {
	$ns at [expr $interval*$i] "$q(r6r7) printStats"
	$ns at [expr $interval*$i] "$q(r7r6) printStats"
    }
}

# Dumps queue-statistics in server- and client-side access-links every 'interval' seconds (simulated).
proc crQmon { svr clnt interval } {
    global ns n
    set qf [open "qmon_[set svr]_to_[set clnt].mon" w]
    set qmon [$ns monitor-queue $n($svr) [$n($svr) neighbors] $qf]
    set qmon2 [$ns monitor-queue [$n($clnt) neighbors] $n($clnt) $qf]

    record $qmon $n($svr) [$n($svr) neighbors] $interval $qf
    record $qmon2 [$n($clnt) neighbors] $n($clnt) $interval $qf
}

# A helper function for 'crQmon'. Recursively call itself to
# write queue information to a file every 'interval' seconds.
proc record { qmon src dst interval file} {
    global ns

    set time  [$ns now]            ;# current simulated time
    set size [$qmon set size_]     ;# size of the queue in bytes
    set pkts [$qmon set pkts_]     ;# size of the queue in packets
    set parrivals [$qmon set parrivals_] ;# number of packets arrived in the queue
    set barrivals [$qmon set barrivals_] ;# number of bytes arrived in the queue
    set pdrops [$qmon set pdrops_] ;# number of packets dropped
    set bdrops [$qmon set bdrops_] ;# number of bytes dropped

    puts $file "$time [$src id]->[$dst id] size $size  pkts $pkts parrivals $parrivals barrivals $barrivals pdrops $pdrops bdrops $bdrops"
    flush $file
    #$qmon reset

    # stats every second
    $ns at [expr $time+$interval] "record $qmon $src $dst $interval $file"
}
