set ns [new Simulator]


 # Simulated seconds and random seed to be used (0 := random seed for every run)
set testTime 500.0
$defaultRNG seed 0

 # Activate tracing for all links (potentially very slow and disk-space-consuming)
 # Output file: tr_diffnet.out
set trace_all false

 # Tracing for the bottleneck link. Output file: tr_bottleneck.out
set trace_bn false

 # Set monitoring for queue length (some performance cost - adjust 'q_interval' below)
 # Outputfiles: q_r6r7.mon, q_r6r7_avg.mon, q_r7r6.mon, q_r7r6_avg.mon.
set monitor_qlengths true



Trace set show_tcphdr_ 1
 # Set tracing
if {$trace_all} {
    $ns trace-all [open tr_diffnet.out w]
    #$ns namtrace-all [open tr_diffnet.nam w]
}

 # Get procedures for creating HTTP, FTP and VoIP traffic
source peer_setup.tcl

 # Load DiffServ-specific procedures
source 2q2p.tcl

 # Create topology
source topology.tcl

 # Load monitor-functions for queue- and flowmonitors
source monitoring.tcl

if {$trace_bn} {
    set tf [open "tr_bottleneck.out" w]
    $ns trace-queue $n(r6) $n(r7) $tf
    $ns trace-queue $n(r7) $n(r6) $tf
}

 # Print node's name and ID on the screen
foreach s [set node_list] {
    puts -nonewline "Node $s's id is [$n($s) address?] and its neighbors are"
    foreach nbor [$n($s) neighbors] {
	puts -nonewline " [$nbor address?]"
    }
    puts ""
}

 # Contains handles for WebTraf- and FTPTraf-sessions. Session handles are added
 # to this variable in "proc launchSession" of file 'peer_setup.tcl'
$ns set sessionList ""

 # Launch HTTP-sessions (syntax: client-list server-list)
launchHttp httpC1 httpS4
launchHttp httpC2 httpS3
launchHttp httpC3 httpS1
launchHttp httpC4 httpS2

 # Launch FTP-sessions (syntax: client-list server-list)
launchFtp ftpC1 ftpS4
launchFtp ftpC2 ftpS3
launchFtp ftpC3 ftpS2
launchFtp ftpC4 ftpS1

 # Launch VOIP-sessions (syntax: src dst id)
launchVoip voip1 voip5 0
launchVoip voip5 voip1 1
launchVoip voip2 voip7 2
launchVoip voip7 voip2 3
launchVoip voip3 voip6 4
launchVoip voip6 voip3 5
launchVoip voip4 voip8 6
launchVoip voip8 voip4 7

 # Committed transfer rates for applications (per connection pair)
set cir_exp   80000
set cir_http 100000
set cir_ftp  200000

 # Configure queue and policy management
   # core queues
confDSCore r6 r7
confDSCore r7 r6

   # edge queues
confDSEdges voip1 voip5 $cir_exp 29_app EF
confDSEdges voip2 voip7 $cir_exp 29_app EF
confDSEdges voip3 voip6 $cir_exp 29_app EF
confDSEdges voip4 voip8 $cir_exp 29_app EF

confDSEdges ftpS1 ftpC4 $cir_ftp 27_app BE
confDSEdges ftpS2 ftpC3 $cir_ftp 27_app AF
confDSEdges ftpS3 ftpC2 $cir_ftp 27_app AF
confDSEdges ftpS4 ftpC1 $cir_ftp 27_app AF

confDSEdges httpS1 httpC3 $cir_http 31_app AF
confDSEdges httpS2 httpC4 $cir_http 31_app AF
confDSEdges httpS3 httpC2 $cir_http 31_app AF
confDSEdges httpS4 httpC1 $cir_http 31_app AF


 # Queue-monitoring (for bottleneck link)
set qf [open "qmon_bottleneck.mon" w]
set qmon [$ns monitor-queue $n(r6) $n(r7) $qf]
set qmon2 [$ns monitor-queue $n(r7) $n(r6) $qf]
$ns at 1.0 "record $qmon $n(r6) $n(r7) 1 $qf"
$ns at 1.0 "record $qmon2 $n(r7) $n(r6) 1 $qf"

 # A procedure for finishing up the simulation
proc finish {} {
    global ns alku trace_on pf q
    $ns flush-trace

    # Print final DiffServ queue statictics from the bottleneck link
    $q(r6r7) printStats
    $q(r7r6) printStats

    puts "\nAjoaika: [expr [clock seconds] - $alku] s"

    flush $pf
    close $pf

    exit 0
}

 # Tries to close all open connections listed in 'sessionList' using the normal TCP-connection teardown
proc close-connections {} {
    global ns
    foreach s [$ns set sessionList] {
	$s close-pool
    }
}

 # Forces all connections to be closed, no matter what the state of the connection is.
 # Needed to ensure statistics to be collected after all connections are closed.
proc kill-em-all {} {
    global ns
    foreach s [$ns set sessionList] {
	$s kill-kill-kill
    }
}


 # Some performance statistics (in Xgraph-compliant format)
set pf [open performance.mon w]
puts $pf "0 0"

 # Some diffserv-specific monitoring stuff
diffservStats

set alku [clock seconds]
$ns at 50 "timeStats 50"

$ns at $testTime "close-connections"      ;# Try to cleanly close all connections (by sending 'fin')
$ns at [expr $testTime + 5] "kill-em-all" ;# Force all remaining connections to be closed
$ns at [expr $testTime + 11] "finish"     ;# End the simulation
$ns run
