# Set number of nodes
set num_r  14
set num_voip  8
set num_ftpC  4
set num_ftpS  4
set num_httpC 4
set num_httpS 4
set num_nodes [expr $num_r + $num_voip + $num_ftpC + $num_ftpS + $num_httpC + $num_httpS]

set r_list     ""
set voip_list  ""
set ftpC_list  ""
set ftpS_list  ""
set httpC_list ""
set httpS_list ""
set node_list  ""


# Set nodes
for {set i 0} {$i < $num_r} {incr i} {
    set n(r$i) [$ns node]
    set r_list "[set r_list] [list r$i]"
}
for {set i 1} {$i <= $num_voip} {incr i} {
    set n(voip$i) [$ns node]
    set voip_list "[set voip_list] [list voip$i]"
}
for {set i 1} {$i <= $num_ftpC} {incr i} {
    set n(ftpC$i) [$ns node]
    set ftpC_list "[set ftpC_list] [list ftpC$i]"
}
for {set i 1} {$i <= $num_ftpS} {incr i} {
    set n(ftpS$i) [$ns node]
    set ftpS_list "[set ftpS_list] [list ftpS$i]"
}
for {set i 1} {$i <= $num_httpC} {incr i} {
    set n(httpC$i) [$ns node]
    set httpC_list "[set httpC_list] [list httpC$i]"
}
for {set i 1} {$i <= $num_httpS} {incr i} {
    set n(httpS$i) [$ns node]
    set httpS_list "[set httpS_list] [list httpS$i]"
}

set node_list "[set r_list] [set voip_list] [set ftpC_list] [set ftpS_list] [set httpC_list] [set httpS_list]"

puts "$num_r Routers: [set r_list]"
puts "$num_voip VOIP:   [set voip_list]"
puts "$num_ftpC ftpC:   [set ftpC_list]"
puts "$num_ftpS ftpS:   [set ftpS_list]"
puts "$num_httpC httpC:   [set httpC_list]"
puts "$num_httpS httpS:   [set httpS_list]"
puts "Total nodes: $num_nodes"


# Set links between routers (core-links)
  # Bottle-neck link
$ns simplex-link $n(r6) $n(r7) 1.5Mb 15ms dsRED/core
$ns simplex-link $n(r7) $n(r6) 1.5Mb 15ms dsRED/core

  # Rest of the core routers (DropTail)
$ns duplex-link $n(r4) $n(r0) 10.0Mb 10ms DropTail
$ns duplex-link $n(r4) $n(r1) 10.0Mb 10ms DropTail
$ns duplex-link $n(r5) $n(r2) 10.0Mb 10ms DropTail
$ns duplex-link $n(r5) $n(r3) 10.0Mb 10ms DropTail

$ns duplex-link $n(r8) $n(r10) 10.0Mb 10ms DropTail
$ns duplex-link $n(r8) $n(r11) 10.0Mb 10ms DropTail
$ns duplex-link $n(r9) $n(r12) 10.0Mb 10ms DropTail
$ns duplex-link $n(r9) $n(r13) 10.0Mb 10ms DropTail

$ns duplex-link $n(r6) $n(r4) 4.5Mb 15ms DropTail
$ns duplex-link $n(r6) $n(r5) 4.5Mb 15ms DropTail
$ns duplex-link $n(r7) $n(r8) 4.5Mb 15ms DropTail
$ns duplex-link $n(r7) $n(r9) 4.5Mb 15ms DropTail

# Set links to hosts
  # dsEdge queues in the direction of host->router
$ns simplex-link $n(voip1) $n(r0) 10.0Mb 10ms dsRED/edge
$ns simplex-link $n(ftpC1) $n(r0) 10.0Mb 10ms dsRED/edge
$ns simplex-link $n(httpS1) $n(r0) 10.0Mb 10ms dsRED/edge

$ns simplex-link $n(voip2) $n(r1) 10.0Mb 10ms dsRED/edge
$ns simplex-link $n(ftpC2) $n(r1) 10.0Mb 10ms dsRED/edge
$ns simplex-link $n(ftpS1) $n(r1) 10.0Mb 10ms dsRED/edge

$ns simplex-link $n(voip3) $n(r2) 10.0Mb 10ms dsRED/edge
$ns simplex-link $n(httpC1) $n(r2) 10.0Mb 10ms dsRED/edge
$ns simplex-link $n(ftpS2) $n(r2) 10.0Mb 10ms dsRED/edge

$ns simplex-link $n(voip4) $n(r3) 10.0Mb 10ms dsRED/edge
$ns simplex-link $n(httpC2) $n(r3) 10.0Mb 10ms dsRED/edge
$ns simplex-link $n(httpS2) $n(r3) 10.0Mb 10ms dsRED/edge

$ns simplex-link $n(voip5) $n(r10) 10.0Mb 10ms dsRED/edge
$ns simplex-link $n(httpC3) $n(r10) 10.0Mb 10ms dsRED/edge
$ns simplex-link $n(ftpS3) $n(r10) 10.0Mb 10ms dsRED/edge

$ns simplex-link $n(voip6) $n(r11) 10.0Mb 10ms dsRED/edge
$ns simplex-link $n(ftpC3) $n(r11) 10.0Mb 10ms dsRED/edge
$ns simplex-link $n(httpS3) $n(r11) 10.0Mb 10ms dsRED/edge

$ns simplex-link $n(voip7) $n(r12) 10.0Mb 10ms dsRED/edge
$ns simplex-link $n(httpC4) $n(r12) 10.0Mb 10ms dsRED/edge
$ns simplex-link $n(ftpS4) $n(r12) 10.0Mb 10ms dsRED/edge

$ns simplex-link $n(voip8) $n(r13) 10.0Mb 10ms dsRED/edge
$ns simplex-link $n(ftpC4) $n(r13) 10.0Mb 10ms dsRED/edge
$ns simplex-link $n(httpS4) $n(r13) 10.0Mb 10ms dsRED/edge

  # The opposite direction (router->host) might as well be DropTail
$ns simplex-link $n(r0) $n(voip1) 10.0Mb 10ms DropTail
$ns simplex-link $n(r0) $n(ftpC1) 10.0Mb 10ms DropTail
$ns simplex-link $n(r0) $n(httpS1) 10.0Mb 10ms DropTail

$ns simplex-link $n(r1) $n(voip2) 10.0Mb 10ms DropTail
$ns simplex-link $n(r1) $n(ftpC2) 10.0Mb 10ms DropTail
$ns simplex-link $n(r1) $n(ftpS1) 10.0Mb 10ms DropTail

$ns simplex-link $n(r2) $n(voip3) 10.0Mb 10ms DropTail
$ns simplex-link $n(r2) $n(httpC1) 10.0Mb 10ms DropTail
$ns simplex-link $n(r2) $n(ftpS2) 10.0Mb 10ms DropTail

$ns simplex-link $n(r3) $n(voip4) 10.0Mb 10ms DropTail
$ns simplex-link $n(r3) $n(httpC2) 10.0Mb 10ms DropTail
$ns simplex-link $n(r3) $n(httpS2) 10.0Mb 10ms DropTail

$ns simplex-link $n(r10) $n(voip5) 10.0Mb 10ms DropTail
$ns simplex-link $n(r10) $n(httpC3) 10.0Mb 10ms DropTail
$ns simplex-link $n(r10) $n(ftpS3) 10.0Mb 10ms DropTail

$ns simplex-link $n(r11) $n(voip6) 10.0Mb 10ms DropTail
$ns simplex-link $n(r11) $n(ftpC3) 10.0Mb 10ms DropTail
$ns simplex-link $n(r11) $n(httpS3) 10.0Mb 10ms DropTail

$ns simplex-link $n(r12) $n(voip7) 10.0Mb 10ms DropTail
$ns simplex-link $n(r12) $n(httpC4) 10.0Mb 10ms DropTail
$ns simplex-link $n(r12) $n(ftpS4) 10.0Mb 10ms DropTail

$ns simplex-link $n(r13) $n(voip8) 10.0Mb 10ms DropTail
$ns simplex-link $n(r13) $n(ftpC4) 10.0Mb 10ms DropTail
$ns simplex-link $n(r13) $n(httpS4) 10.0Mb 10ms DropTail

#setup colors for nam
for {set i 0} {$i <= 100} {incr i} {
    set color [expr $i % 6]
    if {$color == 0} {
        $ns color $i blue
    } elseif {$color == 1} {
        $ns color $i red
    } elseif {$color == 2} {
        $ns color $i brown
    } elseif {$color == 3} {
        $ns color $i purple
    } elseif {$color == 4} {
        $ns color $i green
    } elseif {$color == 5} {
        $ns color $i yellow
    }
}

