BEGIN {
    pageTOs = 0;
}
{
if ($1 == sprintf("%d->%d", svr, clnt)) {
    if ($3 == "Stopped") {
	duration = $9;
	lastLineIsStopped = 1;
    }
    else if ($2 == "obj") {
	getline; # advance to the next line
	if ($1 == "sentpack") {
	    ndatapack += $4;    # ndatapack_
	    sentPack += $2;    # sentpack_
	    sentBytes += $6;    # ndatabytes_
	    rxmitbytes += $8;  # rxmitbytes_
	    rxmitPack += $10; # rxmitpack_
#recPack += ($2 - $10);    # sentpack_ - rxmitpack_
	    recBytes += $12;  # highest_ack_ - 2
	    recPack += $14;  # recPacks_
	    wAvgDelay += $16*$14 # avgDelay * recPacks_
	    connections += 1;
	    
	    lastLineIsStopped = 0;
	}
    }
    else if ($2 == "PageTimeOut:") {
	pageTOs += 1;
	lastLineIsStopped = 1;
    }
}
}
END	{
    if (!lastLineIsStopped) {
	print "Error: no last 'Stopped'-statement";
    }
    else {
	# Include packet header bytes
	sentBytes += 40*sentPack;
	recBytes += 40*recPack;
	rxmitbytes += 40*rxmitPack;
	
	print "   duration", duration, "sentDataPack", ndatapack, "sentPack", sentPack, "recPack", recPack, "rxmitPack", rxmitPack, "packetLoss", 1-recPack/sentPack, "avgDelay", wAvgDelay/recPack, "..";
	print "   .. sentBytes", sentBytes, "recBytes", recBytes, "rxmitbytes", rxmitbytes, "throughPut",  8*recBytes/duration, "connections", connections, "pageTOs", pageTOs;
    }
}
