# Three different policies are defined here: Best Effort (BE),
# Assured Forwarding (AF) and Expedited Forwarding (EF).
# Each policy has a table of parameters which are:
#  cp:  initial code point for the packets in this policy
#  qw:  queue weight for WRR and WIRR
#  in_min:  minimum dropping threshold in the RED-queues for the in-packets
#  in_max:  maximum dropping threshold in the RED-queues for the in-packets
#  in_prob: the maximum dropping probability in the RED-queues for the in-packets
#  out_min:  minimum dropping threshold in the RED-queues for the out-packets
#  out_max:  maximum dropping threshold in the RED-queues for the out-packets
#  out_prob: maximum dropping probability in the RED-queues for the out-packets
#  qlimit:  maximum number of packets in the queue


# Assign initial DS-codepoints
set EF(cp) 10
set AF(cp) 20
set BE(cp) 30

# Assign queue weights for WRR-scheduler
set EF(qw) 6
set AF(qw) 3
set BE(qw) 1

# Set RED parameters (in packets, except for the probability)
 # EF
set EF(in_min) 4.5
set EF(in_max) 8.0
set EF(in_prob) 0.05
set EF(out_min) 0.0   ;# Drop every packet that is out of profile
set EF(out_max) 0.0
set EF(out_prob) 1.00
set EF(qlimit) 0
 # AF
set AF(in_min) 30     ;# ~30% of the queue limit
set AF(in_max) 60     ;# ~60%
set AF(in_prob) 0.05
set AF(out_min) 15    ;# ~15%
set AF(out_max) 60    ;# ~60%
set AF(out_prob) 0.10
set AF(qlimit) 0
 # BE
set BE(in_min) 30     ;# ~15% of the queue limit
set BE(in_max) 120     ;# ~60%
set BE(in_prob) 0.10
set BE(out_min) 30
set BE(out_max) 120
set BE(out_prob) 0.10
set BE(qlimit) 200

# DiffServ Core queue (one-way: from a to b)
proc confDSCore { a b } {
    global ns q n AF EF BE

    set q($a$b) [[$ns link $n($a) $n($b)] queue]

    # The number of physical queues and precedences
    $q($a$b) set numQueues_ 3
    $q($a$b) setNumPrec 2
    $q($a$b) meanPktSize 300

    # Set scheduler (and queue weigths)
    $q($a$b) setSchedularMode WRR      ;# Options: RR, WRR, WIRR, PRI
    $q($a$b) addQueueWeights 0 $EF(qw) ;# For WRR and WIRR. Syntax: $q addQueueWeights [queue] [weight]
    $q($a$b) addQueueWeights 1 $AF(qw)
    $q($a$b) addQueueWeights 2 $BE(qw)

    # Configure PHBs
    # EF
    $q($a$b) addPHBEntry $EF(cp) 0 0 ;
    $q($a$b) addPHBEntry [expr $EF(cp)+1] 0 1
    $q($a$b) configQ 0 0 $EF(in_min) $EF(in_max) $EF(in_prob)
    $q($a$b) configQ 0 1 $EF(out_min) $EF(out_max) $EF(out_prob)
    $q($a$b) setPhysQueueSize 0 $EF(qlimit)
    # AF
    $q($a$b) addPHBEntry $AF(cp) 1 0 ;
    $q($a$b) addPHBEntry [expr $AF(cp)+1] 1 1
    $q($a$b) configQ 1 0 $AF(in_min) $AF(in_max) $AF(in_prob)
    $q($a$b) configQ 1 1 $AF(out_min) $AF(out_max) $AF(out_prob)
    $q($a$b) setPhysQueueSize 1 $AF(qlimit)
    #BE
    $q($a$b) addPHBEntry $BE(cp) 2 0 ;
    $q($a$b) addPHBEntry [expr $BE(cp)+1] 2 1
    $q($a$b) configQ 2 0 $BE(in_min) $BE(in_max) $BE(in_prob)
    $q($a$b) configQ 2 1 $BE(out_min) $BE(out_max) $BE(out_prob)
    $q($a$b) setPhysQueueSize 2 $BE(qlimit)
}

# Configure DS edge queues for access links, both server- and client-side
proc confDSEdges { svr clnt cir app service_type } {
    global ns q n cir_exp cir_http cir_ftp BE EF AF

    if { $service_type == "BE" } {
	set cp_ $BE(cp)
	set in_min_ $BE(in_min)
	set in_max_ $BE(in_max)
	set in_prob_ $BE(in_prob)
	set out_min_ $BE(out_min)
	set out_max_ $BE(out_max)
	set out_prob_ $BE(out_prob)
	set qlimit_ $BE(qlimit)
    } elseif { $service_type == "AF" } {
	set cp_ $AF(cp)
	set in_min_ $AF(in_min)
	set in_max_ $AF(in_max)
	set in_prob_ $AF(in_prob)
	set out_min_ $AF(out_min)
	set out_max_ $AF(out_max)
	set out_prob_ $AF(out_prob)
	set qlimit_ $AF(qlimit)
    } elseif { $service_type == "EF" } {
	set cp_ $EF(cp)
	set in_min_ $EF(in_min)
	set in_max_ $EF(in_max)
	set in_prob_ $EF(in_prob)
	set out_min_ $EF(out_min)
	set out_max_ $EF(out_max)
	set out_prob_ $EF(out_prob)
	set qlimit_ $EF(qlimit)
    }

    # Edge queues (both in server- and client-side)
    set q($svr$clnt) [[$ns link $n($svr) [$n($svr) neighbors]] queue]
    set q($clnt$svr) [[$ns link $n($clnt) [$n($clnt) neighbors]] queue]

    foreach qe "$svr$clnt $clnt$svr" {
	$q($qe) set numQueues_ 1
	$q($qe) setNumPrec 2
	$q($qe) meanPktSize 300
	#$q($qe) set limit_ $qlimit_
	$q($qe) setPhysQueueSize 0 $qlimit_
	
	$q($qe) addPolicyEntry -1 -1 TSW2CM $cp_ $cir $app
	# Multiple precedences only for AF
	if { $service_type == "BE" } {
	    $q($qe) addPolicerEntry TSW2CM $cp_ $cp_
	} else {
	    $q($qe) addPolicerEntry TSW2CM $cp_ [expr $cp_ + 1]
	}
	$q($qe) addPHBEntry $cp_ 0 0
	$q($qe) addPHBEntry [expr $cp_ + 1] 0 1
	$q($qe) configQ 0 0 $in_min_ $in_max_ $in_prob_
	$q($qe) configQ 0 1 $out_min_ $out_max_ $out_prob_
    }
}
