# Set number of nodes
set num_r  14
set num_voip  8
set num_voip2 8
set num_ftpC  4
set num_ftpS  4
set num_httpC 4
set num_httpS 4
set num_nodes [expr $num_r + $num_voip + $num_voip2 + $num_ftpC + $num_ftpS + $num_httpC + $num_httpS]

set r_list     ""
set voip_list  ""
set voip2_list ""
set ftpC_list  ""
set ftpS_list  ""
set httpC_list ""
set httpS_list ""
set node_list  ""


# Set nodes
for {set i 0} {$i < $num_r} {incr i} {
    set n(r$i) [$ns node]
    set r_list "[set r_list] [list r$i]"
}
for {set i 1} {$i <= $num_voip} {incr i} {
    set n(voip$i) [$ns node]
    set voip_list "[set voip_list] [list voip$i]"
}

for {set i 1} {$i <= $num_voip2} {incr i} {
    set n(voip_be$i) [$ns node]
    set voip2_list "[set voip2_list] [list voip_be$i]"
}

for {set i 1} {$i <= $num_ftpC} {incr i} {
    set n(ftpC$i) [$ns node]
    set ftpC_list "[set ftpC_list] [list ftpC$i]"
}
for {set i 1} {$i <= $num_ftpS} {incr i} {
    set n(ftpS$i) [$ns node]
    set ftpS_list "[set ftpS_list] [list ftpS$i]"
}
for {set i 1} {$i <= $num_httpC} {incr i} {
    set n(httpC$i) [$ns node]
    set httpC_list "[set httpC_list] [list httpC$i]"
}
for {set i 1} {$i <= $num_httpS} {incr i} {
    set n(httpS$i) [$ns node]
    set httpS_list "[set httpS_list] [list httpS$i]"
}

set node_list "[set r_list] [set voip_list] [set voip2_list] [set ftpC_list] [set ftpS_list] [set httpC_list] [set httpS_list]"

puts "$num_r Routers: [set r_list]"
puts "$num_voip VOIP:   [set voip_list]"
puts "$num_voip2 VOIP:   [set voip2_list]"
puts "$num_ftpC ftpC:   [set ftpC_list]"
puts "$num_ftpS ftpS:   [set ftpS_list]"
puts "$num_httpC httpC:   [set httpC_list]"
puts "$num_httpS httpS:   [set httpS_list]"
puts "Total nodes: $num_nodes"


# Set links between routers (core-links)
# General params
    set trace_flow 0

# IntServ params
# MS (measured sum) and HB (Hoeffding bounds) as admission control ADC.
# EST determines the estimation method, MS est=TimeWindow, HB est=ExpAvg
set ADC HB
set EST ExpAvg

# Period is the averaging period (in packet transmission times) that controls the sensitivity of the measurement. Smaller period means more sensitivity to bursts. Should be above 100 times of one packet transmission time.
# Too small period_ makes the adc too conservative. Period below is in seconds.
Est set period_ 1
Est/ExpAvg set w_ 0.125
Est/TimeWindow set T_ 3
# T_ controls the adaptability of the measurement to drops. Smaller T means more adaptability, and larger T greater stability. T_ should be several times the averaging period.
ADC/HB set epsilon_ 0.7
ADC/MS set utilization_ 1.0
ADC/MS set backoff_ false

# Bottle-neck link to be replaced with Intserv link
$ns duplex-intserv-link $n(r6) $n(r7) 1.5Mb 15ms SimpleIntServ SALink $ADC $EST CL
#$ns duplex-link $n(r6) $n(r7) 1.5Mb 15ms DropTail
#$ns queue-limit $n(r6) $n(r7) $default_queue_size

# Rest of the core routers (DropTail)

$ns duplex-link $n(r4) $n(r0) 10.0Mb 10ms DropTail
$ns duplex-link $n(r4) $n(r1) 10.0Mb 10ms DropTail
$ns duplex-link $n(r5) $n(r2) 10.0Mb 10ms DropTail
$ns duplex-link $n(r5) $n(r3) 10.0Mb 10ms DropTail

$ns duplex-link $n(r8) $n(r10) 10.0Mb 10ms DropTail
$ns duplex-link $n(r8) $n(r11) 10.0Mb 10ms DropTail
$ns duplex-link $n(r9) $n(r12) 10.0Mb 10ms DropTail
$ns duplex-link $n(r9) $n(r13) 10.0Mb 10ms DropTail

$ns duplex-link $n(r6) $n(r4) 4.5Mb 15ms DropTail
$ns duplex-link $n(r6) $n(r5) 4.5Mb 15ms DropTail
$ns duplex-link $n(r7) $n(r8) 4.5Mb 15ms DropTail
$ns duplex-link $n(r7) $n(r9) 4.5Mb 15ms DropTail

# Set links to hosts
# These are all DropTail in the Intserv

$ns duplex-link $n(voip1) $n(r0) 10.0Mb 10ms DropTail
$ns duplex-link $n(voip_be1) $n(r0) 10.0Mb 10ms DropTail
$ns duplex-link $n(ftpC1) $n(r0) 10.0Mb 10ms DropTail
$ns duplex-link $n(httpS1) $n(r0) 10.0Mb 10ms DropTail

$ns duplex-link $n(voip2) $n(r1) 10.0Mb 10ms DropTail
$ns duplex-link $n(voip_be2) $n(r1) 10.0Mb 10ms DropTail
$ns duplex-link $n(ftpC2) $n(r1) 10.0Mb 10ms DropTail
$ns duplex-link $n(ftpS1) $n(r1) 10.0Mb 10ms DropTail

$ns duplex-link $n(voip3) $n(r2) 10.0Mb 10ms DropTail
$ns duplex-link $n(voip_be3) $n(r2) 10.0Mb 10ms DropTail
$ns duplex-link $n(httpC1) $n(r2) 10.0Mb 10ms DropTail
$ns duplex-link $n(ftpS2) $n(r2) 10.0Mb 10ms DropTail

$ns duplex-link $n(voip4) $n(r3) 10.0Mb 10ms DropTail
$ns duplex-link $n(voip_be4) $n(r3) 10.0Mb 10ms DropTail
$ns duplex-link $n(httpC2) $n(r3) 10.0Mb 10ms DropTail
$ns duplex-link $n(httpS2) $n(r3) 10.0Mb 10ms DropTail

$ns duplex-link $n(voip5) $n(r10) 10.0Mb 10ms DropTail
$ns duplex-link $n(voip_be5) $n(r10) 10.0Mb 10ms DropTail
$ns duplex-link $n(httpC3) $n(r10) 10.0Mb 10ms DropTail
$ns duplex-link $n(ftpS3) $n(r10) 10.0Mb 10ms DropTail

$ns duplex-link $n(voip6) $n(r11) 10.0Mb 10ms DropTail
$ns duplex-link $n(voip_be6) $n(r11) 10.0Mb 10ms DropTail
$ns duplex-link $n(ftpC3) $n(r11) 10.0Mb 10ms DropTail
$ns duplex-link $n(httpS3) $n(r11) 10.0Mb 10ms DropTail

$ns duplex-link $n(voip7) $n(r12) 10.0Mb 10ms DropTail
$ns duplex-link $n(voip_be7) $n(r12) 10.0Mb 10ms DropTail
$ns duplex-link $n(httpC4) $n(r12) 10.0Mb 10ms DropTail
$ns duplex-link $n(ftpS4) $n(r12) 10.0Mb 10ms DropTail

$ns duplex-link $n(voip8) $n(r13) 10.0Mb 10ms DropTail
$ns duplex-link $n(voip_be8) $n(r13) 10.0Mb 10ms DropTail
$ns duplex-link $n(ftpC4) $n(r13) 10.0Mb 10ms DropTail
$ns duplex-link $n(httpS4) $n(r13) 10.0Mb 10ms DropTail

#setup colors for nam
for {set i 0} {$i <= 100} {incr i} {
    set color [expr $i % 6]
    if {$color == 0} {
        $ns color $i blue
    } elseif {$color == 1} {
        $ns color $i red
    } elseif {$color == 2} {
        $ns color $i brown
    } elseif {$color == 3} {
        $ns color $i purple
    } elseif {$color == 4} {
        $ns color $i green
    } elseif {$color == 5} {
        $ns color $i yellow
    }
}
