# Create an HTTP-pagepool, define session parameters and call 'launchSession'
proc launchHttp {clnt svr} {
    global ns

    # Assign traffic parameters. Note! these are mean values of an exponential distribution
    set sessionSize_  5     ;# Number of pages in a session
    set interSession_ 5     ;# Time between session arrivals (seconds)
    set pageSize_     5     ;# Number of objects in a page
    set interPage_    12    ;# Time between page requests (seconds)
    set objSize_      3300  ;# Object size (bytes)
    set interObj_     0.1   ;# Time between object requests (seconds)

    ## Number of Pages per Session
    set sessionSize [new RandomVariable/Exponential]
    $sessionSize set avg_ $sessionSize_

    #puts "HTTP-session parameters (averages): sessionSize=$sessionSize_, interSession=$interSession_, pageSize=$pageSize_, interPage=$interPage_, objSize=$objSize_, interObj=$interObj_"

    # Create page pool
    set pool [new PagePool/WebTraf]

    $pool set-interPageOption 0
    $pool set application_ 31
    
    # Set up session-monitoring
    #$pool set sessMonFile [open "smon_HTTP_[set svr]_to_[set clnt].mon" w]
    $ns set httpMonFile [open "smon_http.mon" w]

    launchSession $pool $clnt $svr $sessionSize $interSession_ $pageSize_ $interPage_ $objSize_ $interObj_
}

# Create an FTP-pagepool, define session parameters and call 'launchSession'
proc launchFtp {clnt svr} {
    global ns

    set sessionSize_  5
    set interSession_ 30
    set pageSize_     1 ;# always 1
    set interPage_    0_   ;# used for determining the first send time
    set objSize_      [expr 1e6]
    set interObj_     0     ;# doesn't affect anything

    ## Number of Pages per Session
    set sessionSize [new RandomVariable/Constant]
    $sessionSize set val_ $sessionSize_

    #puts "FTP-session parameters (averages): interSession=$interPage_, numObj=$pageSize_, objSize=$objSize_"

    # Create page pool
    set pool [new PagePool/WebTraf]
    
    $pool set-interPageOption 1
    $pool set application_ 27

    # Set up session-monitoring
    #$pool set sessMonFile [open "smon_FTP_[set svr]_to_[set clnt].mon" w]
    $ns set ftpMonFile [open "smon_ftp.mon" w]

    launchSession $pool $clnt $svr $sessionSize $interSession_ $pageSize_ $interPage_ $objSize_ $interObj_
}

set vf [open "smon_exp.mon" w]

# Create an UDP-connection, define VoIP-session parameters and start an
# exponential ON-OFF-connection (exponential idle and call holding times)
proc launchVoip {src dst id startvoip} {

    global ns n testTime

    # Random seed at every run => seed=0
    #global defaultRNG
    #$defaultRNG seed 1

    # Load to the system is defined as mean_holding_time/mean_interarrival_time
    set load 0.8

    # Signalling capability needed for IntServ
    # First the receiver
   set sigrec [new Agent/SAack]
   $ns attach-agent $n($dst) $sigrec

    # Then the source
   set sigsend [new Agent/SA]
   set null [new Agent/Null]
   $ns attach-agent $n($src) $sigsend
   $sigsend set fid_ 2
   $ns connect $sigsend $sigrec

    #VoIP-client configuration
    set expoo [new Application/Traffic/Exponential]
    $expoo set packetSize_  [expr 160+40]; # data + header
    $expoo set burst_time_  180
    $expoo set idle_time_   [format %.1f [expr [$expoo set burst_time_]*(1/$load - 1)]]
    $expoo set rate_        [expr 56000*(1 + 40.0/160)] ;# Set the data rate to be 56k
    $expoo set id_          $id
    $expoo session-monitoring
    
# The sigsend parameters define the source in IntServ
    $sigsend set rate_ 56k
    $sigsend set bucket_ 10
    $sigsend attach-traffic $expoo
    $sigsend set lifetime_ $testTime

#Delay measurements


    $expoo set sink_ $null

    $expoo proc voip-start { size estTime } {
        global ns vf
        $self instvar id_
        puts $vf "[format %.6f [$ns now]] VOIP $id_ starting, size $size pkts,
estTxTime $estTime"
    }

    $expoo proc voip-stop { packetsSent txTime } {
        global ns vf
        $self instvar sink_ id_
        puts $vf "[format %.6f [$ns now]] VOIP $id_ stopped, sent $packetsSent
pkts, txTime $txTime"
    }

    $expoo proc finish-stats {} {
        global ns vf
        $self instvar sink_ id_
        if { [$sink_ set udpPackRecs_] > 0 } {
            set avgDelay_ [format %.6f [expr [$sink_ set udpSumDelays_]/[$sink_
set udpPackRecs_]]]
        } else {
            set avgDelay_ 0
        }
        puts $vf "Final statistics VOIP $id_ received [$sink_ set udpPackRecs_]
pkts, avgDelay $avgDelay_"
    }


# Inter-session Interval 

    $ns at $startvoip "$sigsend start"       ;# Start client, used to be expoo start
    $sigsend instvar trafgen_
    set trafgen_ $expoo

    puts "Creating voip $id starting at $startvoip with pSize=[$expoo set packetSize_], bTime=[$expoo set burst_time_], idleTime=[$expoo set idle_time_], rate=[$expoo set rate_]"

    #$ns at $testTime+20 "$sigsend stop"
}

set vf2 [open "smon_exp201.mon" w]

proc launchVoip2 {src dst id} {

global ns n testTime

    # Random seed at every run => seed=0
    #global defaultRNG
    #$defaultRNG seed 1

    # Load to the system is defined as mean_holding_time/mean_interarrival_time
    set load 0.8

    set udp [new Agent/UDP]
    $udp set fid_ 1
    set null [new Agent/Null]
    $ns attach-agent $n($src) $udp
    $ns attach-agent $n($dst) $null
    $ns connect $udp $null

    #VoIP-client configuration
    set expoo [new Application/Traffic/Exponential]
    $expoo attach-agent $udp
    $expoo set packetSize_  [expr 161+40]; # data 161 to differentiate from the other voip-clients + header
    $expoo set burst_time_  180
    $expoo set idle_time_   [format %.1f [expr [$expoo set burst_time_]*(1/$load - 1)]]
    $expoo set rate_        [expr 56000*(1 + 40.0/160)] ;# Set the data rate to be 56k
    $expoo set id_          $id
    $expoo session-monitoring
    
puts "Creating voip2 $id with pSize=[$expoo set packetSize_], bTime=[$expoo set burst_time_], idleTime=[$expoo set idle_time_], rate=[$expoo set rate_]"

#Delay measurements


    $expoo set sink_ $null
    $expoo proc voip-start { size estTime } {
        global ns vf2
        $self instvar id_
        puts $vf2 "[format %.6f [$ns now]] VOIP $id_ starting, size $size pkts,
estTxTime $estTime"
    }
    $expoo proc voip-stop { packetsSent txTime } {
        global ns vf2
        $self instvar sink_ id_
        puts $vf2 "[format %.6f [$ns now]] VOIP $id_ stopped, sent $packetsSent
pkts, txTime $txTime"
    }
    $expoo proc finish-stats {} {
        global ns vf2
        $self instvar sink_ id_
        if { [$sink_ set udpPackRecs_] > 0 } {
            set avgDelay_ [format %.6f [expr [$sink_ set udpSumDelays_]/[$sink_
set udpPackRecs_]]]
        } else {
            set avgDelay_ 0
        }
        puts $vf2 "Final statistics VOIP $id_ received [$sink_ set udpPackRecs_]
pkts, avgDelay $avgDelay_"
    }


    $ns at 0.0 "$expoo start"       ;# Start client

    $ns at $testTime "$expoo stop"
}


# Is called by 'launchHttp' and 'launchFtp'.
# Create needed random variables and assign start-up times for each session.
proc launchSession {pool clnt svr sessionSize interSession_ pageSize_ interPage_ objSize_ interObj_} {
    global ns n testTime
    # both webtraffic and ftptraffic should be set to zero value -> best effort traffic
    # However since webtraf and ftptraf are not signaling agents and it seems that in the intserv package the BE traffic
    # is not measured therefore the fid needs to be set to 1 to get the background traffic effect.

    PagePool/WebTraf set FID_ASSIGNING_MODE_ 2
    $pool set sameFid_ 1

    # Maximum number of sessions to be created
    set numSession_   [expr round(1.4*$testTime/$interSession_)]
    puts "Creating max $numSession_ sessions"

    # Bind TCL-variable to C-variable
    $pool set testTime_ $testTime

    # Add this session to the session list
    $ns set sessionList "[$ns set sessionList] $pool"

    set verbose 1
    #$ns set src_ $clnt
    #$ns set dst_ $svr

    # Setup servers and clients: add nodes listed in src_ and dst_
    # to pagepools server- and client-pool
    $pool set-num-client [llength $clnt]
    $pool set-num-server [llength $svr]
    set i 0
    foreach s $clnt {
        $pool set-client $i $n($s)
        incr i
    }
    set i 0
    foreach s $svr {
        $pool set-server $i $n($s)
        incr i
    }

    # Number of Sessions
    set numSession $numSession_

    # Inter-session Interval
    set interSession [new RandomVariable/Exponential]
    $interSession set avg_ $interSession_

    # Create sessions
    $pool set-num-session $numSession
    set launchTime [$interSession value]
    for {set i 0} {$i < $numSession} {incr i} {
     if {[$pool set application_] == 27 } {
	    set pageSize [new RandomVariable/Constant]
	    $pageSize set val_ $pageSize_
	} else {
	    set pageSize [new RandomVariable/Exponential]
	    $pageSize set avg_ $pageSize_

}


    set interPage [new RandomVariable/Exponential]
    $interPage set avg_ $interPage_

    set pageSize [new RandomVariable/Exponential]
    $pageSize set avg_ $pageSize_

    set interObj [new RandomVariable/Exponential]
    $interObj set avg_ $interObj_

    set objSize [new RandomVariable/Exponential]
    $objSize set avg_ $objSize_

    if { $launchTime < $testTime } {
        
        $pool create-session $i [$sessionSize value] $launchTime \
            $interPage $pageSize $interObj $objSize
        }
    set launchTime [expr $launchTime + [$interSession value]]
    }

}
