# Outputs to the screen the simulated time and the test time every 'interval'-seconds (simulated)
proc timeStats { interval } {
    global ns alku pf

    set openConnections 0
    foreach s [$ns set sessionList] {
    set temp [llength [$s set connList]]
    puts "[$s info class] open connections: $temp"
    set openConnections [expr $openConnections + $temp]
    }
    puts "Total: $openConnections\n"

    # Print simulated and runtime on the screen and to file
    puts "\nSimulated time: [$ns now] s, real time: [expr [clock seconds] - $alku] s"
    #puts $pf "[$ns now] [expr [clock seconds] - $alku]   Open connections $openConnections Number of events [$ns numEvents]"

    $ns at [expr [$ns now] + $interval] "timeStats $interval" ;# Call timeStats in 100s intervals
}

proc record { qmon src dst interval file} {
    global ns
# for intserv monitor the bytedepartures to calculate for the bandwidth utilization, and bytedrops to see how much is left out
    set time  [$ns now]
    #set size [$qmon set size_]
    #set pkts [$qmon set pkts_]
    #set parrivals [$qmon set parrivals_]
    #set barrivals [$qmon set barrivals_]
    #set pdepartures [$qmon set pdepartures_]
    set bdepartures [$qmon set bdepartures_]
    #set pdrops [$qmon set pdrops_]
    set bdrops [$qmon set bdrops_]
    # multiply by 8 to get the bits from bytes
    puts $file "$time [expr 8*$bdepartures/$interval] [expr 8*$bdrops]"
    # zero the measures to start another interval
    $qmon set bdepartures_ 0
    $qmon set bdrops_ 0
    #puts $file "$time [$src id]->[$dst id] size $size  pkts $pkts parrivals $parrivals barrivals $barrivals pdrops $pdrops bdrops $bdrops"
    flush $file
    $qmon reset
    # stats every 1 second
    $ns at [expr $time+$interval] "record $qmon $src $dst $interval $file"
}
