#Helper function to schedule stop time for the new flow - required with the IntServ
Agent/SA instproc sched-stop { decision } {
    global hold simtime ns trace_flow
    $self instvar node_ lifetime_

    if { $decision == 1 } {
        set leavetime [expr [$ns now] + $lifetime_]
        $ns at [expr [$ns now] + $lifetime_] "$self stop;\
                if { $trace_flow } { \
            puts \"Flow [$self set fid_] left @ $leavetime\" \
        }; \
            $ns detach-agent $node_ $self; \
            delete [$self set trafgen_]; delete $self"
    } else {
        set leavetime [$ns now]
        $ns at-now "if { $trace_flow } { \
            puts \"Flow [$self set fid_] left @ $leavetime\"\
        }; \
            $ns detach-agent $node_ $self; \
            delete [$self set trafgen_]; delete $self"
    }
}

set default_queue_size 100

Queue/SimpleIntServ set qlimit5_ $default_queue_size
Queue/SimpleIntServ set qlimit4_ $default_queue_size
Queue/SimpleIntServ set qlimit3_ $default_queue_size
Queue/SimpleIntServ set qlimit2_ [expr $default_queue_size/10]
Queue/SimpleIntServ set qlimit1_ $default_queue_size
Queue/SimpleIntServ set qlimit0_ $default_queue_size

set ns [new Simulator]

# Simulated seconds and random seed to be used (0 := random seed for every run)
$defaultRNG seed 0
set testTime 300.0
set simtime 300.0
# Start whatever measurements right away
set meastime 1.0

 # Activate tracing for all links (potentially very slow and disk-space-consuming)
 # In IntServ this enables for delay calculations
 # Output file: tr_intservnet.out
set trace_all true

Trace set show_tcphdr_ 1
 # Set tracing
if {$trace_all} {
    $ns trace-all [open "| gzip > tr_intservnet.out.gz" w]
    #$ns namtrace-all [open tr_intservnet.nam w]
}

 # Get functions for creating HTTP, FTP and VoIP traffic
source peer_setup.tcl

 # Create topology
source topologyHB.tcl

 # Load monitor-functions for queuemonitors
source monitoring.tcl


 # Print node's name and ID on the screen
foreach s [set node_list] {
    puts -nonewline "Node $s's id is [$n($s) address?] and its neighbors are"
    foreach nbor [$n($s) neighbors] {
    puts -nonewline " [$nbor address?]"
    }
    puts ""
}

 # Contains handles for WebTraf- and FTPTraf-sessions. Session handles are added
 # to this variable in "proc launchSession" of file 'peer_setup.tcl'
$ns set sessionList ""

 # Launch HTTP-sessions (syntax: client-list server-list)
launchHttp httpC1 httpS4
launchHttp httpC2 httpS3
launchHttp httpC3 httpS1
launchHttp httpC4 httpS2

 # Launch FTP-sessions (syntax: client-list server-list)
launchFtp ftpC1 ftpS4
launchFtp ftpC2 ftpS3
launchFtp ftpC3 ftpS2
launchFtp ftpC4 ftpS1

 # Launch VOIP-sessions (syntax: src dst id starttime)
 # Note that these voip clients have their fid set to 2 in peer_setup.tcl
launchVoip voip1 voip5 1 20
launchVoip voip5 voip1 2 40
launchVoip voip2 voip7 3 60
launchVoip voip7 voip2 4 80
launchVoip voip3 voip6 5 100
launchVoip voip6 voip3 6 120
launchVoip voip4 voip8 7 140
launchVoip voip8 voip4 8 160

# Launch VOIP2-sessions (syntax: src dst id)
 # Note that these voip2 clients have their fid set to 1 but no signalling agent attached in peer_setup.tcl
# These clients are to be used as reference in regards to delay measurements
launchVoip2 voip_be1 voip_be5 9
launchVoip2 voip_be5 voip_be1 10
launchVoip2 voip_be2 voip_be7 11
launchVoip2 voip_be7 voip_be2 12
launchVoip2 voip_be3 voip_be6 13
launchVoip2 voip_be6 voip_be3 14
launchVoip2 voip_be4 voip_be8 15
launchVoip2 voip_be8 voip_be4 16

# Queue-monitoring (for bottleneck link) see monitoring.tcl/record for details

# IntServ link util measurements
    set qf2 [open "mon_bottle.mon" w]
    set qmon [$ns monitor-queue $n(r6) $n(r7) $qf2]
    set l67 [$ns link $n(r6) $n(r7)]
    $l67 set qBytesEstimate_ 0
    $l67 set qPktsEstimate_ 0
    $l67 set sampleInterval_ 0

# Show results after the measurement period, comment out if not using int-serv on the link
    $ns at $meastime "$l67 trace-util 0.9 $qf2"

 # Finish up the simulation
proc finish { file } {
    global ns alku trace_on pf qf2 r psize bandwidth simtime meastime qmon
#-------------
$qmon instvar pdrops_ pdepartures_ bdepartures_
    set utlzn [expr $bdepartures_*8.0/(1.5e6*($simtime-$meastime))]
    set d [expr $pdrops_.0 /($pdrops_ + $pdepartures_)]
    puts "Packet Drops : $d Utilization : $utlzn"
    if [ info exists qf2 ] {
        close $qf2
    }
    set output [ open temp.rands w ]
    puts $output "TitleText: $file"
        puts $qf2 "Device: Postscript"

    exec rm -f temp.p1 temp.p2
        exec awk {{print $1,$2}} mon_bottle.mon > temp.p1
        exec awk {{print $1,$3}} mon_bottle.mon > temp.p2
    puts $output [format "\n\"Estimate"]
    exec cat temp.p1 >@ $output
    puts $output [format "\n\"Actual Utilzn"]
        exec cat temp.p2 >@ $output
#-----------
    $ns flush-trace
    puts "Runtime: [expr [clock seconds] - $alku] s"
    flush $qf2
    close $qf2
    flush $pf
    close $pf
#-----------
exec rm -f temp.p1 temp.p2
#Prints a figure on the estimate and on the actual utilzn
        exec xgraph -bb -tk -m -x time -y bandwidth -lx 1,1,300 temp.rands &

#-----------
    # Start producing the delay data, you'll have to enter these by hand
    #cat tr_intservnet.out | grep "r" | grep "exp 200" > voip_received.out
        # exp 201 if you're looking for the reference sources
	# The r means for packets received, useful in determining the delays. 
	# The d collects the dropped packets.
        # We have all the received packets. Now let's start determining the delays.
    #rm tr_intservnet.out, do not if you still need to analyze the dropped packets.
        # Let's modify the output and get timestamp src dst pkt#
    #sed 's/[.]/ /2' voip_received.out | sed 's/[.]/ /2' | awk '$3==$9 || $4==$11 {print $2,$9,$11,$14}' > voip_mod.out
    #sort -k 4,4 voip_mod.out -o voip_sorted.out
    #rm voip_mod.out voip_received.out
    #cat voip_sorted.out | awk '($2==old2 && $3==old3 && $4==old4){printf("%d\t%d\t%d\t%f\n",$2,$3,$4,($1-old1))}{old1=$1;old2=$2;old3=$3;old4=$4}'>delay_voip.out
    #rm voip_sorted.out
        # ok, now we have end-to-end (well, almost) delays for src,dst,pkt#
        # use cat delay_voip.out | awk '{print $4}' to get all the delays, this might be useful in examining the overall performance
        # use cat delay_voip.out | awk '($1==src && $2==dst){print $4}' to get the delays for particular src,dst pair, then input the delays into matlab etc. to get the delay
        # distributions, averages, variances, jitter and what have you
#------------
    exit 0
}

 # Tries to close all open connections listed in 'sessionList' using the normal TCP-connection teardown
proc close-connections {} {
    global ns
    foreach s [$ns set sessionList] {
    $s close-pool
    }
}

 # Forces all connections to be closed, no matter what the state of the connection is.
 # Needed to ensure statistics to be collected after all connections are closed.
proc kill-em-all {} {
    global ns
    foreach s [$ns set sessionList] {
    $s kill-kill-kill
    }
}


 # Some performance statistics (in Xgraph-compliant format)
set pf [open performance.mon w]
#puts $pf "0 0"

set alku [clock seconds]
$ns at 60 "timeStats 60"

$ns at $testTime "close-connections"      ;# Try to cleanly close all connections (by sending 'fin')
$ns at [expr $testTime + 5] "kill-em-all" ;# Force all remaining connections to be closed
$ns at [expr $testTime + 11] "finish ($qf2)"     ;# End the simulation
$ns run
